/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Event;
import java.awt.Panel;
import util.CmdPanelInterface;
import util.Separator;
import util.TabbedFocusInterface;

public class ButtonPanel
extends Panel
implements TabbedFocusInterface,
CmdPanelInterface {
    Panel buttonPanel = new Panel();
    Separator separator = new Separator();
    TabbedFocusInterface peerFocus;
    Button[] buttons;

    public ButtonPanel() {
        this.setLayout(new BorderLayout(0, 5));
        this.add("North", (Component)this.separator);
        this.add("Center", this.buttonPanel);
    }

    public void add(Button button) {
        this.buttonPanel.add(button);
    }

    public Button add(String string) {
        Button button = new Button(string);
        this.buttonPanel.add(button);
        return button;
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + "buttons=" + this.countComponents();
    }

    public void setButtons(Button[] buttonArray) {
        this.buttons = buttonArray;
    }

    public void requestTabFocus(boolean bl) {
        if (this.buttons.length > 0) {
            if (bl) {
                this.buttons[this.buttons.length - 1].requestFocus();
                return;
            }
            this.buttons[0].requestFocus();
        }
    }

    public void setPeerFocusPanel(TabbedFocusInterface tabbedFocusInterface) {
        this.peerFocus = tabbedFocusInterface;
    }

    public void setCmdPanel(CmdPanelInterface cmdPanelInterface) {
    }

    public void handleEnterAsConfirmCmd() {
        Event event = new Event(this.buttons[0], 1001, this.buttons[0].getLabel());
        this.postEvent(event);
    }

    public boolean keyDown(Event event, int n) {
        if (event.target instanceof Button) {
            int n2 = 0;
            while (n2 < this.buttons.length) {
                if (this.buttons[n2] == (Button)event.target) break;
                ++n2;
            }
            if (n == 9) {
                boolean bl = false;
                if (n2 == 0 && event.shiftDown() && this.peerFocus != null) {
                    this.peerFocus.requestTabFocus(event.shiftDown());
                    bl = true;
                } else if (n2 + 1 < this.buttons.length) {
                    this.buttons[n2 + 1].requestFocus();
                    bl = true;
                } else if (event.shiftDown()) {
                    this.buttons[n2 - 1].requestFocus();
                    bl = true;
                } else if (this.peerFocus != null) {
                    this.peerFocus.requestTabFocus(event.shiftDown());
                    bl = true;
                }
                return bl;
            }
            if (n == 10 || n == 13) {
                Event event2 = new Event(this.buttons[n2], 1001, this.buttons[n2].getLabel());
                this.postEvent(event2);
                return true;
            }
        }
        return false;
    }
}

