/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Component;
import java.awt.Event;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import util.AuthURLInterface;
import util.AuthWaiter;
import util.Debug;
import util.Field;
import util.Group;
import util.GroupedPanel;
import util.MD5;
import util.Message;
import util.modal.ModalDialog;
import util.modal.ModalDialogInterface;

public class AuthURL
implements ModalDialogInterface {
    String uri;
    static String user;
    static String realm;
    static String password;
    static String a1_digest;
    String method;
    String domain;
    String a2_digest;
    String nonce;
    String algorithm;
    String host;
    int port;
    Socket socket;
    DataInputStream input;
    PrintStream output;
    Hashtable responseHeader;
    Hashtable requestHeader = new Hashtable();
    Vector postBuffer;
    int postBufferLength;
    AuthURLInterface more;
    private static ModalDialog dialog;
    GroupedPanel panel;
    boolean posted;
    String expectedAction;
    String statusMsg;
    int statusCode;
    static boolean connectInProgress;
    public static final int HS_CONTINUE = 100;
    public static final int HS_OK = 200;
    public static final int HS_AUTH_REQUIRED = 401;
    public static final int HS_PRECONDITION_FAILED = 412;
    public static final int HS_SERVICE_UNAVAILABLE = 503;
    public static final int HS_ADMIN_RESTART_FILE_NOTFOUND = 520;
    public static final int HS_ADMIN_RESTART_ERROR_CONFIG = 521;
    public static final int HS_ADMIN_RESTART_NO_ADMIN_PORT = 522;
    public static final int HS_ADMIN_RESTART_NETBIND_ERROR = 523;
    public static final int HS_GENERIC_CONNECTION_ERROR = -1;

    public static void reset() {
        user = null;
        if (dialog != null) {
            dialog.closeDialog();
        }
    }

    public AuthURL(URL uRL, String string, String string2, AuthURLInterface authURLInterface) {
        this.method = string2;
        this.more = authURLInterface;
        this.host = uRL.getHost();
        this.port = uRL.getPort();
        if (this.port < 0) {
            this.port = 80;
        }
        this.uri = uRL.getRef();
        if (this.uri == null) {
            this.uri = string;
            return;
        }
        this.uri = String.valueOf(this.uri) + string;
    }

    public void appendURI(String string) {
        this.uri = String.valueOf(this.uri) + string;
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setAuthURLInterface(AuthURLInterface authURLInterface) {
        this.more = authURLInterface;
    }

    private void open() throws Exception {
        this.statusMsg = "";
        try {
            this.socket = new Socket(this.host, this.port);
            this.input = new DataInputStream(this.socket.getInputStream());
            this.output = new PrintStream(this.socket.getOutputStream());
            return;
        }
        catch (Exception exception) {
            this.socket = null;
            this.statusMsg = "Open " + exception;
            Debug.println((String)this.statusMsg);
            throw new Exception("Socket Open " + exception);
        }
    }

    private void writeRequestHeader() throws Exception {
        try {
            this.output.print(String.valueOf(this.method) + " " + this.uri + " HTTP/1.0\r\n");
            Enumeration enumeration = this.requestHeader.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)this.requestHeader.get(string);
                this.output.println(String.valueOf(string) + ": " + string2);
            }
            this.output.print("\r\n");
            return;
        }
        catch (Exception exception) {
            this.statusMsg = "Request " + exception;
            Debug.println((String)this.statusMsg);
            throw new Exception("Socket Write " + exception);
        }
    }

    private void postBody() {
        int n = 0;
        while (n < this.postBuffer.size()) {
            this.output.println((String)this.postBuffer.elementAt(n));
            ++n;
        }
    }

    private int connect_sub() {
        this.statusCode = 0;
        try {
            this.open();
            this.writeRequestHeader();
            this.statusCode = this.readResponseHeader();
            if (this.statusCode == 100 && this.method.equals("POST")) {
                this.postBody();
                this.statusCode = this.readResponseHeader();
            }
        }
        catch (Exception exception) {
            Debug.println((String)("connect_sub() : " + exception.toString()));
            this.statusCode = -1;
        }
        return this.statusCode;
    }

    private int readResponseHeader() throws Exception {
        this.responseHeader = new Hashtable();
        this.statusCode = 503;
        try {
            String string = this.input.readLine();
            Debug.println((String)("line " + string));
            StringTokenizer stringTokenizer = new StringTokenizer(string, ": ");
            stringTokenizer.nextToken();
            this.responseHeader.put("status", stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                this.statusMsg = String.valueOf(this.statusMsg) + stringTokenizer.nextToken();
                this.statusMsg = String.valueOf(this.statusMsg) + " ";
            }
            while ((string = this.input.readLine()).length() != 0) {
                stringTokenizer = new StringTokenizer(string, ": ");
                String string2 = stringTokenizer.nextToken();
                stringTokenizer.hasMoreTokens();
                String string3 = stringTokenizer.nextToken("");
                this.responseHeader.put(string2, string3);
                Debug.println((String)("key " + string2 + "val " + string3));
            }
            this.statusCode = Integer.parseInt((String)this.responseHeader.get("status"));
            Debug.println((String)("readResponseHeader() statusCode " + this.statusCode));
        }
        catch (Exception exception) {
            throw new Exception("Socket read " + exception);
        }
        return this.statusCode;
    }

    private boolean parseChallenge() {
        String string = (String)this.responseHeader.get("Admin-Authenticate");
        string = string.substring("Digest ".length(), string.length());
        Hashtable hashtable = this.parms(string);
        this.nonce = (String)hashtable.get("nonce");
        realm = (String)hashtable.get("realm");
        this.domain = (String)hashtable.get("domain");
        this.algorithm = (String)hashtable.get("algorithm");
        String string2 = (String)hashtable.get("stale");
        return string2.equals("true");
    }

    public void setRequestProperty(String string, String string2) {
        if (this.method.equals("POST")) {
            this.requestHeader.put(string, string2);
        }
    }

    public boolean close() {
        boolean bl = true;
        if (this.method.equals("POST")) {
            this.requestHeader.put("Content-Length", Integer.toString(this.postBufferLength));
            bl = this.connect() == 1;
        }
        this.close_sub();
        return bl;
    }

    private void close_sub() {
        try {
            this.output.close();
            this.input.close();
            this.socket.close();
        }
        catch (Exception exception) {
            Debug.println((String)("Close: " + exception));
        }
        connectInProgress = false;
    }

    public int connect() {
        int n = -1;
        if (connectInProgress) {
            return 0;
        }
        if (this.method.equals("POST") && this.requestHeader.get("Content-Length") == null) {
            this.postBuffer = new Vector(100);
            this.postBufferLength = 0;
            return 1;
        }
        Debug.println((String)"connect..");
        connectInProgress = true;
        this.connect_sub();
        Debug.println((String)("connect() " + this.statusCode));
        n = this.handleResponse(this.statusCode);
        if (n == -1 && this.statusCode == 401) {
            this.askUser();
            n = 0;
        }
        return n;
    }

    public void connectOrFatal() {
        int n = this.connect();
        if (n == -1) {
            new Message("Fatal", "An internal error occurred: " + this.statusMsg + "\n" + "To continue, please check the server and\n reload the Administration.");
        }
    }

    private int handleResponse(int n) {
        int n2;
        switch (n) {
            case 401: {
                boolean bl;
                this.close_sub();
                boolean bl2 = this.parseChallenge();
                if (!bl2) {
                    if (user == null) {
                        this.askUser();
                        return 0;
                    }
                    this.md5_uri();
                }
                if (bl = this.md5_nonce()) {
                    n2 = 1;
                    break;
                }
                n2 = -1;
                break;
            }
            case 412: {
                n2 = -1;
                break;
            }
            case 200: {
                n2 = 1;
                break;
            }
            default: {
                this.close_sub();
                n2 = -1;
            }
        }
        this.requestHeader = new Hashtable();
        return n2;
    }

    public String readLine() throws Exception {
        String string;
        try {
            string = this.input.readLine();
        }
        catch (IOException iOException) {
            throw new Exception("readLine:" + iOException);
        }
        return string;
    }

    public void println(String string) {
        this.postBuffer.addElement(string);
        this.postBufferLength += string.length() + 1;
    }

    void askUser() {
        String[] stringArray = new String[]{"OK", "Cancel"};
        this.panel = this.form();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("realm", realm);
        hashtable.put("user", "");
        hashtable.put("password", "");
        this.panel.load(hashtable, true);
        this.expectedAction = stringArray[0];
        dialog = new ModalDialog("Authenticate", (Component)this.panel, stringArray, (ModalDialogInterface)this, "Please enter your username and password for realm " + realm);
        dialog.show();
        this.panel.setFocus("User");
        AuthWaiter authWaiter = new AuthWaiter(dialog, (Object)this);
        authWaiter.go();
    }

    public static void disposeAuthDialog() {
        if (dialog != null) {
            dialog.dispose();
        }
    }

    private GroupedPanel form() {
        Group[] groupArray = new Group[1];
        Field[] fieldArray = new Field[]{new Field("Realm", false, 0, "realm", 0, 15), new Field("User", true, 0, "user", 0, 15), new Field("Password", true, 3, "password", 0, 15)};
        groupArray[0] = new Group("Auth", fieldArray, 3);
        return new GroupedPanel("Authorization", null, groupArray);
    }

    public synchronized boolean moreAction(Event event, Object object) {
        String string = (String)object;
        this.posted = string.equals(this.expectedAction);
        if (this.posted) {
            try {
                this.panel.store();
            }
            catch (Exception exception) {
                return false;
            }
            String string2 = (String)this.panel.table.get("user");
            String string3 = (String)this.panel.table.get("password");
            if (string2.equals("") || string3.equals("")) {
                return false;
            }
        }
        return true;
    }

    void md5_uri() {
        StringBuffer stringBuffer = new StringBuffer(this.method);
        stringBuffer.append(":");
        stringBuffer.append(this.domain);
        MD5 mD5 = new MD5();
        mD5.update(stringBuffer.toString());
        this.a2_digest = mD5.finish();
    }

    boolean isAuthSuccessful(int n) {
        return n == 200;
    }

    boolean md5_nonce() {
        StringBuffer stringBuffer = new StringBuffer(a1_digest);
        stringBuffer.append(":");
        stringBuffer.append(this.nonce);
        stringBuffer.append(":");
        stringBuffer.append(this.a2_digest);
        MD5 mD5 = new MD5();
        mD5.update(stringBuffer.toString());
        String string = mD5.finish();
        StringBuffer stringBuffer2 = new StringBuffer("Digest ");
        stringBuffer2.append("username=\"" + user + "\"");
        stringBuffer2.append(", realm=\"" + realm + "\"");
        stringBuffer2.append(", nonce=\"" + this.nonce + "\"");
        stringBuffer2.append(", uri=\"" + this.domain + "\"");
        stringBuffer2.append(", algorithm=\"" + this.algorithm + "\"");
        stringBuffer2.append(", response=\"" + string + "\"");
        this.requestHeader.put("Admin-Authorization", stringBuffer2.toString());
        boolean bl = this.isAuthSuccessful(this.connect_sub());
        if (this.more != null && bl) {
            this.more.authDoit(this.statusCode);
        }
        return bl;
    }

    private Hashtable parms(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=\" ");
            String string3 = stringTokenizer2.nextToken();
            stringTokenizer2.nextToken("\"");
            String string4 = stringTokenizer2.nextToken("\"");
            hashtable.put(string3, string4);
        }
        return hashtable;
    }
}

