/*
 * Decompiled with CFR 0.152.
 */
package sunw.admin.avm.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.image.ImageObserver;
import java.util.Enumeration;
import java.util.Vector;
import sunw.admin.avm.base.ALIGNMENT;
import sunw.admin.avm.base.ColumnData;
import sunw.admin.avm.base.Context;
import sunw.admin.avm.base.SORT_ORDER;
import sunw.admin.avm.base.Scroller;
import sunw.admin.avm.base.Sort;
import sunw.admin.avm.base.TableView;
import sunw.admin.avm.base.Util;
import sunw.admin.avm.base.ViewPanel;

public class Table
extends Scroller {
    private static String _sccsID = "@(#)Table.java\t1.20    96/09/21 SMI";
    TableView tv;
    ViewPanel header;
    ViewPanel pinnedColumn;
    boolean showHorzScrollbar = true;
    boolean showVertScrollbar = true;
    int numRows;
    int numVisibleRows;
    Vector[] rows;
    int numFilteredRows;
    Vector[] filteredRows;
    int numColumns;
    ColumnData[] colInfo = new ColumnData[9];
    int curCol = -1;
    int padding;
    int firstrow;
    int firstcol;
    int pinnedcol = -1;
    int scrollx;
    int rowh;
    int baseline;
    int hmargin = 10;
    int vmargin = 2;
    int hgap = 3;
    int vgap = 1;
    Image viewBuffer;
    Image headerBuffer;
    boolean showColDivs = false;
    boolean showRowDivs = false;
    Font font = Context.getFontProperty((String)"plainFont");
    Font labelFont = Context.getFontProperty((String)"labelFont");
    boolean multipleSelections = false;
    int[] selected = new int[0];
    boolean columnsResizable = true;
    boolean resizing = false;
    int resizeColumn;
    int startx;
    int endx;
    int z;
    boolean inDrag = false;
    TextField[] textField = new TextField[20];
    StringBuffer searchPattern = new StringBuffer();
    private int _sortIndex;
    private int _filterIndex;
    private String _filterExpr;
    private long _lastTime;

    public Table() {
        this(0);
    }

    public Table(int n) {
        Color color;
        this.header = new ViewPanel();
        this.add("Header", (Component)this.header);
        this.header.hide();
        this.rows = new Vector[40];
        this.filteredRows = this.rows;
        this.numVisibleRows = n;
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.font);
        if (fontMetrics != null) {
            this.baseline = fontMetrics.getAscent();
            this.rowh = fontMetrics.getHeight() + 2 * this.vmargin;
            this.header.resize(100, fontMetrics.getHeight());
        }
        if ((color = Context.getColorProperty((String)"Table.viewportBackground")) != null) {
            this.viewport.setBackground(color);
        }
        if ((color = Context.getColorProperty((String)"Table.viewportForeground")) != null) {
            this.viewport.setForeground(color);
        }
        if ((color = Context.getColorProperty((String)"Table.headerBackground")) != null) {
            this.header.setBackground(color);
        }
        if ((color = Context.getColorProperty((String)"Table.headerForeground")) != null) {
            this.header.setForeground(color);
        }
    }

    public Table(int n, TableView tableView) {
        this(n);
        this.tv = tableView;
    }

    public Component viewportArea() {
        return this.viewport;
    }

    public Component headerArea() {
        return this.header;
    }

    public void scrollTo(int n, int n2) {
    }

    public Dimension getScrollAreaSize() {
        return new Dimension(0, 0);
    }

    public void manageScrollbars() {
        this.manageVbar();
        boolean bl = this.manageHbar();
        if (bl) {
            this.manageVbar();
        }
    }

    private boolean manageHbar() {
        int n = 0;
        boolean bl = false;
        if (this.showHorzScrollbar) {
            int n2 = this.getNumColumns();
            int n3 = this.getVisibleColumns();
            if (n2 > 1 && n2 - n3 > 0) {
                Dimension dimension;
                if (!this.hbar.isVisible()) {
                    this.hbar.show();
                    bl = true;
                }
                Dimension dimension2 = this.size();
                if (this.vbar != null && this.vbar.isVisible()) {
                    dimension = this.vbar.preferredSize();
                    dimension2.width -= dimension.width;
                }
                if (this.pinnedColumn != null && this.pinnedColumn.isVisible()) {
                    dimension = this.pinnedColumn.preferredSize();
                    dimension2.width -= dimension.width;
                }
                int n4 = this.scrollableWidth();
                this.padding = this.hbar.size().width / 2;
                int n5 = this.hmargin;
                int n6 = 0;
                while (n6 < this.numColumns && n5 < n4 - dimension2.width) {
                    n5 += this.colInfo[n6].width + this.hmargin;
                    ++n6;
                }
                int n7 = Math.min(this.hbar.getValue(), n6);
                int n8 = Math.max(n3, 1);
                this.hbar.setValues(n7, n8, n, n6);
                this.hbar.setLineIncrement(1);
                this.hbar.setPageIncrement(n8);
                this.setLeftColumn(n7);
            } else if (this.hbar.isVisible()) {
                this.hbar.hide();
                this.hbar.setValue(0);
                this.setLeftColumn(0);
                bl = true;
            }
        }
        return bl;
    }

    private boolean manageVbar() {
        int n = 0;
        boolean bl = false;
        if (this.showVertScrollbar) {
            int n2;
            int n3 = this.getNumRows();
            if (n3 - (n2 = this.getVisibleRows()) > 0) {
                if (!this.vbar.isVisible()) {
                    this.vbar.show();
                    bl = true;
                }
                int n4 = n3 - n2;
                int n5 = Math.min(this.vbar.getValue(), n4);
                int n6 = Math.max(n2, 1);
                this.vbar.setValues(n5, n6, n, n4);
                this.vbar.setLineIncrement(1);
                this.vbar.setPageIncrement(n6);
                this.setTopRow(n5);
            } else if (this.vbar.isVisible()) {
                this.vbar.hide();
                this.vbar.setValue(0);
                this.setTopRow(0);
                bl = true;
            }
        }
        return bl;
    }

    public Dimension preferredSize(int n) {
        Dimension dimension = new Dimension(4, 4);
        dimension.height += n * (this.rowh + this.vmargin);
        dimension.width = this.scrollableWidth();
        if (this.header != null) {
            Dimension dimension2 = this.header.size();
            dimension.height += dimension2.height;
        }
        return dimension;
    }

    public Dimension preferredSize() {
        if (this.numVisibleRows > 0) {
            return this.preferredSize(this.numVisibleRows);
        }
        return super.preferredSize();
    }

    public synchronized void addRow(Vector vector) {
        this.addRow(vector, -1);
    }

    public synchronized void addRow(Vector vector, int n) {
        Object object;
        int n2 = 0;
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof String) && object instanceof Image) {
                this.rowh = Math.max(this.rowh, ((Image)object).getHeight((ImageObserver)this));
            }
            vector2.addElement(object);
            ++n2;
        }
        if (this.numRows == this.rows.length) {
            object = new Vector[this.rows.length + 100];
            System.arraycopy(this.rows, 0, object, 0, this.rows.length);
            this.rows = object;
            this.filteredRows = this.rows;
        }
        if (n < -1 || n >= this.numRows) {
            n = -1;
        }
        if (n == -1) {
            this.rows[this.numRows++] = vector2;
        } else {
            n2 = this.numRows;
            while (n2 > n) {
                this.rows[n2] = this.rows[n2 - 1];
                --n2;
            }
            this.rows[n] = vector2;
            ++this.numRows;
        }
        this.numFilteredRows = this.numRows;
        if (this.numColumns == 0) {
            this.numColumns = n2;
        }
        this.manageScrollbars();
        this.repaint();
    }

    public synchronized void setRows(Vector[] vectorArray) {
        this.rows = vectorArray;
        this.filteredRows = vectorArray;
        this.numFilteredRows = this.numRows = vectorArray.length;
        this.manageScrollbars();
        this.repaint();
    }

    public synchronized void replaceRow(Vector vector, int n) {
        if (n < 0 || n >= this.numRows) {
            return;
        }
        this.rows[n] = vector;
        this.repaint();
    }

    public synchronized void deleteRow(int n) {
        if (n < 0 || n >= this.numRows) {
            return;
        }
        int n2 = n;
        while (n2 < this.numRows - 1) {
            this.rows[n2] = this.rows[n2 + 1];
            ++n2;
        }
        --this.numRows;
        this.numFilteredRows = this.numRows;
        if (this.isSelected(n)) {
            int[] nArray = new int[this.selected.length - 1];
            if (nArray.length > 0) {
                System.arraycopy(this.selected, 0, nArray, 0, n);
                System.arraycopy(this.selected, n + 1, nArray, n, this.selected.length - (n + 1));
            }
            this.selected = nArray;
        }
        int n3 = 0;
        while (n3 < this.selected.length) {
            if (n < this.selected[n3]) {
                int n4 = n3;
                this.selected[n4] = this.selected[n4] - 1;
            }
            ++n3;
        }
        this.manageScrollbars();
        this.repaint();
    }

    public synchronized void clear() {
        this.rows = new Vector[100];
        this.filteredRows = this.rows;
        this.numRows = 0;
        this.numFilteredRows = 0;
        this.selected = new int[0];
        this.manageScrollbars();
        this.repaint();
    }

    public Object getItem(int n, int n2) {
        return this.rows[n].elementAt(n2);
    }

    public Vector getRow(int n) {
        return this.filteredRows[n];
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumRows() {
        return this.numFilteredRows;
    }

    public int getColumnWidth(int n) {
        return this.colInfo[n].width;
    }

    public String getColumnLabel(int n) {
        return this.colInfo[n].label;
    }

    public boolean getColumnsResizable() {
        return this.columnsResizable;
    }

    public int getVisibleRows() {
        Dimension dimension;
        Dimension dimension2 = this.size();
        if (this.header != null && this.header.isVisible()) {
            dimension = this.header.preferredSize();
            dimension2.height -= dimension.height;
        }
        if (this.hbar != null && this.hbar.isVisible()) {
            dimension = this.hbar.preferredSize();
            dimension2.height -= dimension.height;
        }
        int n = (dimension2.height - 4) / (this.rowh + this.vmargin);
        return Math.max(n, 0);
    }

    public synchronized void setItem(int n, int n2, Object object) {
        if (n < 0 || n >= this.numRows) {
            return;
        }
        this.rows[n].setElementAt(object, n2);
        this.repaint();
    }

    public synchronized void setColumnLabel(int n, String string) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range");
        }
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.labelFont);
        this.colInfo[n].label = string;
        this.colInfo[n].width = fontMetrics.stringWidth(string) + 5;
        this.colInfo[n].align = ALIGNMENT.LEFT;
        this.header.show();
    }

    public synchronized void setColumnLabels(Vector vector) {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.labelFont);
        this.setNumColumns(vector.size());
        int n = 0;
        while (n < vector.size()) {
            String string;
            this.colInfo[n].label = string = (String)vector.elementAt(n);
            this.colInfo[n].width = fontMetrics.stringWidth(string) + 5;
            this.colInfo[n].align = ALIGNMENT.LEFT;
            ++n;
        }
        this.header.show();
    }

    public synchronized void setNumColumns(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of columns less than one");
        }
        ColumnData[] columnDataArray = new ColumnData[n];
        int n2 = Math.min(n, this.numColumns);
        int n3 = 0;
        while (n3 < n2) {
            columnDataArray[n3] = this.colInfo[n3];
            ++n3;
        }
        int n4 = this.numColumns;
        while (n4 < n) {
            columnDataArray[n4] = new ColumnData();
            ++n4;
        }
        this.numColumns = n;
        this.colInfo = columnDataArray;
    }

    public synchronized void setColumnWidth(int n, int n2) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range");
        }
        this.colInfo[n].width = n2;
    }

    public synchronized void setColumnWidth(int n, int n2, ALIGNMENT aLIGNMENT) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range");
        }
        this.colInfo[n].width = n2;
        this.colInfo[n].align = aLIGNMENT;
    }

    public synchronized void setColumnWidthInChars(int n, int n2) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range");
        }
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.font);
        this.colInfo[n].width = Math.max(n2 * fontMetrics.charWidth('a'), this.colInfo[n].width);
    }

    public synchronized void setColumnWidthInChars(int n, int n2, ALIGNMENT aLIGNMENT) {
        this.setColumnWidthInChars(n, n2);
        this.colInfo[n].align = aLIGNMENT;
    }

    public synchronized void setColumnsResizable(boolean bl) {
        Frame frame;
        this.columnsResizable = bl;
        if (!this.columnsResizable && (frame = Util.findFrame((Component)this)) != null) {
            frame.setCursor(0);
        }
    }

    public int getSortColumn() {
        return this._sortIndex;
    }

    public int getFilterColumn() {
        return this._filterIndex;
    }

    public void setSortColumn(int n) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range");
        }
        this._sortIndex = n;
        this.curCol = n;
    }

    public void setFilterColumn(int n) {
        if (n < 0 || n > this.numColumns - 1) {
            throw new IllegalArgumentException("Column number out of range");
        }
        this._filterIndex = n;
    }

    public void setFilterExpression(String string) {
        this._filterExpr = string;
    }

    public String setFilterExpression() {
        return this._filterExpr;
    }

    public void showColumnDividers(boolean bl) {
        if (bl != this.showColDivs) {
            this.showColDivs = bl;
            this.repaint();
        }
    }

    public void showRowDividers(boolean bl) {
        if (bl != this.showRowDivs) {
            this.showRowDivs = bl;
            this.repaint();
        }
    }

    public void showHorizontalScrollbar(boolean bl) {
        this.showHorzScrollbar = bl;
        if (bl) {
            this.hbar.show();
            return;
        }
        this.hbar.hide();
    }

    public void showVerticalScrollbar(boolean bl) {
        this.showVertScrollbar = bl;
        if (bl) {
            this.vbar.show();
            return;
        }
        this.vbar.hide();
    }

    public synchronized int getSelectedIndex() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray.length == 1) {
            return nArray[0];
        }
        return -1;
    }

    public synchronized int[] getSelectedIndexes() {
        return this.selected;
    }

    public synchronized Vector[] getSelectedRows() {
        int[] nArray = this.getSelectedIndexes();
        Vector[] vectorArray = new Vector[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            vectorArray[n] = this.filteredRows[nArray[n]];
            ++n;
        }
        return vectorArray;
    }

    public synchronized void select(int n) {
        this.select(n, true);
    }

    public void select(int n, boolean bl) {
        Object object;
        if (n < 0 || n >= this.numFilteredRows) {
            return;
        }
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                return;
            }
            ++n2;
        }
        Graphics graphics = this.viewBuffer.getGraphics();
        if (!this.multipleSelections) {
            if (this.selected.length > 0) {
                this.highlight(this.selected[0], false, graphics);
            }
            this.selected = new int[1];
            this.selected[0] = n;
        } else {
            object = new int[this.selected.length + 1];
            System.arraycopy(this.selected, 0, object, 0, this.selected.length);
            object[this.selected.length] = n;
            this.selected = object;
        }
        this.highlight(n, true, graphics);
        this.drawDividers(graphics);
        object = this.viewport.getGraphics();
        ((Graphics)object).drawImage(this.viewBuffer, 0, 0, (ImageObserver)this);
        if (bl) {
            Event event = new Event(this, System.currentTimeMillis(), 701, 0, 0, 0, 0, new Integer(n));
            this.deliverEvent(event);
        }
    }

    public synchronized void deselect(int n) {
        int n2 = 0;
        while (n2 < this.selected.length) {
            if (this.selected[n2] == n) {
                Graphics graphics = this.viewBuffer.getGraphics();
                this.highlight(n, false, graphics);
                this.drawDividers(graphics);
                Graphics graphics2 = this.viewport.getGraphics();
                graphics2.drawImage(this.viewBuffer, 0, 0, (ImageObserver)this);
                int[] nArray = new int[this.selected.length - 1];
                System.arraycopy(this.selected, 0, nArray, 0, n2);
                System.arraycopy(this.selected, n2 + 1, nArray, n2, this.selected.length - (n2 + 1));
                this.selected = nArray;
                Event event = new Event(this, System.currentTimeMillis(), 702, 0, 0, 0, 0, new Integer(n));
                this.deliverEvent(event);
                return;
            }
            ++n2;
        }
    }

    public synchronized void deselectAll() {
        this.selected = new int[0];
        this.repaint();
    }

    public synchronized boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean allowsMultipleSelections() {
        return this.multipleSelections;
    }

    public synchronized void setMultipleSelections(boolean bl) {
        if (bl != this.multipleSelections) {
            this.multipleSelections = bl;
            this.selected = new int[0];
            this.repaint();
        }
    }

    public void makeRowVisible(int n) {
        int n2 = this.getVisibleRows();
        if (n < this.firstrow || n > this.firstrow + n2) {
            this.firstrow = Math.max(n - n2 / 2, 0);
            this.firstrow = Math.min(this.numRows - n2, this.firstrow);
            this.vbar.setValue(n);
            this.repaint();
        }
    }

    public void pinColumn(int n) {
        if (n < 0 || n >= this.numColumns || this.pinnedcol != -1) {
            return;
        }
        this.pinnedColumn = new ViewPanel();
        this.add("Pin", (Component)this.pinnedColumn);
        this.pinnedColumn.resize(this.colInfo[n].width + this.hmargin, 100);
        this.pinnedcol = n;
        this.validate();
    }

    public void unpinColumn(int n) {
        if (n < 0 || n >= this.numColumns || this.pinnedcol == -1) {
            return;
        }
        this.remove((Component)this.pinnedColumn);
        this.pinnedColumn = null;
        this.pinnedcol = -1;
        this.validate();
    }

    public void filter() {
        if (this._filterExpr == null) {
            return;
        }
        this.numFilteredRows = 0;
        int n = 0;
        while (n < this.numRows) {
            if (this.match(this.rows[n], this._filterExpr)) {
                ++this.numFilteredRows;
            }
            ++n;
        }
        this.filteredRows = new Vector[this.numFilteredRows];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numRows) {
            if (this.match(this.rows[n3], this._filterExpr)) {
                this.filteredRows[n2++] = this.rows[n3];
            }
            ++n3;
        }
        this.manageScrollbars();
        this.sort();
    }

    private boolean match(Vector vector, String string) {
        Object e = vector.elementAt(this._filterIndex);
        if (e instanceof String) {
            return Util.wildmatch((String)((String)e), (String)string);
        }
        if (e instanceof Integer) {
            return Util.wildmatch((String)((Integer)e).toString(), (String)string);
        }
        if (e instanceof Double) {
            return Util.wildmatch((String)((Double)e).toString(), (String)string);
        }
        return false;
    }

    protected int compare(Vector vector, Vector vector2) {
        Object e = vector.elementAt(this._sortIndex);
        Object e2 = vector2.elementAt(this._sortIndex);
        if (e instanceof String) {
            String string = (String)e;
            String string2 = (String)e2;
            return string.compareTo(string2);
        }
        if (e instanceof Integer) {
            int n = (Integer)e;
            int n2 = (Integer)e2;
            return n - n2;
        }
        return 0;
    }

    public void sort() {
        Sort.quickSort((Table)this);
        this.deselectAll();
    }

    public void sort(SORT_ORDER sORT_ORDER) {
        Sort.quickSort((Vector[])this.filteredRows, (int)0, (int)(this.numFilteredRows - 1), (int)this._sortIndex, (SORT_ORDER)sORT_ORDER);
        this.deselectAll();
    }

    public void paint(Graphics graphics) {
        Dimension dimension;
        Rectangle rectangle = this.viewport.bounds();
        graphics.setColor(this.getBackground());
        this.drawBevelRect(graphics, rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4, 2, false);
        if (this.viewBuffer == null) {
            dimension = this.size();
            this.viewBuffer = this.createImage(dimension.width, dimension.height);
            this.headerBuffer = this.createImage(dimension.width, this.rowh + this.vmargin);
        }
        this.drawLabels(this.headerBuffer.getGraphics());
        dimension = this.viewport.size();
        Graphics graphics2 = this.viewBuffer.getGraphics();
        graphics2.setColor(this.viewport.getBackground());
        graphics2.fillRect(0, 0, dimension.width, dimension.height);
        graphics2.translate(this.scrollx, 0);
        this.drawList(graphics2);
        int n = 0;
        while (n < this.selected.length) {
            this.highlight(this.selected[n], true, graphics2);
            ++n;
        }
        this.drawDividers(graphics2);
        Graphics graphics3 = this.viewport.getGraphics();
        graphics3.drawImage(this.viewBuffer, 0, 0, (ImageObserver)this);
        Graphics graphics4 = this.header.getGraphics();
        graphics4.drawImage(this.headerBuffer, 0, 0, (ImageObserver)this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.viewBuffer = null;
        this.headerBuffer = null;
    }

    public boolean handleEvent(Event event) {
        this.viewport.location();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (event.id == 601 || event.id == 602 || event.id == 603 || event.id == 604 || event.id == 605) {
            n = ((Scrollbar)event.target).getOrientation();
            n5 = ((Scrollbar)event.target).getMinimum();
            n6 = ((Scrollbar)event.target).getMaximum();
            n2 = ((Scrollbar)event.target).getVisible();
            n3 = ((Scrollbar)event.target).getLineIncrement();
            n4 = ((Scrollbar)event.target).getPageIncrement();
        }
        switch (event.id) {
            case 505: {
                return this.pointerExit(event, event.x, event.y);
            }
            case 503: {
                return this.pointerMove(event, event.x, event.y);
            }
            case 501: {
                return this.pointerDown(event, event.x, event.y);
            }
            case 506: {
                return this.pointerDrag(event, event.x, event.y);
            }
            case 502: {
                return this.pointerUp(event, event.x, event.y);
            }
            case 401: 
            case 403: {
                return this.keyPress(event, event.key);
            }
            case 601: {
                if (n == 1) {
                    if (this.firstrow > 0) {
                        this.firstrow -= n3;
                    }
                } else if (this.firstcol > 0) {
                    this.firstcol -= n3;
                }
                this.repaint();
                break;
            }
            case 602: {
                if (n == 1) {
                    if (this.firstrow < this.numRows) {
                        this.firstrow += n3;
                    }
                } else if (this.firstcol < this.numColumns) {
                    this.firstcol += n3;
                }
                this.repaint();
                break;
            }
            case 603: {
                if (n == 1) {
                    this.firstrow = Math.max(this.firstrow - n4, n5);
                } else {
                    this.firstcol = Math.max(this.firstcol - n4, n5);
                }
                this.repaint();
                break;
            }
            case 604: {
                if (n == 1) {
                    this.firstrow = Math.min(this.firstrow + n4, n6);
                } else {
                    this.firstcol = Math.min(this.firstcol + n4, n6);
                }
                this.repaint();
                break;
            }
            case 605: {
                int n7 = (Integer)event.arg;
                if (n == 1) {
                    this.firstrow = n7;
                } else {
                    this.firstcol = n7;
                }
                this.repaint();
                break;
            }
            default: {
                return super.handleEvent(event);
            }
        }
        return false;
    }

    private boolean pointerExit(Event event, int n, int n2) {
        if (event.target == this.viewport && this.resizing) {
            Frame frame = Util.findFrame((Component)this);
            if (frame != null) {
                frame.setCursor(0);
            }
            this.resizing = false;
            if (this.inDrag) {
                this.inDrag = false;
                Graphics graphics = this.viewport.getGraphics();
                Dimension dimension = this.viewport.size();
                graphics.setXORMode(Color.blue);
                graphics.drawLine(this.endx, 0, this.endx, dimension.height);
                this.repaint();
            }
        }
        return true;
    }

    private boolean pointerMove(Event event, int n, int n2) {
        if (this.inDrag) {
            return this.pointerDrag(event, n, n2);
        }
        if (!this.columnsResizable) {
            return true;
        }
        if (this.inResizeArea(n, n2)) {
            if (!this.resizing) {
                Frame frame = Util.findFrame((Component)this);
                if (frame != null) {
                    frame.setCursor(11);
                }
                this.resizing = true;
            }
        } else if (this.resizing) {
            Frame frame = Util.findFrame((Component)this);
            if (frame != null) {
                frame.setCursor(0);
            }
            this.resizing = false;
        }
        this.repaint();
        return true;
    }

    private boolean pointerDrag(Event event, int n, int n2) {
        if (this.resizing && n > this.startx) {
            this.inDrag = true;
            Graphics graphics = this.viewport.getGraphics();
            Dimension dimension = this.viewport.size();
            graphics.setXORMode(Color.blue);
            graphics.drawLine(this.endx, 0, this.endx, dimension.height);
            this.endx = n;
            graphics.drawLine(this.endx, 0, this.endx, dimension.height);
        }
        return true;
    }

    private boolean pointerDown(Event event, int n, int n2) {
        Rectangle rectangle = this.viewport.bounds();
        this.doSelectColumn(event, n, n2);
        if (!rectangle.inside(n, n2) || this.firstrow + (n2 - rectangle.y) / (this.rowh + this.vmargin) > this.numFilteredRows - 1) {
            return true;
        }
        if (this.columnsResizable && this.inResizeArea(n, n2)) {
            this.resizing = true;
            Graphics graphics = this.viewport.getGraphics();
            graphics.setXORMode(Color.blue);
            graphics.drawLine(this.endx, 0, this.endx, rectangle.height);
        } else {
            int n3 = this.firstrow + (n2 - rectangle.y) / (this.rowh + this.vmargin);
            this.select(n3, false);
            Event event2 = new Event(this, event.when, 701, event.x, event.y, event.key, event.modifiers, new Integer(n3));
            event2.clickCount = event.clickCount;
            event2.clickCount = event.when - this._lastTime < 250L ? 2 : 1;
            this._lastTime = event.when;
            this.doSelectRow(n3, event2.clickCount);
            this.deliverEvent(event2);
        }
        return true;
    }

    private boolean pointerUp(Event event, int n, int n2) {
        this.inDrag = false;
        if (this.resizing) {
            Frame frame;
            this.resizing = false;
            Graphics graphics = this.viewport.getGraphics();
            Dimension dimension = this.viewport.size();
            graphics.setXORMode(Color.blue);
            graphics.drawLine(this.endx, 0, this.endx, dimension.height);
            this.setColumnWidth(this.resizeColumn, this.endx - this.startx - this.hmargin / 2);
            if (!this.inResizeArea(n, n2) && (frame = Util.findFrame((Component)this)) != null) {
                frame.setCursor(0);
            }
            this.manageScrollbars();
        }
        this.repaint();
        return true;
    }

    private boolean keyPress(Event event, int n) {
        return false;
    }

    private synchronized void setTopRow(int n) {
        if (n >= 0 && n < this.numRows) {
            this.firstrow = n;
            this.vbar.setValue(n);
            this.repaint();
        }
    }

    private synchronized void setLeftColumn(int n) {
        if (n >= 0 && n < this.numColumns) {
            this.firstcol = n;
            this.hbar.setValue(n);
            this.repaint();
        }
    }

    private int scrollableWidth() {
        int n = this.hmargin;
        int n2 = 0;
        while (n2 < this.numColumns) {
            n += this.colInfo[n2].width + this.hmargin;
            ++n2;
        }
        return n;
    }

    private int getVisibleColumns() {
        Dimension dimension;
        Dimension dimension2 = this.size();
        if (this.vbar != null && this.vbar.isVisible()) {
            dimension = this.vbar.preferredSize();
            dimension2.width -= dimension.width;
        }
        if (this.pinnedColumn != null && this.pinnedColumn.isVisible()) {
            dimension = this.pinnedColumn.preferredSize();
            dimension2.width -= dimension.width;
        }
        int n = -1;
        int n2 = 0;
        while (n < this.numColumns - 1 && n2 < dimension2.width - 4) {
            if (++n == this.pinnedcol) continue;
            n2 += this.hmargin + this.colInfo[n].width;
        }
        return Math.max(n, 0);
    }

    private void highlight(int n, boolean bl, Graphics graphics) {
        Color color;
        Color color2;
        Dimension dimension = this.viewport.size();
        if (n < 0 || n > this.numFilteredRows + this.getVisibleRows()) {
            return;
        }
        graphics.translate(0, 0);
        Rectangle rectangle = new Rectangle(0, (n - this.firstrow) * (this.rowh + this.vmargin), dimension.width, this.rowh);
        if (bl) {
            color2 = this.viewport.getForeground();
            color = this.viewport.getBackground();
        } else {
            color2 = this.viewport.getBackground();
            color = this.viewport.getForeground();
        }
        graphics.setColor(color2);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color);
        graphics.translate(this.scrollx, 0);
        graphics.setFont(this.font);
        this.drawRow(this.filteredRows[n], rectangle.y, graphics);
    }

    private void drawRow(Vector vector, int n, Graphics graphics) {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.font);
        Graphics graphics2 = null;
        int n2 = fontMetrics.getHeight();
        int n3 = this.hmargin;
        int n4 = 0;
        if (this.pinnedColumn != null) {
            graphics2 = this.pinnedColumn.getGraphics();
            graphics2.setFont(this.font);
        }
        int n5 = this.firstcol;
        while (n5 < Math.min(this.firstcol + this.numColumns, this.numColumns)) {
            int n6;
            Object e;
            try {
                e = vector.elementAt(n5);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return;
            }
            if (e instanceof String || e instanceof Integer) {
                String string = e instanceof String ? (String)e : e.toString();
                n6 = fontMetrics.stringWidth(string);
                if (this.colInfo[n5].align == ALIGNMENT.LEFT) {
                    n4 = 0;
                } else if (this.colInfo[n5].align == ALIGNMENT.CENTER) {
                    n4 = (this.colInfo[n5].width - n6) / 2;
                } else if (this.colInfo[n5].align == ALIGNMENT.RIGHT) {
                    n4 = this.colInfo[n5].width - n6;
                }
                if (n5 == this.pinnedcol) {
                    graphics2.translate(this.hmargin, n);
                    graphics2.drawString(string, n4, (this.rowh - n2) / 2 + this.baseline);
                } else {
                    Graphics graphics3 = graphics.create();
                    graphics3.translate(n3, n);
                    graphics3.clipRect(0, 0, this.colInfo[n5].width, this.rowh);
                    graphics3.drawString(string, n4, (this.rowh - n2) / 2 + this.baseline);
                }
            } else if (e instanceof Image) {
                n6 = ((Image)e).getWidth((ImageObserver)this);
                int n7 = ((Image)e).getHeight((ImageObserver)this);
                if (this.colInfo[n5].align == ALIGNMENT.LEFT) {
                    n4 = 0;
                } else if (this.colInfo[n5].align == ALIGNMENT.CENTER) {
                    n4 = (this.colInfo[n5].width - n6) / 2;
                } else if (this.colInfo[n5].align == ALIGNMENT.RIGHT) {
                    n4 = this.colInfo[n5].width - n6;
                }
                if (n5 == this.pinnedcol) {
                    n3 = this.hmargin;
                    graphics2.drawImage((Image)e, n3 + n4, n + (this.rowh - n7) / 2, (ImageObserver)this);
                } else {
                    graphics.drawImage((Image)e, n3 + n4, n + (this.rowh - n7) / 2, (ImageObserver)this);
                }
            }
            if (n5 != this.pinnedcol) {
                n3 += this.colInfo[n5].width + this.hmargin;
            }
            ++n5;
        }
    }

    private void drawList(Graphics graphics) {
        if (this.pinnedColumn != null) {
            Dimension dimension = this.pinnedColumn.size();
            Graphics graphics2 = this.pinnedColumn.getGraphics();
            graphics2.clearRect(0, 0, dimension.width, dimension.height);
        }
        graphics.setFont(this.font);
        graphics.setColor(this.viewport.getForeground());
        int n = 0;
        int n2 = Math.min(this.firstrow + this.getVisibleRows(), this.numFilteredRows);
        int n3 = this.firstrow;
        while (n3 < n2) {
            this.drawRow(this.filteredRows[n3], (this.rowh + this.vmargin) * n++, graphics);
            ++n3;
        }
    }

    private void drawLabels(Graphics graphics) {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.labelFont);
        int n = 0;
        if (this.header != null && this.header.isVisible()) {
            Rectangle rectangle = this.viewport.bounds();
            Rectangle rectangle2 = this.header.bounds();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(0, 0, rectangle2.width, rectangle2.height);
            graphics.setColor(this.header.getForeground());
            graphics.setFont(this.labelFont);
            int n2 = this.hmargin;
            int n3 = this.firstcol;
            while (n3 < Math.min(this.firstcol + this.numColumns, this.numColumns)) {
                int n4 = fontMetrics.stringWidth(this.colInfo[n3].label);
                if (this.colInfo[n3].align == ALIGNMENT.LEFT) {
                    n = 0;
                } else if (this.colInfo[n3].align == ALIGNMENT.CENTER) {
                    n = (this.colInfo[n3].width - n4) / 2;
                } else if (this.colInfo[n3].align == ALIGNMENT.RIGHT) {
                    n = this.colInfo[n3].width - n4;
                }
                Graphics graphics2 = graphics.create();
                if (n3 == this.pinnedcol) {
                    graphics2.translate(this.hmargin, 0);
                } else {
                    graphics2.translate(rectangle.x + this.scrollx + n2, 0);
                }
                graphics2.clipRect(0, 0, this.colInfo[n3].width, this.rowh);
                graphics2.drawString(this.colInfo[n3].label, n, this.baseline);
                if (n3 != this.pinnedcol) {
                    n2 += this.colInfo[n3].width + this.hmargin;
                }
                ++n3;
            }
            this.drawFocusRect(fontMetrics, graphics, this.curCol);
        }
    }

    private void paintLabel(int n, Rectangle rectangle, Graphics graphics, FontMetrics fontMetrics, int n2) {
        int n3 = 0;
        int n4 = fontMetrics.stringWidth(this.colInfo[n].label);
        if (this.colInfo[n].align == ALIGNMENT.LEFT) {
            n3 = 0;
        } else if (this.colInfo[n].align == ALIGNMENT.CENTER) {
            n3 = (this.colInfo[n].width - n4) / 2;
        } else if (this.colInfo[n].align == ALIGNMENT.RIGHT) {
            n3 = this.colInfo[n].width - n4;
        }
        if (n == this.pinnedcol) {
            graphics.translate(this.hmargin, 0);
        } else {
            graphics.translate(rectangle.x + this.scrollx + n2, 0);
        }
        graphics.setColor(this.header.getForeground());
        graphics.setFont(this.labelFont);
        graphics.drawString(this.colInfo[n].label, n3, this.baseline);
    }

    private void doSelectRow(int n, int n2) {
        if (this.tv != null) {
            this.tv.onRowSelect(n, n2);
        }
    }

    private void doSelectColumn(Event event, int n, int n2) {
        this.getToolkit().getFontMetrics(this.labelFont);
        int n3 = this.pointerToColumn(n, n2);
        if (n3 == -1) {
            return;
        }
        this.curCol = n3;
        this.drawLabels(this.header.getGraphics());
        if (this.tv != null) {
            this.tv.onColumnSelect(this.curCol, event.modifiers);
        }
    }

    private void drawFocusRect(FontMetrics fontMetrics, Graphics graphics, int n) {
        Rectangle rectangle = this.viewport.bounds();
        Rectangle rectangle2 = this.header.bounds();
        if (n < this.firstcol || n > this.numColumns) {
            return;
        }
        int n2 = this.hmargin;
        int n3 = this.firstcol;
        while (n3 < n) {
            n2 += this.colInfo[n3].width + this.hmargin;
            ++n3;
        }
        Graphics graphics2 = graphics.create();
        graphics2.setColor(this.getBackground());
        graphics2.fill3DRect(rectangle.x + this.scrollx + n2, 0, this.colInfo[n3].width, rectangle2.height - this.vmargin, true);
        this.paintLabel(n, rectangle, graphics2, fontMetrics, n2);
    }

    private int pointerToColumn(int n, int n2) {
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(this.labelFont);
        int n3 = 0;
        Rectangle rectangle = this.header.bounds();
        this.viewport.bounds();
        if (!rectangle.inside(n, n2)) {
            return -1;
        }
        n3 = this.hmargin;
        int n4 = this.firstcol;
        while (n4 < Math.min(this.firstcol + this.numColumns, this.numColumns)) {
            fontMetrics.stringWidth(this.colInfo[n4].label);
            if (n >= n3 && n <= n3 + this.colInfo[n4].width + this.hmargin) {
                return n4;
            }
            n3 += this.colInfo[n4].width + this.hmargin;
            ++n4;
        }
        return -1;
    }

    private void drawBevelLine(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        Color color = graphics.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        graphics.setColor(bl ? color2 : color3);
        if (n4 == 0) {
            graphics.drawLine(n, n2, n3, n2);
        } else {
            graphics.drawLine(n, n2, n, n3);
        }
        graphics.setColor(bl ? color3 : color2);
        if (n4 == 0) {
            graphics.drawLine(n, n2 + 1, n3, n2 + 1);
        } else {
            graphics.drawLine(n + 1, n2, n + 1, n3);
        }
        graphics.setColor(color);
    }

    private void drawBevelRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        Color color = graphics.getColor();
        Color color2 = color.brighter();
        Color color3 = color.darker();
        graphics.setColor(bl ? color2 : color3);
        int n6 = 0;
        while (n6 < n5) {
            graphics.drawLine(n + n6, n2 + n6, n + n6, n2 + n4 - n6);
            graphics.drawLine(n + n6 + 1, n2 + n6, n + n3 - n6 - 1, n2 + n6);
            ++n6;
        }
        graphics.setColor(bl ? color3 : color2);
        int n7 = 0;
        while (n7 < n5) {
            graphics.drawLine(n + n7 + 1, n2 + n4 - n7, n + n3 - n7, n2 + n4 - n7);
            graphics.drawLine(n + n3 - n7, n2 + n7, n + n3 - n7, n2 + n4 - n7 - 1);
            ++n7;
        }
        graphics.setColor(color);
    }

    private void drawDividers(Graphics graphics) {
        int n;
        int n2;
        Dimension dimension = this.viewport.size();
        graphics.setColor(this.getBackground());
        if (this.showRowDivs) {
            int n3 = 0;
            int n4 = this.getVisibleRows();
            n2 = 0;
            while (n2 < n4) {
                n = (n3 += this.rowh) + this.vmargin / 2 - 1;
                this.drawBevelLine(graphics, 0, n, dimension.width, 0, true);
                n3 += this.vmargin;
                ++n2;
            }
        }
        if (this.showColDivs) {
            int n5 = this.hmargin;
            n2 = this.firstcol;
            while (n2 < Math.min(this.firstcol + this.numColumns - 1, this.numColumns - 1)) {
                if (n2 != this.pinnedcol) {
                    n = (n5 += this.colInfo[n2].width) + this.hmargin / 2 - 1;
                    this.drawBevelLine(graphics, n, 0, dimension.height, 1, true);
                    n5 += this.hmargin;
                }
                ++n2;
            }
        }
    }

    private boolean inResizeArea(int n, int n2) {
        Rectangle rectangle = this.viewport.bounds();
        if (!rectangle.inside(n, n2)) {
            return false;
        }
        int n3 = this.hmargin;
        int n4 = this.firstcol;
        while (n4 < Math.min(this.firstcol + this.numColumns - 1, this.numColumns - 1)) {
            if (n4 != this.pinnedcol) {
                if (n > (n3 += this.colInfo[n4].width) && n < n3 + this.hmargin) {
                    this.resizeColumn = n4;
                    this.startx = n3 - this.colInfo[n4].width;
                    this.endx = n3 + this.hmargin / 2;
                    return true;
                }
                n3 += this.hmargin;
            }
            ++n4;
        }
        return false;
    }

    public String getClassVersion() {
        return _sccsID;
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",numRows=" + this.numRows + ",numColumns=" + this.numColumns;
    }
}

