/*
 * Decompiled with CFR 0.152.
 */
package sunw.admin.avm.base;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Scrollbar;
import sunw.admin.avm.base.Scroller;

public class ScrollerLayout
implements LayoutManager {
    private static String _sccsID = "@(#)ScrollerLayout.java\t1.9    96/09/21 SMI";
    private Scroller scroller;
    private Scrollbar hbar;
    private Scrollbar vbar;
    private Component viewport;
    private Component label;
    private Component pinnedColumn;
    private int border = 2;

    public ScrollerLayout(Scroller scroller) {
        this.scroller = scroller;
    }

    public void addLayoutComponent(String string, Component component) {
        if ("VerticalScrollbar".equals(string)) {
            if (component instanceof Scrollbar) {
                this.vbar = (Scrollbar)component;
                return;
            }
        } else if ("HorizontalScrollbar".equals(string)) {
            if (component instanceof Scrollbar) {
                this.hbar = (Scrollbar)component;
                return;
            }
        } else {
            if ("Scroll".equals(string)) {
                this.viewport = component;
                return;
            }
            if ("Header".equals(string)) {
                this.label = component;
                return;
            }
            if ("Pin".equals(string)) {
                this.pinnedColumn = component;
                return;
            }
        }
        throw new IllegalArgumentException("Illegal scroll component");
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.vbar) {
            this.vbar = null;
            return;
        }
        if (component == this.hbar) {
            this.hbar = null;
            return;
        }
        if (component == this.viewport) {
            this.viewport = null;
            return;
        }
        if (component == this.label) {
            this.label = null;
            return;
        }
        if (component == this.pinnedColumn) {
            this.pinnedColumn = null;
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        return container.size();
    }

    public Dimension minimumLayoutSize(Container container) {
        Cloneable cloneable;
        Dimension dimension = new Dimension(10, 10);
        if (this.vbar != null && this.vbar.isVisible()) {
            cloneable = this.vbar.minimumSize();
            dimension.width += cloneable.width;
        }
        if (this.hbar != null && this.hbar.isVisible()) {
            cloneable = this.hbar.minimumSize();
            dimension.height += cloneable.height;
        }
        if (this.label != null && this.label.isVisible()) {
            cloneable = this.label.minimumSize();
            dimension.height += cloneable.height;
        }
        cloneable = container.insets();
        dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right + 2 * this.border;
        dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom + 2 * this.border;
        return dimension;
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.size();
        Dimension dimension2 = new Dimension(0, 0);
        Dimension dimension3 = new Dimension(0, 0);
        Dimension dimension4 = new Dimension(0, 0);
        Dimension dimension5 = new Dimension(0, 0);
        this.scroller.manageScrollbars();
        if (this.vbar != null && this.vbar.isVisible()) {
            dimension4 = this.vbar.preferredSize();
        }
        if (this.hbar != null && this.hbar.isVisible()) {
            dimension5 = this.hbar.preferredSize();
        }
        if (this.label != null && this.label.isVisible()) {
            dimension2 = this.label.preferredSize();
            this.label.reshape(0, 0, dimension.width - dimension4.width, dimension2.height);
        }
        if (this.pinnedColumn != null && this.pinnedColumn.isVisible()) {
            dimension3 = this.pinnedColumn.preferredSize();
            this.pinnedColumn.reshape(0, dimension2.height + this.border, dimension3.width, dimension.height - dimension2.height - dimension5.height - 2 * this.border);
        }
        if (this.viewport != null && this.viewport.isVisible()) {
            this.viewport.reshape(dimension3.width + this.border, dimension2.height + this.border, dimension.width - dimension3.width - dimension4.width - 2 * this.border - 1, dimension.height - dimension2.height - dimension5.height - 2 * this.border - 1);
        }
        if (this.vbar != null && this.vbar.isVisible()) {
            this.vbar.reshape(dimension.width - dimension4.width, dimension2.height, dimension4.width, dimension.height - dimension2.height - dimension5.height);
        }
        if (this.hbar != null && this.hbar.isVisible()) {
            this.hbar.reshape(dimension3.width, dimension.height - dimension5.height, dimension.width - dimension3.width - dimension4.width, dimension5.height);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[scroll=" + this.viewport + "]";
    }

    public String getClassVersion() {
        return _sccsID;
    }
}

