/*
 * Decompiled with CFR 0.152.
 */
package sunw.admin.avm.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Scrollbar;
import sunw.admin.avm.base.PaintedRectangle;
import sunw.admin.avm.base.SHADOW;
import sunw.admin.avm.base.ScrollerLayout;
import sunw.admin.avm.base.ViewPanel;

public abstract class Scroller
extends Panel {
    private static String _sccsID = "@(#)Scroller.java\t1.11    96/09/21 SMI";
    protected ViewPanel viewport;
    protected Scrollbar hbar;
    protected Scrollbar vbar;
    private PaintedRectangle border = new PaintedRectangle((Component)this, 0, 0, 0, 0, SHADOW.INSET, 2);

    public abstract void scrollTo(int var1, int var2);

    public abstract Dimension getScrollAreaSize();

    public Scroller() {
        this.setLayout((LayoutManager)new ScrollerLayout(this));
        this.viewport = new ViewPanel();
        this.add("Scroll", (Component)this.viewport);
        this.vbar = new Scrollbar(1);
        this.add("VerticalScrollbar", this.vbar);
        this.hbar = new Scrollbar(0);
        this.add("HorizontalScrollbar", this.hbar);
    }

    public Scrollbar getHorizontalScrollbar() {
        return this.hbar;
    }

    public Scrollbar getVerticalScrollbar() {
        return this.vbar;
    }

    public Panel getViewport() {
        return this.viewport;
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 601: {
                this.scrollLineUp(event);
                break;
            }
            case 602: {
                this.scrollLineDown(event);
                break;
            }
            case 603: {
                this.scrollPageUp(event);
                break;
            }
            case 604: {
                this.scrollPageDown(event);
                break;
            }
            case 605: {
                this.scrollAbsolute(event);
                break;
            }
        }
        if (event.id == 601 || event.id == 602 || event.id == 603 || event.id == 604 || event.id == 605) {
            return true;
        }
        return super.handleEvent(event);
    }

    protected void scrollLineUp(Event event) {
        this.scroll();
    }

    protected void scrollLineDown(Event event) {
        this.scroll();
    }

    protected void scrollPageUp(Event event) {
        this.scroll();
    }

    protected void scrollPageDown(Event event) {
        this.scroll();
    }

    protected void scrollAbsolute(Event event) {
        this.scroll();
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.viewport.size();
        this.border.resize(dimension.width + 4, dimension.height + 4);
        this.border.paint();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void manageScrollbars() {
        this.manageHorizontalScrollbar();
        this.manageVerticalScrollbar();
    }

    protected void manageHorizontalScrollbar() {
        int n;
        Dimension dimension = this.size();
        Insets insets = this.insets();
        Dimension dimension2 = this.getScrollAreaSize();
        int n2 = 0;
        if (this.vbar.isVisible()) {
            n2 = this.vbar.size().width;
        }
        if ((n = dimension.width - insets.left - insets.right - n2) > 0) {
            if (dimension2.width > n) {
                this.setHorizontalScrollbarValues(n);
                if (!this.hbar.isVisible()) {
                    this.hbar.show();
                    return;
                }
            } else if (this.hbar.isVisible()) {
                this.hbar.setValue(0);
                this.scrollTo(0, this.vbar.getValue());
                this.hbar.hide();
            }
        }
    }

    protected void manageVerticalScrollbar() {
        int n;
        Dimension dimension = this.size();
        Insets insets = this.insets();
        Dimension dimension2 = this.getScrollAreaSize();
        int n2 = 0;
        if (this.hbar.isVisible()) {
            n2 = this.hbar.size().height;
        }
        if ((n = dimension.height - insets.top - insets.bottom - n2) > 0) {
            if (dimension2.height > n) {
                this.setVerticalScrollbarValues(n);
                if (!this.vbar.isVisible()) {
                    this.vbar.show();
                    return;
                }
            } else if (this.vbar.isVisible()) {
                this.vbar.setValue(0);
                this.scrollTo(this.hbar.getValue(), 0);
                this.vbar.hide();
            }
        }
    }

    protected void setHorizontalScrollbarValues(int n) {
        Dimension dimension = this.getScrollAreaSize();
        this.hbar.setValues(this.hbar.getValue(), n, 0, dimension.width - n);
        int n2 = n / 10;
        if (n2 < 1) {
            n2 = 1;
        }
        this.hbar.setLineIncrement(n2);
        n2 = n;
        if (n2 < 1) {
            n2 = 1;
        }
        this.hbar.setPageIncrement(n2);
    }

    protected void setVerticalScrollbarValues(int n) {
        Dimension dimension = this.getScrollAreaSize();
        this.vbar.setValues(this.vbar.getValue(), n, 0, dimension.height - n);
        int n2 = n / 10;
        if (n2 < 1) {
            n2 = 1;
        }
        this.vbar.setLineIncrement(n2);
        n2 = n;
        if (n2 < 1) {
            n2 = 1;
        }
        this.vbar.setPageIncrement(n2);
    }

    protected void scroll() {
        this.scrollTo(-this.hbar.getValue(), -this.vbar.getValue());
    }

    public String getClassVersion() {
        return _sccsID;
    }
}

