/*
 * Decompiled with CFR 0.152.
 */
package sunw.admin.avm.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import sunw.admin.avm.base.SHADOW;

public class PaintedRectangle
extends Rectangle {
    private static String _sccsID = "@(#)PaintedRectangle.java\t1.7    96/09/21 SMI";
    protected Component drawInto;
    private int thick = 2;
    private SHADOW shadow = SHADOW.RAISED;
    private Color dark;
    private Color light;

    public PaintedRectangle(Component component) {
        this(component, 0, 0, 0, 0);
    }

    public PaintedRectangle(Component component, int n, int n2, int n3, int n4) {
        this.drawInto = component;
        this.reshape(n, n2, n3, n4);
    }

    public PaintedRectangle(Component component, int n, int n2, int n3, int n4, SHADOW sHADOW, int n5) {
        this.drawInto = component;
        this.thick = n5;
        this.shadow = sHADOW;
        this.reshape(n, n2, n3, n4);
    }

    public SHADOW getShadow() {
        return this.shadow;
    }

    public void setThickness(int n) {
        this.thick = n;
    }

    public int getThickness() {
        return this.thick;
    }

    public void clear() {
        this.clearExterior();
        this.clearInterior();
    }

    public void clearExterior() {
        Graphics graphics = this.drawInto.getGraphics();
        Color color = this.drawInto.getBackground();
        if (graphics != null) {
            this.drawTopLeftLines(graphics, color);
            this.drawBottomRightLines(graphics, color);
            this.shadow = SHADOW.FLAT;
        }
    }

    public void clearInterior() {
        Graphics graphics = this.drawInto.getGraphics();
        if (graphics != null) {
            Rectangle rectangle = this.getInnerBounds();
            graphics.setColor(this.drawInto.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paint() {
        this.paint(this.shadow);
    }

    public void paint(SHADOW sHADOW) {
        Graphics graphics = this.drawInto.getGraphics();
        if (graphics != null) {
            this.setShadingColors();
            if (sHADOW == SHADOW.INSET) {
                this.drawTopLeftLines(graphics, this.dark);
                this.drawBottomRightLines(graphics, this.light);
                this.shadow = SHADOW.INSET;
                return;
            }
            if (sHADOW == SHADOW.FLAT) {
                this.drawTopLeftLines(graphics, this.dark);
                this.drawBottomRightLines(graphics, this.dark);
                this.shadow = SHADOW.FLAT;
                return;
            }
            if (sHADOW == SHADOW.RAISED) {
                this.drawTopLeftLines(graphics, this.light);
                this.drawBottomRightLines(graphics, this.dark);
                this.shadow = SHADOW.RAISED;
            }
        }
    }

    public Rectangle getInnerBounds() {
        return new Rectangle(this.x + this.thick, this.y + this.thick, this.width - this.thick * 2, this.height - this.thick * 2);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "  Bounds:  " + super.toString() + " Thickness:  " + this.thick;
    }

    protected void drawTopLeftLines(Graphics graphics, Color color) {
        graphics.setColor(color);
        int n = 0;
        while (n < this.thick) {
            graphics.drawLine(this.x + n, this.y + n, this.x + this.width - (n + 1), this.y + n);
            graphics.drawLine(this.x + n, this.y + n + 1, this.x + n, this.y + this.height - (n + 1));
            ++n;
        }
    }

    protected void drawBottomRightLines(Graphics graphics, Color color) {
        graphics.setColor(color);
        int n = 1;
        while (n <= this.thick) {
            graphics.drawLine(this.x + n - 1, this.y + this.height - n, this.x + this.width - n, this.y + this.height - n);
            graphics.drawLine(this.x + this.width - n, this.y + n - 1, this.x + this.width - n, this.y + this.height - n);
            ++n;
        }
    }

    private void setShadingColors() {
        Color color = this.drawInto.getBackground();
        this.dark = color.darker();
        this.light = color.brighter();
    }

    public String getClassVersion() {
        return _sccsID;
    }
}

