/*
 * Decompiled with CFR 0.152.
 */
package logview;

import admin.Admin;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import logview.MsgFilterDialog;
import logview.MsgFilterInfo;
import sunw.admin.avm.base.SORT_ORDER;
import sunw.admin.avm.base.Table;
import sunw.admin.avm.base.TableView;
import util.AuthURL;
import util.Debug;
import util.Message;
import util.Sublet;
import util.Util;
import util.modal.ModalDialog;
import util.modal.ModalDialogInterface;

public class SEventView
extends Panel
implements Sublet,
TableView,
ModalDialogInterface {
    public static final int NUM_EVENTLOG_COLS = 3;
    public static final int EVENTTIME = 0;
    public static final int EVENTMSG = 1;
    public static final int RESERVED = 2;
    static final int ROWDIALOG_WIDTH = 45;
    static final String EVENTLOGREQ = "/sws-administration/cgi/eventlog";
    int[] evlogField;
    String[] headings;
    Table evtbl;
    File f;
    URL s;
    DataInputStream din;
    DataOutputStream dout;
    boolean network;
    Panel logpanel;
    Panel choicepanel;
    GridBagLayout gridbag;
    ModalDialog rowDialog;
    TextComponent rowTimeField;
    TextComponent rowEventField;
    int numRows;
    String more;
    boolean eofReached;
    MsgFilterInfo msgFilter;
    MsgFilterDialog dlgFilter;
    SORT_ORDER sortOrder;
    int sortCol;
    AuthURL auth;
    ModalDialog messageDlg;
    static Color background;
    static Color foreground;
    Panel menu;
    Choice[] choice;
    private static final int ChoiceLog = 0;
    private static final int ChoiceView = 1;

    public SEventView() {
        int[] nArray = new int[2];
        nArray[1] = 1;
        this.evlogField = nArray;
        this.headings = new String[]{"Time", "Event/Message"};
        this.network = true;
        this.gridbag = new GridBagLayout();
        this.eofReached = false;
        this.msgFilter = new MsgFilterInfo();
        background = new Color(0x999999);
        foreground = new Color(0xC0C0C0);
        this.initLayout();
        this.numRows = this.refreshEventLog();
        if (this.numRows == 0) {
            this.messageDlg = Message.info((String)"No entries found in SWS event log for the current filter.");
        }
        this.show();
    }

    public String name() {
        return "Event Log";
    }

    public void init() {
    }

    public String status() {
        return this.name();
    }

    private AuthURL open() {
        String string = "";
        if (this.more != null) {
            string = String.valueOf(string) + "&more=" + this.more;
        }
        Debug.println((String)("/sws-administration/cgi/eventlog?" + this.msgFilter.toString() + string));
        AuthURL authURL = new AuthURL(Util.home, "/sws-administration/cgi/eventlog?" + this.msgFilter.toString() + string, "GET", null);
        return authURL;
    }

    public void cleanup() {
        if (this.messageDlg != null) {
            this.messageDlg.closeDialog();
        }
        if (this.rowDialog != null) {
            this.rowDialog.closeDialog();
        }
        if (this.dlgFilter != null) {
            this.dlgFilter.closeDialog();
        }
    }

    public synchronized boolean moreAction(Event event, Object object) {
        if (this.rowDialog != null) {
            this.rowDialog.hide();
        }
        return true;
    }

    public String formatEventField(String string) {
        if (string != null) {
            Graphics graphics = Util.applet.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = this.rowEventField.size().width - 7;
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n2 = 0;
            int n3 = 0;
            while (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                int n4 = fontMetrics.stringWidth(String.valueOf(string2) + " ");
                n3 = n2 + n4;
                if (n3 >= n) {
                    stringBuffer.append("\n");
                    n2 = n4;
                } else {
                    n2 = n3;
                }
                stringBuffer.append(String.valueOf(string2) + " ");
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public boolean helpChk(String string) {
        return Admin.helpChk((String)"Event", (String)string, null);
    }

    public void doMsgFilter() {
        this.dlgFilter = new MsgFilterDialog(this);
        this.dlgFilter.showDialog();
    }

    public void setMsgFilter(MsgFilterInfo msgFilterInfo) {
        if (this.msgFilter.isSameAs(msgFilterInfo)) {
            return;
        }
        Debug.println((String)msgFilterInfo.toString());
        this.msgFilter = msgFilterInfo;
        this.resetAndLoadEventLog();
    }

    void resetAndLoadEventLog() {
        this.evtbl.clear();
        this.more = null;
        this.numRows = 0;
        this.refresh();
    }

    void refresh() {
        int n;
        if (this.sortCol != 0 || this.sortOrder != SORT_ORDER.DESCENDING) {
            this.sortCol = 0;
            this.sortOrder = SORT_ORDER.DESCENDING;
            this.evtbl.setSortColumn(this.sortCol);
            this.evtbl.sort(this.sortOrder);
        }
        if ((n = this.refreshEventLog()) == 0) {
            this.messageDlg = Message.info((String)"No new entries found in SWS system event/error log for the current filter.");
        } else {
            this.evtbl.repaint();
            this.repaint();
        }
        this.numRows += n;
        Debug.println((String)("Refresh: numRows=" + this.numRows));
    }

    private void eventViewSetup() {
        this.evtbl = new Table(17, (TableView)this);
        this.evtbl.setNumColumns(3);
        Vector<String> vector = new Vector<String>(3);
        vector.insertElementAt(String.valueOf(this.headings[0]) + "                ", 0);
        vector.insertElementAt(String.valueOf(this.headings[1]) + "                       ", 1);
        vector.insertElementAt("", 2);
        this.evtbl.setColumnLabels(vector);
        this.evtbl.setColumnWidthInChars(0, 16);
        this.evtbl.setColumnWidthInChars(1, 32);
    }

    public int refreshEventLog() {
        int n = 0;
        Util.setBusy((boolean)true, (Component)this);
        this.auth = this.open();
        this.auth.connectOrFatal();
        try {
            String string;
            while ((string = this.auth.readLine()) != null) {
                if (string.startsWith("#")) continue;
                if (string.startsWith("ERROR")) {
                    Util.applet.showStatus(string);
                    break;
                }
                if (string.startsWith(".") || string.length() == 0) break;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                int n2 = 0;
                Vector<String> vector = new Vector<String>(3);
                vector.setSize(3);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    vector.setElementAt(string2, this.evlogField[n2]);
                    ++n2;
                }
                if (this.numRows + ++n > this.msgFilter.maxMsgs) {
                    this.evtbl.deleteRow(n + this.numRows - 1);
                    --this.numRows;
                }
                this.evtbl.addRow(vector, n);
            }
            string = this.auth.readLine();
            if (string != null) {
                Debug.println((String)string);
                if (string.startsWith("more=") || (this.eofReached = string.startsWith("eofl="))) {
                    this.more = string.substring(5);
                }
            }
        }
        catch (Exception exception) {}
        Util.setBusy((boolean)false, (Component)this);
        this.auth.close();
        if (n > 0) {
            this.evtbl.setSortColumn(0);
            this.evtbl.sort(SORT_ORDER.DESCENDING);
            this.sortCol = 0;
            this.sortOrder = SORT_ORDER.DESCENDING;
        }
        return n;
    }

    public void closeDialogs() {
        if (this.messageDlg != null) {
            this.messageDlg.closeDialog();
        }
    }

    public void initLayout() {
        this.setLayout(new BorderLayout());
        this.setBackground(foreground);
        this.menu = new Panel();
        this.menu.setLayout(new FlowLayout(0));
        this.add("North", this.menu);
        this.choiceBuild();
        this.eventViewSetup();
        this.add("Center", (Component)this.evtbl);
    }

    private void choiceBuild() {
        String[][][] stringArrayArray = new String[][][]{{{"Log"}, {"Filter..."}}, {{"View"}, {"More", "Rewind"}}};
        this.choice = new Choice[stringArrayArray.length];
        int n = 0;
        while (n < stringArrayArray.length) {
            this.choice[n] = new Choice();
            this.menu.add(this.choice[n]);
            this.choice[n].addItem(stringArrayArray[n][0][0]);
            int n2 = 0;
            while (n2 < stringArrayArray[n][1].length) {
                this.choice[n].addItem(stringArrayArray[n][1][n2]);
                ++n2;
            }
            ++n;
        }
    }

    public boolean action(Event event, Object object) {
        String string = (String)object;
        boolean bl = false;
        if (event.target == this.choice[0]) {
            this.choice[0].select(0);
            if (!string.equals("Filter...")) {
                return false;
            }
            this.doMsgFilter();
            bl = true;
        } else if (event.target == this.choice[1]) {
            this.choice[1].select(0);
            if (string.equals("More")) {
                this.refresh();
            } else if (string.equals("Rewind")) {
                this.resetAndLoadEventLog();
            } else {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof Choice) {
            if (event.id == 1001) {
                if (this.action(event, event.arg)) {
                    return true;
                }
            } else if (event.id != 1004) {
                return false;
            }
            Choice choice = (Choice)event.target;
            String string = choice.getSelectedItem();
            Admin.helpChk((String)"Event", (String)string, null);
            if (event.id == 1004) {
                return this.gotFocus(event, event.arg);
            }
            return true;
        }
        if (event.id == 1001) {
            return this.action(event, event.arg);
        }
        return false;
    }

    public void initRowDialog(Vector vector) {
        ModalDialog modalDialog;
        Panel panel = new Panel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        Label label = new Label(this.headings[0], 0);
        this.rowTimeField = new TextField((String)vector.elementAt(0), 45);
        this.rowTimeField.setEditable(false);
        panel.add(label);
        panel.add(this.rowTimeField);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.rowTimeField, gridBagConstraints);
        label = new Label(this.headings[1], 0);
        this.rowEventField = new TextArea(5, 45);
        this.rowEventField.setEditable(false);
        panel.add(label);
        panel.add(this.rowEventField);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.rowEventField, gridBagConstraints);
        String[] stringArray = new String[]{"OK"};
        this.rowDialog = modalDialog = new ModalDialog("Row Details", (Component)panel, stringArray, (ModalDialogInterface)this, false);
        modalDialog.noted = true;
        modalDialog.show();
        this.rowEventField.setText(this.formatEventField((String)vector.elementAt(1)));
    }

    public void updateRowDialog(Vector vector) {
        if (this.rowDialog != null) {
            this.rowTimeField.setText((String)vector.elementAt(0));
            this.rowEventField.setText(this.formatEventField((String)vector.elementAt(1)));
            this.rowDialog.show();
            this.rowDialog.toFront();
        }
    }

    public void onRowSelect(int n, int n2) {
        Vector vector = this.evtbl.getRow(n);
        if (n2 == 1) {
            if (this.rowDialog == null || !this.rowDialog.isVisible()) {
                Util.applet.showStatus("Double-click on the row to see the details");
                return;
            }
            this.updateRowDialog(vector);
            return;
        }
        if (this.rowDialog == null) {
            this.initRowDialog(vector);
            return;
        }
        this.updateRowDialog(vector);
    }

    public void onColumnSelect(int n, int n2) {
        SORT_ORDER sORT_ORDER = (n2 & 1) != 0 ? SORT_ORDER.DESCENDING : SORT_ORDER.ASCENDING;
        if (this.sortCol == n && this.sortOrder == sORT_ORDER) {
            return;
        }
        this.evtbl.setSortColumn(n);
        Util.setBusy((boolean)true, (Component)this);
        this.evtbl.sort(sORT_ORDER);
        Util.setBusy((boolean)false, (Component)this);
        this.sortCol = n;
        this.sortOrder = sORT_ORDER;
    }
}

