/*
 * Decompiled with CFR 0.152.
 */
package logview;

import java.util.Date;
import logview.ReqView;
import util.Debug;

class RequestLogFilterInfo {
    Date sdate = new Date(System.currentTimeMillis());
    Date edate;
    String inurl;
    String exurl;
    String resp;
    int maxRecs;
    public static final int DEFAULT_MAX_RECS = 100;

    public RequestLogFilterInfo() {
        this.sdate.setHours(0);
        this.sdate.setMinutes(0);
        this.sdate.setSeconds(0);
        this.resp = new String("All");
        this.maxRecs = 100;
    }

    public void setLogFilter(RequestLogFilterInfo requestLogFilterInfo) {
        this.sdate = requestLogFilterInfo.sdate == null ? null : new Date(requestLogFilterInfo.sdate.getYear(), requestLogFilterInfo.sdate.getMonth(), requestLogFilterInfo.sdate.getDate(), requestLogFilterInfo.sdate.getHours(), requestLogFilterInfo.sdate.getMinutes(), requestLogFilterInfo.sdate.getSeconds());
        this.edate = requestLogFilterInfo.edate == null ? null : new Date(requestLogFilterInfo.edate.getYear(), requestLogFilterInfo.edate.getMonth(), requestLogFilterInfo.edate.getDate(), requestLogFilterInfo.edate.getHours(), requestLogFilterInfo.edate.getMinutes(), requestLogFilterInfo.edate.getSeconds());
        this.inurl = requestLogFilterInfo.inurl != null ? new String(requestLogFilterInfo.inurl) : null;
        this.exurl = requestLogFilterInfo.exurl != null ? new String(requestLogFilterInfo.exurl) : null;
        this.resp = requestLogFilterInfo.resp != null ? new String(requestLogFilterInfo.resp) : null;
        this.maxRecs = requestLogFilterInfo.maxRecs;
    }

    private boolean sameDates(Date date, Date date2) {
        boolean bl = false;
        if (date == null && date2 == null || date != null && date2 != null && date.equals(date2)) {
            bl = true;
        }
        return bl;
    }

    private boolean sameStrs(String string, String string2) {
        boolean bl = false;
        if (string == null && string2 == null || string != null && string2 != null && string.compareTo(string2) == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isSameAs(RequestLogFilterInfo requestLogFilterInfo) {
        Debug.println((String)("in: " + requestLogFilterInfo.toString() + "this " + this.toString()));
        if (requestLogFilterInfo == null) {
            return false;
        }
        if (!this.sameDates(this.sdate, requestLogFilterInfo.sdate)) {
            return false;
        }
        if (!this.sameDates(this.edate, requestLogFilterInfo.edate)) {
            return false;
        }
        if (!this.sameStrs(this.inurl, requestLogFilterInfo.inurl)) {
            return false;
        }
        if (!this.sameStrs(this.exurl, requestLogFilterInfo.exurl)) {
            return false;
        }
        if (!this.sameStrs(this.resp, requestLogFilterInfo.resp)) {
            return false;
        }
        return this.maxRecs == requestLogFilterInfo.maxRecs;
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public String toString() {
        String string = new String(this.sdate == null ? "" : "&sdate=" + ReqView.DateStr((Date)this.sdate) + "&stime=" + ReqView.TimeStr((Date)this.sdate));
        String string2 = new String(this.edate == null ? "" : "&edate=" + ReqView.DateStr((Date)this.edate) + "&etime=" + ReqView.TimeStr((Date)this.edate));
        String string3 = new String(this.isEmpty(this.inurl) ? "" : "&inurls=" + this.inurl);
        String string4 = new String(this.isEmpty(this.exurl) ? "" : "&exurls=" + this.exurl);
        return new String(String.valueOf(string) + string2 + "&resp=" + this.resp + string3 + string4 + "&maxrecs=" + this.maxRecs);
    }
}

