/*
 * Decompiled with CFR 0.152.
 */
package logview;

import java.util.Date;
import logview.ReqView;
import util.Debug;

public class MsgFilterInfo {
    Date sdate = new Date(System.currentTimeMillis());
    Date edate;
    int maxMsgs;
    public static final int DEFAULT_MAX_RECS = 100;

    public MsgFilterInfo() {
        this.sdate.setHours(0);
        this.sdate.setMinutes(0);
        this.sdate.setSeconds(0);
        this.maxMsgs = 100;
    }

    public void setMsgFilter(MsgFilterInfo msgFilterInfo) {
        this.sdate = msgFilterInfo.sdate == null ? null : new Date(msgFilterInfo.sdate.getYear(), msgFilterInfo.sdate.getMonth(), msgFilterInfo.sdate.getDate(), msgFilterInfo.sdate.getHours(), msgFilterInfo.sdate.getMinutes(), msgFilterInfo.sdate.getSeconds());
        this.edate = msgFilterInfo.edate == null ? null : new Date(msgFilterInfo.edate.getYear(), msgFilterInfo.edate.getMonth(), msgFilterInfo.edate.getDate(), msgFilterInfo.edate.getHours(), msgFilterInfo.edate.getMinutes(), msgFilterInfo.edate.getSeconds());
        this.maxMsgs = msgFilterInfo.maxMsgs;
    }

    private boolean sameDates(Date date, Date date2) {
        boolean bl = false;
        if (date == null && date2 == null || date != null && date2 != null && date.equals(date2)) {
            bl = true;
        }
        return bl;
    }

    public boolean isSameAs(MsgFilterInfo msgFilterInfo) {
        Debug.println((String)("in: " + msgFilterInfo.toString() + "this " + this.toString()));
        if (msgFilterInfo == null) {
            return false;
        }
        if (!this.sameDates(this.sdate, msgFilterInfo.sdate)) {
            return false;
        }
        if (!this.sameDates(this.edate, msgFilterInfo.edate)) {
            return false;
        }
        return this.maxMsgs == msgFilterInfo.maxMsgs;
    }

    private boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public String toString() {
        String string = new String(this.sdate == null ? "" : "&sdate=" + ReqView.DateStr((Date)this.sdate) + "&stime=" + ReqView.TimeStr((Date)this.sdate));
        String string2 = new String(this.edate == null ? "" : "&edate=" + ReqView.DateStr((Date)this.edate) + "&etime=" + ReqView.TimeStr((Date)this.edate));
        return new String(String.valueOf(string) + string2 + "&maxmsgs=" + this.maxMsgs);
    }
}

