/*
 * Decompiled with CFR 0.152.
 */
package logview;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import logview.DateTime;
import logview.MSGenField;
import logview.MsgFilterInfo;
import logview.MsgFilterWaiter;
import logview.ReqView;
import logview.SEventView;
import util.Debug;
import util.Field;
import util.Group;
import util.GroupedPanel;
import util.modal.ModalDialog;
import util.modal.ModalDialogInterface;

class MsgFilterDialog
extends Panel
implements ModalDialogInterface {
    public static final String STR_EVENTLOG_FILTERS = "SWS Event Log Filter";
    public boolean posted;
    static String[] dialogErrors = new String[]{"", "Please check the start-time for the request log view.", "Please check the end-time for the request log to view.", "Please make sure end-time is after start-time or till end of log.", "Specify an appropriate value for maximum number of records to fetch."};
    SEventView msgView;
    MsgFilterInfo msgFilter;
    DateTime startDate;
    DateTime endDate;
    TextField maxMsgs;
    Choice httpReqs;
    Field[] urlFields;
    Field[] otherFields;
    String notOKMsg;
    ModalDialog dlg;

    public MsgFilterDialog(SEventView sEventView) {
        this.msgView = sEventView;
        this.msgFilter = new MsgFilterInfo();
        this.msgFilter.setMsgFilter(sEventView.msgFilter);
    }

    public void showDialog() {
        this.dialog((ModalDialogInterface)this);
        this.show();
    }

    public void closeDialog() {
        this.dlg.closeDialog();
    }

    boolean readLogFilterInfo() {
        if (this.startDate.getDateOption()) {
            this.msgFilter.sdate = null;
        } else {
            this.msgFilter.sdate = this.startDate.getLogDate();
            if (this.msgFilter.sdate == null) {
                this.notOKMsg = this.startDate.getErrorMsg();
                return false;
            }
            Debug.println((String)this.msgFilter.sdate.toString());
        }
        if (this.endDate.getDateOption()) {
            this.msgFilter.edate = null;
        } else {
            this.msgFilter.edate = this.endDate.getLogDate();
            if (this.msgFilter.edate == null) {
                this.notOKMsg = this.endDate.getErrorMsg();
                return false;
            }
        }
        if (!this.startDate.getDateOption() && !this.endDate.getDateOption() && this.msgFilter.sdate != null && this.msgFilter.edate != null && this.msgFilter.edate.before(this.msgFilter.sdate)) {
            this.notOKMsg = new String(dialogErrors[3]);
            return false;
        }
        this.msgFilter.maxMsgs = ReqView.getIntValue((String)this.maxMsgs.getText());
        if (this.msgFilter.maxMsgs <= 0 || this.msgFilter.maxMsgs > 1000) {
            this.notOKMsg = new String(dialogErrors[5]);
            return false;
        }
        Debug.println((String)this.msgFilter.toString());
        return true;
    }

    public synchronized boolean moreAction(Event event, Object object) {
        String string = (String)object;
        this.posted = string.equals("Apply");
        if (this.posted) {
            Debug.println((String)"Reading event log filter info");
            if (!this.readLogFilterInfo()) {
                Debug.println((String)this.notOKMsg);
                this.posted = false;
                this.dlg.setNotOKMessage(this.notOKMsg);
                return false;
            }
        }
        return true;
    }

    public void setMsgFilterInfo() {
        this.msgView.setMsgFilter(this.msgFilter);
    }

    GroupedPanel formFilterPanel() {
        Group[] groupArray = new Group[3];
        this.startDate = new DateTime(this.msgFilter.sdate, "Start Time ", "Beginning");
        groupArray[0] = this.startDate.getDateTimeGroup();
        this.endDate = new DateTime(this.msgFilter.edate, "End Time ", "End of Log");
        groupArray[1] = this.endDate.getDateTimeGroup();
        this.otherFields = new Field[1];
        this.otherFields[0] = new MSGenField("Maximum Messages To View", true, 0, "filter_maxmsgs", 1, 20);
        groupArray[2] = new Group("Other ", "OtherFilter", this.otherFields, 2);
        GroupedPanel groupedPanel = new GroupedPanel("Event Log", "Filter", groupArray);
        groupedPanel.load(null, true);
        return groupedPanel;
    }

    void initFilterPanel() {
        this.startDate.initDateAndTime();
        this.endDate.initDateAndTime();
        this.maxMsgs = (TextField)this.otherFields[0].w;
        ((TextComponent)this.maxMsgs).setText(Integer.toString(this.msgFilter.maxMsgs));
    }

    ModalDialog dialog(ModalDialogInterface modalDialogInterface) {
        String[] stringArray = new String[]{"Apply", "Cancel"};
        GroupedPanel groupedPanel = this.formFilterPanel();
        this.initFilterPanel();
        this.dlg = new ModalDialog(STR_EVENTLOG_FILTERS, (Component)groupedPanel, stringArray, modalDialogInterface, this.notOKMsg);
        this.dlg.show();
        MsgFilterWaiter msgFilterWaiter = new MsgFilterWaiter(this.dlg, this);
        msgFilterWaiter.go();
        return this.dlg;
    }
}

