/*
 * Decompiled with CFR 0.152.
 */
package logview;

import admin.Admin;
import admin.Cmd;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Panel;
import java.util.Vector;
import logview.ReqView;
import util.Sublet;

public class LogCmd
extends Panel
implements Sublet {
    Panel menu;
    Choice[] choice;
    private static final int ChoiceLog = 0;
    private static final int ChoiceView = 1;
    private static final int ChoiceHosts = 2;
    ReqView view;
    Vector hosts;
    Vector prefixes;
    Vector types;
    String curHost;
    String curPrefix;
    int curType;

    public LogCmd(Vector vector, Vector vector2, Vector vector3) {
        this.setLayout(new BorderLayout());
        this.hosts = vector;
        this.prefixes = vector2;
        this.types = vector3;
        this.menu = new Panel();
        this.menu.setLayout(new FlowLayout(0));
        this.add("North", this.menu);
        this.choiceBuild();
        this.setCurrent((String)vector.firstElement());
        this.view = new ReqView(this.curPrefix, this.curType);
        this.add("Center", (Component)this.view);
    }

    private void choiceBuild() {
        String[][][] stringArrayArray = new String[][][]{{{"Log"}, {"Filter..."}}, {{"View"}, {"More", "Rewind"}}, {{"Hosts"}, new String[0]}};
        this.choice = new Choice[stringArrayArray.length];
        int n = 0;
        while (n < stringArrayArray.length) {
            this.choice[n] = new Choice();
            this.menu.add(this.choice[n]);
            this.choice[n].addItem(stringArrayArray[n][0][0]);
            int n2 = 0;
            while (n2 < stringArrayArray[n][1].length) {
                this.choice[n].addItem(stringArrayArray[n][1][n2]);
                ++n2;
            }
            ++n;
        }
        Cmd.choiceHostsFromStringList(this.hosts.elements(), (Choice)this.choice[2]);
    }

    public String name() {
        return "Request Log";
    }

    public void init() {
    }

    public String status() {
        String string = this.curHost;
        if (this.curHost.equals("Host")) {
            string = "default host";
        }
        return String.valueOf(this.name()) + " for " + string;
    }

    public void cleanup() {
        if (this.view != null) {
            this.view.closeDialogs();
        }
    }

    private boolean setCurrent(String string) {
        if (this.curHost != null && this.curHost.equals(string)) {
            return false;
        }
        this.curHost = string;
        int n = this.hosts.indexOf(string);
        if (n < 0) {
            n = 0;
        }
        this.curPrefix = (String)this.prefixes.elementAt(n);
        String string2 = (String)this.types.elementAt(n);
        this.curType = string2.equals("clf") ? 1 : (string2.equals("bclf") ? 2 : (string2.equals("elf") ? 3 : 0));
        return true;
    }

    public boolean action(Event event, Object object) {
        String string = (String)object;
        boolean bl = false;
        if (event.target == this.choice[0]) {
            this.choice[0].select(0);
            if (!string.equals("Filter...")) {
                return false;
            }
            this.view.doReqLogFilter();
            bl = true;
        } else if (event.target == this.choice[1]) {
            this.choice[1].select(0);
            if (string.equals("More")) {
                this.view.refresh();
            } else if (string.equals("Rewind")) {
                this.view.resetAndLoadDetailLog();
            } else {
                return false;
            }
            bl = true;
        } else if (event.target == this.choice[2]) {
            this.choice[2].select(0);
            if (string.equals("Hosts")) {
                return false;
            }
            if (this.setCurrent(string)) {
                this.view.reload(this.curPrefix, this.curType);
                Admin.folderLabelUpdate((String)("Request Log " + this.status()));
            }
            bl = true;
        }
        return bl;
    }

    public boolean handleEvent(Event event) {
        if (event.target instanceof Choice) {
            if (event.id == 1001) {
                if (this.action(event, event.arg)) {
                    return true;
                }
            } else if (event.id != 1004) {
                return false;
            }
            Choice choice = (Choice)event.target;
            String string = choice.getSelectedItem();
            Admin.helpChk((String)"Request", (String)string, null);
            if (event.id == 1004) {
                return this.gotFocus(event, event.arg);
            }
            return true;
        }
        if (event.id == 1001) {
            return this.action(event, event.arg);
        }
        return false;
    }

    public void paint(Graphics graphics) {
        this.view.show(this.view.getCurrentFolder());
    }
}

