/*
 * Decompiled with CFR 0.152.
 */
package logview;

import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import logview.DateTime;
import logview.GenField;
import logview.LogFilterWaiter;
import logview.ReqView;
import logview.RequestLogFilterInfo;
import util.Debug;
import util.Field;
import util.Group;
import util.GroupedPanel;
import util.modal.ModalDialog;
import util.modal.ModalDialogInterface;

class FilterDialog
extends Panel
implements ModalDialogInterface {
    public static final String STR_REQLOG_FILTERS = "Request Log Filter";
    public boolean posted;
    static String[] httpSelection = new String[]{"All", "Oks", "Fails"};
    static String[] dialogErrors = new String[]{"", "Please check the start-time for the request log view.", "Please check the end-time for the request log to view.", "Please make sure end-time is after start-time or till end of log.", "The URL patterns to include and exclude are same; could you please verify the URL prefixes to match.", "Specify an appropriate value for maximum number of records to fetch."};
    ReqView reqView;
    RequestLogFilterInfo logFilter;
    DateTime startDate;
    DateTime endDate;
    TextField inclUrls;
    TextField exclUrls;
    TextField maxRecs;
    Choice httpReqs;
    Field[] urlFields;
    Field[] otherFields;
    String notOKMsg;
    ModalDialog dlg;

    public FilterDialog(ReqView reqView) {
        this.reqView = reqView;
        this.logFilter = new RequestLogFilterInfo();
        this.logFilter.setLogFilter(reqView.logFilter);
    }

    public void showDialog() {
        this.dialog((ModalDialogInterface)this);
        this.show();
    }

    public void closeDialog() {
        this.dlg.closeDialog();
    }

    boolean readLogFilterInfo() {
        if (this.startDate.getDateOption()) {
            this.logFilter.sdate = null;
        } else {
            this.logFilter.sdate = this.startDate.getLogDate();
            if (this.logFilter.sdate == null) {
                this.notOKMsg = this.startDate.getErrorMsg();
                return false;
            }
            Debug.println((String)this.logFilter.sdate.toString());
        }
        if (this.endDate.getDateOption()) {
            this.logFilter.edate = null;
        } else {
            this.logFilter.edate = this.endDate.getLogDate();
            if (this.logFilter.edate == null) {
                this.notOKMsg = this.endDate.getErrorMsg();
                return false;
            }
        }
        if (!this.startDate.getDateOption() && !this.endDate.getDateOption() && this.logFilter.sdate != null && this.logFilter.edate != null && this.logFilter.edate.before(this.logFilter.sdate)) {
            this.notOKMsg = new String(dialogErrors[3]);
            return false;
        }
        this.logFilter.inurl = this.inclUrls.getText();
        this.logFilter.exurl = this.exclUrls.getText();
        if (this.logFilter.inurl != null && this.logFilter.exurl != null && this.logFilter.inurl.length() > 0 && this.logFilter.exurl.length() > 0 && this.logFilter.inurl.compareTo(this.logFilter.exurl) == 0) {
            this.notOKMsg = new String(dialogErrors[4]);
            return false;
        }
        this.logFilter.resp = new String(httpSelection[this.httpReqs.getSelectedIndex()]);
        this.logFilter.maxRecs = ReqView.getIntValue((String)this.maxRecs.getText());
        if (this.logFilter.maxRecs <= 0 || this.logFilter.maxRecs > 1000) {
            this.notOKMsg = new String(dialogErrors[5]);
            return false;
        }
        Debug.println((String)this.logFilter.toString());
        return true;
    }

    public synchronized boolean moreAction(Event event, Object object) {
        String string = (String)object;
        this.posted = string.equals("Apply");
        if (this.posted) {
            Debug.println((String)"Reading request log filter info");
            if (!this.readLogFilterInfo()) {
                Debug.println((String)this.notOKMsg);
                this.posted = false;
                this.dlg.setNotOKMessage(this.notOKMsg);
                return false;
            }
        }
        return true;
    }

    public void setLogFilterInfo() {
        this.reqView.setLogFilter(this.logFilter);
    }

    GroupedPanel formFilterPanel() {
        Group[] groupArray = new Group[4];
        this.startDate = new DateTime(this.logFilter.sdate, "Start Time ", "Beginning");
        groupArray[0] = this.startDate.getDateTimeGroup();
        this.endDate = new DateTime(this.logFilter.edate, "End Time ", "End of Log");
        groupArray[1] = this.endDate.getDateTimeGroup();
        this.urlFields = new Field[2];
        this.urlFields[0] = new GenField("Include ", true, 0, "filter_incl_urls", 0, 20);
        this.urlFields[1] = new GenField("Exclude ", true, 0, "filter_excl_urls", 0, 20);
        groupArray[2] = new Group("Match URL Prefix", "URLFilter", this.urlFields, 2);
        this.otherFields = new Field[2];
        this.otherFields[0] = new GenField("Completion Status", true, 2, "filter_resp", 0, 0);
        this.otherFields[1] = new GenField("Maximum Records To View", true, 0, "filter_maxrecs", 1, 20);
        groupArray[3] = new Group("Other ", "OtherFilter", this.otherFields, 2);
        GroupedPanel groupedPanel = new GroupedPanel("Request Log", "Filter", groupArray);
        groupedPanel.load(null, true);
        return groupedPanel;
    }

    void initFilterPanel() {
        this.startDate.initDateAndTime();
        this.endDate.initDateAndTime();
        this.inclUrls = (TextField)this.urlFields[0].w;
        this.exclUrls = (TextField)this.urlFields[1].w;
        this.httpReqs = (Choice)this.otherFields[0].w;
        this.maxRecs = (TextField)this.otherFields[1].w;
        ((TextComponent)this.inclUrls).setText(this.logFilter.inurl);
        ((TextComponent)this.exclUrls).setText(this.logFilter.exurl);
        this.httpReqs.addItem("All Requests");
        this.httpReqs.addItem("Successful");
        this.httpReqs.addItem("Failures");
        ((TextComponent)this.maxRecs).setText(Integer.toString(this.logFilter.maxRecs));
        int n = 0;
        n = 0;
        while (n < 3) {
            if (httpSelection[n].compareTo(this.logFilter.resp) == 0) break;
            ++n;
        }
        this.httpReqs.select(n);
    }

    ModalDialog dialog(ModalDialogInterface modalDialogInterface) {
        String[] stringArray = new String[]{"Apply", "Cancel"};
        GroupedPanel groupedPanel = this.formFilterPanel();
        this.initFilterPanel();
        this.dlg = new ModalDialog(STR_REQLOG_FILTERS, (Component)groupedPanel, stringArray, modalDialogInterface, this.notOKMsg);
        this.dlg.show();
        LogFilterWaiter logFilterWaiter = new LogFilterWaiter(this.dlg, this);
        logFilterWaiter.go();
        return this.dlg;
    }
}

