/*
 * Decompiled with CFR 0.152.
 */
package logview;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.util.Date;
import logview.DTOptionField;
import logview.DateTimeField;
import logview.ReqView;
import util.Debug;
import util.Field;
import util.Group;

class DateTime {
    Field[] f;
    Group dtGroup;
    Checkbox inOption;
    boolean opState;
    TextField dt;
    Choice monthList;
    TextField year;
    TextField hour;
    TextField min;
    TextField sec;
    Date date;
    String title;
    String errorMsg;

    DateTime(Date date, String string, String string2) {
        if (date != null) {
            this.opState = false;
        } else {
            date = new Date(System.currentTimeMillis());
            this.opState = true;
        }
        this.date = date;
        this.title = string;
        this.buildDateTime(string, string2);
    }

    private int isLeap(int n) {
        if (n % 4 == 0) {
            return 1;
        }
        return 0;
    }

    public void enableDateFields() {
        boolean bl = !this.inOption.getState();
        this.dt.enable(bl);
        this.monthList.enable(bl);
        this.year.enable(bl);
        this.hour.enable(bl);
        this.min.enable(bl);
        this.sec.enable(bl);
    }

    private void buildDateTime(String string, String string2) {
        this.f = new Field[2];
        this.f[0] = new DTOptionField(string2, true, 1, "dt_option", 0, this);
        this.f[1] = new DateTimeField("Enter a Date", true, 0, "dt_date_time", 0, this);
        this.dtGroup = new Group(string, "DateTime", this.f, 2);
    }

    public Group getDateTimeGroup() {
        return this.dtGroup;
    }

    public Panel createDateTimePanel() {
        Panel panel = new Panel();
        this.dt = new TextField("", 2);
        this.monthList = new Choice();
        this.monthList.addItem("January");
        this.monthList.addItem("February");
        this.monthList.addItem("March");
        this.monthList.addItem("April");
        this.monthList.addItem("May");
        this.monthList.addItem("June");
        this.monthList.addItem("July");
        this.monthList.addItem("August");
        this.monthList.addItem("September");
        this.monthList.addItem("October");
        this.monthList.addItem("November");
        this.monthList.addItem("December");
        this.year = new TextField("", 4);
        panel.add(this.dt);
        panel.add(this.monthList);
        panel.add(this.year);
        Panel panel2 = new Panel();
        FlowLayout flowLayout = new FlowLayout(1, 2, 2);
        panel2.setLayout(flowLayout);
        this.hour = new TextField("", 2);
        this.min = new TextField("", 2);
        this.sec = new TextField("", 2);
        panel2.add(this.hour);
        panel2.add(new Label(":"));
        panel2.add(this.min);
        panel2.add(new Label(":"));
        panel2.add(this.sec);
        Panel panel3 = new Panel();
        panel3.add(panel);
        panel3.add(panel2);
        return panel3;
    }

    public void initDateAndTime() {
        this.inOption = (Checkbox)this.f[0].w;
        this.inOption.setState(this.opState);
        ((TextComponent)this.dt).setText(ReqView.Int2String((int)this.date.getDate(), (int)2));
        this.monthList.select(this.date.getMonth());
        ((TextComponent)this.year).setText(Integer.toString(this.date.getYear() + 1900));
        ((TextComponent)this.hour).setText(ReqView.Int2String((int)this.date.getHours(), (int)2));
        ((TextComponent)this.min).setText(ReqView.Int2String((int)this.date.getMinutes(), (int)2));
        ((TextComponent)this.sec).setText(ReqView.Int2String((int)this.date.getSeconds(), (int)2));
        this.enableDateFields();
    }

    public boolean getDateOption() {
        return this.inOption.getState();
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Date getLogDate() {
        int[][] nArrayArray = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
        if (this.inOption.getState()) {
            return null;
        }
        boolean bl = true;
        String string = this.dt.getText();
        int n = this.monthList.getSelectedIndex();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        String string2 = this.year.getText();
        String string3 = this.hour.getText();
        String string4 = this.min.getText();
        String string5 = this.sec.getText();
        Debug.println((String)(String.valueOf(string2) + n + string + " " + string3 + string4 + string5));
        try {
            n2 = Integer.parseInt(string);
            n3 = Integer.parseInt(string2);
            n4 = Integer.parseInt(string3);
            n5 = Integer.parseInt(string4);
            n6 = Integer.parseInt(string5);
            boolean bl2 = bl = n2 > 0 && n >= 0 && n3 > 0 && n4 >= 0 && n4 < 24 && n5 >= 0 && n5 < 60 && n6 >= 0 && n6 < 60;
            if (!bl) {
                this.errorMsg = new String(String.valueOf(this.title) + ": Please enter correct time field.");
            } else {
                int n7 = this.isLeap(n3);
                boolean bl3 = bl = n3 >= 1990 && n2 <= nArrayArray[n7][n];
                if (!bl) {
                    this.errorMsg = new String(String.valueOf(this.title) + ": Please enter correct date field.");
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.errorMsg = new String(String.valueOf(this.title) + ": Please make sure date/time fields all have numeric values.");
            bl = false;
        }
        if (!bl) {
            return null;
        }
        Debug.println((String)("New date: " + n3 + n + n2 + n4 + n5 + n6));
        return new Date(n3 - 1900, n, n2, n4, n5, n6);
    }
}

