/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.Admin;
import admin.CmdEdit;
import admin.CommentField;
import admin.Config;
import admin.ConfigEdit;
import admin.DTField;
import admin.DependentField;
import admin.DirListingField;
import admin.HostField;
import admin.IPField;
import admin.LogPrefixField;
import admin.LogTypeField;
import admin.NotNullField;
import admin.PortPoolField;
import admin.RemovableHost;
import admin.RemovablePort;
import admin.RootField;
import admin.ScaleField;
import admin.View;
import admin.XbithackField;
import java.awt.Component;
import java.util.Hashtable;
import util.Debug;
import util.Field;
import util.FieldValidationException;
import util.Group;
import util.GroupedPanel;
import util.Message;
import util.Util;

class ViewEdit
extends View {
    boolean hostChanged;

    ViewEdit(Config config) {
        super(config);
    }

    public void closeDialogs() {
        if (this.config != null) {
            ((ConfigEdit)this.config).closeDialogs();
        }
    }

    public boolean folderTabCheck(String string) {
        if (Admin.helpChk((String)"Configuration", (String)string, null)) {
            return true;
        }
        return super.folderTabCheck(string);
    }

    String hostNew(Config config) {
        ConfigEdit configEdit = (ConfigEdit)this.config;
        Hashtable hashtable = (Hashtable)config.hosts.firstElement();
        Hashtable hashtable2 = configEdit.hostClone(hashtable);
        String string = Config.getHostName((Hashtable)hashtable2);
        configEdit.portPoolNewHost(string);
        this.changeHost(string);
        configEdit.dirty = true;
        return string;
    }

    void hostRemove() {
        String string = Config.getHostName((Hashtable)this.curhost);
        if (string.equals("Host")) {
            Message.info((String)"Can't remove the default host");
            return;
        }
        this.config.hosts.removeElement(this.curhost);
        this.changeHost((Hashtable)this.config.hosts.firstElement());
        ((CmdEdit)this.getParent()).status();
    }

    void portLink(String string) {
        Hashtable hashtable = this.config.portLookup(string);
        String string2 = Config.getHostName((Hashtable)this.curhost);
        if (((String)hashtable.get("port_pool_info")).equals("no") && !Config.portSupports((Hashtable)hashtable, (String)string2)) {
            if (this.config.readonly) {
                Message.info((String)("Cannot link new port. Configuration " + this.config.name + " is read-only."));
            } else {
                this.addTab(string);
                ConfigEdit.portSupportAdd((Hashtable)hashtable, (String)string2);
                ((ConfigEdit)this.config).dirty = true;
            }
        }
        this.setCurrentFolder(string);
    }

    void portUnlink(Hashtable hashtable, GroupedPanel groupedPanel) {
        ConfigEdit configEdit = (ConfigEdit)this.config;
        String string = Config.portGetId((Hashtable)hashtable);
        hashtable.put("port_pool_info", "no");
        if (configEdit.portSupportRemove(hashtable, Config.getHostName((Hashtable)this.curhost))) {
            ((CmdEdit)this.getParent()).status();
        }
        this.remove(string, (Component)groupedPanel);
        this.show(this.getCurrentFolder());
        this.repaint();
    }

    String portNew(ConfigEdit configEdit) {
        Hashtable hashtable = (Hashtable)configEdit.ports.firstElement();
        Hashtable hashtable2 = ((ConfigEdit)this.config).portClone(hashtable);
        this.creatingNewPort = true;
        String string = Config.portGetId((Hashtable)hashtable2);
        this.addTab(string);
        this.layout();
        this.setCurrentFolder(string);
        return string;
    }

    boolean readonly() {
        if (this.config.readonly) {
            Message.info((String)("Configuration " + this.config.name + " is read only"));
            return true;
        }
        return false;
    }

    public boolean folderTabPressed(String string) {
        if (!this.config.readonly && !this.storeCurrentForm()) {
            return true;
        }
        return super.folderTabPressed(string);
    }

    boolean currentFormDirty() {
        String string = this.getCurrentFolder();
        GroupedPanel groupedPanel = this.formLookup(string);
        return groupedPanel.dirty;
    }

    void currentFormClean() {
        String string = this.getCurrentFolder();
        GroupedPanel groupedPanel = this.formLookup(string);
        groupedPanel.dirty = false;
    }

    boolean storeCurrentForm() {
        if (this.config.readonly) {
            return true;
        }
        String string = this.getCurrentFolder();
        GroupedPanel groupedPanel = this.formLookup(string);
        if (groupedPanel == null) {
            Debug.println((String)("No form " + string));
            return true;
        }
        if (!groupedPanel.dirty) {
            return true;
        }
        if (groupedPanel.stale) {
            return true;
        }
        this.hostChanged = false;
        try {
            groupedPanel.store();
        }
        catch (FieldValidationException fieldValidationException) {
            Message.info((String)fieldValidationException.getMessage());
            Util.setBusy((boolean)false, (Component)this);
            return false;
        }
        ((ConfigEdit)this.config).dirty = true;
        if (string.startsWith("Port")) {
            Hashtable hashtable = groupedPanel.table;
            String string2 = Config.getHostName((Hashtable)this.curhost);
            if (!Config.portSupports((Hashtable)hashtable, (String)string2)) {
                ConfigEdit configEdit = (ConfigEdit)this.config;
                if (this.creatingNewPort && Config.portInPool((Hashtable)hashtable)) {
                    configEdit.portAddToPool(hashtable);
                } else {
                    ConfigEdit.portSupportAdd((Hashtable)hashtable, (String)Config.getHostName((Hashtable)this.curhost));
                }
                this.creatingNewPort = false;
            }
        } else if (this.hostChanged) {
            this.updateHostLabel(true);
            ((CmdEdit)this.getParent()).status();
        }
        return true;
    }

    GroupedPanel formServer() {
        Group[] groupArray = new Group[5];
        boolean bl = true;
        Field[] fieldArray = new Field[]{new CommentField("Comment", bl, 0, "comment", 0, 32)};
        groupArray[0] = new Group("Alive", fieldArray, 1);
        fieldArray = new Field[]{new RootField("Server Root", bl, 0, "server_root", 3, 15)};
        groupArray[1] = new Group("Root", fieldArray, 1);
        fieldArray = new Field[]{new NotNullField("Server User", bl, 0, "server_user", 0, 15), new Field("Admin E-mail", bl, 0, "server_admin", 0, 15)};
        groupArray[2] = new Group("Server", fieldArray, 2);
        fieldArray = new Field[]{new DTField("Enable Access Control", bl, 1, "acl_enable", 0, 1), new DependentField("Access Control File", bl, 0, "acl_file", 3, 24, fieldArray[0])};
        ((DTField)fieldArray[0]).setDependent(fieldArray[1]);
        groupArray[3] = new Group("Acl", fieldArray, 2);
        fieldArray = new Field[]{new DTField("Enable Document Cache", bl, 1, "cache_enable", 0, 4), new DependentField("Max Entry Size (MBytes)", bl, 0, "cache_max_file_size", 1, fieldArray[0]), new DependentField("Small File Cache (MBytes)", bl, 0, "cache_small_file_cache_size", 1, fieldArray[0]), new DependentField("Large File Cache (MBytes)", bl, 0, "cache_large_file_cache_size", 1, fieldArray[0]), new DependentField("Verification Interval (sec)", bl, 0, "cache_verification_time", 1, fieldArray[0])};
        groupArray[4] = new Group("Cache", fieldArray, 5);
        ((DTField)fieldArray[0]).setDependent(fieldArray[1]);
        ((DTField)fieldArray[0]).setDependent(fieldArray[2]);
        ((DTField)fieldArray[0]).setDependent(fieldArray[3]);
        ((DTField)fieldArray[0]).setDependent(fieldArray[4]);
        return new GroupedPanel("Configuration", "Server", groupArray);
    }

    GroupedPanel formHost() {
        Group[] groupArray = new Group[5];
        boolean bl = true;
        Field[] fieldArray = new Field[]{new HostField("Hostname", bl, 0, "host_info_name", 0, 20, this), new RootField("Doc Root", bl, 0, "doc_root", 3), new DirListingField("Directory Listing", bl, 2, "directory_listing", 0)};
        groupArray[0] = new Group("Host", fieldArray, 3);
        fieldArray = new Field[]{new DTField("User Doc Enable", bl, 1, "user_doc_enable", 0, 1), new DependentField("User Directory", bl, 0, "user_doc_root", 0, fieldArray[0])};
        ((DTField)fieldArray[0]).setDependent(fieldArray[1]);
        groupArray[1] = new Group("User", fieldArray, 1);
        fieldArray = new Field[]{new DTField("CGI Enable", bl, 1, "cgi_enable", 0, 3), new DependentField(".cgi Suffix", bl, 1, "cgi_suffix_enable", 0, fieldArray[0]), new DependentField("DNS", bl, 1, "cgi_dns_enable", 0, fieldArray[0]), new DependentField("User", bl, 0, "cgi_user", 0, fieldArray[0])};
        ((DTField)fieldArray[0]).setDependent(fieldArray[1]);
        ((DTField)fieldArray[0]).setDependent(fieldArray[2]);
        ((DTField)fieldArray[0]).setDependent(fieldArray[3]);
        groupArray[2] = new Group("CGI", fieldArray, 1);
        fieldArray = new Field[]{new DTField("Enable SSI", bl, 1, "ssi_enable", 0, 2), new DependentField("Allow SSI Exec", bl, 1, "ssi_exec", 0, fieldArray[0]), new XbithackField("SSI Xbithack", bl, 1, "ssi_xbithack", 0, fieldArray[0])};
        ((DTField)fieldArray[0]).setDependent(fieldArray[1]);
        ((DTField)fieldArray[0]).setDependent(fieldArray[2]);
        groupArray[3] = new Group("SSI", fieldArray, 1);
        fieldArray = new Field[]{new LogTypeField("Format", bl, 2, "log_type", 0, 4), new LogPrefixField("Prefix", bl, 0, "log_prefix", 3, 13, fieldArray[0]), new DependentField("Max Files", bl, 0, "log_max_files", 1, 3, fieldArray[0]), new ScaleField("Max Size (MBytes)", bl, 0, "log_max_file_size", 1, 3, 1000000, fieldArray[0]), new DependentField("Cycle (minutes)", bl, 0, "log_cycle_time", 1, 6, fieldArray[0])};
        ((LogTypeField)fieldArray[0]).setDependent(fieldArray[1]);
        ((LogTypeField)fieldArray[0]).setDependent(fieldArray[2]);
        ((LogTypeField)fieldArray[0]).setDependent(fieldArray[3]);
        ((LogTypeField)fieldArray[0]).setDependent(fieldArray[4]);
        groupArray[4] = new Group("Logging Parameters", "Log", fieldArray, 3);
        return new RemovableHost(this, groupArray);
    }

    GroupedPanel formPort(Hashtable hashtable) {
        Group[] groupArray = new Group[4];
        boolean bl = true;
        Field[] fieldArray = new Field[2];
        IPField iPField = new IPField("IP Address", bl, 2, "ip_address", 0, this.config);
        fieldArray[0] = iPField;
        fieldArray[1] = new Field("Port", bl, 0, "port_info_port", 1, 4);
        iPField.setPortField(fieldArray[1]);
        groupArray[0] = new Group("Identity", fieldArray, 1);
        fieldArray = new Field[]{new PortPoolField("Support All Hosts", true, 1, "port_pool_info", 0, (ConfigEdit)this.config)};
        groupArray[1] = new Group("Supported", fieldArray, 1);
        fieldArray = new Field[]{new Field("Request Timeout (secs)", bl, 0, "request_timeout", 1)};
        groupArray[2] = new Group("Timeout", fieldArray, 1);
        fieldArray = new Field[]{new Field("Enable SSL (Secure Sockets)", true, 1, "ssl_enable", 0), new Field("Require Client Certificate", true, 1, "ssl_client_cert_required", 0), new Field("Support 40-bit Cipher", true, 1, "SSL_RSA_EXPORT_WITH_RC4_40_MD5", 0), new Field("Support 128-bit Cipher", true, 1, "SSL_RSA_WITH_RC4_128_MD5", 0)};
        groupArray[3] = new Group("Security", fieldArray, 4);
        return new RemovablePort(this, groupArray, hashtable);
    }
}

