/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.Config;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import util.Debug;
import util.GroupedPanel;
import util.TFolder;
import util.Util;

abstract class View
extends TFolder {
    Config config;
    GroupedPanel server;
    GroupedPanel host;
    Hashtable portForms = new Hashtable();
    Hashtable curhost;
    boolean creatingNewPort;

    View(Config config) {
        this.config = config;
        this.addTab("Server");
        this.addTab("Host");
        config.run();
        this.curhost = config.hostLookup("[default]");
        this.portTabs();
        this.show("Server");
    }

    private void portTabs() {
        String string = Config.getHostName((Hashtable)this.curhost);
        int n = 0;
        while (n < this.config.ports.size()) {
            Hashtable hashtable = (Hashtable)this.config.ports.elementAt(n);
            if (((String)hashtable.get("port_pool_info")).equals("yes") || Config.portSupports((Hashtable)hashtable, (String)string)) {
                String string2 = Config.portGetId((Hashtable)hashtable);
                this.addTab(string2);
                this.portForms.put(string2, "");
            }
            ++n;
        }
    }

    public boolean folderTabPressed(String string) {
        GroupedPanel groupedPanel = this.formLookup(string);
        if (groupedPanel == null) {
            Debug.println((String)("View: null form for " + string));
        }
        if (groupedPanel != null && groupedPanel.stale) {
            groupedPanel.load();
            if (this.creatingNewPort) {
                groupedPanel.dirty = true;
            }
            Util.setBusy((boolean)false, (Component)this);
        }
        return false;
    }

    public synchronized Component getCard(String string) {
        Hashtable hashtable;
        GroupedPanel groupedPanel;
        Util.setBusy((boolean)true, (Component)this);
        if (string.equals("Server")) {
            groupedPanel = this.server = this.formServer();
            hashtable = this.config.server;
        } else if (string.equals("Host")) {
            groupedPanel = this.host = this.formHost();
            hashtable = this.curhost;
        } else {
            hashtable = this.config.portLookup(string);
            groupedPanel = this.formPort(hashtable);
            this.portForms.put(string, groupedPanel);
        }
        groupedPanel.setTable(hashtable, !this.config.readonly);
        return groupedPanel;
    }

    private GroupedPanel getPortCard(String string) {
        Hashtable hashtable = this.config.portLookup(string);
        GroupedPanel groupedPanel = this.formPort(hashtable);
        this.portForms.put(string, groupedPanel);
        groupedPanel.setTable(hashtable, !this.config.readonly);
        return groupedPanel;
    }

    public GroupedPanel formLookup(String string) {
        if (string.equals("Server")) {
            return this.server;
        }
        if (string.equals("Host")) {
            return this.host;
        }
        Object v = this.portForms.get(string);
        if (v instanceof GroupedPanel) {
            return (GroupedPanel)v;
        }
        return this.getPortCard(string);
    }

    void changeConfig(Config config) {
        this.change(config, (Hashtable)config.hosts.firstElement());
    }

    void changeHost(String string) {
        this.changeHost(this.config.hostLookup(string));
    }

    void changeHost(Hashtable hashtable) {
        String string = Config.getHostName((Hashtable)this.curhost);
        if (string.equals(Config.getHostName((Hashtable)hashtable))) {
            this.getCurrentFolder();
            this.show("Host");
            this.repaint();
            return;
        }
        this.setCurrentFolder("Host");
        this.change(this.config, hashtable);
    }

    private void change(Config config, Hashtable hashtable) {
        Enumeration enumeration = this.portForms.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.portForms.get(string);
            GroupedPanel groupedPanel = null;
            if (v instanceof GroupedPanel) {
                groupedPanel = (GroupedPanel)v;
            }
            try {
                this.remove(string, (Component)groupedPanel);
            }
            catch (Exception exception) {}
        }
        this.portForms = new Hashtable();
        if (config != this.config) {
            this.config = config;
        }
        this.config.run();
        if (this.server != null) {
            this.server.setTable(this.config.server, !this.config.readonly);
        }
        this.curhost = hashtable;
        if (this.host != null) {
            this.host.setTable(this.curhost, !this.config.readonly);
        }
        this.updateHostLabel(false);
        this.portTabs();
        this.layout();
        this.show(this.getCurrentFolder());
        this.repaint();
    }

    String updateHostLabel(boolean bl) {
        String string = Config.getHostName((Hashtable)this.curhost);
        this.labelChange("Host", string);
        if (bl) {
            this.repaint();
        }
        return string;
    }

    GroupedPanel formServer() {
        return null;
    }

    GroupedPanel formHost() {
        return null;
    }

    GroupedPanel formPort(Hashtable hashtable) {
        return null;
    }
}

