/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.CmdEdit;
import admin.Config;
import admin.ConfigEdit;
import admin.LostUpdateWaiter;
import admin.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FontMetrics;
import java.util.Vector;
import util.AuthURL;
import util.AuthURLInterface;
import util.Confirm;
import util.ConfirmInterface;
import util.Debug;
import util.FatList;
import util.FollowupInterface;
import util.Message;
import util.StandardFonts;
import util.Util;
import util.modal.ModalDialog;
import util.modal.ModalDialogInterface;
import util.modal.Waiter;

class ConfigList
implements ConfirmInterface {
    AuthURL admin;
    Vector configs;
    String prev;
    String config_dir;
    private String originOfRunning;
    FatList openList;
    Component comp;
    ModalDialog messageDlg;
    Waiter from;

    ConfigList(Component component) {
        this.comp = component;
    }

    int connect(AuthURLInterface authURLInterface) {
        this.admin = new AuthURL(Util.home, "/sws-administration/", "GET", authURLInterface);
        int n = this.admin.connect();
        return n;
    }

    public void disposeAuthDialog() {
        if (this.admin != null) {
            AuthURL.disposeAuthDialog();
        }
        if (this.messageDlg != null) {
            this.messageDlg.closeDialog();
        }
    }

    public void authDoit(boolean bl) {
        this.loadConfigs();
    }

    void loadConfigs() {
        this.configs = new Vector();
        ConfigEdit configEdit = new ConfigEdit("[running]", false);
        this.configs.addElement(configEdit);
        try {
            String string;
            this.config_dir = this.admin.readLine();
            configEdit = null;
            while ((string = this.admin.readLine()) != null) {
                Debug.println((String)("name = " + string));
                configEdit = this.lookup(string, false);
                if (configEdit != null) continue;
                configEdit = new ConfigEdit(string, false);
                this.configs.addElement(configEdit);
            }
            this.originOfRunning = configEdit == null ? "httpd.conf" : configEdit.name;
        }
        catch (Exception exception) {}
        this.admin.close();
    }

    void configAdd(Config config) {
        this.configs.addElement(config);
    }

    void configRemove(Config config) {
        this.configs.removeElement(config);
    }

    String getOriginOfRunning() {
        return this.originOfRunning;
    }

    ConfigEdit lookup(String string, boolean bl) {
        int n = 0;
        while (n < this.configs.size()) {
            ConfigEdit configEdit = (ConfigEdit)this.configs.elementAt(n);
            if (configEdit.name.equals(string)) {
                if (bl) {
                    configEdit.run();
                }
                return configEdit;
            }
            ++n;
        }
        return null;
    }

    ConfigEdit lookup(String string) {
        return this.lookup(string, true);
    }

    int restart(String string, AuthURLInterface authURLInterface) {
        ConfigEdit configEdit = this.lookup(string, false);
        return configEdit.restart(authURLInterface);
    }

    void handleRestartError(String string) {
        ConfigEdit configEdit = this.lookup(string, false);
        configEdit.handleRestartError();
    }

    ModalDialog dialog(String[] stringArray, ModalDialogInterface modalDialogInterface, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        FontMetrics fontMetrics = this.comp.getGraphics().getFontMetrics(StandardFonts.getSystemFont());
        int n = Math.min(this.configs.size(), 5);
        this.openList = new FatList(n, false, fontMetrics, 160);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.configs.size()) {
            object2 = (ConfigEdit)this.configs.elementAt(n3);
            if (!(bl3 && object2.name.equals("[builtin]") || bl && object2.readonly || bl2 && object2.name.equals("[running]") || object2.newNotSaved && !object2.name.equals("[builtin]") && !object2.name.equals("[running]"))) {
                this.openList.addItemChk(object2.name);
                object = ((CmdEdit)modalDialogInterface).view.config.name;
                if (object2.name.equals(object)) {
                    this.openList.select(n2);
                }
                ++n2;
            }
            ++n3;
        }
        this.openList.done();
        if (n2 == 0) {
            this.messageDlg = Message.info((String)("No configurations to " + stringArray[0]));
            return null;
        }
        object2 = stringArray[0].equals("Restart") ? "Restart Server" : String.valueOf(stringArray[0]) + " a Configuration";
        object = new ModalDialog((String)object2, (Component)this.openList, stringArray, modalDialogInterface);
        ((Dialog)object).show();
        Event event = new Event(object, System.currentTimeMillis(), 202, 0, 0, 0, 0, null);
        ((Container)object).deliverEvent(event);
        return object;
    }

    boolean flush(FollowupInterface followupInterface) {
        return this.flush(followupInterface, null);
    }

    boolean flush(FollowupInterface followupInterface, Waiter waiter) {
        this.from = waiter;
        boolean bl = followupInterface == null;
        boolean bl2 = false;
        int n = 0;
        while (n < this.configs.size()) {
            ConfigEdit configEdit = (ConfigEdit)this.configs.elementAt(n);
            if (configEdit.dirty) {
                if (configEdit.newNotSaved) {
                    this.configs.removeElement(configEdit);
                } else if (bl) {
                    bl2 |= configEdit.write() != null;
                } else {
                    String[] stringArray = new String[]{"Save", "Discard"};
                    new Confirm("Save un-saved changes to " + configEdit.name + "?", stringArray, (ConfirmInterface)this, (Object)configEdit, followupInterface);
                    return false;
                }
            }
            ++n;
        }
        return !bl2;
    }

    public void confirmed(boolean bl, Object object, FollowupInterface followupInterface, Object object2) {
        ConfigEdit configEdit = (ConfigEdit)object;
        configEdit.dirty = false;
        if (bl) {
            Waiter waiter = configEdit.write();
            if (waiter != null) {
                ((LostUpdateWaiter)waiter).setFollowup(followupInterface);
                waiter.go();
                return;
            }
        } else {
            configEdit.setStale();
            View view = ((CmdEdit)followupInterface).view;
            ((CmdEdit)followupInterface).confirmed(true, (Object)view, followupInterface, null);
        }
        ((CmdEdit)followupInterface).followupCaller(true, this.from);
    }
}

