/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.Admin;
import admin.Cmd;
import admin.Config;
import admin.ConfigEdit;
import admin.ConfigList;
import admin.DeleteWaiter;
import admin.LostUpdateWaiter;
import admin.NewWaiter;
import admin.OpenWaiter;
import admin.Reloader;
import admin.RestartWaiter;
import admin.SaveAsWaiter;
import admin.View;
import admin.ViewEdit;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Event;
import java.awt.TextField;
import java.util.Hashtable;
import java.util.Vector;
import util.AuthURL;
import util.AuthURLInterface;
import util.Confirm;
import util.ConfirmInterface;
import util.Debug;
import util.FollowupInterface;
import util.Message;
import util.Sublet;
import util.Util;
import util.XTextField;
import util.modal.ModalDialog;
import util.modal.ModalDialogInterface;
import util.modal.Waiter;
import util.modal.WaiterBase;

class CmdEdit
extends Cmd
implements AuthURLInterface,
ConfirmInterface,
FollowupInterface,
Sublet {
    ConfigList configList = new ConfigList((Component)this);
    boolean loaded;
    ModalDialog newDialog;
    ModalDialog openDialog;
    ModalDialog saveAsDialog;
    ModalDialog deleteDialog;
    ModalDialog restartDialog;
    ModalDialog restartTimeoutDlg;
    static final int ChoiceConfig = 0;
    static final int ChoiceHosts = 1;
    static final int ChoicePorts = 2;
    static final int TIMEOUT = 30;
    TextField saveAsText;
    boolean toldAboutRestart;

    CmdEdit() {
        super("Configuration");
        boolean bl;
        AuthURL.reset();
        boolean bl2 = bl = this.configList.connect((AuthURLInterface)this) == 1;
        if (bl) {
            this.authDoit(200);
        }
    }

    synchronized void sleep() {
        if (this.loaded) {
            return;
        }
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    synchronized void wakeup() {
        this.loaded = true;
        this.notifyAll();
    }

    public void setRestartTimeoutDlg(ModalDialog modalDialog) {
        this.restartTimeoutDlg = modalDialog;
    }

    public void authDoit(int n) {
        boolean bl = n == 200;
        Util.setBusy((boolean)true, (Component)this);
        this.configList.authDoit(bl);
        ConfigEdit configEdit = this.configList.lookup(this.configList.getOriginOfRunning());
        this.view = new ViewEdit((Config)configEdit);
        this.menuBuild();
        this.add("Center", (Component)this.view);
        this.wakeup();
        Util.setBusy((boolean)false, (Component)this);
    }

    private void menuBuild() {
        String[][][] stringArrayArray = new String[][][]{{{"Config"}, {"New...", "Open...", "Save", "Save As...", "Undo", "Delete...", "Restart..."}}, {{"Hosts"}, {"New"}}, {{"Ports"}, {"New"}}};
        this.choice = new Choice[stringArrayArray.length];
        int n = 0;
        while (n < stringArrayArray.length) {
            this.choice[n] = new Choice();
            this.menu.add(this.choice[n]);
            this.choice[n].addItem(stringArrayArray[n][0][0]);
            int n2 = 0;
            while (n2 < stringArrayArray[n][1].length) {
                this.choice[n].addItem(stringArrayArray[n][1][n2]);
                ++n2;
            }
            switch (n) {
                case 1: {
                    Cmd.choiceHosts(this.view.config.hosts.elements(), (Choice)this.choice[1]);
                    break;
                }
                case 2: {
                    this.choicePorts();
                    break;
                }
            }
            ++n;
        }
    }

    private void choicePorts() {
        Config config = this.view.config;
        int n = 0;
        while (n < config.ports.size()) {
            Hashtable hashtable = (Hashtable)config.ports.elementAt(n);
            this.choice[2].addItem(Config.portGetId((Hashtable)hashtable));
            ++n;
        }
    }

    public void cleanup() {
        Debug.println((String)"Cleaning up.. CmdEdit");
        this.configList.disposeAuthDialog();
        if (this.newDialog != null) {
            this.newDialog.closeDialog();
        }
        if (this.openDialog != null) {
            this.openDialog.closeDialog();
        }
        if (this.saveAsDialog != null) {
            this.saveAsDialog.closeDialog();
        }
        if (this.deleteDialog != null) {
            this.deleteDialog.closeDialog();
        }
        if (this.restartDialog != null) {
            this.restartDialog.closeDialog();
        }
        if (this.view != null) {
            ((ViewEdit)this.view).closeDialogs();
        }
        if (this.restartTimeoutDlg != null) {
            this.restartTimeoutDlg.closeDialog();
        }
    }

    public boolean action(Event event, Object object) {
        ViewEdit viewEdit;
        if (!(event.target instanceof Choice)) {
            return false;
        }
        if (((Choice)event.target).getSelectedIndex() == 0) {
            return false;
        }
        int n = 0;
        while (n < this.choice.length) {
            if ((Choice)event.target == this.choice[n]) break;
            ++n;
        }
        if (n == this.choice.length) {
            return false;
        }
        String string = (String)object;
        ((Choice)event.target).select(0);
        if (!(event.target == this.choice[0] && (string.equals("Undo") || string.equals("Delete...")) || (viewEdit = (ViewEdit)this.view).storeCurrentForm())) {
            return true;
        }
        boolean bl = false;
        Waiter waiter = null;
        ViewEdit viewEdit2 = (ViewEdit)this.view;
        Debug.println((String)string);
        if (event.target == this.choice[0]) {
            if (string.equals("New...")) {
                waiter = this.doNew();
            } else if (string.equals("Open...")) {
                waiter = this.doOpen();
            } else if (string.equals("Save")) {
                waiter = this.doSave();
            } else if (string.equals("Save As...")) {
                waiter = this.doSaveAs();
            } else if (string.equals("Undo")) {
                waiter = this.doUndo();
            } else if (string.equals("Delete...")) {
                waiter = this.doDelete();
            } else if (string.equals("Restart...")) {
                waiter = this.doRestart();
            } else {
                return false;
            }
            bl = true;
        } else if (event.target == this.choice[1]) {
            if (string.equals("New")) {
                if (!viewEdit2.readonly()) {
                    ConfigEdit configEdit = this.configList.lookup("[builtin]");
                    this.choice[1].addItem(viewEdit2.hostNew((Config)configEdit));
                }
            } else {
                this.view.changeHost(string);
            }
            this.view.show(this.view.getCurrentFolder());
            this.view.repaint();
            this.repaint();
            bl = true;
        } else if (event.target == this.choice[2]) {
            if (string.equals("New")) {
                if (!viewEdit2.readonly()) {
                    ConfigEdit configEdit = this.configList.lookup("[running]");
                    String string2 = viewEdit2.portNew(configEdit);
                    this.choice[2].addItem(string2);
                    this.menuRebuild();
                }
            } else {
                viewEdit2.portLink(string);
            }
            this.view.show(this.view.getCurrentFolder());
            bl = true;
        }
        if (waiter != null) {
            waiter.go();
        }
        return bl;
    }

    private void menuRebuild() {
        int n = 0;
        while (n < this.choice.length) {
            this.menu.remove(this.choice[n]);
            ++n;
        }
        this.menuBuild();
        this.menu.getParent().invalidate();
        this.menu.getParent().validate();
        this.menu.getParent().repaint();
    }

    private Waiter doOpen() {
        if (!this.configList.flush((FollowupInterface)this, (Waiter)new OpenWaiter(null, null))) {
            return null;
        }
        String[] stringArray = new String[]{"Open", "Cancel"};
        this.expectedAction = stringArray[0];
        this.openDialog = this.configList.dialog(stringArray, (ModalDialogInterface)this, false, false, false);
        this.checkList = this.configList.openList;
        return new OpenWaiter(this.openDialog, this);
    }

    private Waiter doDelete() {
        if (!this.configList.flush((FollowupInterface)this, (Waiter)new DeleteWaiter(null, null))) {
            return null;
        }
        String[] stringArray = new String[]{"Delete", "Cancel"};
        this.expectedAction = stringArray[0];
        this.deleteDialog = this.configList.dialog(stringArray, (ModalDialogInterface)this, true, true, true);
        this.checkList = this.configList.openList;
        if (this.deleteDialog == null) {
            return null;
        }
        return new DeleteWaiter(this.deleteDialog, this);
    }

    private Waiter doUndo() {
        boolean bl = ((ViewEdit)this.view).currentFormDirty();
        Debug.println((String)("Current form dirty=" + bl));
        if (!bl && !((ConfigEdit)this.view.config).dirty) {
            Message.info((String)"No changes to undo.");
            return null;
        }
        String[] stringArray = new String[]{"Undo", "Cancel"};
        new Confirm("Undo changes since last save to " + this.view.config.name + "?", stringArray, (ConfirmInterface)this, (Object)this.view);
        return null;
    }

    public void confirmed(boolean bl, Object object, FollowupInterface followupInterface, Object object2) {
        if (object2 != null && object2 instanceof String) {
            if (bl) {
                String string = (String)object2;
                ConfigEdit configEdit = (ConfigEdit)object;
                String string2 = (String)configEdit.server.get("ETag");
                this.configList.configRemove((Config)configEdit);
                ConfigEdit configEdit2 = new ConfigEdit(string, this.view.config);
                this.configList.configAdd((Config)configEdit2);
                configEdit2.server.put("ETag", string2);
                Waiter waiter = configEdit2.write();
                if (waiter != null) {
                    waiter.go();
                    return;
                }
                this.view.changeConfig((Config)configEdit2);
                Admin.folderLabelUpdate((String)this.status());
                return;
            }
        } else if (bl) {
            Util.setBusy((boolean)true, (Component)this);
            View view = (View)object;
            view.config.setStale();
            view.changeConfig(view.config);
            Admin.folderLabelUpdate((String)this.status());
            Util.setBusy((boolean)false, (Component)this);
            ((ViewEdit)view).currentFormClean();
            ((ConfigEdit)view.config).dirty = false;
        }
    }

    private Waiter doSaveAs() {
        String[] stringArray = new String[]{"Save", "Cancel"};
        this.expectedAction = stringArray[0];
        this.saveAsText = new XTextField(40);
        this.saveAsDialog = new ModalDialog("Save a Configuration", (Component)this.saveAsText, stringArray, (ModalDialogInterface)this);
        this.saveAsDialog.show();
        return new SaveAsWaiter(this.saveAsDialog, this);
    }

    private Waiter doNew() {
        if (!this.configList.flush((FollowupInterface)this, (Waiter)new NewWaiter(null, null))) {
            return null;
        }
        String[] stringArray = new String[]{"New", "Cancel"};
        this.expectedAction = stringArray[0];
        this.checkText = this.saveAsText = new XTextField(40);
        this.newDialog = new ModalDialog("Name a New Configuration", (Component)this.saveAsText, stringArray, (ModalDialogInterface)this);
        this.newDialog.show();
        return new NewWaiter(this.newDialog, this);
    }

    private Waiter doSave() {
        if (((ViewEdit)this.view).readonly()) {
            return null;
        }
        Util.setBusy((boolean)true, (Component)this);
        Waiter waiter = ((ConfigEdit)this.view.config).write();
        Util.setBusy((boolean)false, (Component)this);
        if (waiter != null && waiter instanceof LostUpdateWaiter) {
            Reloader reloader = new Reloader(this.view, this);
            ((LostUpdateWaiter)waiter).setFollowup((FollowupInterface)reloader);
        } else {
            if (waiter != null && waiter instanceof WaiterBase) {
                Util.setBusy((boolean)false, (Component)this);
                return null;
            }
            if (!this.toldAboutRestart) {
                this.toldAboutRestart = true;
                String string = this.configList.getOriginOfRunning();
                if (this.view.config.name.equals(string)) {
                    Message.info((String)"Saved configuration to disk. You may use Restart to run it.");
                }
            }
        }
        return waiter;
    }

    private Waiter doRestart() {
        if (!this.configList.flush((FollowupInterface)this)) {
            return null;
        }
        String[] stringArray = new String[]{"Restart", "Cancel"};
        this.expectedAction = stringArray[0];
        this.restartDialog = this.configList.dialog(stringArray, (ModalDialogInterface)this, false, true, false);
        this.checkList = this.configList.openList;
        return new RestartWaiter(this.restartDialog, this);
    }

    public void followup(boolean bl) {
        Waiter waiter = this.doRestart();
        if (waiter != null) {
            waiter.go();
        }
    }

    public void followupCaller(boolean bl, Waiter waiter) {
        if (waiter == null || waiter instanceof RestartWaiter) {
            this.followup(bl);
            return;
        }
        Waiter waiter2 = waiter instanceof OpenWaiter ? this.doOpen() : (waiter instanceof NewWaiter ? this.doNew() : this.doDelete());
        if (waiter2 != null) {
            waiter2.go();
        }
    }

    public void init() {
    }

    public String name() {
        return "Configuration";
    }

    public String status() {
        String string = "";
        if (this.view.config.readonly) {
            string = "Read Only ";
        }
        string = String.valueOf(string) + this.name() + " " + this.view.config.name;
        if (this.view.config.name.equals("[running]")) {
            string = String.valueOf(string) + " (" + this.configList.getOriginOfRunning() + ")";
        }
        this.menuRebuild();
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append(string);
        int n = 60 - stringBuffer.length();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        string = stringBuffer.toString();
        return string;
    }

    boolean flush(boolean bl) {
        Vector vector = this.configList.configs;
        boolean bl2 = false;
        int n = 0;
        while (n < vector.size()) {
            ConfigEdit configEdit = (ConfigEdit)vector.elementAt(n);
            if (configEdit.dirty) {
                if (bl) {
                    bl2 = configEdit.write() != null;
                } else {
                    String[] stringArray = new String[]{"Save", "Discard"};
                    new Confirm("Save un-saved changes to " + configEdit.name + "?", stringArray, (ConfirmInterface)this, (Object)configEdit);
                    return false;
                }
            }
            ++n;
        }
        return true;
    }
}

