/*
 * Copyright (c) 1993-1996 CheckPoint Software Technologies Ltd.
 * All Rights Reserved
 *
 * (c) Copyright 1993-1997 Check Point Software Technologies Ltd.
 * All rights reserved.
 * 
 * This is proprietary information of Check Point Software Technologies
 * Ltd., which is provided for informational purposes only and for use
 * solely in conjunction with the authorized use of Check Point Software
 * Technologies Ltd. products.  The viewing and use of this information is
 * subject, to the extent appropriate, to the terms and conditions of the
 * license agreement that authorizes the use of the relevant product.
 * 
 *
 * $Header: /fw/cvs/fw-1/fwlib/traps.h,v 1.41.2.8 1997/04/15 14:54:57 moshe Exp $
 */

#ifndef __traps_h__
#define __traps_h__

/*
 * Daemon traps
 */
#define	AUTH_INVOKE			0x101
#define AUTH_INTRCPT		0x102
#define	AUTH_MATCH			0x103
#define AUTH_KCONN_INVOKE	0x104

#define	PMAP_FETCH			0x110

#define ENCRYPT_INVOKE		0x120
#define ENCRYPT_INTRCPT		0x121
#define NEW_ENCRYPT_INVOKE	0x126
#define NEW_ENCRYPT_INTRCPT	0x127

/*
 * User Encryption (GW side) old (V2.1) trap:
 *
 * At this stage we need only check that the destination is in the
 * encryption domain of the gateway, and if it is, add this connection
 * to the connections table (with its key). The daemon is also responsible
 * for sending the log. After completing the check, the packet, which
 * caused the invoke, will be released (regardless of the result of the
 * check). 
 */
#define USERC_SERVER_INVOKE 0x122

/*
 * User Encryption (GW side) new (V3.0) trap:
 *
 * At this stage we need only check that the destination is in the
 * encryption domain of the gateway, and if it is, add this connection
 * to the connections table (with its key). The daemon is also responsible
 * for sending the log. After completing the check, the packet, which
 * caused the invoke, will be released (regardless of the result of the
 * check). 
 */
#define USERC_NEW_SERVER_INVOKE 0x128

/*
 * User Encryption (PC side):
 *
 *    The daemon running on the PC is requested to establish a session with a
 * GW. The session key will be added to the session table. The packet which
 * caused the invoke will be relased.
 */
#define USERC_ENCRYPT_INVOKE 0x123

/*
 *    Invoked when encountering a SKIP packet for which there is no established
 * secret key between the source and destination.
 */
#define SKIP_DECRYPT	0x124

/*
 *  Invoked when encountering an IPSec packet without key a management protocol
 * for the first time
 */
#define MANUAL_DECRYPT	0x125

/*
 *  The Decrypt-Invoke trap moves an entry from the decryption pending table to
 * the connections table,  given that the  encryption parameters  of the key of
 * that entry match those of the rule.
 */
#define DECRYPT_INVOKE	0x11f

#define BALANCE_INVOKE	0x130

#define	DEBUG_TUNNEL	0x166

#define HOST_REPORT		0x170

#define SYNATK_REPORT	0x180

#define TRAP_EXECUTE    0x190

#define ACCT_REPORT     0x200

#define ADD_CONN        0x210
#define DEL_CONN        0x211
#define CONN_UPDATE     0x213

/*
 * The trap from the tracked table is sent only
 * every CONN_UPDATE_INTERVAL updates.
 */
#define CONN_UPDATE_INTERVAL 10

/*
 * Kernel traps
 */
#define KFUNC_FTPPORT					0
#define KFUNC_GETNET					1
#define KFUNC_ENCRYPT					2
#define KFUNC_DECRYPT					3
#define KFUNC_CONN_EXPIRE				4
#define KFUNC_TCP_ESTABLISHED			5
#define	KFUNC_XLATE_FORW				6
#define	KFUNC_XLATE_BACKW				7
#define KFUNC_KBUF_DUP					8
#define	KFUNC_XLATE_FOLD				9
#define KFUNC_MASK_GET          		10
#define KFUNC_END_ACCT_CONN     		11
#define KFUNC_USERC_EXPIRE      		12
#define KFUNC_XLATE_ANTICIPATE			13
#define KFUNC_SQLNET					14
#define KFUNC_TABLES					15
#define KFUNC_IPHONE_H245_PORT          16
#define KFUNC_IPHONE_RTP_PORT_ONE       17
#define KFUNC_IPHONE_RTP_PORT_TWO       18
#define KFUNC_ACCT_UPDATE				19
#define KFUNC_USERC_RULES_EXPIRE 		20
#define KFUNC_INIT_H225                 21
#define KFUNC_FOLLOW_H225               22
#define KFUNC_INIT_H245                 23
#define KFUNC_FOLLOW_H245               24
#define KFUNC_GET_RTP                   25
#define KFUNC_NOT_IPSEC_ENCAPS          26
#endif /* __traps_h__ */
