###############################################################################
#
# The set defines the state table used to erase html tags.
#
#	states_number:		number of states in table
#	outside_tag_state:	number of default state outside of <> tag
#	inside_tag_state:	number of state corresponds to HTML tag initialization
#	erasure_state:		number of state where erasure of kw takes place
#	keyword:
#		id:		unique activity identifier in the range 1..32 (0 -> empty)
#		switch:
#			from_state:	initial state
#			if_char:	characters that triggers state change
#			to_state:	switch to that state
# 
# Updates:
# 1/6/97   Netscape bug fix.
#
###############################################################################

(
 	:states_number (101)
	:outside_tag_state (0)
	:inside_tag_state (1)
 	:erasure_state (100)
	:keyword	(		# mutual "<" (optional whitespaces) ___________________
		:id	(0)
		:switch (
			:from_state (0)
			:if_char ("<")
			:to_state (1)
		)
		:switch (
			:from_state (1)
			:if_char (" 	
")
			:to_state (1)
		)
	)
	:keyword	(		# "applet" ____________________________________________
		:id	(1)
		:switch (
			:from_state (1)
			:if_char ("Aa")
			:to_state (2)
		)
		:switch (
			:from_state (2)
			:if_char ("Pp")
			:to_state (3)
		)
		:switch (
			:from_state (3)
			:if_char ("Pp")
			:to_state (4)
		)
		:switch (
			:from_state (4)
			:if_char ("Ll")
			:to_state (5)
		)
		:switch (
			:from_state (5)
			:if_char ("Ee")
			:to_state (6)
		)
		:switch (
			:from_state (6)
			:if_char ("Tt")
			:to_state (100)
		)
	)
	:keyword	(		# "script" ____________________________________________
		:id	(2)

		# "script" ____________________________________________
		:switch ( 
			:from_state (1)
			:if_char ("Ss")
			:to_state (7)
		)
		:switch (
			:from_state (7)
			:if_char ("Cc")
			:to_state (8)
		)
		:switch (
			:from_state (8)
			:if_char ("Rr")
			:to_state (9)
		)
		:switch (
			:from_state (9)
			:if_char ("Ii")
			:to_state (10)
		)
		:switch (
			:from_state (10)
			:if_char ("Pp")
			:to_state (11)
		)
		:switch (
			:from_state (11)
			:if_char ("Tt")
			:to_state (100)
		)

		# type="file"_____________________________________________
		:switch (
			:from_state (1)
			:if_char ("tT")
			:to_state (12)
		)
		:switch (
			:from_state (0)
			:if_char ("tT")
			:to_state (12)
		)
		:switch (
			:from_state (12)
			:if_char ("yY")
			:to_state (13)
		)
		:switch (
			:from_state (13)
			:if_char ("pP")
			:to_state (14)
		)
		:switch (
			:from_state (14)
			:if_char ("eE")
			:to_state (15)
		)
		:switch (
			:from_state (15)
			:if_char (" 	
")
			:to_state (15)
		)
		:switch (
			:from_state (15)
			:if_char ("=")
			:to_state (16)
		)
		:switch (
			:from_state (16)
			:if_char (" 	
")
			:to_state (16)
		)
		:switch (
			:from_state (16)
			:if_char (x"x)
			:to_state (17)
		)
		:switch (
			:from_state (16)
			:if_char ("'")
			:to_state (17)
		)
		:switch (
			:from_state (16)
			:if_char ("fF")
			:to_state (18)
		)
		:switch (
			:from_state (17)
			:if_char ("fF")
			:to_state (18)
		)
		:switch (
			:from_state (18)
			:if_char ("iI")
			:to_state (19)
		)
		:switch (
			:from_state (19)
			:if_char ("lL")
			:to_state (20)
		)
		:switch (
			:from_state (20)
			:if_char ("eE")
			:to_state (100)
		)

		# ON*_____________________________________________
		:switch (
			:from_state (1)
			:if_char ("oO")
			:to_state (21)
		)
		:switch (
			:from_state (0)
			:if_char ("oO")
			:to_state (21)
		)
		:switch (
			:from_state (21)
			:if_char ("nN")
			:to_state (22)
		)

		:switch ( # ONabort
			:from_state (22)
			:if_char ("aA")
			:to_state (23)
		)
		:switch (
			:from_state (23)
			:if_char ("bB")
			:to_state (24)
		)
		:switch (
			:from_state (24)
			:if_char ("oO")
			:to_state (25)
		)
		:switch (
			:from_state (25)
			:if_char ("rR")
			:to_state (26)
		)
		:switch (
			:from_state (26)
			:if_char ("tT")
			:to_state (100)
		)

		:switch ( # ONchange
			:from_state (22)
			:if_char ("cC")
			:to_state (27)
		)
		:switch (
			:from_state (27)
			:if_char ("hH")
			:to_state (28)
		)
		:switch (
			:from_state (27)
			:if_char ("lL") # onClick
			:to_state (33)
		)
		:switch (
			:from_state (28)
			:if_char ("aA")
			:to_state (29)
		)
		:switch (
			:from_state (29)
			:if_char ("nN")
			:to_state (30)
		)
		:switch (
			:from_state (30)
			:if_char ("gG")
			:to_state (31)
		)
		:switch (
			:from_state (31)
			:if_char ("eE")
			:to_state (100)
		)

		# ONclick
		:switch (
			:from_state (33)
			:if_char ("iI")
			:to_state (34)
		)
		:switch (
			:from_state (34)
			:if_char ("cC")
			:to_state (35)
		)
		:switch (
			:from_state (35)
			:if_char ("kK")
			:to_state (100)
		)

		:switch ( # ONerror
			:from_state (22)
			:if_char ("eE")
			:to_state (36)
		)
		:switch (
			:from_state (36)
			:if_char ("rR")
			:to_state (37)
		)
		:switch (
			:from_state (37)
			:if_char ("rR")
			:to_state (38)
		)
		:switch (
			:from_state (38)
			:if_char ("oO")
			:to_state (39)
		)
		:switch (
			:from_state (39)
			:if_char ("rR")
			:to_state (100)
		)

		:switch ( # ONfocus
			:from_state (22)
			:if_char ("fF")
			:to_state (40)
		)
		:switch (
			:from_state (40)
			:if_char ("oO")
			:to_state (41)
		)
		:switch (
			:from_state (41)
			:if_char ("cC")
			:to_state (42)
		)
		:switch (
			:from_state (42)
			:if_char ("uU")
			:to_state (43)
		)
		:switch (
			:from_state (43)
			:if_char ("sS")
			:to_state (100)
		)

		:switch ( # ONload
			:from_state (22)
			:if_char ("lL")
			:to_state (44)
		)
		:switch (
			:from_state (44)
			:if_char ("oO")
			:to_state (45)
		)
		:switch (
			:from_state (45)
			:if_char ("aA")
			:to_state (46)
		)
		:switch (
			:from_state (46)
			:if_char ("dD")
			:to_state (100)
		)

		:switch ( # ONmouseout
			:from_state (22)
			:if_char ("mM")
			:to_state (47)
		)
		:switch (
			:from_state (47)
			:if_char ("oO")
			:to_state (48)
		)
		:switch (
			:from_state (48)
			:if_char ("uU")
			:to_state (49)
		)
		:switch (
			:from_state (49)
			:if_char ("sS")
			:to_state (50)
		)
		:switch (
			:from_state (50)
			:if_char ("eE")
			:to_state (51)
		)
		:switch (
			:from_state (51)
			:if_char ("oO")
			:to_state (52)
		)
		:switch (
			:from_state (52)
			:if_char ("uU")
			:to_state (53)
		)
		:switch (
			:from_state (52)
			:if_char ("vV")	# onmouseoVer
			:to_state (60)
		)
		:switch (
			:from_state (53)
			:if_char ("tT")
			:to_state (100)
		)

		# ONmouseover
		:switch (
			:from_state (60)
			:if_char ("eE")
			:to_state (61)
		)
		:switch (
			:from_state (61)
			:if_char ("rR")
			:to_state (100)
		)

		:switch ( # ONreset
			:from_state (22)
			:if_char ("rR")
			:to_state (62)
		)
		:switch (
			:from_state (62)
			:if_char ("eE")
			:to_state (63)
		)
		:switch (
			:from_state (63)
			:if_char ("sS")
			:to_state (64)
		)
		:switch (
			:from_state (64)
			:if_char ("eE")
			:to_state (65)
		)
		:switch (
			:from_state (65)
			:if_char ("tT")
			:to_state (100)
		)

		:switch ( # ONselect
			:from_state (22)
			:if_char ("sS")
			:to_state (66)
		)
		:switch (
			:from_state (66)
			:if_char ("eE")
			:to_state (67)
		)
		:switch (
			:from_state (66)
			:if_char ("uU")	# onsUbmit
			:to_state (72)
		)
		:switch (
			:from_state (67)
			:if_char ("lL")
			:to_state (68)
		)
		:switch (
			:from_state (68)
			:if_char ("eE")
			:to_state (69)
		)
		:switch (
			:from_state (69)
			:if_char ("cC")
			:to_state (70)
		)
		:switch (
			:from_state (70)
			:if_char ("tT")
			:to_state (100)
		)

		# ONsubmit
		:switch (
			:from_state (72)
			:if_char ("bB")
			:to_state (73)
		)
		:switch (
			:from_state (73)
			:if_char ("mM")
			:to_state (74)
		)
		:switch (
			:from_state (74)
			:if_char ("iI")
			:to_state (75)
		)
		:switch (
			:from_state (75)
			:if_char ("tT")
			:to_state (100)
		)

		:switch ( # ONunload
			:from_state (22)
			:if_char ("uU")
			:to_state (76)
		)
		:switch (
			:from_state (76)
			:if_char ("nN")
			:to_state (77)
		)
		:switch (
			:from_state (77)
			:if_char ("lL")
			:to_state (78)
		)
		:switch (
			:from_state (78)
			:if_char ("oO")
			:to_state (79)
		)
		:switch (
			:from_state (79)
			:if_char ("aA")
			:to_state (80)
		)
		:switch (
			:from_state (80)
			:if_char ("dD")
			:to_state (100)
		)
	)
	:keyword	(		# "object" ____________________________________________
		:id	(4)
		:switch (
			:from_state (1)
			:if_char ("Oo")
			:to_state (81)
		)
		:switch (
			:from_state (81)
			:if_char ("Bb")
			:to_state (82)
		)
		:switch (
			:from_state (82)
			:if_char ("Jj")
			:to_state (83)
		)
		:switch (
			:from_state (83)
			:if_char ("Ee")
			:to_state (84)
		)
		:switch (
			:from_state (84)
			:if_char ("Cc")
			:to_state (85)
		)
		:switch (
			:from_state (85)
			:if_char ("Tt")
			:to_state (100)
		)
	)
	:keyword	(		# "embed" _____________________________________________
		:id	(8)
		:switch (
			:from_state (1)
			:if_char ("Ee")
			:to_state (86)
		)
		:switch (
			:from_state (86)
			:if_char ("Mm")
			:to_state (87)
		)
		:switch (
			:from_state (87)
			:if_char ("Bb")
			:to_state (88)
		)
		:switch (
			:from_state (88)
			:if_char ("Ee")
			:to_state (89)
		)
		:switch (
			:from_state (89)
			:if_char ("Dd")
			:to_state (100)
		)
	)

)
