#ifndef __h_fwconn__
#define __h_fwconn__

/*
 * the partition of the cr_type 32 bit field :
 * 
 * 01234567    01234567    0123  4567    01234567
 * >      <    >      <    >  <  >  <    >      <
 *  flags     encryption   ctrl  match     type
 *               args      bits  values   values
 */


#define CONN_TCP			(1)
#define	CONN_UDP			(2)
#define CONN_ENC_A			(3)
#define CONN_ENC_B			(4)

#define CTRL_SRC_FIN          (1<<0)  /* bit mask ! */  
#define CTRL_DST_FIN          (1<<1)  /* bit mask ! */  
#define CTRL_TCP_ESTABLISHED  (1<<2)  /* bit mask ! */  

#define MATCH_BY_PROTOCOL	(0)
#define MATCH_BY_OFFSET		(1)
#define MATCH_BY_RPC		(2)
#define MATCH_BY_GETPORT	(3)
#define MATCH_BY_CALLIT		(4)
#define MATCH_BY_SEQACK_CHG	(5)

#define	MAKE_ENTRY(type,ctrl,match,arg)	((type) | ((ctrl) << 12) | ((match) << 8) | ((arg) << 16))
#define	ENTRY_TYPE(entry)			((entry) & 0xff)
#define ENTRY_CTRL(entry)			(((entry) >>  12) & 0xf)
#define ENTRY_MATCH(entry)			(((entry) >>  8) & 0xf)
#define ENTRY_ARG(entry)			(((entry) >> 16) & 0xff)
#define ENTRY_FLAGS(entry)			( (entry) >> 24)
#define CHANGE_TYPE(entry,type)		(((entry) & 0xffffff00) | (type))
#define CHANGE_CTRL(entry,ctrl)		(((entry) & 0xffff0fff) | ((ctrl)  << 12))
#define CHANGE_MATCH(entry,match)   (((entry) & 0xfffff0ff) | ((match) <<  8))
#define CHANGE_ARG(entry,arg) 		(((entry) & 0xff00ffff) | ((arg)   << 16))
#define CHANGE_FLAGS(entry,flags)   (((entry) & 0x00ffffff) | ((flags) << 24))
#define ADD_TYPE(entry,type)		((entry) | (type))
#define ADD_CTRL(entry,ctrl)        ((entry) | ((ctrl)  << 12))
#define ADD_MATCH(entry,match)      ((entry) | ((match) <<  8))
#define ADD_ARG(entry,arg) 		    ((entry) | ((arg)   << 16))
#define ADD_FLAGS(entry,flags)      ((entry) | ((flags) << 24))
#define REMOVE_TYPE(entry,type)		((entry) & ~(type))
#define REMOVE_CTRL(entry,ctrl)     ((entry) & ~((ctrl)  << 12))
#define REMOVE_MATCH(entry,match)   ((entry) & ~((match) <<  8))
#define REMOVE_ARG(entry,arg) 		((entry) & ~((arg)   << 16))
#define REMOVE_FLAGS(entry,flags)   ((entry) & ~((flags) << 24))

#define	C_SRC				(0)
#define	C_SPORT				(1)
#define	C_DST				(2)
#define	C_DPORT				(3)
#define	C_IPP				(4)
#define C_LAST				C_IPP

#define X_HIDE_PORT			(0x80000000)
#define X_DST_STATIC		(0x40000000)
#define X_TCP_FIN			(0x20000000)
#define X_TCP_EST			(0x10000000)
#define X_REVERSE_UDP		(0x08000000)
#define X_FLAG_MASK			(0xffff0000)

#define NOACCT              (0)
#define ACCT                (1)

/* XXX */
#define	X_TCPSEQ			(4)
#define	MAKE_ENTRY(type,ctrl,match,arg)	((type) | ((ctrl) << 12) | ((match) << 8) | ((arg) << 16))

#define	MAKE_PVAL(acode,pid)	( (acode) | ((pid) << 4))
#define	PVAL_ACT(pval)	((pval) & 0xf )
#define	PVAL_ID(pval)	((pval) >> 4)
#endif

