// IP source and destination
#define src [12,b]
#define dst [16,b]

// TCP or UDP source and destination ports
#define sport [20:2,b]
#define dport [22:2,b]

// IP protocol
#define ip_p [9:1]

// Some IP protocols
#define icmp (ip_p = 0x1)
#define udp (ip_p = 0x11)
#define tcp (ip_p = 0x6)

// Definition of a broadcast packet
#define broadcast (													\
		(!( (dst & ~netof(dst)) & ((dst & ~netof(dst)) + 1))) or	\
		(!(dst & ~netof(dst)))										\
)

// Table for recording outgoing sessions. Incoming packets are matched against
// this table.
connections = dynamic refresh expires 60;

// The following two rules deal with outgoing and incoming packets in which
// the IP source and destination are the same. The first rule accepst and
// records such outgoing packets. The second rule accepts such packet if 
// a matching packet was previously recorded.
<= all@all
	accept (
		src = dst, 
		record <0,src,ip_p,sport,dport> in connections
	);

=> all@all
	accept (
		src = dst,
		<0,src,ip_p,sport,dport> in connections
	);

// Outbound traffic: allow everything. Record UDP, TCP and broadcast packets
// in connections.
<= all@all
	accept (
		icmp
			or
		(broadcast, record <src,sport,0,0,ip_p> in connections)
			or
		(udp, record <src,sport,dst,0,ip_p> in connections)
			or
		(tcp, record <src,sport,dst,dport,ip_p> in connections)
			or
		1
	);


// Inbound traffic: allow ICMP and broadcasts. Otherwise, check if alreay in 
// connections. If not, reject.
=> all@all
	accept (
		(icmp or broadcast)
			or
		<dst,dport,0,0,ip_p> in connections
			or
		(udp, <dst,dport,src,0,ip_p> in connections)
			or
		(tcp, <dst, dport, src, sport, ip_p> in connections)
	);

