/* @(#)src/lib/vxvm/common/libvxvm/volintf.h	2.1 30 Sep 1997 13:03:49 -  */
#ident	"@(#)cvm:src/lib/vxvm/common/libvxvm/volintf.h	2.1"

/*
 * Copyright(C)1996 VERITAS Software Corporation.  ALL RIGHTS RESERVED.
 * UNPUBLISHED -- RIGHTS RESERVED UNDER THE COPYRIGHT
 * LAWS OF THE UNITED STATES.  USE OF A COPYRIGHT NOTICE
 * IS PRECAUTIONARY ONLY AND DOES NOT IMPLY PUBLICATION
 * OR DISCLOSURE.
 * 
 * THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND
 * TRADE SECRETS OF VERITAS SOFTWARE.  USE, DISCLOSURE,
 * OR REPRODUCTION IS PROHIBITED WITHOUT THE PRIOR
 * EXPRESS WRITTEN PERMISSION OF VERITAS SOFTWARE.
 * 
 *               RESTRICTED RIGHTS LEGEND
 * USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT IS
 * SUBJECT TO RESTRICTIONS AS SET FORTH IN SUBPARAGRAPH
 * (C) (1) (ii) OF THE RIGHTS IN TECHNICAL DATA AND
 * COMPUTER SOFTWARE CLAUSE AT DFARS 252.227-7013.
 *               VERITAS SOFTWARE
 * 1600 PLYMOUTH STREET, MOUNTAIN VIEW, CA 94043
 */

#ifndef _VXVM_VOLINTF_H
#define _VXVM_VOLINTF_H

/*
 * volintf.h - interface structures for utilities and vold
 */

#if defined(CVM)
#include <vxvm/volcvm_defs.h>
#endif	/* CVM */

/*
 * vol_r_pol	- volume read policies (round-robin, preferred-plex)
 * vol_kstate	- volume enabled state (disabled, detached, enabled)
 * plex_kstate	- plex enabled state (must exactly match volume)
 * vol_except	- volume exception policies
 * plex_layout	- layout within a plex (striped, concatenated, raid5)
 */

enum vol_r_pol {			/* type of volume read policy */
	MIN_VOL_R_POL,			/* sentinel value, must be first */
	V_ROUND,			/* round robin */
	V_PREFER,			/* use a preferred plex */
	V_R_POL_SELECT,			/* select based on plex layouts */
	V_RAID,				/* use single RAID plex */
	MAX_VOL_R_POL			/* sentinel value, must be last */
};
enum vol_kstate {			/* volume kernel state */
	MIN_VOL_KSTATE,			/* sentinel value, must be first */
	V_DISABLED,			/* volume is offline */
	V_DETACHED,			/* volume is detached */
	V_ENABLED,			/* volume is enabled */
	MAX_VOL_KSTATE			/* sentinel value, must be last */
};
enum vol_except {			/* what to do in case of an error */
	MIN_VOL_EXCEPT,			/* sentinel value, must be first */
	V_NO_OP,			/* no additional action required */
	V_FAIL_OP,			/* fail the operation */
	V_DET_PL,			/* just detach plex */
	V_FAIL_DET_PL,			/* fail operation and detach plex */
	V_DET_VOL,			/* just detach volume */
	V_FAIL_DET_VOL,			/* fail operation and detach volume */
	V_GEN_DET,			/* detach plex, or volume if 
					   no complete plexes would remain */
	V_GEN_DET_SPARSE,		/* detach plex, or all incomplete
					   plexes if no complete plexes would
					   remain*/
	V_GEN_FAIL,			/* detach plex and volume and fail */
	V_GEN_DET2,			/* detach plex, or volume if no two
					   complete plexes would remain */
	MAX_VOL_EXCEPT			/* sentinel value, must be last */
};
enum plex_layout {		/* type of plex subdisk order */
	MIN_PLEX_LAYOUT,	/* sentinel value, must be first */
	PL_STRIPE,		/* stripe subdisks */
	PL_CONCAT,		/* concatenate subdisks */
	PL_RAID,		/* RAID layout */
	MAX_PLEX_LAYOUT		/* sentinel value, must be last */
};

/* plex_kstate type is provided for source-level backward compatibility
 * it must exactly match vol_kstate */
enum plex_kstate {	/* plex kernel state */
	MIN_PLEX_KSTATE,	/* sentinel value, must be first */
	PL_DISABLED,		/* plex is offline */
	PL_DETACHED,		/* plex is detached */
	PL_ENABLED,		/* plex is enabled */
	MAX_PLEX_KSTATE		/* sentinel value, must be last */
};

/*
 * configuration id numbers
 */
struct vol_id {
	long	config_id;		/* kept for source compatibility */
	time_t	config_epoch;		/* kept for source compatibility */
	volseqno_t config_tid;		/* last committed transaction ID */
};

/*
 * volume manager database summary
 */

struct vol_summary {
	size_t	vs_v_cnt;		/* number of volumes */
	size_t	vs_pl_cnt;		/* number of plexes */
	size_t	vs_sd_cnt;		/* number of subdisks */
	size_t	vs_pl_n_cnt;		/* number of non-associated plexes */
	size_t	vs_sd_n_cnt;		/* number of non-associated subdisks */
	size_t	vs_dm_cnt;		/* number of disk media records */
	size_t	vs_da_cnt;		/* number of disk access records */
	size_t	vs_reserved_1;		/* reserved for future use */
	size_t	vs_reserved_2;		/* reserved for future use */
};

/*
 * Fields marked with RO are strictly read-only fields.  Attempts to set
 * these fields will be ignored.
 *
 * Fields marked with CO are interpreted when the record is created.
 * Attempts to change these fields after record creation will be
 * ignored.
 */

/* volume structure */
struct v_tmp {			/* volume items that go away on reboot */
	char	v_tutil[UTIL_NUM][UTIL_SZ];	/* 'in kernel' utility field */
	ulong_t	v_tflag;			/* temp flags for volume */
/*RO*/	long	v_rec_lock;			/* 1 => record locked */
/*RO*/	long	v_data_lock;			/* 1 => volume data locked */
/*RO*/	long	v_lasterr;			/* VxVM 1.2 lasterr field */
	enum vol_kstate v_kstate;		/* relation to file space */
	enum vol_except v_r_all;		/* if all plex reads fail */
	enum vol_except v_r_some;		/* if some plex reads fail */
	enum vol_except v_w_all;		/* if all plex writes fail */
	enum vol_except v_w_some;		/* if some plex writes fail */
/*RO*/	enum vol_r_pol v_current_read_pol;	/* current read policy */
/*RO*/	dev_t	v_node_bdev;			/* block dev for vol device */
/*RO*/	dev_t	v_node_cdev;			/* char dev for vol device */
/*RO*/	size_t	v_iosize;			/* minimum size for raw I/Os */
	voff_t	v_recover_offset;		/* volume recovery offset */
	long	v_log_serial_lo;		/* log serial number/low part */
	long	v_log_serial_hi;		/* log serial number/hi part */
/*RO*/	volseqno_t v_lasterr_tid;		/* config tid at last error */
	ulong_t	v_recover_seqno;		/* # of ops needing recovery */
	ulong_t	v_recover_active;		/* seqno of active recovery */
};
struct v_perm {			/* volume items that exist after reboot */
/*RO*/	char	v_name[NAME_SZ];		/* volume name */
	char	v_putil[UTIL_NUM][UTIL_SZ];	/* 'on disk' utility field */
	char	v_comment[COMMENT_SZ];		/* comment field */
	char	v_state[STATE_SZ];		/* utility state of volume */
/*RO*/	char	v_use_type[NAME_SZ];		/* volume usage type name */
	char	v_fstype[FSTYPE_SZ];		/* guess of volumes fstype */
	char	v_pref_name[NAME_SZ];		/* plex name if V_PREPER */
	char	v_start_opts[V_STOPTS_SZ];	/* volume start options */
/*RO*/	volrid_t v_rid;				/* unique identifier */
	volrid_t v_pref_plex_rid;		/* preferred plex record ID */
/*RO*/	volseqno_t v_update_tid;		/* trans id of last update */
/*RO*/	volseqno_t v_detach_tid;		/* trans id of kernel detach */
	enum vol_r_pol v_read_pol;		/* method of plex selection */
	ulong_t	v_pflag;			/* perm flags for volume */
/*CO*/	minor_t	v_minor;			/* minor number in disk group */
	uid_t	v_uid;				/* owner of /dev/vol/name */
	gid_t	v_gid;				/* group of /dev/vol/name */
	mode_t	v_mode;				/* mode of /dev/vol/name */
/*RO*/	long	v_pl_num;			/* associated plex count */
	voff_t	v_len;				/* byte length of volume */
	voff_t	v_log_len;			/* length of log area */
	volrid_t v_log_rid;			/* rid of log object */
	voff_t	v_recover_checkpoint;		/* ckpoint for recover_offset */
/*RO*/	long	v_sd_num;			/* # subvolumes on volume */
	long	v_recov_seqno;			/* ORM recovery seqno */
};

struct volrec {
	struct v_tmp	v_tmp;		/* items that go away on reboot */
	char	v_tspare[8];		/* room for expansion */
	struct v_perm	v_perm;		/* items that remain after reboot */
	char	v_pspare[16];		/* room for expansion */
};

/* VxVM 1.2 source backward compatibility */
#define v_bdev	v_node_bdev
#define v_cdev	v_node_cdev

/* non-persistent volume flags, stored in v_tmp.v_tflag: */
#define V_TFLAG_MASK	    0x000007	/* mask for volume tflag */
#define V_TFLAG_READ	    0x000001	/* volume is shared readable */
#define V_TFLAG_WRITE	    0x000002	/* volume is shared writable */
#define V_TFLAG_RECOVER     0x000004	/* recover volume on reads */
#define V_TFLAG_RMASK	    0x01ff00	/* read-only volume tflag bits */
#define V_TFLAG_KRECOVER    0x000100	/* kernel still in recovery mode */
#define V_TFLAG_INVALID	    0x000200	/* volume is unusable */
#define V_TFLAG_LOGGING     0x000400	/* volume requires logging */
#define V_TFLAG_DIRTY	    0x000800	/* volume has been written */
#define V_TFLAG_BUSY	    0x001000	/* volume is part of open vol device */
#define V_TFLAG_DEGRADED    0x002000	/* RAID 5 degraded mode */
#define V_TFLAG_UNUSABLE    0x004000	/* RAID 5 is unusable */
#define V_TFLAG_HAS_LOGS    0x008000	/* volume has log subdisks or log
					 * plexes */
#define V_TFLAG_APP_DIRTY   0x010000	/* volume dirtied in APP_RECOV mode */
#define V_TFLAG_DEVOPEN	    VK_OPEN	/* device node is open on object */

#if defined(CVM)
/* these definition are temporary for phase 1 */
#undef  V_TFLAG_MASK
#define V_TFLAG_MASK	    0x0000ff	/* mask for volume tflag */
#define V_TFLAG_CLUSTER	    0x000008	/* volume to be recovered */
#define V_TFLAG_SHARED	    0x000010	/* volume is shared */
/* these definitions support distributed transactions */
#define V_TFLAG_DELETED	    0x000020	/* volume is to be deleted */
#define V_TFLAG_RENAMED     0x000040	/* volume is to be renamed */
#define V_TFLAG_HASASSERTS  0x000080	/* volume to be loaded in kernel */
#endif	/* CVM */

/* the VK_OPEN flag is kept for backward compatibility with VxVM 1.2: */
#define VK_OPEN		  0x01000000	/* volume, plex, or subdisk is open */
#define VOL_TFLAG_KMASK	  0xff000000	/* mask of bits reserved for kernel */

/* non-persistent volume flags, stored in v_tmp.v_tflag: */
#define V_PFLAG_MASK	    0x001fff	/* mask for volume pflag */
#define V_PFLAG_RMASK	    0x000000	/* read-only volume pflag bits */
#define V_PFLAG_WRITEBACK   0x000001	/* writeback error enabled */
#define V_PFLAG_WRITECOPY   0x000002	/* log block numbers being changed */
#define V_PFLAG_ACTIVE	    0x000004	/* kernel logged activity on volume */
#define V_PFLAG_FORCEMINOR  0x000008	/* force use of specified minor
					 * used for root and swap vols */
#define V_PFLAG_LOGTYPE	    0x0000f0	/* mask for log type */
#define V_PFLAG_LOGUNDEF    0x000000	/* no logging on volume, can default */
#define V_PFLAG_LOGNONE	    0x000010	/* no logging on volume */
#define V_PFLAG_LOGDRL      0x000020	/* dirty region logging on volume */
#define V_PFLAG_LOGSEQ	    0x000040	/* drl should have sequential policy */
#define V_PFLAG_BADLOG	    0x000100	/* volume activity log failed */
#define V_PFLAG_SPECIFY_WRITECOPY 0x200	/* set if writecopy was specified
					 * explicitly, off to use default */
#define V_PFLAG_KDETACH	    0x000400	/* kernel detached volume */
#define V_PFLAG_STORAGE	    0x000800	/* can create subvolumes on volume */
#define V_PFLAG_APP_RECOVER 0x001000	/* requres application recovery */
 
/*
 * The V_PFLAG_LOGSEQ should never be set by itself.  It should always
 * be set along with the V_PFLAG_LOGDRL flag.
 */
#define V_PFLAG_DRLSEQ	    (V_PFLAG_LOGDRL | V_PFLAG_LOGSEQ)

/*
 * minimum log length for RAID-5, measured in full stripes
 * NOTE: This must match VOLKRA_LOG_MIN in vxvm/voldobject.h.
 */
#define V_RAID_LOG_MIN	    3		/* must have at least 3 stripes */


/* volume structure change mask flags: */
#define EDIT_V_MASK		  0x0fffffff
#define EDIT_V_TUTIL		  0x00000001	/* v_tutil */
#define EDIT_V_KSTATE		  0x00000002	/* v_kstate */
#define EDIT_V_R_ALL		  0x00000004	/* v_r_all */
#define EDIT_V_R_SOME		  0x00000008	/* v_r_some */
#define EDIT_V_W_ALL		  0x00000010	/* v_w_all */
#define EDIT_V_W_SOME		  0x00000020	/* v_w_some */
#define EDIT_V_TFLAG		  0x00000040	/* v_tflag */
#define EDIT_V_FSTYPE		  0x00000080	/* v_fstype */
#define EDIT_V_COMMENT		  0x00000100	/* v_comment */
#define EDIT_V_PUTIL		  0x00000200	/* v_putil */
#define EDIT_V_STATE		  0x00000400	/* v_state */
#define EDIT_V_PFLAG		  0x00000800	/* v_pflag */
#define EDIT_V_PREFPLEX		  0x00001000	/* v_pref_name */
#define EDIT_V_READ_POL		  0x00002000	/* v_read_pol */
#define EDIT_V_UID		  0x00004000	/* v_uid */
#define EDIT_V_GID		  0x00008000	/* v_gid */
#define EDIT_V_MODE		  0x00010000	/* v_mode */
#define EDIT_V_LEN		  0x00020000	/* v_len */
#define EDIT_V_USE_TYPE		  0x00040000	/* v_use_type */
#define EDIT_V_LOG_LEN		  0x00080000	/* v_log_len */
#define EDIT_V_LOG_SERIAL	  0x00100000	/* v_log_serial */
#define EDIT_V_START_OPTS	  0x00200000	/* v_start_opts */
#define EDIT_V_PREFPLEX_RID	  0x00400000	/* v_pref_plex_rid */
#define EDIT_V_RECOVER_OFFSET	  0x00800000	/* v_rwback_offset */
#define EDIT_V_MINOR		  0x01000000	/* v_minor */
#define EDIT_V_RECOVER_CHECKPOINT 0x02000000	/* v_recover_checkpoint */
#define EDIT_V_RECOVER_SEQNO      0x04000000	/* v_recover_seqno */
#define EDIT_V_RECOVER_ACTIVE     0x08000000	/* v_recover_active */

/* 
 * plex - one or more subdisks, replication of volume data
 */

/* plex structure */
struct pl_tmp {			/* plex items that go away on reboot */
	char	pl_tutil[UTIL_NUM][UTIL_SZ];	/* 'in mem' utility field */
	ulong_t	pl_tflag;			/* flag, see PL_TFLAG_XXX */
/*RO*/	long	pl_lock;			/* 1 => record locked */
/*RO*/	long	pl_lasterr;			/* VxVM 1.2 lasterr field */
	enum vol_kstate pl_kstate;		/* relation to volume */
/*RO*/	long	pl_compact;			/* 1 => plex has no holes */
/*RO*/	minor_t	pl_minor;			/* minor number of plex dev */
/*RO*/	voff_t	pl_len;				/* byte length of plex */
/*RO*/	voff_t	pl_contig_len;			/* contiguous len from start */
/*RO*/	dev_t	pl_dev;				/* plex device number */
/*RO*/	volseqno_t pl_lasterr_tid;		/* config tid at last error */
};
struct pl_perm {		/* plex items that exist after reboot */
/*RO*/	char	pl_name[NAME_SZ];		/* plex name */
	char	pl_putil[UTIL_NUM][UTIL_SZ];	/* 'on disk' utility field */
	char	pl_comment[COMMENT_SZ];		/* comment field */
/*RO*/	char	pl_v_name[NAME_SZ];		/* volume name or \0 */
	char	pl_state[STATE_SZ];		/* utility state of plex */
/*RO*/	volrid_t pl_rid;			/* unique identifier */
/*RO*/	volrid_t pl_vol_rid;			/* record ID for volume */
/*RO*/	volrid_t pl_log_sd_rid;			/* record ID of log subdisk */
/*RO*/	volseqno_t pl_update_tid;		/* trans id of last update */
/*RO*/	volseqno_t pl_detach_tid;		/* trans id of kernel detach */
/*CO*/	enum plex_layout pl_layout;		/* layout of subdisks */
/*CO*/	voff_t	pl_st_width;			/* stripe element width if
						 * PL_STRIPE or PL_RAID */
	ulong_t	pl_pflag;			/* flag, see PL_FLAG_XXX */
/*RO*/	long	pl_sd_num;			/* number of associated sds */
	char	pl_log_sd[NAME_SZ];		/* name of log subdisk */
/*CO*/	long	pl_ncolumn;			/* number of stripe columns */
};

struct plexrec {
	struct pl_tmp pl_tmp;		/* items that go away on reboot */
	char	pl_tspare[16];		/* room for expansion */
	struct pl_perm pl_perm;		/* items that remain after reboot */
	char	pl_pspare[16];		/* room for expansion */
};

/* non-persistent plex flags, stored in pl_tmp.pl_tflag: */
#define PL_TFLAG_MASK	    0x000b	/* mask for plex tflag */
#define PL_TFLAG_RMASK	    0x7f04	/* mask for plex read-only tflag bits */
#define PL_TFLAG_READ	    0x0001	/* 1=>read ops are allowed */
#define PL_TFLAG_WRITE	    0x0002	/* 1=>write ops are allowed */
#define PL_TFLAG_LOG	    0x0004	/* plex has enabled log subdisk */
#define PL_TFLAG_COMPLETE   0x0008	/* plex is complete w.r.t. volume */
#define PL_TFLAG_VOLATILE   0x0100	/* an associated disk is volatile */
#define PL_TFLAG_REMOVED    0x0200	/* a disk device for plex is removed */
#define PL_TFLAG_NODAREC    0x0400	/* expected physical disk not found */
#define PL_TFLAG_DIRTY	    0x0800	/* plex has been written */
#define PL_TFLAG_BUSY	    0x1000	/* plex is part of open vol device */
#define PL_TFLAG_DEVOPEN    VK_OPEN	/* device node is open on object */
#define PL_TFLAG_RAIDLOG    0x2000	/* plex is a RAID log mirror */
#define PL_TFLAG_SDDETACH   0x4000	/* plex has a bad subdisk */
#if defined(CVM)
/* these definitions support distributed transactions */
#undef  PL_TFLAG_RMASK
#define PL_TFLAG_RMASK      0x7ff4	/* mask for plex read-only tflag bits */
#define PL_TFLAG_DELETED    0x0020	/* plex is to be deleted */
#define PL_TFLAG_RENAMED    0x0040	/* plex is to be renamed */
#define PL_TFLAG_DISSOC     0x0080	/* plex is to dissociated  */
#define PL_TFLAG_HASASSERTS 0x0010	/* plex to be loaded in kernel */
#endif	/* CVM */

/* persistent plex flags, stored in pl_perm.pl_pflag: */
#define PL_PFLAG_MASK	    0x0007	/* mask for plex pflag */
#define PL_PFLAG_RMASK	    0x0000	/* mask for plex read-only pflag bits */
#define PL_PFLAG_NOERROR    0x0001	/* 0=>participate in errors,
					 * 1=>don't participate */
#define PL_PFLAG_STALE	    0x0002	/* plex needs recovery */
#define PL_PFLAG_KDETACH    0x0004	/* kernel logged a detach */

/* plex structure change mask flags: */
#define EDIT_PL_MASK		0x000003ff
#define EDIT_PL_TUTIL		0x00000001	/* pl_tutil */
#define EDIT_PL_TFLAG		0x00000002	/* pl_tflag */
#define EDIT_PL_KSTATE		0x00000004	/* pl_kstate */
#define EDIT_PL_COMMENT		0x00000008	/* pl_comment */
#define EDIT_PL_PUTIL		0x00000010	/* pl_putil */
#define EDIT_PL_PFLAG		0x00000020	/* pl_pflag */
#define EDIT_PL_LAYOUT		0x00000040	/* pl_layout */
#define EDIT_PL_ST_WIDTH	0x00000080	/* pl_st_width */
#define EDIT_PL_STATE		0x00000100	/* pl_state */
#define EDIT_PL_NCOLUMN		0x00000200	/* pl_ncolumn */

/* 
 * subdisk - physical component of a plex
 */

/* subdisk structure */
struct sd_tmp {			/* subdisk items that go away on reboot */
	char	sd_tutil[UTIL_NUM][UTIL_SZ];	/* 'in mem' utility field */
/*CO*/	char	sd_da_name[NAME_SZ];		/* disk access name */
/*CO*/	char	sd_dm_name[NAME_SZ];		/* disk media name */
/*RO*/	char	sd_device_tag[NAME_SZ];		/* device tag */
	ulong_t	sd_tflag;			/* temp flags for subdisk */
/*RO*/	long	sd_lock;			/* 1 => record locked */
/*RO*/	dev_t	sd_dev;				/* block device of disk */
/*RO*/	volseqno_t sd_lasterr_tid;		/* config tid of last error */
/*RO*/	dev_t	sd_node_bdev;			/* block dev of vol device */
/*RO*/	dev_t	sd_node_cdev;			/* char dev of vol device */
};
struct sd_perm {		/* subdisk items that exist after reboot */
/*RO*/	char	sd_name[NAME_SZ];		/* subdisk record name */
/*CO*/	char	sd_path[SD_PATH_SZ];		/* subdisk block device path */
/*RO*/	char	sd_pl_name[NAME_SZ];		/* associated plex name or \0 */
	char	sd_comment[COMMENT_SZ];		/* comment field */
	char	sd_putil[UTIL_NUM][UTIL_SZ];	/* 'on disk' utility field */
/*RO*/	volrid_t sd_rid;			/* unique identifier */
/*RO*/	volrid_t sd_plex_rid;			/* record ID of plex */
/*CO*/	volrid_t sd_dm_rid;			/* disk media or volume rid */
/*RO*/	volseqno_t sd_update_tid;		/* trans id of last update */
	ulong_t	sd_pflag;			/* flag, see SD_FLAG_XXX */
/*RO*/	voff_t	sd_dev_offset;			/* offset within bdev */
/*RO*/	voff_t	sd_pl_offset;			/* offset of subdisk in plex */
/*RO*/	voff_t	sd_dm_offset;			/* offset relative to disk */
	voff_t	sd_len;				/* byte length of subdisk */
	minor_t	sd_minor;			/* minor number of vol device */
/*RO*/	volseqno_t sd_detach_tid;		/* trans id of kernel detach */
/*RO*/	long    sd_column;			/* stripe column of subdisk */
};

struct sdrec {
	struct sd_tmp sd_tmp;		/* items that go away on reboot */
	char	sd_tspare[16];		/* room for expansion */
	struct sd_perm sd_perm;		/* items that remain after reboot */
	char	sd_pspare[16];		/* room for expansion */
};

/* non-persistent subdisk flags, stored in sd_tmp.sd_tflag: */
#define SD_TFLAG_MASK	    0x0003	/* mask for subdisk tflag */
#define SD_TFLAG_DETACH	    0x0001	/* detach subdisk from plex or RAID */
#define SD_TFLAG_WRITEONLY  0x0002	/* subdisk is attached write-only */
#define SD_TFLAG_RMASK	    0x3f00	/* mask for sd read-only tflag bits */
#define SD_TFLAG_IS_LOG	    0x0100	/* subdisk is used as a log area */
#define SD_TFLAG_DIRTY	    0x0200	/* subdisk has been written */
#define SD_TFLAG_DEVOPEN    0x0400	/* device node is open on object */
#define SD_TFLAG_BUSY	    VK_OPEN	/* subdisk is part of open vol device */
#define SD_TFLAG_ENABLED    0x0800	/* subdisk is enabled (has a disk) */
#define SD_TFLAG_NODAREC    0x1000	/* no physical disk backs the subdisk */
#define SD_TFLAG_REMOVED    0x2000	/* physical disk was removed */
/* these definitions support distributed transactions */
#if defined(CVM)
#undef  SD_TFLAG_RMASK	  
#define SD_TFLAG_RMASK	    0x3f04	/* mask for sd read-only tflag bits */
#define SD_TFLAG_SHARED     0x0010	/* subdisk is shared */
#define SD_TFLAG_DELETED    0x0020	/* subdisk is to be deleted */
#define SD_TFLAG_RENAMED    0x0040	/* subdisk is to be renamed */
#define SD_TFLAG_DISSOC	    0x0080	/* subdisk is to dissociated  */
#define SD_TFLAG_HASASSERTS 0x0004	/* subdisk to be loaded in kernel */
#endif	/* CVM */


/* persistent subdisk flags, stored in sd_perm.sd_pflag: */
#define SD_PFLAG_MASK	    0x001f	/* mask for subdisk pflag */
#define SD_PFLAG_MKDEVICE   0x0001	/* create device node for subdisk */
#define SD_PFLAG_FORCEMINOR 0x0002	/* force minor field of subdisk */
#define SD_PFLAG_SUBVOLUME  0x0004	/* subdisk resides on a volume */
#define SD_PFLAG_STALE	    0x0008	/* subdisk contents require recovery */
#define SD_PFLAG_KDETACH    0x0010	/* kernel detached subdisk */
#ifdef SOLARIS
#define SD_PFLAG_RMASK	    0x0300	/* mask for read-only sd pflag bits */
#else	/* not SOLARIS */
#define SD_PFLAG_RMASK	    0x0100	/* mask for read-only sd pflag bits */
#endif	/* SOLARIS */
#define SD_PFLAG_VOLATILE   0x0100	/* sd contents do not survive reboot */
#ifdef SOLARIS
#define SD_PFLAG_BLOCKZERO  0x0200	/* block-zero overlap subdisk */
#endif	/* SOLARIS */

/*
 * NOTE: The VOLATILE pflag flag is kept in the pflag field purely for
 *	 historical reasons.  This flag is no longer persistent, but is
 *	 a property of the physical disk represented by the disk access
 *	 record (which is dynamically bound to the subdisk).
 */

/* subdisk structure change mask flags: */
#define EDIT_SD_MASK	  0x0000007f
#define EDIT_SD_TUTIL	  0x00000001	/* sd_tmp.sd_tutil */
#define EDIT_SD_TFLAG	  0x00000002	/* sd_tmp.sd_tflag */
#define EDIT_SD_COMMENT	  0x00000004	/* sd_perm.sd_comment */
#define EDIT_SD_PUTIL	  0x00000008	/* sd_perm.sd_putil */
#define EDIT_SD_LEN	  0x00000010	/* sd_perm.sd_len */
#define EDIT_SD_PFLAG	  0x00000020	/* sd_perm.sd_pflag */
#define EDIT_SD_MINOR	  0x00000040	/* sd_perm.sd_minor */

/*
 * dmrec - disk media interface structure
 */

struct dmrec {

	/* temporary part */

	char	dm_tutil[UTIL_NUM][UTIL_SZ];	/* non-persistent util fields */
/*RO*/	char	dm_da_name[NAME_SZ];		/* disk access name */
/*RO*/	char	dm_device_tag[NAME_SZ];		/* component of this device */
/*RO*/	char	dm_da_type[DA_TYPE_SZ];		/* type from diskdev record */
/*RO*/	char	dm_pub_bpath[DK_PATH_SZ];	/* path of public block dev */
/*RO*/	char	dm_priv_bpath[DK_PATH_SZ];	/* path of private block dev */
/*RO*/	char	dm_pub_cpath[DK_PATH_SZ];	/* path of public raw dev */
/*RO*/	char	dm_priv_cpath[DK_PATH_SZ];	/* path of private raw dev */
	ulong_t	dm_tflag;			/* temp flags for disk */
/*RO*/	long	dm_lock;			/* 1 => record locked */
/*RO*/	dev_t	dm_pub_bdev;			/* dev of public partition */
/*RO*/	dev_t	dm_priv_bdev;			/* dev of private partition */
/*RO*/	voff_t	dm_pub_offset;			/* offset of public region */
/*RO*/	voff_t	dm_priv_offset;			/* offset of private region */
/*RO*/	voff_t	dm_pub_len;			/* length of public partition */
/*RO*/	voff_t	dm_priv_len;			/* len of private partition */
/*RO*/	size_t	dm_atomic_iosize;		/* minimum I/O size */
/*RO*/	long	dm_sd_num;			/* cnt of subdisks using disk */
	char	dm_tspare[32];			/* room for expansion */

	/* persistent part */

/*RO*/	char	dm_name[NAME_SZ];		/* disk name for disk group */
	char	dm_comment[COMMENT_SZ];		/* comment field */
	char	dm_putil[UTIL_NUM][UTIL_SZ];	/* persistent util fields */
/*RO*/	char	dm_diskid[VOL_UUID_SZ];		/* unique ID for disk */
/*RO*/	char	dm_last_da_name[NAME_SZ];	/* last associated DA record */
/*RO*/	volrid_t dm_rid;			/* record ID */
/*RO*/	volseqno_t dm_update_tid;		/* trans id of last update */
	ulong_t	dm_pflag;			/* persistent flags */
	char	dm_pspare[32];			/* room for expansion */
};

/* non-persistent disk media record flags, stored in dm_tflag: */
#define	DM_TFLAG_MASK		0x0000	/* mask for disk tflag */
#define	DM_TFLAG_RMASK		0x1f00	/* mask of read-only flags */
#define DM_TFLAG_PRIVATE	0x0100	/* disk has a private region */
#define DM_TFLAG_COMPONENT	0x0200	/* component of another device */
#define DM_TFLAG_VOLATILE	0x0400	/* disk contents don't survive reboot */
#define DM_TFLAG_NODAREC	0x0800	/* disk not found on reboot */
#define DM_TFLAG_AUTOCONFIG	0x1000	/* da record was auto-configured */
#define DM_TFLAG_BUSY		VK_OPEN	/* volume on disk is open */

#if defined(CVM)
/* these definitions support distributed transactions */
#define DM_TFLAG_DELETED    	0x0002	/* disk is to be deleted */
#define DM_TFLAG_RENAMED    	0x0004	/* disk is to be renamed */
#define DM_TFLAG_DISSOC		0x0008	/* disk is to dissociated  */
#define DM_TFLAG_RECONNECT	0x0010	/* disk to be reconnected to darec  */
#define DM_TFLAG_NEWDA		0x0020	/* disk to be connected to new darec  */
#define DM_TFLAG_SPARE		0x0040	/* spare to be dissociated */
#endif	/* CVM */

/* persistent disk media record flags, stored in dm_pflag: */
#define DM_PFLAG_MASK	  0x00000003	/* mask of modifiable pflag bits */
#define DM_PFLAG_RESERVE  0x00000001	/* disk is reserved for special uses */
#define DM_PFLAG_SPARE	  0x00000002	/* disk is a spare for disk group */
#define DM_PFLAG_RMASK	  0x00000100	/* mask of read-only pflag bits */
#define DM_PFLAG_REMOVED  0x00000100	/* disk is currently inaccessible */

/* disk media structure change mask flags: */
#define EDIT_DM_MASK	  0x0000001f
#define EDIT_DM_TUTIL	  0x00000001	/* dm_tutil */
#define EDIT_DM_TFLAG	  0x00000002	/* dm_tflag */
#define EDIT_DM_COMMENT	  0x00000004	/* dm_comment */
#define EDIT_DM_PUTIL	  0x00000008	/* dm_putil */
#define EDIT_DM_PFLAG	  0x00000010	/* dm_pflag */

/*
 * dgrec - disk group interface structure
 */

struct dgrec {

	/* temporary part */

	char	dg_tutil[UTIL_NUM][UTIL_SZ];	/* non-persistent util fields */
/*CO*/	char	dg_name[NAME_SZ];		/* import name (maybe alias) */
	ulong_t	dg_tflag;			/* non-persistent flags */
/*RO*/	long	dg_lock;			/* 1 => record locked */
/*RO*/	volrid_t dg_import_id;			/* non-persistent import ID */
	char	dg_tspare[32];			/* room for expansion */

	/* persistent part */

/*RO*/	char	dg_real_name[NAME_SZ];		/* name stored in disk group */
	char	dg_comment[COMMENT_SZ];		/* comment field */
	char	dg_putil[UTIL_NUM][UTIL_SZ];	/* persistent utility fields */
/*RO*/	char	dg_dgid[VOL_UUID_SZ];		/* unique ID for disk group */
/*RO*/	volrid_t dg_rid;			/* record ID in disk group */
/*RO*/	volseqno_t dg_update_tid;		/* trans id of last update */
	ulong_t	dg_pflag;			/* persistent flags */
	long	dg_nconfig;			/* #config copies to enable */
	long	dg_nlog;			/* #log copies to enable */
	minor_t dg_base_minor;			/* base minor# for devices */
	char	dg_pspare[20];			/* room for expansion */
};

/* non-persistent disk group flags, stored in dg_tflag: */
#define DG_TFLAG_MASK	  0x000000	/* mask for disk group tflag */
#define DG_TFLAG_RMASK	  0x000300	/* read-only disk group tflag bits */
#define DG_TFLAG_DISABLED 0x000100	/* disk group is disabled */
#define DG_TFLAG_NO_AUTOIMPORT 0x200	/* do not auto-reimport disk group */

#if defined(CVM)
#define DG_TFLAG_SHARED	  0x000400	/* disk group is shared */
#define DG_TFLAG_CREATING 0x000800	/* shared disk group being imported */
#endif	/* CVM */

/* persistent disk group flags, stored in dg_pflag: */
#define DG_PFLAG_MASK	  0x000000	/* mask for disk pflag */
#define DG_PFLAG_RMASK	  0x000000	/* read-only disk group tflag bits */

/* disk group structure change mask flags: */
#define EDIT_DG_MASK	  0x000000ff
#define EDIT_DG_TUTIL	  0x00000001	/* dg_tutil */
#define EDIT_DG_TFLAG	  0x00000002	/* dg_tflag */
#define EDIT_DG_COMMENT	  0x00000004	/* dg_comment */
#define EDIT_DG_PUTIL	  0x00000008	/* dg_putil */
#define EDIT_DG_PFLAG	  0x00000010	/* dg_pflag */
#define EDIT_DG_NCONFIG	  0x00000020	/* dg_nconfig */
#define EDIT_DG_NLOG	  0x00000040	/* dg_nlog */
#define EDIT_DG_BASE_MINOR 0x0000080	/* dg_base_minor */

/*
 * Default number of enabled config and log copies per disk group.
 *
 * A value of 0 for the default config and log copy counts indicates
 * that the "volume manager knows best" policy should be used by
 * default to determine which copies to enable.
 */
#define DFLT_DG_NCONFIG   0		/* default #config copies to enable */
#define DFLT_DG_NLOG	  0		/* default #log copies to enable */

/*
 * darec - disk access interface structure
 */

struct darec {

	/* temporary part */

/*RO*/	char	da_dm_name[NAME_SZ];		/* media name in disk group */
/*RO*/	char	da_dg_name[NAME_SZ];		/* disk group name, if any */
/*RO*/	char	da_device_tag[NAME_SZ];		/* part of this device */
/*RO*/	char	da_pub_bpath[DK_PATH_SZ];	/* path of public block dev */
/*RO*/	char	da_priv_bpath[DK_PATH_SZ];	/* path of private block dev */
/*RO*/	char	da_pub_cpath[DK_PATH_SZ];	/* path of public raw dev */
/*RO*/	char	da_priv_cpath[DK_PATH_SZ];	/* path of private raw dev */
/*RO*/	ulong_t	da_tflag;			/* temp flags for disk dev */
/*RO*/	long	da_lock;			/* 1 => record locked */
/*RO*/	volrid_t da_dg_import_id;		/* disk group import ID */
/*RO*/	volrid_t da_dm_rid;			/* media record rid */
/*RO*/	dev_t	da_pub_bdev;			/* dev of public partition */
/*RO*/	dev_t	da_priv_bdev;			/* dev of private partition */
/*RO*/	long	da_fail_code;			/* failed operation */
/*RO*/	long	da_fail_errno;			/* error number for failure */
/*RO*/	size_t	da_maxiosize;			/* max I/O size (blocks) */ 

#if defined(CVM) 
	ulong_t da_owners[BT_BITOUL(CVM_MAX_NODES)]; /* owners bitmask */
	char    da_tspare[28 - BT_BITOUL(CVM_MAX_NODES)]; /* expansion room */
#else	/* !CVM */
	char	da_tspare[28];			/* room for expansion */ 
#endif	/* CVM */

	/* persistent part */

/*RO*/	char	da_name[NAME_SZ];		/* device name */
	char	da_comment[COMMENT_SZ];		/* comment field */
/*CO*/	char	da_type[DA_TYPE_SZ];		/* disk device type */
/*CO*/	char	da_info[DA_INFO_SZ];		/* type-specific info */
/*RO*/	volrid_t da_rid;			/* record ID in root config */
/*RO*/	volseqno_t da_update_tid;		/* trans id of last update */
	ulong_t	da_pflag;			/* persistent flags */
	char	da_pspare[32];			/* room for expansion */
};

/* operations in da_fail_code */
#define DA_FAIL_ONLINE		1	/* implicit online operation failed */
#define DA_FAIL_JOIN		2	/* implicit join operation failed */

/* non-persistent disk access record flags, stored in da_tflag: */
#define DA_TFLAG_MASK		0x00000	/* mask for disk group tflag */

#if defined(CVM)
#define DA_TFLAG_RMASK          0xfff00
#else   /* not CLUSTER */
#define DA_TFLAG_RMASK          0x1ff00 /* mask of read-only flags */
#endif	/* CVM */

#define DA_TFLAG_PRIVATE	0x00100	/* disk has a private region */
#define DA_TFLAG_COMPONENT	0x00200	/* device is part of a disk */
#define DA_TFLAG_VOLATILE	0x00400	/* disk is volatile */
#define DA_TFLAG_BADTYPE	0x00800	/* disk type is unknown */
#define DA_TFLAG_READY		0x01000	/* disk is accessible */
#define DA_TFLAG_INVALID	0x02000	/* configuration error */
#define DA_TFLAG_AUTOCONFIG	0x04000	/* generated DA record, not stored */
#define DA_TFLAG_RESERVE	0x08000	/* reserved bit is set in DM record */
#define DA_TFLAG_SPARE		0x10000 /* hotspare bit is set in DM record */
#define DA_TFLAG_MPTH_DISABLE	0x20000 /* DA record subsumed by multipathing */

#if defined(CVM)
#define DA_TFLAG_SHARED         0x040000 /* disk is shared */
#define DA_TFLAG_CLUSTER_DEPORT 0x080000 /* disk being deported from cluster */
#define DA_TFLAG_CTLR_RSVD 	0x100000 /* controller reserved by other host */
#define DA_TFLAG_NEWDM 		0x200000 /* disk being hot-spared */ 
#define DA_TFLAG_REMOTE		0x400000 /* disk is a remote-disk */
#define DA_TFLAG_LOCALONLY	0x800000 /* may not belong to shared dg */
#endif	/* CVM */

/* persistent disk access record flags, stored in da_pflag: */
#define DA_PFLAG_MASK		0x00000	/* mask for disk pflag */
#define DA_PFLAG_RMASK		0x00100	/* mask of read-only flags */
#define DA_PFLAG_ONLINE		0x00100	/* disk should be made accessible */

/* disk access structure change mask flags: */
#define EDIT_DA_MASK		0x00000007
#define EDIT_DA_COMMENT		0x00000001	/* da_comment */
#define EDIT_DA_TFLAG		0x00000002	/* da_tflag */
#define EDIT_DA_PFLAG		0x00000004	/* da_pflag */

#endif	/* _VXVM_VOLINTF_H */
