#ifndef __RWCOMPILER_H__
#define __RWCOMPILER_H__ 1

/*
 * Compiler and system related foibles and directives
 *
 ****************************************************************************
 *
 * Rogue Wave Software, Inc.
 * P.O. Box 2328
 * Corvallis, OR 97339
 * Voice: (503) 754-3010	FAX: (503) 757-6650
 *
 * Copyright (C) 1989 - 1993.
 * This software is subject to copyright protection under the laws of
 * the United States and other countries.
 *
 */


#if __sun && ! __SVR4
#  define RWSunOS4x
#endif

#if defined(__SUNPRO_CC) && defined(__hppa)
#include "compilerhpux.h"
#undef RWSunOS4x
#endif

#ifdef RWSunOS4x

// compiler.h but no guard
#  include "compiler4x.h"

#else

// The value of RW_MULTI_THREAD must always match between the library
// and the application so object sizes will agree, so if this is
// not on, the programmer has to be careful to match compiler
// options and library versions.
//
// Note that compiling -mt turns on _REENTRANT, which turns this on.
// RW_1THREAD makes this controllable from the command line.
#  ifndef RW_1THREAD
#    define RW_MULTI_THREAD 1
#  endif
  
/* 
 * Most compilers have a built in "manifest constant".
 */

#define __ATT2__ 1


/******************** COMPILER WORD SIZES, ETC ********************/

#define RW_BYTES_PER_WORD 4

#define RW_BYTES_PER_PTR 4


/*************************** TEMPLATES ****************************/

/*
 * The compiler does template
 * instantiation at compile time.
 */

#define RW_COMPILE_INSTANTIATE 1


/*************************** STRINGS ****************************/

/*
 * Uncomment the following if your compiler does not have the
 * function stricmp() (case-independent comparisons).
 */

#define RW_NO_STRICMP 1


/*
 * Uncomment the following if your compiler does not have the
 * function strnicmp() (limited case-independent comparisons).
 */

#define RW_NO_STRNICMP 1



/****************** INTERNATIONALIZATION ************************/


#define RW_NOMSG    0x00
#define RW_CATGETS  0x01
#define RW_GETTEXT  0x02
#define RW_DGETTEXT 0x03

/*
 * Set RW_MESSAGE to the type of messaging facility you want:
 *   RW_NOMSG	 No messaging facility
 *   RW_CATGETS  Use catgets()
 *   RW_GETTEXT  Use gettext()
 *   RW_DGETTEXT Use dgettext()
 */

#define RW_MESSAGE RW_CATGETS

/************************** TIME ********************************/

/*
 * Uncomment the following if your system supplies a global variable
 * named "daylight" instead of the nominally more correct "_daylight".
 */

#define RW_NO_LEADING_UNDERSCORE 1

#  define __ATT__ 1

#  define STARTWRAP
#  define ENDWRAP

#  define RWSCOPE(a) a::
#  define RWVECTOR_DELETE(i) delete[]

#endif // RWSunOS4x

#endif /* __RWCOMPILER_H__ */
