/*
 *	Copyright 12 Sep 1996 Sun Microsystems, Inc.  All Rights Reserved.
 *
 *	@(#)rpcsvc.cc	1.7 12 Sep 1996 12:18:59
 */

#include <stdlib.h>
#include <unistd.h>
#include <iostream.h>
#include <rpc/rpc.h>
#include <rw/xdrstrea.h>
#include <rw/collstr.h>
#include "rpcexam.h"

static RWCollectableString dummy("Starting the object RPC server");

int& demo(RWCollectable*& xp, svc_req&) {
    static int value;
    if (xp->isA() == __RWCOLLECTABLESTRING) {
	cout << (RWCollectableString&)*xp << endl;
	delete xp; xp = 0;
	value = 1;
    } else {
	cout << xp->isA() << endl;
	value = 0;
    }
    return value;
}

main() {
    if (rpc_reg(DEMOPROG, DEMOVERS, DEMOPROC, (char *(*)(char *))demo,
		(xdrproc_t)xdr, (xdrproc_t)xdr_int, "visible") == -1) {
	cerr << "Couldn't register\n";
	exit(1);
    }

    cout << dummy << endl;

    svc_run();
    cerr << "Error: svc_run returned!\n";
    exit(1);
    return 0;
}
