/*
 *	Copyright 12 Sep 1996 Sun Microsystems, Inc.  All Rights Reserved.
 *
 *	@(#)rpcclnt.cc	1.6 12 Sep 1996 12:19:00
 */

#include <stdlib.h>
#include <unistd.h>
#include <iostream.h>
#include <rpc/rpc.h>
#include <rw/collstr.h>
#include <rw/xdrstrea.h>
#include "rpcexam.h"

main(int argc, char **argv) {
    clnt_stat status;
    static int value;
    static RWCollectable* arg;

    if (argc != 3) {
	fprintf(stderr, "Usage: rpcclnt hostname message\n");
	exit(1);
    }

    arg = new RWCollectableString(argv[2]);

    status = rpc_call(argv[1], DEMOPROG, DEMOVERS, DEMOPROC,
		      (xdrproc_t)xdr, (char*)&arg,
		      (xdrproc_t)xdr_int, (char*)&value,
		      "visible");
    if (status != RPC_SUCCESS) {
	clnt_perrno(status);
	return 1;
    }
    return 0;
}
