

10/22/96
                        C++ 4.2 README
                        Tools.h++ 7.0
=============================================================================

Introduction: 

These are notes on version 7.0.6 of Tools.h++ as of August, 1996, and
on earlier versions as indicated.

This README is to  help you deal with issues you may encounter installing
and using your release of Tools.h++.  Most issues are handled by the
Installation Guide or by the Tools.h++ Introduction and
Reference Manual.  These notes cover items that deserve special note,
that are specific to this release, or that have come up after the
production of those documents.


Contents:
          A. New Features
          B. Changes to Features 
          C. Software Incompatiblities
          D. Current Software Bugs
          E. Fixed Software Bugs
          F. Documentation Errata
          G. Frequently Asked Questions
	  Appendix A. New Features
	  Appendix B. Changes to Features
       
____________________________________________________________________________
A. New Features

Please refer to Appendix A.

____________________________________________________________________________
B. Changes to Features

Please refer to Appendix B.

____________________________________________________________________________
C. Software Incompatibilities

Except as noted, all documented features of the Rogue Wave version of
Tools.h++ 7.0.6 are supported in the Sun release, which is built from
the same source base.

Rogue Wave's 6.0.3 and up releases support backward compatibility with
the ASCII persistence format of pre-6.0 versions of Tools.h++ and use
the pre-6.0 format as the default. Sun's 6.0.4 release does not support 
this feature.

With C++ 4.2 (SPARCompilers 4.2) Sun ships both Tools.h++ 7.0.6 and 
Tools.h++ 6.0.4 (minus vstream-related changes). Because Tools.h++ 7.0.6
is not fully link compatible with the version of
Tools.h++ shipped with Sun's previous compilers, applications and
libraries that would use Tools.h++ 7.0.6 should recompile all
source modules before linking. Please see the "Changes to Features"  
sections for details of the changes from 6.0.2 to the present version.
 
With C++ 4.0.1 (SPARCompilers 3.0.1) and C++ 4.1 (SPARCompilers 4.0)
Sun ships Tools.h++ 6.0.4 minus vstream-related changes. Some of these
would break link compatibility with version 6.0 so they were not put
into this "minor" release.

With C++ 4.0 (SPARCompilers 3.0), Sun ships Tools.h++ 6.0 with just a
couple of key fixes from 6.0.2.
   
____________________________________________________________________________
D. Current Software Bugs

---------------------------
(Tools.h++ 6.0.4 and 7.0.6)
RWCString constructors are still significantly slower in the
thread-ready version of the library (SunOS 5.x) compared with the
single-threaded version (SunOS 4.x).  This should not affect
most users.

---------------------------

(Tools.h++ 6.0.4 and 7.0.6)
Japanese monetary printing: There is a minor problem in SunOS 5.3 and
before in the tables supplied by SunOS for conversion of Japanese
currency. Please install the following OS patch to fix this problem: 

SunOS 5.3: 101659-01, Localization -- Japanese currency formatting problem

____________________________________________________________________________
E. Fixed Software Bugs

Operators << and >> correctly obey ios::setw().

RWTime now checks RWDate::isValid() before using a date.

The RWDate constructor that accepts a month string is no longer
sensitive to case or leading blanks.  Japanese months numbered less
than 10 are stored with a leading blank.

New INDEXERR message to avoid ranges from 0 -> 400 billion

Changed certain unsigned return values to size_t

Erroneus assertion removed from bsearch


____________________________________________________________________________
F. Documentation Errata
 
  o RWLocale::stringToNum(const RWCString&, long*); (page 257) When we
    say that for "an English-speaking locale" RWLocaleSnapshots can
    parse numbers with commas marking the thousands, we are telling the
    truth, but in a confusing way. The default locale is very likely
    to be "C" for many English-speaking  programmers, and the "C"
    locale does not accept commas in numeric strings.
 
  o RWHashDictionary and RWHashTable have persistence level
    "Polymorphic", not "None" as currently documented.
 
  o The description for RWTPtrSlistIterator on page 767 should tell
    the user that if the slist is modified, the iterator is no longer
    valid. This is generally true for all iterators.
 
  o When we documented the classes rw_hashmap, rw_hashmultimap,
    rw_hashset, rw_hashmultiset, and rw_slist, we said they were to be
    found in the wrong subdirectory.  They are located in rw/stdex.
 
    Also note that these classes depend on the Standard C++ Library.
    If RW_NO_STL is defined, these classes cannot be used.
 
  o RWDiskPageHeap::allocate() is documented to return 0 if there is
    no space available, but it always returns at least 1.
 
  o Values stored in the templatized dictionary containers must be
    able to respond to operator==() and operator<(). This is necessary
    when the Standard C++ Library is being used as the implementation
    for these classes because the standard requires it, and when our
    own implementation is used because we wanted to be sure that
    containers with identical keys but distinct values were not
    considered the same. According to the Draft ANSII/ISO Standard,
    compilers should only require these operators if they are used.
    Unfortunately, we know of several compilers that do not meet this
    part of the draft standard.

  o There is no overloaded shift operator to extract an RWTime from a
    stream. This is deliberate, because the problem of parsing a time
    from a string is very difficult. For instance, if you know the
    stream instream holds "1 One", you could read it like this:
        instream >> anInteger >> anRWCString;
    But suppose instream holds "9:30 am Dentist Appointment", and you
    try: 
        instream >> anRWTime >> anRWCString;
    There is no way that RWTime can know whether or not the "am" is
    part of the time.  You can get around this if you know that there
    is no such problem of ambiguity. Read the time string into an
    RWCString, and create the RWTime from that:
        instream >> anRWCString;
        anRWTime = RWTime(appropriateRWDate, anRWCString);
   o The RWTime section of the Class Reference should say "See Section
     5 of the Users Guide..." rather than "See Section 8...".

  o RWSortedVectorIterator is not in the manual since it is merely a
    typedef for RWOrderedVectorIterator. 

  o The manual talks about the semantics of the types that may
    instantiate the templatized collections by saying something like
    "Class K must have 
     * well-defined equality semantics (K::operator==(const K&))."
    The example is too restrictive. We should be saying that the
    compiler must be able to unambiguously find an operator== that
    applies to two instances of K regardless of how the operator is
    implemented. 

  o Method RWFile::Error() checks whether the RWFile has an error
    state. This cannot happen if the RWFile failed to open.  Users
    should always check isValid() prior to calling Error() or any
    other function that expects the RWFile to exist:
    
       RWFile aFile("filename");
       //...
       if(aFile.isValid() && ! aFile.Error()) {
         //...
       }
    
  o Some classes which were developed purely for internal use by
    Tools.h++ appear in the documented hierarchy, but not in the class
    reference section. This omission is deliberate, and implies that
    the undocumented classes may be changed, augmented, or removed in
    a later release without warning to users. We encourage you not to
    use such classes.


RWLocaleSnapshot
----------------

The following paragraph applies to RWLocaleSnapshot, but is not in
the documentation:

Note - The constructor for class RWLocaleSnapshot calls the function
setlocale, which is not thread-safe.  For safety in multithreaded
applications, instances of RWLocaleSnapshot must be constructed only
when it can be guaranteed that no other thread may be using
locale-dependent functions.  To guarantee this condition, 
construct all instances of RWLocaleSnapshot in the initial thread 
before starting any other thread.

____________________________________________________________________________
G. Frequently Asked Questions

How do I contact Rogue Wave Software?
=====================================

Please don't contact Rogue Wave  for support of your Sun product.  If you
want information on other Rogue Wave products you can call:

541-754-3010 or
800-487-3217



How do I get support for Tools.h++?
===================================

Use Sun support as you would for any other SunSoft product.
Sun has access to Rogue Wave for updates, consulting, fixes, and so
on, but Sun fully supports Tools.h++.



Spro_install_tool can't find a license file for Tools.h++ source.
=================================================================

In some cases when installing Tools.h++ source code, spro_install_tool
pops up a message box saying there doesn't seem to be a Tools.h++
source license.  Try continuing the installation.  Spro_install_tool
can be wrong.  The actual installation code finds and uses the license
anyway.


Is the Sun version different from the Rogue Wave version?
=========================================================

The Sun and Rogue Wave versions of Tools.h++ are built from the same
source base.  Bug fixes are brought into the master sources.  We each
release on our own schedules, so released versions are likely to be a
little different.  In general, Rogue Wave releases more often, so they
are usually (though not always) a bit ahead.

Sun maintains link-compatibility across minor releases, so we may hold
back selected fixes if they must break link compatibility.  (When we
maintain link compatibility you can link your new Tools.h++ library
with object files compiled for the old Tools.h++ library.)



Can I get the latest Rogue Wave version from Sun?
=================================================

Usually no; only if that's what Sun ships anyway.  Sufficiently
important bug fixes are likely to be available from Sun.



Where are the Tools.h++ header files?
=====================================

Use CC -H <file>.cc to determine their location in your installation,
where <file>.cc includes at least one Tools.h++ header file.



Is there a shared library version of librwtool?
===============================================

There is a shared library version for Tools.h++ 7.0.6, but not for
Tools.h++ 6.0.4.


Can I build libraries that use Tools.h++ ?
==========================================

It's all right to build an archive library that depends on Tools.h++ if your
library is just used internally inside your project, for example to
simplify build procedures.  If you intend to ship your archive library
to anyone, your customer needs to have access to Tools.h++ as well.
Sun customers may redistribute librwtool.a, but not the header files
that go with it.

Sun does not ship a shared object for Tools.h++ 6.0.4, i.e. no librwtool.so,
and therefore does not support use of Tools.h++ 6.0.4 in shared libraries.  
Sun does ship a shared object, and supports the use of shared libraries, 
for Tools.h++ 7.0.6.


Printing RWCStrings
===================

In SPARCworks 3.0 the command interpreter for dbx is a Korn shell, so
you can define new dbx commands that do specialized debugging
functions.  Printing strings is an often-wanted facility.  The
Tools.h++ manual chapter on compiling and debugging describes ways to
print strings in dbx.  Another way to print an RWCString is to define
a new dbx command, such as:

function dumpstr
{
  print (char*)($1.pref_+1)
}

Then in dbx you can say:

(dbx) dumpstr myString
(char *) (myString.pref_+1) = 0x28d5c "Contents of myString"
(dbx)

You may put the definition of dumpstr into your .dbxrc if you wish.


Additional details
==================
  o The capacity of RWCString and RWWString may be changed by calling
    the clone member function: aString.clone(0) will adjust the
    capacity of aString be exactly large enough, whereas calling
    aString.clone(aString.length()+someMore) will leave someMore extra
    bytes in the buffer.
 
  o All iterators: If the collection is modified directly or through
    the use of any iterator except the one in question, then that
    iterator is no longer guaranteed to be valid. Some collections may
    be altered "most of the time" without such side effects, which
    could lead you into a trap if you come to expect that iterators
    may be trusted after the collection is modified. Beware.

  o Some templatized containers have a method clearAndDestroy(), which
    is not protected against the possibility that the container holds
    more than one pointer to the same object. Do not call
    clearAndDestroy() unless you are sure your container holds no
    duplicates. (This warning does not apply to RWCollections.)

  o Some Tools.h++ methods are overloaded to take either a pointer or
    an integer type. RWTime constructors, for example, may be passed
    either a struct tm* or an unsigned long representing seconds since
    the "beginning of time." If you attempt to pass a zero to such
    methods, the compiler will correctly complain about ambiguity.
    This may be resolved by holding the zero value in the appropriate
    type, casting it, or using a construction such as "0ul" for a
    manifest constant.
    
  o Problems with incorrect RWTime construction from struct tm*: The
    system function localtime() returns a pointer to a static struct
    tm. Subsequent calls to localtime overwrite that struct.  RWTime
    uses RWZone::local(), which is not created until needed. That
    creation also calls localtime().  If you experience difficulty
    related to calls to localtime(), make a call to RWZone::local()
    before you first call localtime().

  o RWLocale::asString(struct tm*, ..%U.., RWZone&= RWZone::local())
    returns different values for week of the year, for years that
    begin on Sunday, depending on platform. Although the standard is
    precise, it is apparently not clear, since many vendors disagree.
    We pass the vendor's result without examining it, so if you care
    about cross-platform results, we suggest you do not use the %U
    format specifier.

  o Problems using RWFactory, or polymorphic persistence: Before the
    factory can create an RWCollectable, that collectable and its
    identifier must be registered. The easy way to do this is by
    creating at least one instance of the particular RWCollectable in
    the program.
    This problem may manifest in several ways. Usually you will see
    this message:
    
    "[NOCREATE] RWFactory: no create function for class with ID (something)"
    
    However it is possible to get a core dump or GPF during a call to
    theFactory->create(someID) (This call is made while reading in
    persisted RWCollectables). This can happen with some compilers
    which do not create an instance of an object if you instantiate
    only a pointer to the object.

  o When creating your own RWCollectable, it is important to provide
    your class with all the methods that the RWCollectable methods
    use. In particular, you must provide a default constructor that
    may be used to create new "empty" instances for the persistence
    mechanism to "fill", and a copy constructor that may be used to
    clone copies of your object to a new location.  You should also be
    careful to have related methods and operators be consistent with
    each other: If you have comparison operators defined for your
    class, they should give results that match the values returned by
    the method compareTo().

  o When to use RWCollectable::recursiveStoreSize() and when to use
    RWCollectable::binaryStoreSize().  Although the answer is simple,
    it does sometimes require a bit of thought:
    recursiveStoreSize() should be used at the _top_ level of an
    RWCollectable, when you plan to use operator<<() or the 
    undocumented recursiveSaveOn() method.  On the other hand, 
    binaryStoreSize() should be used when you are interested in 
    working with a _part_ of the entire collection:  When you plan to 
    use saveGuts(). 

    Neither of these methods deals with streams: They are only of use
    for RWFile. If you need to find the size of an RWCollectable as
    saved to a virtual stream, use the class RWAuditStreamBuffer.

  o Use of mutexes prior to main suffers from the paired difficulty of
    knowing the order of static initialization (no general solution)
    and knowing which pre-main thread should initialize a given mutex.
    There are no known software solutions to this problem. Therefore
    we suggest that static initialization code should not call any
    thread-hot functions. 

  o Using templatized hash-based containersin your class. Many
    customers have asked us to explain how to add to their own
    classes a class member which requires a non-default constructor,
    such as the Tools.h++ hash based containers.  The answer is a bit
    of tricky C++ syntax. Suppose your class should have a
    hash dictionary member: 
      class MyClass {
        // ...
        RWTValHashDictionary<RWCString,int> myDict; // no ctor args here!
      public:
         MyClass();
      };

    The special syntax is known as "member initialization", and it
    looks like this: Where you provide the actual constructor body,
    you have to use a ":" followed by a comma-separated list of
    constructors for each member which requires non-default
    construction.  This example extends the example above.

       MyClass::MyClass() : myDict(theHashFunction) /* like this */
       { /* code for your constructor */ }
             
    Of course, you could instead use the member initialization syntax
    to write an inline constructor if that makes sense. What you
    cannot do is add the constructor arguments to the _declaration_ of
    the dictionary in the class declaration. 

------------------------------------------------------------------------------------
Appendix A. New Features
========================

What's New This Release
-----------------------------------------

------------------------------
7.0.5 --> 7.0.6
Date:     May, 1997
------------------------------
  o Changed interface not to mention "const" return value when the
    return is by value: quiets some compiler warnings.
    
  o Fixed a bug which caused a string's capacity to double without
    bound when it was used to readLine successive lines in a file
    which were exactly 1 less than a power of 2 characters in
    length. Also changed string's capacity to be adjusted to fit after
    it is read from a file.

  o Fixed a bug which caused RWMemoryPool to cache the usual amount of
    space allocated from the heap, but did not allow the cached
    locations to be used.

  o Fixed a bug with compiling character sets in the extended regular 
    expression class.

------------------------------
7.0.4 --> 7.0.5
Date:     
------------------------------
  o No changes to code. Internal release.

------------------------------
7.0.3 --> 7.0.4
Date:     
------------------------------
  o No changes to code. Internal release.

------------------------------
7.0.2 --> 7.0.3
Date:     October, 1996
------------------------------
  o Each rwCreateFN is now a friend of the associated collectable
    class. This means that Collectable classes need not have public
    constructors. 
    
  o RWLocale and RWDate code may now be compiled to provide a larger
    measure of enforcement for the use of 4-digit years, as follows:
    - if RW_YEAR_2000_COMPLIANT is defined, then RW_ANY_YEAR and
      RW_4DIGIT_YEAR_REQUIRE will both be defined. Or either may be
      defined individually.
    - if RW_ANY_YEAR is defined, years whose values are between 0 and
      99 will be accepted as constructors for an RWDate in the 1st
      century AD. The default is with the macro undefined, which adds
      1900 to such years, as before.
    - if RW_4DIGIT_YEAR_REQUIRE is defined, there are two effects:
      + When a date is parsed from a string, if the year field holds
        fewer than 4 characters, the result is an invalid date.
      + If the %x specifier for strftime would print a 2-character
         year field, it is changed to print the full 4 characters.
         This is done so that constructs such as 
           RWDate thisDate(thatDate.asString())
        will work as expected, even if the operating system defaults
        date output to 2-digit year format.
      The default is with the macro undefined, which continues to
      print and parse RWDates as before.

    The intent is twofold: By compiling so that RW_ANY_YEAR is
    defined, you may expect that code which depends on the difference
    between dates (such as interest calculations) will be obviously
    wrong if integer year numbers less than 100 have been used.
    Simultaneously, RW_4DIGIT_YEAR_REQUIRE enforces the use of 4-digit
    years in cases where the year is encoded as a string.

  o RWDate can now print any date after 0 A.D. Previously, it could
    not print any date prior to January 1, 1900. Note that dates prior
    to the adoption of the Gregorian calendar at any particular location
    will not exactly match weekday or even month names from that era
    in that location.  However such dates are still appropriate for
    doing date arithmetic or comparisons. 
    
  o We have introduced a link-incompatible fix for certain cross-
    platform RWestream persistence problems:  If you are using two
    platforms which have all these:
    - Size_t resolves to different types on the platforms (int vs
      long, for instance)
    - The number of bytes of those two types is different on the two
      platforms (4 vs 8 bytes, for instance)
    - you persisted any data using a size_t type (as RWCollections do,
      which use size_t for the count of data).
    Then you will be unable to use estreams to persist data between
    the platforms without the fix.  To use the fix, you must change
    your code to use the virtual methods vistream::getSizeT(&size_t)
    and vostream::putSizeT(size_t) rather than using the overloaded
    insertion and extraction operators.  The fix is available only if
    the macro RW_FIX_XSIZE_T is defined, so that link compatibility is 
    preserved when the macro is not defined.

  o A miscellany of small bugs fixed, small features added, and small
    misfeatures removed.

------------------------------
7.0.1 --> 7.0.2
Date:     June 1996
------------------------------

  o Template collections based on hashing no longer abort if they are
    constructed or resized to zero capacity.

  o Modified the persistence mechanism to increase speed for storing large 
    collections.

  o RWLocaleSnapshot now correctly returns false from 
    stringToNum (const RWCstring&, *long) when the string represents a
    number "just too large" to fit in the long.

  o A miscellany of performance enhancements, minor bug fixes, and
    changes to quiet compiler warnings.

------------------------------
7.0.0 --> 7.0.1
Date:     April 1996
------------------------------

  o Minor bug fixes

------------------------------
6.1.0 --> 7.0.0
Date:     March 1996
------------------------------

  o We no longer ship librwtool_dbg.a with C++ 4.2.


  o Changes to RWTValOrderedVector<T>:

    A change was made to the function-call operator, which in the
    case of RWTValOrderedVector<T> is used for indexing.  Where we
    used to have

     T operator()(size_t i) const
           { return copy of i'th element; }

     we now have

     const T& operator()(size_t i) const
           { return const reference to i'th element; }

    So now in the code for occurrencesOf:

    template <class T> size_t
    RWTValOrderedVector<T>::occurrencesOf(const T& val) const
    {
      size_t count = 0;
      for (register size_t i=0; i<nitems_; i++)
        if ((*this)(i) == val) ++count;
      return count;
    }

    it is neccessary for T::operator==() to be a const member function (or
    a global function) where it was not necessary before.  The advantage,
    of course, is that the occurrencesOf function no longer copies every
    element of the collection before passing it to T::operator==() to see
    if it is equal to val.

    Because of this change, if you compile your existing sources with
    tools.h++ 7.0, you might get errors of the form:

    "Error: Non-const function ReturnInfo::operator==(const ReturnInfo&)
    called for const object"

    The best work-around, if possible, would be for you to make
    ReturnInfo::operator==(const ReturnInfo&) a const member function,
    assuming that it really does not modify the receiver, which is
    certainly almost always the case for the equality operator.


  o Class RWCRExpr: A new extended regular expression class.
    This class represents an extended regular expression such as those
    found in lex and awk. The constructor "compiles" the expression to
    an internal format. The results can then be used for string
    searches using class RWCString. Regular expressions can be of
    arbitrary size, limited by memory. The extended regular expression
    features found here are a subset of those found in the POSIX.2
    standard (ANSI/IEEE Std 1003.2, ISO/IEC 9945-2), including
    grouping and alternation. Note that your compiler must support
    exception handling, templates, and Rogue Wave's C++ Standard
    Library V. 1.2 to use this class.

  o New RWStringID:
    When creating a persistable class derived from RWCollectable, you
    now have the choice of supplying an RWClassID (an unsigned short
    value) as in earlier versions of the library, or, new to this
    version, a more descriptive RWStringID. For example, instead of
       DEFINE_COLLECTABLE(MyFooClass, 0x101A)
    you might now say
       DEFINE_NAMED_COLLECTABLE(MyFooClass, "D1T3_MyFooClass")
    In return for a small amount of additional overhead, this new
    feature should make it easier for large teams of developers to
    manage their ID space. See the chapter on "Designing an
    RWCollectable Class" in the Tools.h++ User's Guide for more
    information.

  o Class RWAuditStreamBuffer:
    This class can be used to count the number of bytes that an object
    will take up when persisted via the Rogue Wave virtual stream
    mechanism. This provides, for streams, the equivalent of
    RWCollectable::recursiveStoreSize(), which only works for RWFiles.
    RWAuditStreamBuffer can also be constructed with a function
    pointer so that the function will be called with each byte that
    passes through the stream.

   
  o Locale-based string formatting improved:
    In classes RWDate, RWTime, and RWLocale, member functions
    asString() that take a strftime-like formatting character have
    been extended with an overloaded version that will take a string
    of format characters in one call. At the same time, because the
    formatting specification "%C" is not universally supported, and
    worse, means different things on different systems, we have
    deprecated its use. It is still present for those compilers that
    support it to mean "long date and time" but is no longer
    documented.
 
  o New example programs:
    We have added several new example programs for the new
    extended regular expression class.  As a convenience, we have also
    provided code for many of the examples found in the printed
    manual.  Look in the toolexam and toolexam/manual directories.
    
  o Better access to RWDate internals:
    Both accessor and mutator functions are now provided for the
    internal julian day number within an RWDate object. Developers had
    requested this to make the class more useful as an underlying
    representation for more domain-specific date classes. (If you had
    already found a way to make these available, you may leave your
    "round the barn" code in place, or choose to make use of the
    easier interface.)
 
  o Storage size for nil:
    A new static member function RWCollectable::nilStoreSize() returns
    the number of bytes required to store a nil pointer in an RWFile.
 
  o RWFile "mode" extensions:
    An optional mode parameter has been added to the static member
    function RWFile::Exists(const char* name, int mode = F_OK). This
    allows you to check whether a file exists and is executable,
    writable, and/or readable.
    
    The member function RWFile::access(), returns the access mode used
    to open the FILE* upon which the class is implemented.
 
  o RWBinaryTree additions:
    We have enhanced the performance of RWBinaryTree::balance() and
    added a new method height() that returns the largest number of
    nodes traversed between the root and a leaf. (The height() of a
    tree with one element is 1.)
    
  o Static hash() members:
    RWDate, RWCString, RWTime, and RWWString all have new static
    hash() member functions, eg:
        static unsigned RWCString::hash(const RWCString& str)
     Each one simply turns around and calls its own hash member function,
    (e.g. str.hash()).  These were added so that programmers could
    supply them to hash collections such as RWTValHashTable, rather
    than repeatedly writing their own tiny hash functions.
    
  o New Set functions:
    Classes RWTValHashSet, and RWTPtrHashSet have been given new
    member functions providing the set-theoretic functions union,
    difference, intersection, subset, proper subset, and equivalence.
 
   

  o Improved exception safety:
    We have enhanced the library to make it still safer in a world of
    C++ exceptions. In particular, we scanned the library to protect
    against dangling resources and inconsistent states which might
    have resulted from an exception being thrown from code belonging
    to a user of our library. Even something as innocent looking as an
    assignment statement involving instances of some type T in a class
    parameterized on T is a potential culprit that might throw an
    exception. As a specific example, we wrapped up the static read
    and store tables used for persistence. Now if an exception is
    thrown, say, from a user's saveGuts function, the store table will
    be properly destroyed and not left dangling.
   
    Unfortunately, we cannot do that work for the RWCollectable that
    was being restored when the exception is thrown: Only the
    programmer who wrote saveGuts and restoreGuts can know the exact
    shape of the RWCollectable that is being restored so that
    programmer must be the one to write code that will correctly deal
    with the partly restored RWCollectable which will be available if
    an exception is thrown.
    
  o Better error messages:
    We have fixed a few run-time error messages to make a little more
    sense.  We sincerely hope your users never see the result of this
    effort!
 
  
  o Bug fix for RWpostream::operator<<() and RWpistream::operator>>():
    These now handle unprintable characters such as '\n' and '\b'.
    Previously, the restored value was always the character '\', and
    the stream was left unsynchronized for subsequent restores.
 
  o XDR streams may now be constructed from a streambuf* or stream
    reference. 
 
  o Change to RWCSubString and RWWSubString:
    The undocumented data() member functions have been deprecated
    although they remain publicly accessible to preserve source
    compatibility with Tools.h++ Version 6.1. Method data() has been
    replaced by the equally undocumented startData(), which will not
    remain public in a future version. Since RWCSubString works by
    referencing the RWCString's data, if you attempt to directly use
    the data() member of the substring, you will very likely be
    surprised by the result, which will not be null terminated at the
    extent of the substring, but at the end of the RWCString to which
    it refers.
 
  o BTree improvements:
    RWBTree and RWBTreeOnDisk made use of a cache that caused them not
    to be re-entrant. We moved the cached information onto the call
    stack, so they are both now re-entrant. In addition, since RWBTree
    calculated the number of items for each call to entries(), we were
    able to re-use the space to cache the number of items instead.
    This has the potential to be a major speed improvement if your
    program uses RWBTree::entries() on large RWBTrees.
 


  o RWBTreeOnDisk may now be used to access a read-only file.
 
  o Changed implementation of RWLocaleDefault:
    Because of "cross-talk" between ANSI C setlocale() and sprintf(),
    RWLocaleDefault now has a private constructor, and is completely
    undocumented. If you have been using RWLocaleDefault, you may
    obtain the pointer to a new RWLocale* on the heap by calling
    RWLocale* RWLocale::defaultLocale() which returns a pointer to a
    "real" RWLocaleDefault if your compiler doesn't support ANSI C
    locales, or a pointer to an RWLocaleSnapshot("C") if it does.
 
  o RWCSubString and RWWSubString assignment operators:
    Assignment from equivalent substrings now acts as expected: All
    substring assignments now are documented to return a reference to
    "self" (and "self" is now fixed to have the assigned extent so
    that such references are useful).
    
  o RWCString and RWWString from streams:
    The efficiency of reading an RWCString or RWWString from a stream
    has been much improved by changing the heuristic for stringRef
    resizing.
 
  o RWCString and RWWString space pre-allocation:
    The Tools.h++ string classes no longer "shrink to fit" unless you
    change them by removing one or more characters. In particular, you
    may now create a string with a larger buffer than it now needs,
    then add to it without losing the buffer.
 
  o Persisting large collections improved:
    Very large persisted collections will now read back into memory
    much more efficiently. The cost is that recovering medium sized
    collections may temporarily use more heap space than was used
    previously.
 
  o Embedded nulls handled better:
    RWCString and RWWString methods first(char), first( char*) and
    last(char) have been extended to correctly handle embedded nulls
    in both the string and search key.
 
    RWCTokenizer has been updated to work correctly with RWCStrings
    that contain embedded NULL characters.
    
  o RWTValOrderedVector and RWTValSortedVector item removal:
    A subtle fix has been made to the semantics of removing items from
    either of the RWTValOrderedVector<T> or RWTValSortedVector<T>
    collections. Previously, when an item or items were removed from
    one of these collections, the remaining items were copied (or
    "slid") to the left and the count of items adjusted accordingly.
    This sliding resulted in unused cells to the right, cells which
    nonetheless contained the same objects that were there before any
    sliding took place. In particular, this created a problem for
    reference-counted objects that were referred to by items in the
    collection. We have fixed this problem by making sure that any
    unused cells are reset, via the assignment operator, to the
    default value of the element type T. Affected member functions
    include remove(), removeAt(), removeAll(), removeFirst(),
    removeLast(), and clear().
    
 o RWBTreeDictionary::operator==() fixed:
    Operator==() on RWBTreeDictionary now compares values as well as
    keys. Beware that if you were depending on the previous behavior,
    the semantics of your program will change!
    
  o RWTime constructor for small times:
    The RWTime::RWTime(unsigned secs) constructor now works correctly
    for small values of s (e.g. secs = 10). Previously there was a
    problem when secs was less than the number of seconds between the
    local time zone and GMT.
    
  o RWTime and the 21st century:
    RWTime objects are now correctly constructed when given dates
    beyond the year 2000.  We encourage you to start NOW to use
    4-digit years in your code. For the sanity and those of us who
    must maintain code into the 21st century.
    
  o A miscellany of small bugs fixed, small features added, and other
    "housekeeping" changes too numerous to mention.
    
----------------------------------------------------------------------------
Appendix B. Changes to Features
===============================
 (Of interest to users of older versions of Tools.h++)
------------------------------------------------------------
6.1.0 --> 7.0.0
 
Date:     March 1996
  Please see the documentation at the top of this file.
 
------------------------------
6.0.4  --> 6.1.0
 
Date     : July 1994
------------------------------
    
  o It is now easier to view RWCString objects from your debugger.
    RWCString and RWWString internals have been changed so that the
    only data member is now a pointer directly to the string contents.
    (Other information is found "in front of" the string contents,
    within the same memory allocation.)
 
  o In earlier versions of Tools.h++, RWCString had the following
    two constructors (in addition to others) :
 
       RWCString(char c);     // Construct a string of one character
       RWCString(RWSize_T n); // Construct a null string with room
                              // for n characters
 
    RWSize_T is a class defined in rw/defs.h.  Its intent was
    to prevent some unwanted automatic conversions and/or
    ambiguities.  Unfortunately, code such as the following
    invokes unexpected constructors:
 
       const size_t buflen = 100;
       RWCString s(buflen);   // Calls RWCString(char)  !
       RWCString r(200);      // Calls RWCString(char)  !
 
    In cases where the string variable is subsequently assigned a new
    value, the problem went unnoticed.  To address this problem, we
    have added the following two constructors:
 
       RWCString(unsigned char);  // Construct a string of one character
       RWCString(signed char);    // Construct a string of one character
 

    As a result, calls such as those above will now be ambiguous at
    compile time, rather than silently calling the wrong constructor.
    To use the RWCString(RWSize_T) constructor, simply cast the
    argument to RWSize_T:
     
        RWCString s(RWSize_T(200));
 
    A similar discussion applies to class RWWString.
 
 
  o We have removed most of Tools.h++ dependence on run-time static
    initialization code.  Only those static objects generated by the
    RWDEFINE_COLLECTABLE macro are known to remain.  Even these have
    been eliminated for DLL's and shared libraries.  The
    RWDEFINE_COLLECTABLE macro is used by all classes which derive
    from RWCollectable.
 
  o The following member function has been added to RWvostream:
 
    virtual RWvostream&  RWvostream::flush();
 
    This mimics the flush() function found on iostreams classes.
    In addition, there is now a flush iomanipulator for the
    RWvostream family of classes.  Manipulators such as those found
    in the iostreams library are not provided because they relate to
    formatting issues.  With RWvostream classes, the format is
    defined by the concrete class used and cannot be changed.
    (See following discussion of postream)
 
    o The following member functions have been added to RWpostream:
 
    int RWpostream::precision() const;
    int RWpostream::precision(int p);
 
    Their function is the same as that of the ios::precision functions
    found in iostreams.  In addition, the default precision for a
    RWpostream is now 16, (previously it was 6). This change
    eliminates the loss of precision when writing and reading float
    and double data to RWpostreams.  It will, however, increase the
    size of RWpostream files when writing float and double data.  You
    can change the default by setting RW_DEFAULT_PRECISION in
    compiler.h and rebuilding the library.
 
  o RWCLIPStreambuf now overrides the sync() member function.
    This allows the endl and flush manipulators to be used on streams
    built from RWCLIPStreambufs.  Previously, use of these manipulators
    would cause the bad bit of the stream to be set.
 
 o RWLocaleSnapshot::monthIndex now ignores leading spaces when
    comparing month name strings.  This means that when using a
    month name (or abbreviation) in an RWDate constructor, a valid
    date object will be constructed even if the month name does not
    match the one maintained by strftime with regard to leading spaces.
    (This supports Japanese locales where the month name often includes
    leading spaces.)
 
  o The RWTHROW macro now always calls the library function RWThrow().
    Thus, it is now possible to change a program's exception behavior
    by re-linking to a different version of the library.
 
  o RWTime and RWZone now handle the Daylight Savings Time (Summer
    Time) transition more gracefully.  RWTime now rejects times in
    the hour of the standard->summer transition.  Also, RWDate has
    become more robust at detecting invalid dates.
 
  o All the hash collections now provide a member, buckets(), which
    reports the number of buckets used.  This value may be used to
    compute an argument value for resize() when rehashing.
 
  o Most destructors have been moved out of line.  In many cases out
    of line destructors were added where previously the compiler
    generated one automatically.  This substantially reduces the size
    of large program files, especially when linked with shared
    libraries.
 
  o The following constructor has been added to RWCollectableDate:
 
    RWCollectableDate(unsigned long julianDate);
 
    This sets the date to the Julian date supplied.
 
  o The constructor for RWFileManager now has a "mode" argument
    (existing programs should be source compatible).  The reference
     on page 54-1 should now read:
 
        Public constructor
 
        RWFileManager(const char* filename, const char* mode = 0);

        Constructs an RWFileManager for the file with path name
        filename using mode mode.  The mode is as given by the Standard C
        library function fopen().  If mode is zero (the default) then the
        constructor will attempt to open an existing file with the given
        filename for update (mode "rb+").  If this is not possible, then it
        will attempt to create a new file with the given filename (mode
        "wb+").  If the file exists and is not empty, then the constructor
        assumes it contains an existing file manager; other contents
        will cause an exception of type RWExternalErr to be thrown.
        If no file exists or if an existing file is empty, then the
        constructor will attempt to create the file (if necessary) and
        initialize it with a new file manager.  A possible exception that
        could occur is RWFileErr.  The resultant object should be checked
        for validity using function isValid().
      
------------------------------
6.0.3  -->  6.0.4
 
Date     : March 1994
------------------------------
 
  o Previously, a program that attempted to create an RWFileManager
    from a read-only file would get a segmentation fault.  This no
    longer occurs; instead, the object is created with an invalid
    state.  Be sure to check the state of the object after creation
    using the isValid() member function (inherited from RWFile).
 
  o Collection classes derived from from RWCollection are now consistent
    with respect to the isEqual member function.  In each of these
    collections, isEqual(const RWCollectable* c) will return TRUE if c is an
    instance of the same class as self, and  self == c.  The following
    classes were affected: RWDlistCollectables, RWIdentitySet,
    RWIdentityDictionary, RWOrdered, RWSlistCollectables, RWBTreeDictionary,
    RWSortedVector, RWSlistCollectablesQueue, RWSlistCollectablesStack.
    (The other collections derived from RWCollection already had these
    semantics for the isEqual member function.)
 
  o RWHashDictionary::operator==(const RWHashDictionary&) now works as
    documented---that is, both keys and values are compared.  Previously,
    only the keys were compared.
 
------------------------------
6.0.2  -->  6.0.3
 
Date     : 12 January 1993
------------------------------
 
  o Added const version of RWGDlist(type)::at(size_t i)
 
  o RWCollectable* RWOrdered::removeAt(size_t indx)
    Moved from protected to public access.  This allows removing
    a particular entry among duplicates.  indx must be within bounds
    or an exception of type RWBoundsErr will be thrown.
 
  o RWCollectable* RWBag::remove(const RWCollectable* target)
    Now works as documented: always removes and returns the item
    that isEqual to the item pointed to by target, or rwnil if
    not found.
 
  o void RWBag::removeAndDestroy(const RWCollectable* target)
    No longer inherited from class RWCollection.  Redefined to only
    delete the object being removed if it is the last occurrence
    of its kind in the bag.  Note that this maintains the semantics
    from the previous versions of the libary.
 
  o Many member functions of the following pointer-based template
    classes have had parameters of type   T*   changed to   const T*.
    RWTPtrDlist, RWTPtrDlistIterator, RWTPtrHashDictionary, RWTPtrHashSet,
    RWTPtrHashTable, RWTPtrOrderedVector, RWTPtrSlist, RWTPtrSlistIterator,
    RWTPtrSortedVector.
 
    The following rough list of member functions gives an idea of
    the scope of the change:
        contains, find, index, occurrencesOf, remove, removeAll,
        findNext, removeNext, findValue, findKeyAndValue.
 
    E.g.:  old:   RWBoolean RWTPtrDlist::contains(T* a) const;
           new:   RWBoolean RWTPtrDlist::contains(const T* a) const;
 
------------------------------
6.0.1  -->  6.0.2
 
Date     : 15 November 1993
------------------------------
 
  o Added const version of RW[CW]String::strip().
 
  o Fixed bug that prevented reading strings created with Tools.h++ V5.X.
 
  o Allow storing and retrieving of RWCStrings with embedded nulls.
 
  o Classes RWp[io]stream no longer inherit from [io]stream.  Instead,
    the [io]stream is member data.  This avoids ambiguous shift
    operations such as:
 
      RWpostream s;
      RWCString c;
      s << c;      // Was ambiguous; now works as expected
 
  o Fixed bug in RWIsvDlistIterator::operator-=(size_t);
 
  o Added virtual destructor RWvios::~RWvios()


  o Classes RWTValVector<T>, RWTValOrderedVector<T>, and
    RWTValSortedVector<T> now have RWExport tags, allowing them
    to be used with the Tools.h++ DLL.
 
  o RWv[io]stream now has version number for backward compatibility.
    RWCString::saveOn, restoreFrom now checks version of RWv[io]stream
    to determine format:
 
        Version 0: treat chars as numbers a la Tools 6.0.0, 6.0.1.
        Version 1: treat chars as characters as in versions before 6.0.0,
                   and versions 6.0.2 and onward.
                      
    Use the version(unsigned n) member function of RWv[io]stream to
    set the version number for an RWp[io]stream object, thereby determining
    the format which will be used.  Default version number is the highest
    in use, which is 1 at this time.
 
 


