      *
      * @(#)stockin.cbl	1.7

      ****************************************************************
      * Copyright Micro Focus Limited 1989-92. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      ***********************************************************
      *                                                         *
      *             MICRO FOCUS MULTI-USER COBOL		*
      *             ============================		*
      *                DEMONSTRATION PROGRAM                    *
      *                =====================                    *
      *                                                         *
      *  This program demonstrates the file and record locking  *
      *      facilities of MULTI-USER COBOL. This      		*
      *   subprogram, which is called by MUDEMO, acquires no    *
      *          locks because it is for input only.            *
      *                                                         *
      ***********************************************************

       IDENTIFICATION DIVISION.
       PROGRAM-ID.  STOCKIN.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
          CONSOLE IS CRT.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
           SELECT STOCK-FILE ASSIGN "MUSTOCK"
                ORGANIZATION INDEXED
                ACCESS DYNAMIC
                RECORD KEY STOCK-KEY
                STATUS FILE-STATUS.
      /
       DATA DIVISION.

      ***********************************************************
      * FILE DEFINITION                                         *
      ***********************************************************

       FILE SECTION.
       FD  STOCK-FILE.
       01  STOCK-RECORD.
           03  STOCK-KEY                        PIC 9(06).
           03  STOCK-DATA.
               05  STOCK-DESCRIPTION-1          PIC X(53).
               05  STOCK-DESCRIPTION-2          PIC X(53).
               05  STOCK-DESCRIPTION-3          PIC X(53).
               05  STOCK-HELD                   PIC 9(06).
               05  STOCK-COST                   PIC 9(06)V99.
      /
       WORKING-STORAGE SECTION.
       01     STOCK-00   .
           03    STOCK-00-0101 PIC X(0080) VALUE "----------------------
      -    "----------------------------------------------------------".
           03    STOCK-00-0201 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0078).
           03    STOCK-00-0280 PIC X(0001) VALUE "|".
           03    STOCK-00-0301 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0031).
           03    STOCK-00-0333 PIC X(0011) VALUE "Micro Focus".
           03 FILLER           PIC X(0020).
           03    STOCK-00-0364 PIC X(0017) VALUE "Date   /  /     |".
           03    STOCK-00-0401 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0031).
           03    STOCK-00-0433 PIC X(0011) VALUE "===========".
           03 FILLER           PIC X(0020).
           03    STOCK-00-0464 PIC X(0017) VALUE "Time   :        |".
           03    STOCK-00-0501 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0027).
           03    STOCK-00-0529 PIC X(0020) VALUE "Stock Control System".
           03 FILLER           PIC X(0031).
           03    STOCK-00-0580 PIC X(0001) VALUE "|".
           03    STOCK-00-0601 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0027).
           03    STOCK-00-0629 PIC X(0020) VALUE "====================".
           03 FILLER           PIC X(0031).
           03    STOCK-00-0680 PIC X(0001) VALUE "|".
           03    STOCK-00-0701 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0078).
           03    STOCK-00-0780 PIC X(0001) VALUE "|".
           03    STOCK-00-0801 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0078).
           03    STOCK-00-0880 PIC X(0001) VALUE "|".
           03    STOCK-00-0901 PIC X(0018) VALUE "|  Stock Code    [".
           03    STOCK-00-0919 PIC 9(0006) VALUE 0.
           03    STOCK-00-0925 PIC X(0001) VALUE "]".
           03 FILLER           PIC X(0054).
           03    STOCK-00-0980 PIC X(0001) VALUE "|".
           03    STOCK-00-1001 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0078).
           03    STOCK-00-1080 PIC X(0001) VALUE "|".
           03    STOCK-00-1101 PIC X(0022) VALUE "|  Stock Description [
      -    "".
           03 FILLER           PIC X(0053).
           03    STOCK-00-1176 PIC X(0005) VALUE "]   |".
           03    STOCK-00-1201 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0020).
           03    STOCK-00-1222 PIC X(0001) VALUE "[".
           03 FILLER           PIC X(0053).
           03    STOCK-00-1276 PIC X(0005) VALUE "]   |".
           03    STOCK-00-1301 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0020).
           03    STOCK-00-1322 PIC X(0001) VALUE "[".
           03 FILLER           PIC X(0053).
           03    STOCK-00-1376 PIC X(0005) VALUE "]   |".
           03    STOCK-00-1401 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0078).
           03    STOCK-00-1480 PIC X(0001) VALUE "|".
           03    STOCK-00-1501 PIC X(0018) VALUE "|  Stock Held    [".
           03    STOCK-00-1519 PIC 9(0006) VALUE 0.
           03    STOCK-00-1525 PIC X(0001) VALUE "]".
           03 FILLER           PIC X(0054).
           03    STOCK-00-1580 PIC X(0001) VALUE "|".
           03    STOCK-00-1601 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0078).
           03    STOCK-00-1680 PIC X(0001) VALUE "|".
           03    STOCK-00-1701 PIC X(0028) VALUE "|  Cost per Unit [
      -    "     ]".
           03 FILLER           PIC X(0051).
           03    STOCK-00-1780 PIC X(0001) VALUE "|".
           03    STOCK-00-1801 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0078).
           03    STOCK-00-1880 PIC X(0001) VALUE "|".
           03    STOCK-00-1901 PIC X(0001) VALUE "|".
           03 FILLER           PIC X(0078).
           03    STOCK-00-1980 PIC X(0001) VALUE "|".
           03    STOCK-00-2101 PIC X(0080) VALUE "----------------------
      -    "----------------------------------------------------------".
           03    STOCK-00-2201 PIC X(0040)
                 VALUE "-----Open Mode----Lock Mode--Last Operat".
           03    STOCK-00-2241 PIC X(0040)
                 VALUE "ion-----------Outcome------File Status--".
           03 FILLER           PIC X(0206).
           03 FILLER           PIC 9(0001) VALUE 0.

       01     STOCK-01    REDEFINES    stock-00   .
           03 FILLER           PIC X(0658).
           03   STOCK-01-CODE           PIC 9(0006).
           03 FILLER           PIC X(0158).
           03   STOCK-01-DESCRIPTION-1  PIC X(0053).
           03 FILLER           PIC X(0027).
           03   STOCK-01-DESCRIPTION-2  PIC X(0053).
           03 FILLER           PIC X(0027).
           03   STOCK-01-DESCRIPTION-3  PIC X(0053).
           03 FILLER           PIC X(0103).
           03   STOCK-01-HELD           PIC 9(0006).
           03 FILLER           PIC X(0154).
           03   STOCK-01-COST           PIC $$$$$9.99.
           03 FILLER           PIC X(0579).
           03   CHOICE                  PIC 9.

      ***********************************************************
      * FILE STATUS VARIABLES                                   *
      ***********************************************************

       01  FILE-STATUS.
           03  STATUS-1                 PIC X.
           03  STATUS-2                 PIC X.

       01  BINARY-STATUS REDEFINES FILE-STATUS PIC 9(04) COMP.
      ***********************************************************
      * DATE AND TIME VARIABLES                                 *
      ***********************************************************

       01  DATE-TO-DAY.
           03  DAYS                     PIC 99.
           03  FILLER                   PIC X.
           03  MONTH                    PIC 99.
           03  FILLER                   PIC X.
           03  YEAR                     PIC 99.

       01  UP-TO-DATE-TIME.
           03  HOURS                    PIC 99.
           03  FILLER                   PIC X.
           03  MINS                     PIC 99.

       01  TEMP-DATE.
           03  TEMP-YEAR                PIC XX.
           03  TEMP-MONTH               PIC XX.
           03  TEMP-DAY                 PIC XX.
       01  TEMP-TIME.
           03  TEMP-HOURS               PIC 99.
           03  TEMP-MINS                PIC 99.
           03  TEMP-REST                PIC 9999.

      ***********************************************************
      * INFORMATION LINE DECLARATION                            *
      ***********************************************************

       01  STATUS-LINE.
           03  FILLER                   PIC X(02).
           03  OPEN-MODE                PIC X(14).
           03  FILLER                   PIC X(02).
           03  LOCK-MODE                PIC X(09)
                  VALUE "---------".
           03  FILLER                   PIC X(03).
           03  LAST-OPERATION           PIC X(11).
           03  FILLER                   PIC X(03).
           03  WAS-IT-SUCCESSFUL        PIC X(20).
           03  FILLER                   PIC X(08).
           03  ERROR-CODE.
               05 STAT-1                PIC X.
               05 FILLER                PIC X.
               05 STAT-2                PIC 9(03) VALUE 0.
               05 STAT-REDEF REDEFINES STAT-2.
                  07 FILLER-2           PIC 99.
                  07 STAT-2-REDEF       PIC X.

       01  HYPHEN-LINE                  PIC X(80)
               VALUE ALL "-".

       01  YESNO                        PIC X.

       01    inpopt.
           03   FILLER         PIC X(10).
           03   inpopt-00      PIC X(0056) VALUE "1. Read on Key   2. Re
      -    "ad next   3. Start not <   4. Exit".

      ***********************************************************
      * PROGRAM FOR INPUT ONLY                                  *
      ***********************************************************

       PROCEDURE DIVISION.
       MAIN.
           initialize choice stock-01.
           DISPLAY SPACE.
           DISPLAY STOCK-00.
           DISPLAY INPOPT AT 2301.
           DISPLAY "Input Choice [ ]" AT 2433 UPON CRT-UNDER.
           OPEN INPUT STOCK-FILE.
           MOVE "----Open Input" TO OPEN-MODE.
           MOVE "-Open Input" TO LAST-OPERATION.
           PERFORM STATUS-CHECK.
           IF WAS-IT-SUCCESSFUL NOT = "----------Successful"
               MOVE "----Closed----" TO OPEN-MODE
               DISPLAY HYPHEN-LINE AT 2201 UPON CRT-UNDER
               DISPLAY STATUS-LINE AT 2201 UPON CRT-UNDER
               GO TO ENDIT.

      ***********************************************************
      * MAIN LOOP                                               *
      ***********************************************************

       ENT-RY.
           PERFORM DISPLAY-DATE.
           PERFORM DISPLAY-TIME.
           DISPLAY HYPHEN-LINE AT 2201 UPON CRT-UNDER
           DISPLAY STATUS-LINE AT 2201 UPON CRT-UNDER
           MOVE ZERO TO STAT-2.
           ACCEPT STOCK-01.

           IF CHOICE = 1 PERFORM READ-ON-KEY
                         GO TO ENT-RY.

           IF CHOICE = 2 PERFORM READ-NEXT
                         GO TO ENT-RY.

           IF CHOICE = 3 PERFORM START-NOT-LESS-THAN
                         GO TO ENT-RY.

           IF CHOICE = 4 GO TO WRAP-UP.

           GO TO ENT-RY.

      ***********************************************************
      * CLOSING DOWN PARAGRAPHS                                 *
      ***********************************************************

       WRAP-UP.
           CLOSE STOCK-FILE.
           MOVE "----Closed----" TO OPEN-MODE.
           MOVE "------Closed" TO LAST-OPERATION.
           PERFORM STATUS-CHECK.
           DISPLAY HYPHEN-LINE AT 2201 UPON CRT-UNDER.
           DISPLAY STATUS-LINE AT 2201 UPON CRT-UNDER.

       ENDIT.
           DISPLAY "Do you wish to restart (Y/N) [ ]"
               AT 2424 UPON CRT-UNDER.
           ACCEPT YESNO AT 2454.
           IF YESNO = "Y" OR "y"
               GO TO MAIN.
           IF YESNO = "N" OR "n"
               GO TO END-PARA.
           GO TO ENDIT.
       END-PARA.
           EXIT PROGRAM.


      ***********************************************************
      * FILE HANDLING PARAGRAPHS                                *
      ***********************************************************

       READ-ON-KEY.
           MOVE "Read on key" TO LAST-OPERATION.
           PERFORM MOVE-KEY-FROM-SCREEN-TO-REC.
           READ STOCK-FILE.
           PERFORM STATUS-CHECK.
           IF STAT-1 = "0" OR STAT-2 = 068
              PERFORM MOVE-FROM-REC-TO-SCREEN
              DISPLAY STOCK-01.

       READ-NEXT.
           MOVE "--Read Next" TO LAST-OPERATION.
           READ STOCK-FILE NEXT.
           PERFORM STATUS-CHECK.
           IF STAT-1 = "0" OR STAT-2 = 068
              PERFORM MOVE-FROM-REC-TO-SCREEN
              DISPLAY STOCK-01.

       START-NOT-LESS-THAN.
           MOVE "Start not <" TO LAST-OPERATION.
           PERFORM MOVE-KEY-FROM-SCREEN-TO-REC.
           START STOCK-FILE KEY NOT LESS THAN STOCK-KEY.
           PERFORM STATUS-CHECK.

      ***********************************************************
      *    FILE STATUS CHECKING ROUTINES.                       *
      ***********************************************************

       STATUS-CHECK.
               MOVE STATUS-1 TO STAT-1
               MOVE STATUS-2 TO STAT-2-REDEF.
           IF STATUS-1 = "0"
               MOVE "----------Successful" TO WAS-IT-SUCCESSFUL.

           IF STATUS-1 = "1"
               MOVE "---------End of file" TO WAS-IT-SUCCESSFUL.

           IF STATUS-1 = "2"
               MOVE "---------Invalid Key" TO WAS-IT-SUCCESSFUL.

           IF STATUS-1 = "9"
               PERFORM LOOK-UP-ERROR THRU ERROR-END.

      ***********************************************************
      *     LOOK UP ERROR NUMBER                                *
      ***********************************************************

       LOOK-UP-ERROR.
           MOVE LOW-VALUES TO STATUS-1.
           MOVE BINARY-STATUS TO STAT-2.
           IF STAT-2 = 002
               MOVE "-------File not open" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 007
               MOVE "Disk space exhausted" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 013
               MOVE "------File not found" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 024
               MOVE "----------Disk error" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 041
               MOVE "---Corrupt ISAM file" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 065
               MOVE "---------File locked" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 068
               MOVE "-------Record locked" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 139
               MOVE "Record inconsistency" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 146
               MOVE "---No current record" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 180
               MOVE "------File malformed" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 208
               MOVE "-------Network error" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
           IF STAT-2 = 213
               MOVE "------Too many locks" TO WAS-IT-SUCCESSFUL
               GO TO ERROR-END.
       ERROR-END.
           EXIT.


      ***********************************************************
      *     SUBROUTINES FOR MOVING DATA TO AND FROM THE SCREEN  *
      ***********************************************************

       MOVE-KEY-FROM-SCREEN-TO-REC.
          MOVE STOCK-01-CODE TO STOCK-KEY.

       MOVE-FROM-SCREEN-TO-REC.
          MOVE STOCK-01-CODE TO STOCK-KEY.
          MOVE STOCK-01-DESCRIPTION-1 TO STOCK-DESCRIPTION-1.
          MOVE STOCK-01-DESCRIPTION-2 TO STOCK-DESCRIPTION-2.
          MOVE STOCK-01-DESCRIPTION-3 TO STOCK-DESCRIPTION-3.
          MOVE STOCK-01-HELD TO STOCK-HELD.
          MOVE STOCK-01-COST TO STOCK-COST.

       MOVE-FROM-REC-TO-SCREEN.
          MOVE STOCK-KEY TO STOCK-01-CODE.
          MOVE STOCK-DESCRIPTION-1 TO STOCK-01-DESCRIPTION-1.
          MOVE STOCK-DESCRIPTION-2 TO STOCK-01-DESCRIPTION-2.
          MOVE STOCK-DESCRIPTION-3 TO STOCK-01-DESCRIPTION-3.
          MOVE STOCK-HELD TO STOCK-01-HELD.
          MOVE STOCK-COST TO STOCK-01-COST.

      ***********************************************************
      * DATE AND TIME ROUTINES.                                 *
      ***********************************************************

       DISPLAY-DATE.
          ACCEPT TEMP-DATE FROM DATE.
          MOVE TEMP-DAY TO DAYS.
          MOVE TEMP-MONTH TO MONTH.
          MOVE TEMP-YEAR TO YEAR.
          DISPLAY DATE-TO-DAY AT 0369.

       DISPLAY-TIME.
          ACCEPT TEMP-TIME FROM TIME.
          MOVE TEMP-HOURS TO HOURS.
          MOVE TEMP-MINS TO MINS.
          DISPLAY UP-TO-DATE-TIME AT 0469.
