      *
      * @(#)sharemem.cbl	1.5
      ****************************************************************
      * Copyright Micro Focus Limited 1989-95. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      $ set vsc2 rtncode-size(4)
      *
	identification division.
	program-id. sharemem.
      *
      * This program demonstrates the used of shared memory via COBOL
      * directly calling Unix functions. When this program is run 2 or
      * more times, each process will update a counter in shared memory.
      *
      * The demo can be animated or run. First you will need to build an
      * RTS executable that includes the necessary Unix support routines.
      * This can be done be entering:
      *
      * cob -xvo drts -I shmctl -I semctl -I semget -I semop -I shmat
      * -I shmget
      *
      * You also need to compile the two cobol programs. You can do this
      * by entering:
      * cob -a smstart.cbl sharemem.cbl
      *
      * smstart.cbl initialises the semaphore and the shared memory and must
      * be run first on one of the terminals you are using. sharemem.cbl
      * can then be run or animated to demonstrate the use of shared memory.
      *
      * So once the programs are compiled if you want the animated demo
      * you will require at least 2 terminals to demo. On the 1st terminal
      * enter:
      *
      * drts smstart
      * COBSW=+A
      * export COBSW
      * drts sharemem
      *
      * and on all subsequent terminals enter:
      *
      * COBSW=+A
      * export COBSW
      * drts sharemem
      *
      * You can then step through each animation. Observe how access to
      * the shared memory is controlled by use of semaphores.
      *
      * Using the 'smdemo' script will allow you to run the demo directly on
      * a single terminal. Note though that smstart is still run first to
      * initialise the semaphore and the shared memory.
      * This will create 3 files called 'out1', 'out2', and 'out3'. These
      * files show how each process has updated the piece of shared memory.
      *
      * Optionally, you can pass an argument through to each running version
      * of 'sharemem'. This argument, if valid, controls the number of
      * iterations that the program attempts to update the shared memory.
      * Range of values possible are 1-99999.
      *
	copy "smwrks.cpy".

        procedure division.
        main section.
      *
      * Get number of iterations via command line.
      *
	    accept cmdln from command-line
	    if cmdln not = zeros
	    	move cmdln to iterations
	    end-if
      *
      * Get semaphore id
      *
	    perform cbl-semget
      *
      * Get the shared memory id and attach it to this process
      *
	    perform cbl-memget
      *
      * Access to the shared memory is controlled by the semaphore
      *
            perform until counter > iterations
      *
      * This is the 'critical section' which must have controlled access
      * otherwise, Program A could be in the middle of updating when
      * Program B comes along and messes things up.
      *
		perform cbl-aquire-sem
                if return-code <> -1
                    add 1 to counter
		    display "counter=" counter
      *
      * The end of the critical section is marked by the Semaphore clear
      *
		    perform cbl-release-sem
                end-if
            end-perform
      *
      * Close down nicely
      *

      *
      * Acquire semaphore so that no one else can remove it.
      *
      
            perform cbl-aquire-sem 
      **************************************************
      * The last parameter to the semctl call below is defined by Unix  
      * systems as a Union. Some C compilers require unions to 
      * be passed by value whilst others require them to be passed
      * as a pointer,ie by reference. There are two versions of the
      * relevant call statement below the first passes the final parameter
      * by value, whilst the second passes it by reference. This system
      * requires the parameter to be passed by reference so the other version
      * of the call has been commented out.
      **************************************************

            if return-code <> -1
      * Pass final parameter by value
      * call "semctl" using by value
      *               cbl-semid zeroarg rmid zeroarg

      * Pass final parameter by reference
                call "semctl" using by value
                              cbl-semid zeroarg rmid 
                              by reference zeroarg
       

	        call "shmctl" using by value cbl-shmid rmid zeroarg
            end-if 
            stop run.
      *
      * Generic routines
      *
	copy "smproc.cpy".
