      *
      * @(#)scdemo1.cbl	1.3

      ****************************************************************
      * Copyright Micro Focus Limited 1989-92. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

       Identification Division.
       program-id. scdemo1.

      * This program demonstrates screen handling. It shows, for
      * demonstration purposes only, how part of a program for handling
      * a bank account might be written: it accepts a password, and then
      * repeatedly accepts details of cheques. Neither the password nor
      * the cheque details are actually processed: only the
      * screen-handling code is given. For both, the program uses Format
      * 2 of the ACCEPT and DISPLAY verbs, which references screen
      * items. The message asking the operator whether to continue
      * demonstrates Format 3, which references data items.

       Environment Division.
       special-names.
           cursor is cursor-position.

       Data Division.
       working-storage section.

       01  cursor-position.
           02  cursor-line         pic 99.
           02  cursor-col          pic 99.

       01  date-cols.
           02  day-col             pic 99      value 56.
           02  month-col           pic 99      value 59.
           02  year-col            pic 99      value 62.

      *
      * Areas to contain data from forms on the screen.

       01  p-password              pic x(20)   value spaces.

       01  s-cheque.
           02  s-to            pic x(15)       occurs 4.
           02  s-for           pic x(10).
           02  s-refno         pic x(10).
           02  s-amount        pic s9(6)v99.
           02  s-date.
               03  s-day       pic 99.
               03  s-month     pic 99.
               03  s-year      pic 9999.

      *
      * Area for Format 3 ACCEPT/DISPLAY used for "continue" message

       01  go-on.
           02  go-message          pic x(55) value
           "Do you want to enter another? (y for yes, n to finish):".
           02  filler              pic x.
       01  go-on-red.
           02  filler              pic x(55).
           02  go-on-reply         pic x.


       screen section.

       01  password-form.
         02  blank screen.
         02  value "Please enter password  <".
         02  pic x(20) to p-password, required, secure.
         02  value ">".

       01  cheque-form.
           03  blank screen.
           03  line 2, column 35, value "Cheque".

           03  line 4.
           03  occurs 4.
               04  pic x from "<", line, column 10.
               04  pic x(15) using s-to.
               04  pic x from ">".
           03  value "Recipient Name and Address", line + 2, column 6.

           03  value "<", line 14, column 10.
           03  pic zzz,zz9.99 using s-amount, required.
           03  value ">".
           03  value " Amount", line 15, column - 9.

           03  value "<", line 5, column 40.
           03  pic x(10) using s-for.
           03  value ">".
           03  value "   For", line 6, column - 9.

           03  value "<", line 5, column 60.
           03  pic x(10) using s-refno, full.
           03  value ">".
           03  value "Reference", line 6, column - 9.

           03  value "Date: ", line 14, column 46.
           03  value "<", column day-col.
           03  pic zz    using s-day, prompt is "d", auto, required.
           03  value "/", column month-col.
           03  pic zz    using s-month, prompt is "m", auto, required.
           03  value "/", column year-col.
           03  pic zzzz  using s-year, prompt is "y", full, required.
           03  value ">  ".

       01  error-messages, blink.
         02  clear-msg   line 24, blank line.
         02  msg1        line 24, value "Invalid day  ".
         02  msg2        line 24, value "Invalid month".
         02  msg3        line 24, value "Invalid year ".


       Procedure Division.

       start-up.
           display password-form.
           accept password-form.
      * Code to check the password would be written here.

       initialize-cheque.
           move spaces to cursor-position.
           display clear-msg.
           move spaces to s-cheque.
           move zero to s-amount s-day s-month s-year.
           display cheque-form.

       accept-cheque.
           accept cheque-form.

       validate-date.
           move 14 to cursor-line.
           if      s-day > 31
               display msg1
               add day-col 1 giving cursor-col
               go to accept-cheque
           else if s-month > 12
               display msg2
               add month-col 1 giving cursor-col
               go to accept-cheque
           else if s-year < 1900 or > 2100
               display msg3
               add year-col 1 giving cursor-col
               go to accept-cheque
           else
               display clear-msg.

      * Code to process the cheque, perhaps with further validation of
      * the date, would be written here.

       next-cheque.
           move space to go-on-reply.
           display go-on at 2401.
           accept go-on-red at 2401.
           if go-on-reply = "y" or "Y" go to initialize-cheque.
           if go-on-reply = "n" or "N" stop run.
           go to next-cheque.
