      $set mf ans85

      ****************************************************************
      * Copyright Micro Focus Limited 1992-94. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      ************************************************************
      *                                                          *
      *                     callhelp.cbl                         *
      *                                                          *
      *  This program demonstrates some features of the call     *
      *  interface to the On-Line Help System. Using             *
      *  the call interface to Hyhelp, you can control           *
      *  a great deal about the help panels you show the         *
      *  user: things like panel size and location, or           *
      *  whether the function keys are shown or hidden.          *
      *                                                          *
      *  Before running this demo program, you will need to      *
      *  have compiled the demonstration on-line help text file  *
      *  ONLEX.TXT. To do this you will have need to have        *
      *  installed on-line builder from setup. Use the following *
      *  code to compile the text.                               *
      *                                                          *
      *        run ohbld onlex /index /contents                  *
      *                                                          *
      *  To compile this program you will need to have the file  *
      *  ONL-LINK.CPY. This can be found in the SOURCE           *
      *  subdirectory of your cobol system.                      *
      *                                                          *
      *  See the chapter On-line Help System in your             *
      *  Toolset Reference or Toolbox Reference for more details.*
      *                                                          *
      ************************************************************

       working-storage section.
       78 pack-byte-func                   value x"f4".
       01 packed-byte                      pic 99 comp-x
                                             value zeros.
       01 byte-array.
           05 unpacked-byte                pic 99 comp-x
                                             occurs 8 times
                                             value zeros.

      ****************************************************************
      *   On-Line Help System Constants                              *
      ****************************************************************
       01  on-line-topic               pic x(50) value spaces.
       78  help-menu-invisible         value 1.
       78  help-screen-on-exit         value 1.
       78  help-no-return-topic-not-fd value 1.
       78  help-file-not-open-on-start value 1.
       78  help-screen-saved-restored  value 1.
       78  help-close-files-on-exit    value 1.
       78  help-deallocate-mem-on-exit value 1.
       78  help-win-location-given     value 1.
       78  help-win-size-given         value 1.

       copy "onl-link.cpy".

       procedure division.
       main-logic.
           perform help-request
           perform terminate-prog.

       help-request.
           perform initialize-help-system
           move on-line-qry-by-context to on-line-action
           move "onlex" to on-line-topic
           move 7 to on-line-context-no
           perform call-on-line-help.

       initialize-help-system.
           move on-line-initialize to on-line-action
           perform set-help-system-flags
           perform call-on-line-help
           move 26 to on-line-window-x
           move 5  to on-line-window-y
           move 45 to on-line-win-width
           move 15 to on-line-win-height.

       call-on-line-help.
           call "hyhelp" using on-line-pb
                               on-line-topic
           if on-line-return not = 0
               display "On-Line Error: " on-line-return
           end-if.

       set-help-system-flags.
           move zero to on-line-flags
           move help-menu-invisible to unpacked-byte(1)
           move help-screen-saved-restored to unpacked-byte(6)
           move help-close-files-on-exit to unpacked-byte(7)
           move help-deallocate-mem-on-exit to unpacked-byte(8)
           perform pack-a-byte
           move packed-byte to on-line-flags
           move zeroes to packed-byte byte-array
           move help-win-location-given to unpacked-byte(7)
           move help-win-size-given to unpacked-byte(6)
           perform pack-a-byte
           move packed-byte to on-line-win-flags.

       pack-a-byte.
           initialize packed-byte
           call pack-byte-func using packed-byte
                                     byte-array.

       terminate-prog.
           move on-line-close-down to on-line-action
           perform call-on-line-help
           cancel "HYHELP"
           stop run.
