      *
      * @(#)sortsub.cpy 1.2
      *
      *    This is the copyfile for the sort subroutines for the
      *    Micro Focus NLS demonstration program.  The subroutines sort
      *    the table given below into ASCII and NLS sequences
      *    The character set encoding can be ISO8859-1 or IBM PC with
      *    code page 850 enabled.
      *    Select the one suitable for your display by setting the
      *    constant below to "ISO" or "IBMPC".
       78  charset                                 value "ISO".
      *78  charset                                 value "IBMPC".

      $if charset = "ISO"
       78  sort-table-size                         value 57.
       78  item-size                               value 20.
       78  display-size                            value 20.
       01  sort-table.
           03 filler   pic x(item-size) value "mnchen             ".
           03 filler   pic x(item-size) value "Chteau Thierry     ".
           03 filler   pic x(item-size) value "Chlons S. Marne    ".
           03 filler   pic x(item-size) value "Crvecoeur le Gd.   ".
           03 filler   pic x(item-size) value "Lbn                ".
           03 filler   pic x(item-size) value "Vitry le Franois   ".
           03 filler   pic x(item-size) value "Mcon               ".
           03 filler   pic x(item-size) value "taples             ".
           03 filler   pic x(item-size) value "Leucate             ".
           03 filler   pic x(item-size) value "Nmes               ".
           03 filler   pic x(item-size) value "Nice                ".
           03 filler   pic x(item-size) value "Nievre              ".
           03 filler   pic x(item-size) value "Rm                ".
           03 filler   pic x(item-size) value "Fhr                ".
           03 filler   pic x(item-size) value "Roma                ".
           03 filler   pic x(item-size) value "Blvands Huk        ".
           03 filler   pic x(item-size) value "Gteborg            ".
           03 filler   pic x(item-size) value "Hjrring            ".
           03 filler   pic x(item-size) value "Sro                ".
           03 filler   pic x(item-size) value "Slvesborg          ".
           03 filler   pic x(item-size) value "Bda                ".
           03 filler   pic x(item-size) value "land               ".
           03 filler   pic x(item-size) value "lborg              ".
           03 filler   pic x(item-size) value "land               ".
           03 filler   pic x(item-size) value "sterbymo           ".
           03 filler   pic x(item-size) value "deshg             ".
           03 filler   pic x(item-size) value "Nstrved            ".
           03 filler   pic x(item-size) value "rnhoj              ".
           03 filler   pic x(item-size) value "Oddes               ".
           03 filler   pic x(item-size) value "Oslo                ".
           03 filler   pic x(item-size) value "Mnchen             ".
           03 filler   pic x(item-size) value "Mhldorf            ".
           03 filler   pic x(item-size) value "Nrnberg            ".
           03 filler   pic x(item-size) value "Munnerstadt         ".
           03 filler   pic x(item-size) value "Aschaffenburg       ".
           03 filler   pic x(item-size) value "Lrrach             ".
           03 filler   pic x(item-size) value "Poznad    *         ".
           03 filler   pic x(item-size) value "Sumperk   *         ".
           03 filler   pic x(item-size) value "Rmarov   *         ".
           03 filler   pic x(item-size) value "slav    *         ".
           03 filler   pic x(item-size) value "Chteauneuf en Thm.".
           03 filler   pic x(item-size) value "Perusic   *         ".
           03 filler   pic x(item-size) value "Sikls    *         ".
           03 filler   pic x(item-size) value "Brzov   *         ".
           03 filler   pic x(item-size) value "Tns               ".
           03 filler   pic x(item-size) value "Mlaga              ".
           03 filler   pic x(item-size) value "Crdoba             ".
           03 filler   pic x(item-size) value "La Campia          ".
           03 filler   pic x(item-size) value "Pearanda           ".
           03 filler   pic x(item-size) value "Cdiz               ".
           03 filler   pic x(item-size) value "Nykping            ".
           03 filler   pic x(item-size) value "Muhlhausen          ".
           03 filler   pic x(item-size) value "Chatel-Guyon        ".
           03 filler   pic x(item-size) value "Mysliborz *         ".
           03 filler   pic x(item-size) value "Munden              ".
           03 filler   pic x(item-size) value "Mcon               ".
           03 filler   pic x(item-size) value "                    ".
      $end
      $if charset = "IBMPC"

       78  sort-table-size                         value 57.
       78  item-size                               value 20.
       78  display-size                            value 20.
       01  sort-table.
           03 filler   pic x(item-size) value "mnchen             ".
           03 filler   pic x(item-size) value "Chteau Thierry     ".
           03 filler   pic x(item-size) value "Chlons S. Marne    ".
           03 filler   pic x(item-size) value "Crvecoeur le Gd.   ".
           03 filler   pic x(item-size) value "Lbn                ".
           03 filler   pic x(item-size) value "Vitry le Franois   ".
           03 filler   pic x(item-size) value "Mcon               ".
           03 filler   pic x(item-size) value "taples             ".
           03 filler   pic x(item-size) value "Leucate             ".
           03 filler   pic x(item-size) value "Nmes               ".
           03 filler   pic x(item-size) value "Nice                ".
           03 filler   pic x(item-size) value "Nievre              ".
           03 filler   pic x(item-size) value "Rm                ".
           03 filler   pic x(item-size) value "Fhr                ".
           03 filler   pic x(item-size) value "Roma                ".
           03 filler   pic x(item-size) value "Blvands Huk        ".
           03 filler   pic x(item-size) value "Gteborg            ".
           03 filler   pic x(item-size) value "Hjrring            ".
           03 filler   pic x(item-size) value "Sro                ".
           03 filler   pic x(item-size) value "Slvesborg          ".
           03 filler   pic x(item-size) value "Bda                ".
           03 filler   pic x(item-size) value "land               ".
           03 filler   pic x(item-size) value "lborg              ".
           03 filler   pic x(item-size) value "land               ".
           03 filler   pic x(item-size) value "sterbymo           ".
           03 filler   pic x(item-size) value "deshg             ".
           03 filler   pic x(item-size) value "Nstrved            ".
           03 filler   pic x(item-size) value "rnhoj              ".
           03 filler   pic x(item-size) value "Oddes               ".
           03 filler   pic x(item-size) value "Oslo                ".
           03 filler   pic x(item-size) value "Mnchen             ".
           03 filler   pic x(item-size) value "Mhldorf            ".
           03 filler   pic x(item-size) value "Nrnberg            ".
           03 filler   pic x(item-size) value "Munnerstadt         ".
           03 filler   pic x(item-size) value "Aschaffenburg       ".
           03 filler   pic x(item-size) value "Lrrach             ".
           03 filler   pic x(item-size) value "Poznad    *         ".
           03 filler   pic x(item-size) value "Sumperk   *         ".
           03 filler   pic x(item-size) value "Rmarov   *         ".
           03 filler   pic x(item-size) value "Ԡslav    *         ".
           03 filler   pic x(item-size) value "Chteauneuf en Thm.".
           03 filler   pic x(item-size) value "Perusic   *         ".
           03 filler   pic x(item-size) value "Sikls    *         ".
           03 filler   pic x(item-size) value "Brzov   *         ".
           03 filler   pic x(item-size) value "Tns               ".
           03 filler   pic x(item-size) value "Mlaga              ".
           03 filler   pic x(item-size) value "Crdoba             ".
           03 filler   pic x(item-size) value "La Campia          ".
           03 filler   pic x(item-size) value "Pearanda           ".
           03 filler   pic x(item-size) value "Cdiz               ".
           03 filler   pic x(item-size) value "Nykping            ".
           03 filler   pic x(item-size) value "Muhlhausen          ".
           03 filler   pic x(item-size) value "Chatel-Guyon        ".
           03 filler   pic x(item-size) value "Mysliborz *         ".
           03 filler   pic x(item-size) value "Munden              ".
           03 filler   pic x(item-size) value "Mcon               ".
      $end
       01  sort-table-r is global redefines sort-table.
           03  sort-item occurs sort-table-size    pic x(item-size).
       77  temp-item                   is global   pic x(item-size).
       77  lowest-sub                  is global   pic 999.
       77  pass-sub                    is global   pic 999.
       77  sort-sub                    is global   pic 999.
       01  display-position.
           03  disp-line                           pic 99.
           03  disp-col                            pic 99.
       procedure division.
       a000.   perform b000-sort-pass varying pass-sub from 1 by 1
                       until pass-sub > sort-table-size.
               perform e000-tailored-display.
       a999.   exit program.

       b000-sort-pass.
               move pass-sub to lowest-sub
               perform c000-set-lowest varying sort-sub from pass-sub
                       by 1 until sort-sub > sort-table-size
               if pass-sub not = lowest-sub
                       move sort-item(lowest-sub) to temp-item
                       move sort-item(pass-sub) to sort-item(lowest-sub)
                       move temp-item to sort-item(pass-sub)
               end-if.

       c000-set-lowest.
               if sort-item(sort-sub) < sort-item(lowest-sub)
                       move sort-sub to lowest-sub
               end-if.

       d000-display-table.
               move 3 to disp-line
               perform varying sort-sub from 1 by 1 until
                                       sort-sub > display-size
                   display sort-item(sort-sub) at display-position
                   add 1 to disp-line
               end-perform
               move 3 to disp-line
               add 20 to disp-col
               perform varying sort-sub from sort-sub
                           by 1 until sort-sub > (display-size * 2)
                   display sort-item(sort-sub) at display-position
                   add 1 to disp-line
               end-perform.

       e000-tailored-display.
