      *
      * @(#)motdemo.cbl    1.0

      ****************************************************************
      * Copyright Micro Focus Limited 1993-95. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************
 
      ****************************************************************
      * This program demonstrates how to call the Motif API from     *
      * COBOL.                              *
      * For details on how to link this program to Motif libraries   *
      * and then run it, see your COBOL System Reference manual.     *
      ****************************************************************

       working-storage section.
      * First define the C null terminator as a level 78
       78  c-null               value x"00".

      * Core resources
       01 XmNx PIC X(2) VALUE "x" & c-null.
       01 XmNy PIC X(2) VALUE "y" & c-null.
       01 XmNwidth PIC X(6) VALUE "width" & c-null.
       01 XmNheight PIC X(7) VALUE "height" & c-null.

      * Label resources
       01 XmNlabelString PIC X(12) VALUE "labelString" & c-null.

      * Push button resources
       01 XmNactivateCallback PIC X(17)
           VALUE "activateCallback" & c-null.
       01 XmNmnemonic PIC X(9) VALUE "mnemonic" & c-null.

      * Dialog resources
       01 XmNdialogTitle PIC X(12) VALUE "dialogTitle" & c-null.
       78 XmDIALOG-HELP-BUTTON VALUE 7.

      * Message box resources
       01 XmNmessageString PIC X(15) VALUE "messageString" & c-null.

      * Cascade button resources
       01 XmNsubMenuId PIC X(10) VALUE "subMenuId" & c-null.

       01  argc            pic x(4) comp-5 value 0.
       01  argv.
           03 argv-1       pic x(20) value "demo" & c-null.

       01  proc-pointer        usage procedure-pointer.

      $if 64bit defined

      * Xt argument handling for 64 bit environments

       78  max-args        value 100.
       01  value all x"00".
        02 all-args occurs max-args.
           03 name-tab     usage pointer.
           03                   pic x(4).
           03 arg-tab      pic x(4) comp-5.
           03                   pic x(4).
       01  arg-name        usage pointer.
       01  arg         pic x(4) comp-5.
       01  args            usage pointer.
       01  nargs       pic x(4) comp-5.

      $else

      * Xt argument handling for 32 bit environments.

       78  max-args        value 100.
       01  all-args occurs max-args.
           03 name-tab     usage pointer.
           03 arg-tab      pic x(4) comp-5.
       01  arg-name        usage pointer.
       01  arg         pic x(4) comp-5.
       01  args            usage pointer.
       01  nargs       pic x(4) comp-5.

      $end

      * widgets
       01  root-widget         pointer.
       01  main-window         pointer.
       01  bulletin-board  pointer.
       01  menu-bar        pointer.
       01  pull-down       pointer.
       01  pull-down-comp5      pic x(4) comp-5 redefines pull-down.
       01  cascade         pointer.
       01  push-button         pointer.
       01  quit-button         pointer.
       01  message-box         pointer.
       01  help-button         pointer.

       local-storage section.
      * This allows us to have recursion

       linkage section.
       01  ba-widget       pic x(4) comp-5.
       01  ba-client       usage pointer.
       01  ba-call     usage pointer.

       procedure division.
       main-control section.
      * Initialise parameter handling
           set args to address of all-args ( 1 )

      * Initialize the X toolkit.
           call "XtInitialize" using "demo" & c-null,
           "demo" & c-null, by value 0, 0,
           by reference argc, argv
           returning root-widget

           if root-widget = null then
           display "Could not initialise, check DISPLAY, and"
           display "connection to server."
           stop run
           end-iF

      * Create a main-window
           perform new-args
           set arg-name to address of XmNwidth
           move 500 to arg
           perform set-arg
           set arg-name to address of XmNheight
           move 500 to arg
           perform set-arg
           call "XmCreateMainWindow" using by value root-widget,
           by content "mainWindow" & c-null,
           by value args, nargs
           returning main-window
            if main-window = null then
           display "Error creating main-window"
           stop run
           end-if
           call "XtManageChild" using by value main-window

      * Create a bulletin board as the child of the main window
           perform new-args
           set arg-name to address of XmNwidth
           move 500 to arg
           perform set-arg
           set arg-name to address of XmNheight
           move 500 to arg
           perform set-arg
           call "XmCreateBulletinBoard" using by value main-window,
           by content "bulletinBoard" & c-null,
           by value args, nargs
           returning bulletin-board
           if bulletin-board = null then
           display "Error creating bulletin-board"
           stop run
           end-if
           call "XtManageChild" using by value bulletin-board

      * Create the menu bar
           perform new-args
           call "XmCreateMenuBar" using by value main-window,
           by content "menuBar" & c-null,
           by value args, nargs
           returning menu-bar
           if menu-bar = null then
           display "Error creating menu-bar"
           stop run
           end-if

      * Create the pulldown and menu shell
           perform new-args
           call "XmCreatePulldownMenu" using by value menu-bar,
           by content "pullDown" & c-null,
           by value args, nargs
           returning pull-down
           if pull-down = null then
           display "Error creating pull-down"
           stop run
           end-if

      * Create the menu cascade button
           perform new-args
           set arg-name to address of XmNsubMenuId
           move pull-down-comp5 to arg
           perform set-arg
           set arg-name to address of XmNmnemonic
           move h"46" to arg
           perform set-arg
           call "XmCreateCascadeButton" using by value menu-bar
           by content "File" & c-null,
           by value args, nargs
           returning cascade
           if cascade = null then
           display "Error creating cascade"
           stop run
           end-if

      * Put a menu item in the pull-down
           perform new-args
           set arg-name to address of XmNmnemonic
           move h"51" to arg
           perform set-arg
           call "XmCreatePushButtonGadget" using by value pull-down,
           by content "Quit" & c-null,
           by value args, nargs
           returning quit-button
           if quit-button = null then
           display "Error creating quit-button"
           stop run
           end-if
           set proc-pointer to entry "quit-activated"
           call "XtAddCallback" using by value quit-button,
           by reference XmNactivateCallback,
           by value proc-pointer, 0

      * Manage the menu children
           call "XtManageChild" using by value quit-button
           call "XtManageChild" using by value cascade
           call "XtManageChild" using by value menu-bar

      * Set up the main window
           call "XmMainWindowSetAreas" using by value main-window,
           menu-bar, 0, 0, 0, bulletin-board


      * Create the push-button
           perform new-args
           call "XmStringCreateSimple" using "Push Me" & c-null,
           returning arg
           set arg-name to address of XmNlabelString
           perform set-arg
           set arg-name to address of XmNx
           move 200 to arg
           perform set-arg
           set arg-name to address of XmNy
           move 200 to arg
           perform set-arg
           call "XmCreatePushButton" using by value bulletin-board,
           by content "pushButton" & c-null,
           by value args, nargs
           returning push-button
           if push-button = null then
           display "Error creating push-button"
           stop run
           end-if
           call "XtManageChild" using by value push-button

      * Add a callback so we can tell when the button has been pressed
           set proc-pointer to entry "button-activated"
           call "XtAddCallback" using by value push-button,
           by reference XmNactivateCallback,
           by value proc-pointer, 0

      * Create the information message box which will be displayed
      * later.
           perform new-args
           call "XmStringCreateSimple" using "You pressed the button" &
           c-null,
           returning arg
           set arg-name to address of XmNmessageString
           perform set-arg
           call "XmStringCreateSimple" using "Button pressed" & 
                c-null,
           returning arg
           set arg-name to address of XmNdialogTitle
           perform set-arg
           call "XmCreateInformationDialog",
           using by value bulletin-board,
           by content "infoDialog",
           by value args, nargs
           returning message-box
           if message-box = null then
           display "Error creating message-box"
           stop run
           end-if

      * Unmanage the help button so that it does not get displayed
           call "XmMessageBoxGetChild" using by value message-box,
           XmDIALOG-HELP-BUTTON
           returning help-button
           call "XtUnmanageChild" using by value help-button

      * We can now "realize" the widget hierachy, this will actually
      * create the windows.
           call "XtRealizeWidget" using by value root-widget

      * Call Xt to loop forever, reading events from the event queue
      * and dispatching them. This will cause our call-backs to get
      * activated when appropriate.
           call "XtMainLoop"

      * We should never get here!
           display "HELP! Fell out of XtMainLoop!!"
           stop run.

           entry "quit-activated" using ba-widget, ba-client, ba-call
      * We get here when the menu quit has been pressed, ba-widget
      * is the widget, ba-client is the client-data and ba-call
      * is the call-data.
           stop run.

           entry "button-activated" using ba-widget, ba-client, ba-call
      * We get here when the push button has been pressed.
           call "XtManageChild" using by value message-box
           exit program.

      * Some useful sections:

       new-args section.
      * Simply set the number of arumnents to zero.
           move 0 to nargs.

       set-arg section.
           add 1 to nargs
           set name-tab ( nargs ) to arg-name
           move arg to arg-tab ( nargs ).
