      $set ans85 mf align(4) nobound
      $set callfh"FHREDIR"

      ****************************************************************
      * Copyright Micro Focus Limited 1994-95. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      ****************************************************************
      *            PROGRAM  WR2TEST                                  *
      * A test program to time operations on an indexed file,        *
      * timing 100 writes and 100 reads on two files.                *
      * The programs must be given a parameter which is the 1st      *
      * record to start using, ie 1000, 2000 etc. It is up to the    *
      * operator to ensure the numbers are all at least 1000 apart or*
      * an error will occur. No parameter or a parameter of 0        *
      * indicates it is the controlling program and it should be     *
      * started last. The 0 program will create the test file, all   *
      * the other programs will delete it and then wait for its      *
      * recreation.                                                  *
      * The Program displays two times, the first is the time        *
      * required to write 100  records and the second is the time to *
      * read them back. We read them back in the order 1,51,2,52     *
      * etc.                                                         *
      ****************************************************************

       ENVIRONMENT DIVISION.

       input-output section.
      *--------------------
       select file-one assign to "fileone.dat"
           organization is indexed
           access is dynamic
           lock mode is automatic with lock on record
           record key is prime-one
           alternate record key is second-one with duplicates
           file status is file-one-status.

       select file-two assign to "filetwo.dat"
           organization is indexed
           access is dynamic
           lock mode is automatic with lock on record
           record key is prime-two
           alternate record key is second-two with duplicates
           file status is file-two-status.

       DATA DIVISION.
      *-------------
       file section.
      *------------
       fd file-one.
       01 record-one.
           03 prime-one                     pic x(30).
           03 second-one                       pic x(30).
           03 data-one                      pic x(200).

       fd file-two.
       01 record-two.
           03 prime-two                     pic x(30).
           03 second-two                       pic x(30).
           03 data-two                      pic x(200).

       working-storage section.
      *-----------------------
       01 prime-value         pic 9(6) value ZERO.
       01 step-value          pic 9(6) value ZERO.
       01 temp-value          pic 9(6).
       01 sec-values.
           03 sec-10          pic x(30) value all "j".
           03 sec-09          pic x(30) value all "i".
           03 sec-08          pic x(30) value all "h".
           03 sec-07          pic x(30) value all "g".
           03 sec-06          pic x(30) value all "f".
           03 sec-05          pic x(30) value all "e".
           03 sec-04          pic x(30) value all "d".
           03 sec-03          pic x(30) value all "c".
           03 sec-02          pic x(30) value all "b".
           03 sec-01          pic x(30) value all "a".
       01 filler redefines sec-values.
           03 sec-data pic x(30) occurs 10.
       01 sec-index           pic 99.
       01 rec-data            pic x(200) value all "aaaaabbbbb".
       01 save-prime          pic 9(6).

       01 file-one-status.
           03 f1-status-key-1    pic x.
           03 f1-status-key-2    pic x.
           03 status-key-bin redefines f1-status-key-2 pic x comp-x.
       01 key-2-disp          pic 999.

       01 file-two-status.
           03 f2-status-key-1 pic x.
           03 f2-status-key-2 pic x.

       01 wrk-count               pic 9(3).
       01 work-msg                pic x(20).

       01 cfh-code                pic xx comp-x.
       01 ret-val                 pic xx comp-x.
       01 ret-bytes               redefines ret-val.
          03 ret-val1             pic x comp-x.
          03 ret-val2             pic x comp-x.
       01 disp-val1               pic 999.
       01 disp-val2               pic 999.

       01 loop-ctrl               pic xx comp-x.
       01 first-key               pic 9(6).
       01 end-key                 pic 9(6).
       01 start-time              pic 9(8).

       01                         redefines start-time.
         03 start-hh              pic 99.
         03 start-mm              pic 99.
         03 start-ss              pic 99.
         03 start-cc              pic 99.
       01 start-seconds           pic 9(8) comp.
       01 end-time                pic 9(8).
       01                         redefines end-time.
         03 end-hh                pic 99.
         03 end-mm                pic 99.
         03 end-ss                pic 99.
         03 end-cc                pic 99.
       01 end-seconds             pic 9(8) comp.
       01 time-taken              pic 99999999V99 COMP.
       01 disp-time               pic 99999999.99.
       01 save-time               pic 99999999.99.

       01 cmd-line                pic x(80).
       01 cmd-index               pic xx comp-x.

      * ONLY VARY MAX LOOPS TO CHANGE REPETITIONS
       78 max-loops                value 2.
       78 max-dups                 value 10.
       78 max-records              value max-dups * max-loops.


       PROCEDURE DIVISION.
      *------------------

       main-function.
           perform get-start-number
           perform delete-file
           if first-key > 0
               perform wait-for-file
           end-if
           perform open-file
           if f1-status-key-1 = ZERO and f2-status-key-1 = ZERO
           then
               display "Test started"
               perform main-loop
               perform file-close
           else
               display "Open error - run aborted"
               perform disp-status
           end-if.
       stop run
       exit.

      *********************************************************
      * The main code which checks the time and displays this *
      * after the writes and the reads.                       *
      *********************************************************
       main-loop.
               accept start-time from time
               perform write-records
               accept end-time from time
               compute start-seconds = (start-hh * 3600 + start-mm * 60
                                  + start-ss) * 100 + start-cc
               compute end-seconds = (end-hh * 3600 + end-mm * 60
                                  + end-ss) * 100 + end-cc
               if end-seconds < start-seconds
                   move 8640000 to time-taken
                   subtract start-seconds from time-taken
                   add end-seconds to time-taken

               else
                   move end-seconds to time-taken
                   subtract start-seconds from time-taken
               end-if
               divide 100 into time-taken
               move time-taken to disp-time
               move disp-time to save-time
               if f1-status-key-1 not = 0 and f2-status-key-1 not = 0
               then
                   display "File error"
                   perform disp-status
                   rollback
                   perform file-close
                   stop run
               else
      *            Now we shall read file
                   accept start-time from time
                   perform read-records
               end-if
               accept end-time from time
               compute start-seconds = (start-hh * 3600 + start-mm * 60
                                  + start-ss) * 100 + start-cc
               compute end-seconds = (end-hh * 3600 + end-mm * 60
                                  + end-ss) * 100 + end-cc
               if end-seconds < start-seconds
                   move 8640000 to time-taken    *> seconds in 24hrs
                   subtract start-seconds from time-taken
                   add end-seconds to time-taken

               else
                   move end-seconds to time-taken
                   subtract start-seconds from time-taken
               end-if
               divide 100 into time-taken
               move time-taken to disp-time
               display " "
               display "Time taken for WRITEs : " with no advancing
               display save-time
               display "Time taken for READs : " with no advancing
               display disp-time
       exit.
      *
      ****************************************************************
      * get start number gets a number as a parameter on the command *
      * line or if none exists uses the value 0                      *
      ****************************************************************
       get-start-number.
           accept cmd-line from command-line
           perform varying cmd-index from 1 by 1 until
                    cmd-line( cmd-index : 1) = " "
           end-perform
           subtract 1 from cmd-index
           if cmd-index > 0
               move cmd-line(1:cmd-index) to first-key
           else
               move 0 to first-key
           end-if
       exit.


      *
      ****************************************
      * wait for the test file to be created *
      ****************************************
       wait-for-file.
           display "Waiting for test file"
           perform with test after until f2-status-key-1 = "0"
               open input file-two
           end-perform
           perform with test after until f1-status-key-1 = "0"
               open input file-one
           end-perform
           close file-one
           close file-two
       .
      *
      *******************
      * Delete the file *
      *******************
       delete-file.
           display "File deletes"
           delete file file-one
           delete file file-two
       .
      *
      *************************************************************
      * Lets open for creation our indexed file                   *
      *************************************************************
       open-file.
           open i-o file-one
           open i-o file-two
       .

      *********************************************
      * close the file is fairly straight forward *
      *********************************************
       file-close.
           close file-one.
           close file-two.
       .

      **********************************************
      * Write records has to write 100 records,   *
      * repeating the 10 predefined secondary keys.*
      * 10 times each                             *
      **********************************************
       write-records.
           move first-key to prime-value
           perform sec-loop varying sec-index from 1 by 1 until
               sec-index > max-dups.
       exit.

       sec-loop.
           move prime-value to save-prime
           move 1 to cfh-code
           move save-prime to prime-value
           perform prime-loop max-loops times
           if f1-status-key-1 not = ZERO and f2-status-key-1 not = ZERO
           then
               display "write error"
               perform disp-status
           end-if
       exit.

       prime-loop.
           if f1-status-key-1 = ZERO and f2-status-key-1 = ZERO
           then
               move sec-data (sec-index) to second-one second-two
               move prime-value to prime-one prime-two
               move rec-data to data-one data-two
               display "Write record " prime-value
               write record-one
               write record-two
               add 1 to prime-value
           end-if
       exit.
      *****************************************************************
      * Read records will read the records written but attempt to     *
      * put some head movement into the job by spliiting the          *
      * range of records into 2 and reading a record from each range *
      *****************************************************************
       read-records.
           move max-records to step-value
           divide 2 into step-value
           move step-value to end-key
           add first-key to end-key
           perform pread-loop varying prime-value from first-key by 1
                                          until prime-value = end-key
       exit.
       pread-loop.
           display "Read record " prime-value
           move prime-value to prime-one prime-two
           read file-one into record-one
           read file-two into record-two
           if f1-status-key-1 not = ZERO and f2-status-key-1 not = ZERO
           then
               display "read error"
               perform disp-status
           end-if
           move prime-value to temp-value
           add step-value to temp-value
           move temp-value to prime-one prime-two
           display "Read record " temp-value
           read file-one into record-one
           read file-two into record-two
           if f1-status-key-1 not = ZERO and f2-status-key-1 not = ZERO
           then
               display "read error"
               perform disp-status
           end-if
       exit.

      ******************
      *Disp-status
      ******************
       disp-status.
           display "record ",prime-one
           if f1-status-key-1 = "0"
               move file-two-status to file-one-status
           end-if
           if f1-status-key-1 = "9"
               move status-key-bin to key-2-disp
           else
               move f1-status-key-2 to key-2-disp
           end-if
           move spaces to work-msg
           string f1-status-key-1 delimited by size
                  " " delimited by size
                  key-2-disp delimited by size
                  " " delimited by size
                  into work-msg
           display work-msg
           perform file-close
           stop run
       exit.
