      $set ans85 mf align(4) nobound
      $set callfh"FHREDIR"

      ****************************************************************
      * Copyright Micro Focus Limited 1994-95. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      ****************************************************************
      *            PROGRAM  TPTEST                                   *
      * A test program to time operations on an indexed file,        *
      * timing 1000 writes and 1000 reads.                           *
      * The programs must be given a parameter which is the 1st      *
      * record to start using, ie 1000, 2000 etc. It is up to the    *
      * operator to ensure the numbers are all at least 1000 apart or*
      * an error will occur. No parameter or a parameter of 0        *
      * indicates it is the controlling program and it should be     *
      * started last. The 0 program will create the test file, all   *
      * the other programs will delete it and then wait for its      *
      * recreation.                                                  *
      * The file to use is determined by the environment variable    *
      * TESTFILE, allowing std extfh or fileshare to be used without *
      * requiring any change to the program.                         *
      * The Program displays two times, the first is the time        *
      * required to write 1000 records and the second is the time to *
      * read them back. We read them back in the order 1,501,2,502   *
      * etc.                                                         *
      ****************************************************************

       ENVIRONMENT DIVISION.

       input-output section.
      *--------------------
       select lgind-file assign to "fileone.dat"
           organization is indexed
           access is dynamic
           lock mode is automatic with rollback
           record key is lg-prime
           alternate record key is lg-sec with duplicates
           file status is lgind-status.

       DATA DIVISION.
      *-------------
       file section.
      *------------
       fd lgind-file.
       01 lg-rec.
           03 lg-prime                     pic x(30).
           03 lg-sec                       pic x(30).
           03 lg-data                      pic x(200).

       working-storage section.
      *-----------------------
       01 prime-value         pic 9(6) value ZERO.
       01 step-value          pic 9(6) value ZERO.
       01 temp-value          pic 9(6).
       01 sec-values.
           03 sec-10          pic x(30) value all "j".
           03 sec-09          pic x(30) value all "i".
           03 sec-08          pic x(30) value all "h".
           03 sec-07          pic x(30) value all "g".
           03 sec-06          pic x(30) value all "f".
           03 sec-05          pic x(30) value all "e".
           03 sec-04          pic x(30) value all "d".
           03 sec-03          pic x(30) value all "c".
           03 sec-02          pic x(30) value all "b".
           03 sec-01          pic x(30) value all "a".
       01 filler redefines sec-values.
           03 sec-data pic x(30) occurs 10.
       01 sec-index           pic 99.
       01 rec-data            pic x(200) value all "data".
       01 save-prime          pic 9(6).

       01 lgind-status.
           03 status-key-1    pic x.
           03 status-key-2    pic x.
           03 status-key-bin redefines status-key-2 pic x comp-x.
       01 key-2-disp          pic 999.

       01 wrk-count               pic 9(3).
       01 work-msg                pic x(20).

       01 cfh-code                pic xx comp-x.
       01 ret-val                 pic xx comp-x.
       01 ret-bytes               redefines ret-val.
          03 ret-val1             pic x comp-x.
          03 ret-val2             pic x comp-x.
       01 disp-val1               pic 999.
       01 disp-val2               pic 999.

       01 loop-ctrl               pic xx comp-x.
       01 first-key               pic 9(6).
       01 end-key                 pic 9(6).
       01 start-time              pic 9(8).

       01                         redefines start-time.
         03 start-hh              pic 99.
         03 start-mm              pic 99.
         03 start-ss              pic 99.
         03 start-cc              pic 99.
       01 start-seconds           pic 9(8) comp.
       01 end-time                pic 9(8).
       01                         redefines end-time.
         03 end-hh                pic 99.
         03 end-mm                pic 99.
         03 end-ss                pic 99.
         03 end-cc                pic 99.
       01 end-seconds             pic 9(8) comp.
       01 time-taken              pic 99999999V99 COMP.
       01 disp-time               pic 99999999.99.
       01 save-time               pic 99999999.99.

       01 cmd-line                pic x(80).
       01 cmd-index               pic xx comp-x.

      * ONLY VARY MAX LOOPS TO CHANGE REPETITIONS
       78 max-loops                value 2.
       78 max-dups                 value 10.
       78 max-records              value max-dups * max-loops.


       PROCEDURE DIVISION.
      *------------------

       main-function.
           perform get-start-number
           perform delete-file
           if first-key > 0
               perform wait-for-file
           end-if
           perform open-file
           if status-key-1 = ZERO
           then
               display "Test started"
               perform main-loop
               perform file-close
           else
               display "Open error - run aborted"
               perform disp-status
           end-if.
       stop run
       exit.

      *********************************************************
      * The main code which checks the time and displays this *
      * after the writes and the reads.                       *
      *********************************************************
       main-loop.
               accept start-time from time
               perform write-records
               accept end-time from time
               compute start-seconds = (start-hh * 3600 + start-mm * 60
                                  + start-ss) * 100 + start-cc
               compute end-seconds = (end-hh * 3600 + end-mm * 60
                                  + end-ss) * 100 + end-cc
               if end-seconds < start-seconds
                   move 8640000 to time-taken
                   subtract start-seconds from time-taken
                   add end-seconds to time-taken

               else
                   move end-seconds to time-taken
                   subtract start-seconds from time-taken
               end-if
               divide 100 into time-taken
               move time-taken to disp-time
               move disp-time to save-time
               if status-key-1 not = 0
               then
                   display "File error"
                   perform disp-status
                   rollback
                   perform file-close
                   stop run
               else
                   accept start-time from time
      *            Don't read the records in the TP test.
      *            perform read-records
               end-if
               accept end-time from time
               compute start-seconds = (start-hh * 3600 + start-mm * 60
                                  + start-ss) * 100 + start-cc
               compute end-seconds = (end-hh * 3600 + end-mm * 60
                                  + end-ss) * 100 + end-cc
               if end-seconds < start-seconds
                   move 8640000 to time-taken    *> seconds in 24hrs
                   subtract start-seconds from time-taken
                   add end-seconds to time-taken

               else
                   move end-seconds to time-taken
                   subtract start-seconds from time-taken
               end-if
               divide 100 into time-taken
               move time-taken to disp-time
      *        display " "
      *        display "Time taken for WRITEs : " with no advancing
      *        display save-time
      *        display "Time taken for READs : " with no advancing
      *        display disp-time
       exit.
      *
      ****************************************************************
      * get start number gets a number as a parameter on the command *
      * line or if none exists uses the value 0                      *
      ****************************************************************
       get-start-number.
           accept cmd-line from command-line
           perform varying cmd-index from 1 by 1 until
                    cmd-line( cmd-index : 1) = " "
           end-perform
           subtract 1 from cmd-index
           if cmd-index > 0
               move cmd-line(1:cmd-index) to first-key
           else
               move 0 to first-key
           end-if
       exit.


      *
      ****************************************
      * wait for the test file to be created *
      ****************************************
       wait-for-file.
           display "Waiting for test file"
           perform with test after until status-key-1 = "0"
               open input lgind-file
           end-perform
           close lgind-file
       .
      *
      *******************
      * Delete the file *
      *******************
       delete-file.
           delete file lgind-file
       .
      *
      *************************************************************
      * Lets open for creation our indexed file                   *
      *************************************************************
       open-file.
           open i-o lgind-file
       .

      *********************************************
      * close the file is fairly straight forward *
      *********************************************
       file-close.
           close lgind-file.
       .

      **********************************************
      * Write records has to write 1000 records,   *
      * repeating the 10 predefined secondary keys.*
      * 100 times each                             *
      **********************************************
       write-records.
           move first-key to prime-value
           perform varying sec-index from 1 by 1 until
                                                   sec-index > max-dups
               perform sec-loop
      *        Roll back half of the WRITEs
               if sec-index = 5
                   display "Issuing COMMIT"
                   commit
                   call "fs_status"
                   end-call
                   if return-code not = 0
                       display "COMMIT failure"
                       stop run
                   end-if
               end-if
               if sec-index = 10
                   display "Issuing ROLLBACK"
                   rollback
               end-if
           end-perform
       exit.

       sec-loop.
           move prime-value to save-prime
           move 1 to cfh-code
           move save-prime to prime-value
           perform prime-loop max-loops times
           if status-key-1 not = ZERO
           then
               display "write error"
               perform disp-status
           end-if
       exit.

       prime-loop.
           if status-key-1 = ZERO
           then
               move sec-data (sec-index) to lg-sec
               move prime-value to lg-prime
               move rec-data to lg-data
               display "Writing record " with no advancing
               display prime-value
               write lg-rec
               add 1 to prime-value
           end-if
       exit.
      *****************************************************************
      * Read records will read the records written but attempt to     *
      * put some head movement into the job by spliiting the          *
      * range of records into 2 and reading a record from each range *
      *****************************************************************
       read-records.
           move max-records to step-value
           divide 2 into step-value
           move step-value to end-key
           add first-key to end-key
           perform pread-loop varying prime-value from first-key by 1
                                          until prime-value = end-key
       exit.
       pread-loop.
           move prime-value to lg-prime
           read lgind-file into lg-rec
           if status-key-1 not = ZERO
           then
               display "read error"
               perform disp-status
           end-if
           move prime-value to temp-value
           add step-value to temp-value
           move temp-value to lg-prime
           display "Reading record " with no advancing
           display prime-value
           read lgind-file into lg-rec
           if status-key-1 not = ZERO
           then
               display "read error"
               perform disp-status
           end-if
       exit.

      ******************
      *Disp-status
      ******************
       disp-status.
           display "record ",lg-prime
           if status-key-1 = "9"
               move status-key-bin to key-2-disp
           else
               move status-key-2 to key-2-disp
           end-if
           move spaces to work-msg
           string status-key-1 delimited by size
                  " " delimited by size
                  key-2-disp delimited by size
                  " " delimited by size
                  into work-msg
           display work-msg
           perform file-close
           stop run
       exit.
