      $set ans85 mf align(4) nobound
      $set callfh "FHREDIR"

      ****************************************************************
      * Copyright Micro Focus Limited 1989-95. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      ****************************************************************
      * A test program to use transactions on an indexed file via    *
      * the FILESHARE utility timing 100 writes and 100 read-deletes.*
      * The program accepts a numeric parameter from the command line*
      * as the value to use as the first primary key.                *
      ****************************************************************

       ENVIRONMENT DIVISION.

       input-output section.

      * The following code specifies the prefix to talk to our copy of FS
      * and also specifies rollback to obtain transaction processing

       select testind-file assign to fileshare-filename
           organization is indexed
           access is dynamic
           lock mode is automatic with rollback
           record key is test-prime
           alternate record key is test-sec with duplicates
           file status is testind-status.

       DATA DIVISION.

       file section.

       fd testind-file.
       01 test-rec.
           03 test-prime                     pic 9(6) comp.
           03 test-sec                       pic x(10).
           03 test-data                      pic x(100).

       working-storage section.

       01 prime-value         pic 9(6) value zero.
       01 sec-values.
           03 sec-10          pic x(10) value "jjjjjjjjjj".
           03 sec-09          pic x(10) value "iiiiiiiiii".
           03 sec-08          pic x(10) value "hhhhhhhhhh".
           03 sec-07          pic x(10) value "gggggggggg".
           03 sec-06          pic x(10) value "ffffffffff".
           03 sec-05          pic x(10) value "eeeeeeeeee".
           03 sec-04          pic x(10) value "dddddddddd".
           03 sec-03          pic x(10) value "cccccccccc".
           03 sec-02          pic x(10) value "bbbbbbbbbb".
           03 sec-01          pic x(10) value "aaaaaaaaaa".
       01 filler redefines sec-values.
           03 sec-data pic x(10) occurs 10.
       01 sec-index           pic 99.
       01 rec-data            pic x(100)     value all "data".
       01 save-prime          pic 9(6).

       01 testind-status.
           03 status-key-1    pic x.
           03 status-key-2    pic x.
           03 status-key-bin redefines status-key-2 pic x comp-x.
       01 key-2-disp          pic 999.

       01 work-msg                pic x(20).

       01 fs-code                 pic xx comp-x.
       01 ret-val                 pic xx comp-x.
       01 ret-bytes               redefines ret-val.
          03 ret-val1             pic x comp-x.
          03 ret-val2             pic x comp-x.
       01 disp-val1               pic 999.
       01 disp-val2               pic 999.

       01 loop-ctrl               pic xx comp-x.
       01 first-key               pic 9(6).
       01 end-key                 pic 9(6).
       01 start-time              pic 9(8).

       01                         redefines start-time.
         03 start-hh              pic 99.
         03 start-mm              pic 99.
         03 start-ss              pic 99.
         03 start-cc              pic 99.
       01 start-seconds           pic 9(8) comp.
       01 end-time                pic 9(8).
       01                         redefines end-time.
         03 end-hh                pic 99.
         03 end-mm                pic 99.
         03 end-ss                pic 99.
         03 end-cc                pic 99.
       01 end-seconds             pic 9(8) comp.
       01 time-taken              pic 9(8)V99 COMP.
       01 disp-time               pic 9(8).99.

       01 cmd-line                pic x(80).
       01 cmd-index               pic xx comp-x.

       01 fileshare-filename      pic x(80).

       78 max-records              value 100.
       78 max-dups                 value 10.

       78 FSHARE-FNAME             value "timetest.dat".

       01 file-open-flag          pic x    comp-x value 0.
           88 FILE-OPENED                         value 1.

       78 SUCCESSFUL                              value "00".
       78 INVALID-DUPLICATE                       value "22".
       78 RECORD-LOCKED                           value "9D".
       78 COMMUNICATION-ERROR                     value "9|".
       78 NO-VIRTUAL-FILE-REDIRECTOR              value "9".

       PROCEDURE DIVISION.

       DECLARATIVES.
       Error-file section.
           use after error procedure on testind-file.
       check-errors.
               evaluate testind-status
                   when INVALID-DUPLICATE
                       display "Restart program, with a different value
      -                "for the first primary key."
                       perform abort-run
                   when RECORD-LOCKED
                       display "Restart program, with a different value
      -                "for the first primary key."
                       perform abort-run
                   when COMMUNICATION-ERROR
                       display "Fileshare communications problem"
                       perform abort-run
                   when NO-VIRTUAL-FILE-REDIRECTOR
                       display "Couldn't find the program specified for
      -                "file redirection."
                       perform abort-run
                   when other
                       perform abort-run
               end-evaluate
               .
       END DECLARATIVES.


      *************************************************
      * The main control paragraph                    *
      * We perform the write-read/delete sequence 10  *
      * times to allow for variations in the timing.  *
      *************************************************
       main-function.
           move FSHARE-FNAME TO fileshare-filename
           perform get-start-number
           perform open-file
           if status-key-1 = ZERO
               display "Starting demo . . ."
               perform test-loop varying loop-ctrl from 1 by 1 until
                          loop-ctrl > 10
               perform file-close
               display "Demo finished."
           else
               display "Open error - run aborted"
               perform disp-status
           end-if
           exit program
           stop run
       .

      ***************************************************************
      * Accept input from the command line (assume numeric) and use *
      * this as the 1st primary key for our file.                   *
      ***************************************************************
       get-start-number.
           accept cmd-line from command-line
           perform varying cmd-index from 1 by 1 until
                    cmd-line( cmd-index : 1) = " "
           end-perform
           subtract 1 from cmd-index
           if cmd-index > 0
               move cmd-line(1:cmd-index) to first-key
           else
               move 0 to first-key
           end-if
       .

      *****************************************************************
      * This is the control paragraph for the writes and read deletes *
      * We record the time before the test start and at the end of the*
      * test we calculate and display how many seconds have passed.   *
      *****************************************************************
       test-loop.
           display "  Beginning test # " loop-ctrl
           accept start-time from time
           perform write-records
           if status-key-1 not = 0
               display "File error"
               perform disp-status
               rollback
               perform file-close
               stop run
           else
      *        Now we shall read file
               perform read-delete-records
           end-if
           accept end-time from time
           compute start-seconds = (start-hh * 3600 + start-mm * 60
                              + start-ss) * 100 + start-cc
           compute end-seconds = (end-hh * 3600 + end-mm * 60
                              + end-ss) * 100 + end-cc
      *    check if we have run over midnight
           if end-seconds < start-seconds
               move 8640000 to time-taken
               subtract start-seconds from time-taken
               add end-seconds to time-taken
           else
               move end-seconds to time-taken
               subtract start-seconds from time-taken
           end-if
           divide 100 into time-taken
           move time-taken to disp-time
           display "     Total time for this test: " disp-time
       .
      *
      *************************************************************
      * Lets open for creation our indexed file                   *
      *************************************************************
       open-file.
           open i-o testind-file
           if testind-status equal SUCCESSFUL
               set FILE-OPENED to true
           end-if
       .

      *********************************************
      * close the file is fairly straight forward *
      *********************************************
       file-close.
           close testind-file
       .

      **********************************************
      * Write records has to write 100 records,    *
      * repeating the 10 predefined secondary keys.*
      * 10 times each                              *
      **********************************************
       write-records.
           move first-key to prime-value
           perform sec-loop varying sec-index from 1 by 1 until
               sec-index > max-dups
       .
      **************************************************************
      * Write 10 records with the same secondary key, if an        *
      * error occurs then rollback the transaction and start again,*
      * if no error occurs then commit the transaction and return. *
      **************************************************************
       sec-loop.
           move prime-value to save-prime
           move 1 to fs-code
           perform until status-key-1 = ZERO and
                         fs-code = 0
               move save-prime to prime-value
               perform prime-loop max-dups times
               if status-key-1 not = ZERO
                   rollback
               else
                   commit
               end-if
               call "fs_status" returning fs-code
               if fs-code not = 0
                   display "commit/rollback failure"
                   perform disp-status
               end-if
           end-perform
       .

       prime-loop.
           if status-key-1 = ZERO
               move sec-data (sec-index) to test-sec
               move prime-value to test-prime
               move rec-data to test-data
               write test-rec
               add 1 to prime-value
           end-if
       .

      ***********************************************************
      * Read and delete the 100 records in our file as a single *
      * transaction. Check the status of the commit and display *
      * if an error occurs.                                     *
      ***********************************************************
       read-delete-records.
           move max-records to end-key
           add first-key to end-key
           perform pread-loop varying test-prime from first-key by 1
                                              until test-prime = end-key
           commit
      *    if the commit succeeded then we will have a zero return code
      *    from the fs_status routine
           call "fs_status" returning fs-code
           if fs-code not = 0
               display "commit failure"
               perform disp-status
           end-if
       .
       pread-loop.
           read testind-file into test-rec
           if status-key-1 not = ZERO
               display "read error"
               perform disp-status
           else
               delete testind-file record
           end-if
       .

      ****************************************************
      *Display the File status and Fileshare return code.*
      ****************************************************
       disp-status.
           call "fs_status" returning fs-code
           move fs-code to ret-val
           move ret-val1 to disp-val1
           move ret-val2 to disp-val2
           if status-key-1 = "9"
               move status-key-bin to key-2-disp
           else
               move status-key-2 to key-2-disp
           end-if
           move spaces to work-msg
           string status-key-1 delimited by size
                  " " delimited by size
                  key-2-disp delimited by size
                  " " delimited by size
                  disp-val1 delimited by size
                  " " delimited by size
                  disp-val2 delimited by size
                  into work-msg
           display work-msg
           if FILE-OPENED
               perform file-close
           end-if
           stop run
       .

       abort-run.
           perform disp-status
           stop run
           .
