      ****************************************************************
      * Copyright Micro Focus Limited 1984-91. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      ************************************************************************
      *
      *	Micro Focus Ltd,
      *	26 West Street, Newbury, Berkshire, United Kingdom.             
      *	(0635) 32646
      *
      *	Filehandler Utilities Demos
      *
      *	Source Module validate2.cbl	Sccs Identification 1.2
      *
      *	Last Modified on 91/06/25 at 10:26:25
      *
      ************************************************************************

      * static	char *SccsId = "@(#)validate2.cbl	1.2";

      $set NOWARNING
      * This calls fhvalidate to validate the file corrupt
      * This also demonstrates the use of the cob_util_last_error
      * variable and demonstrates how to decode it to provide
      * a standard error code


        working-storage section.


      * Variable that contains the error code. Underscores are replaced
      * by hyphens so the name is COBOL conforming. Decoding is
      * identical to that of the COBOL file status.


        01 cob-util-last-error is external.
           02 last-error-byte1  pic x.
           02 last-error-byte2  pic x.
          

        01 file-status-bin redefines cob-util-last-error pic 9(4) COMP.
        01 file-status-1        pic x.      
        01 file-status-2        pic 999.


        01 noargs pic 9(2) comp-5 value zero.
        01 arg1 pic x(10) value spaces.
        01 arg2 pic x(12) value spaces.
        01 arg3 pic x(16) value spaces.
        01 arg4 pic x(10) value low-values.
        01 arg5 pic x(10) value low-values.
        01 arg6 pic x(10) value low-values.

        PROCEDURE DIVISION.

        display "Demo3 - Using fhvalidate and fhrebuild" at 0301
          with highlight.
        display "--------------------------------------" at 0401
        display "This program calls fhvalidate to validate the file" 
           at 0601
        display "Called corrupt" at 0701.
        display 
        "The output from fhvalidate will be placed on the screen"
          at 0901.
        display "For further details, refer to the section in your "
          at 1101.
        display 
        "Filehandler Utilities guide detailing these demonstrations"
          at 1201
        display space at 1401
        stop "Press return to commence validation"
        move 3 to noargs.
        move "fhvalidate" to arg1.
        move "-rv" to arg2.
        move "validate.val" to arg3
        call "cobcallfhutil" using by value noargs,
                             by reference arg1,
                             by reference arg2,
                             by reference arg3,
                             by reference arg4,
                             by reference arg5,
                             by reference arg6.


      * See your operating guide section entitled INPUT-OUTPUT ERROR HANDLING
      * for an explanation of the following file status decoding

        move last-error-byte1 to file-status-1.

        if last-error-byte1 not = 9
           move last-error-byte2 to file-status-2
        else
           move low-values to last-error-byte1
           move file-status-bin to file-status-2
        end-if
        display spaces
        display "The following is the COBOL file status returned"

        display "status 1 - " file-status-1
        display "status 2 - " file-status-2
