      ****************************************************************
      * Copyright Micro Focus Limited 1984-91. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      ************************************************************************
      *
      *	Micro Focus Ltd,
      *	26 West Street, Newbury, Berkshire, United Kingdom.             
      *	(0635) 32646
      *
      *	Filehandler Utilities Demos
      *
      *	Source Module edit.cbl	Sccs Identification 1.2
      *
      *	Last Modified on 91/06/25 at 10:26:15
      *
      ************************************************************************

      * static	char *SccsId = "@(#)edit.cbl	1.2";

      **************************************************************************
      * This demonstration writes to the file you created by running fhcreate
      * and then edited by running fhedit
      *
      * For each line of COBOL in the file declaration there is a comment
      * showing the output that will be produced by the fhinfo utility for the
      * particular line.
      *
      **************************************************************************

         select demofile assign "demofile3"

      *****fhinfo will output ******
      * IN demofile3
      ******************************

         organization is indexed

      *****fhinfo will output ******
      * IT I0
      ******************************

         access mode is dynamic 
         record key is demo4-key

         alternate key is demo4-alt-key with duplicates
         alternate key is demo4-alt-key2
         alternate key is demo4-alt-key3
      $set keycompress(7)
         alternate key is demo4-alt-key4 with duplicates
         file status is fstat.
 
         file section.
         fd demofile.
     
      *****fhinfo will output ******
      * IF 20
      ******************************

         01 demo-record.
            
            02 demo4-key.
               03 filler         pic x(7).
               03 demo4-alt-key4 pic x.

      *****fhinfo will output ******
      * PK (0:8:CHARTYPE) 
      * AK DC(7:1:CHARTYPE)
      ******************************

            02 demo4-alt-key     pic 9(4).

      *****fhinfo will output ******
      * AK D(8:4:CHARTYPE) 
      ******************************

            02 demo4-alt-key2    pic 9(2).

      *****fhinfo will output ******
      * AK (12:2:CHARTYPE) 
      ******************************
            02 filler            pic x(2).

            02 demo4-alt-key3    pic 9(4).

      *****fhinfo will output ******
      * AK (16:4:CHARTYPE) 
      ******************************
 
         working-storage section.
         01 fstat      pic xx.

         procedure division.

         display "Demo2 - Reading and writing the edited file"
           with highlight at 0301.
         display "-------------------------------------------"
           at 0401
         display space at 0601
         open I-O demofile.
         if fstat not = "00"
            display 
            "ERROR - You have not created the file yet, see you manual".
         

         move all "a" to demo4-key.
         move 9999 to demo4-alt-key.
         move 9999 to demo4-alt-key2.
         move 9999 to demo4-alt-key3.
         move 9    to demo4-alt-key4.


         display "writing a record to the file"

         write demo-record.

         if fstat = "00"
            display "Write successful"
         else
            display "Write failed file status - "fstat

         display "reading a record from the file"

         read demofile key is demo4-alt-key4.

         if fstat = "00"
            display "Read the record back successfully"
         else
            display "Failed to read the record back file status - "fstat.

         close demofile.

         stop run.
