      ****************************************************************
      * Copyright Micro Focus Limited 1984-91. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      ************************************************************************
      *
      *	Micro Focus Ltd,
      *	26 West Street, Newbury, Berkshire, United Kingdom.             
      *	(0635) 32646
      *
      *	Filehandler Utilities Demos
      *
      *	Source Module convert.cbl	Sccs Identification 1.2
      *
      *	Last Modified on 91/06/25 at 10:26:27
      *
      ************************************************************************

      * static	char *SccsId = "@(#)convert.cbl	1.2";

      **************************************************************************
      * This demonstration produces a file to be used as a demonstration file
      * for use with the fhconvert filehandler utility.
      *
      * For each line of COBOL in the file declaration there is a comment
      * showing the output that will be produced by the fhinfo utility for the
      * particular line.
      *
      **************************************************************************

      $SET DATACOMPRESS(1)
         select demofile assign "demofile4"

      *****fhinfo will output ******
      * IN demo1
      ******************************

         organization is indexed

      *****fhinfo will output ******
      * IT I0
      ******************************

         access mode is dynamic 
         record key is demo1-key

      $set KEYCOMPRESS(7)
         alternate key is demo1-alt-key with duplicates
         alternate key is demo1-alt-key2
         alternate key is demo1-alt-key3.
 
         file section.
         fd demofile.
     
      *****fhinfo will output ******
      * IF 20
      ******************************

         01 demo-record.

            02 demo1-key         pic x(8).

      *****fhinfo will output ******
      * PK (0:8:CHARTYPE) 
      ******************************

            02 demo1-alt-key     pic 9(4).

      *****fhinfo will output ******
      * AK D(8:4:CHARTYPE) 
      ******************************

            02 demo1-alt-key2    pic 9(4).

      *****fhinfo will output ******
      * AK (12:4:CHARTYPE) 
      ******************************

            02 demo1-alt-key3    pic 9(4).

      *****fhinfo will output ******
      * AK (12:4:CHARTYPE) 
      ******************************

         working-storage section.
         01 record1  pic x(20) value "aaaaaaaa111111111111".
         01 record2  pic x(20) value "bbbbbbbb222222222222".
         01 record3  pic x(20) value "cccccccc333333333333".

         procedure division.

         display "Demo4 - Using fhconvert" at 0301 with highlight.
         display "-----------------------" at 0401.
         display 
         "This creates a file which will you can convert to other"
            at 0601,
         display "file types. This file is called demofile4" at 0701
         display "For further details, refer to the section in your "
          at 0901.
         display 
        "Filehandler Utilities guide detailing these demonstrations"
          at 1001
         display space at 1179
         open output demofile.

         write demo-record from record1.
         write demo-record from record2.
         write demo-record from record3.

         close demofile.

         stop run.
