      *
      * @(#)datecall.cbl        1.4
      $SET NESTCALL ANS85 MF(3)

      ****************************************************************
      * Copyright Micro Focus Limited 1989-94. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

       IDENTIFICATION DIVISION.
       PROGRAM-ID. DATECALL.
      ****************************************************************
      *   DATECALL is a test program for the subprogram "DATECHK".   *
      *   DATECALL shows the user the results of calling DATECHK".   *
      *   by providing a window into the Linkage fields.             *
      ****************************************************************
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
           CRT STATUS IS ACPT-END-STAT
           CURSOR IS CURSOR-POSITION.

       DATA DIVISION.
       WORKING-STORAGE SECTION.

       01  CURSOR-POSITION             PIC 9(4).
       01  HELP-SCREEN-ID              PIC AA          VALUE "AA".
       01  ALARM                       PIC X           VALUE X"E5".
       01  ACPT-END-STAT.
           03  ACPT-END-STAT1  PIC X VALUE "0".
               88  TERM-OR-AUTO-SKIP   VALUE "0".
               88  FUNCTION-KEY        VALUE "1".
           03  ACPT-END-STAT2  PIC X VALUE "0".
               88  TERMINATE-CHAR      VALUE "0".
               88  ESC-IS-PRESSED      VALUE X"00".
               88  F1-IS-PRESSED       VALUE X"01".
               88  F2-IS-PRESSED       VALUE X"02".
           03  ACPT-END-STAT3  PIC X VALUE "0".
       01  SCREEN-IO           PIC X               VALUE X"B7".
       01  WRITE-ATTR          PIC 99      COMP.
       01  FORM-PARAMS.
           03 IO-LENGTH        PIC 9(4)    COMP.
           03 SCREEN-OFFSET    PIC 9(4)    COMP.
           03 BUFFER-OFFSET    PIC 9(4)    COMP.

           COPY "datescrn.DDS".

       01    datescrn-DATA     REDEFINES   datescrn-00   .
           03 FILLER           PIC X(0841).
           03 DATE-IN          PIC X(0008).
           03 FILLER           PIC X(0090).
           03 FORMAT-INDICATOR PIC X(0001).
           03 FILLER           PIC X(0382).
           03 DAY-NAME-OUT     PIC X(0003).
           03 FILLER           PIC X(0077).
           03 MONTH-NAME-OUT   PIC X(0003).
           03 FILLER           PIC X(0001).
           03 DAY-NO-OUT       PIC X(0002).
           03 FILLER           PIC X(0001).
           03 YEAR-NO-OUT      PIC X(0004).
           03 FILLER           PIC X(0068).
           03 DAY-COUNT-OUT    PIC X(0005).
           03 FILLER           PIC X(0114).

       01  DATEPROM-00-ATTR.
           03 FILLER           PIC X(0080) VALUE ALL X"00".
           03 FILLER           PIC X(0002) VALUE ALL X"01".
           03 FILLER           PIC X(0007) VALUE ALL X"00".
           03 FILLER           PIC X(0002) VALUE ALL X"01".
           03 FILLER           PIC X(0021) VALUE ALL X"00".
           03 FILLER           PIC X(0004) VALUE ALL X"01".
           03 FILLER           PIC X(0014) VALUE ALL X"00".
           03 FILLER           PIC X(0003) VALUE ALL X"01".
           03 FILLER           PIC X(0027) VALUE ALL X"00".
           03 FILLER           PIC X(0080) VALUE ALL X"01".
       01  DATEPROM-00   .
           03 DATEPROM-00-0101 PIC X(0080) VALUE "Actions---------------
      -    "----------------------------------------------------------".
           03 DATEPROM-00-0201 PIC X(0056) VALUE "F1=help  F2=clear retu
      -    "rn areas  C/R Call program  Escape".
           03 FILLER           PIC X(0104) VALUE SPACES.
       01  DATEPROM-01    REDEFINES DATEPROM-00   .
           03 FILLER           PIC X(0024).
           03 FORMAT-MSG       PIC X(0020).
           03 FILLER           PIC X(0116).
           03 RESULT-MSG       PIC X(0030).
           03 FILLER           PIC X(0050).

       01  DATE-YYMMDD.
           03  DATE-YY                 PIC 99.
           03  DATE-MM                 PIC 99.
           03  DATE-DD                 PIC 99.

       01  INPUT-DATE                  PIC X(8).
       01  USA-OR-UK                   PIC X.
           88  USA     VALUE  "U".
           88  UK      VALUE  "E".
       01  OUTPUT-DATE.
           02  DAY-NAME                PIC XXX.
           02  DAY-NO                  PIC XX.
           02  MONTH-NAME              PIC XXX.
           02  YEAR-NO                 PIC XXXX.
           02  DAYS-SINCE-JAN-1-1900   PIC X(5).
      /
       PROCEDURE DIVISION.
       DATE-GET SECTION.
       INITIALISE.
           DISPLAY SPACE UPON CRT.
           ACCEPT DATE-YYMMDD FROM DATE.
           MOVE DATE-DD TO datescrn-01-1145.
           MOVE DATE-MM TO datescrn-01-1142.
           MOVE DATE-YY TO datescrn-01-1148.
           MOVE "U" TO datescrn-01-1260.

       SHOW-datescrn.
           MOVE 1600 TO IO-LENGTH.
           MOVE 1 TO SCREEN-OFFSET BUFFER-OFFSET.
           MOVE 3 TO WRITE-ATTR.
           CALL SCREEN-IO USING WRITE-ATTR FORM-PARAMS datescrn-00-ATTR.
           MOVE 1 TO WRITE-ATTR.
           CALL SCREEN-IO USING WRITE-ATTR FORM-PARAMS datescrn-00.
           PERFORM DISPLAY-datescrn-DATA.

           PERFORM UNTIL FUNCTION-Key AND Esc-IS-Pressed
               ACCEPT  datescrn-01 FROM CRT
               MOVE DATE-IN TO INPUT-DATE
               EVALUATE FORMAT-INDICATOR
                   WHEN "u"
                       MOVE "U" TO FORMAT-INDICATOR
                   WHEN "e"
                       MOVE "E" TO FORMAT-INDICATOR
               END-EVALUATE
               MOVE FORMAT-INDICATOR TO USA-OR-UK
               EVALUATE TRUE
                 WHEN TERM-OR-AUTO-SKIP AND TERMINATE-CHAR
                   CALL "DATECHK" USING INPUT-DATE,
                                        USA-OR-UK,
                                        OUTPUT-DATE
                   MOVE DAY-NAME TO DAY-NAME-OUT
                   MOVE DAY-NO TO DAY-NO-OUT
                   MOVE MONTH-NAME TO MONTH-NAME-OUT
                   MOVE YEAR-NO TO YEAR-NO-OUT
                   MOVE USA-OR-UK TO FORMAT-INDICATOR
                   MOVE DAYS-SINCE-JAN-1-1900 TO DAY-COUNT-OUT
                   PERFORM TEST-RESULTS
                   PERFORM DISPLAY-datescrn-DATA
                WHEN FUNCTION-KEY AND F1-IS-PRESSED
                   CALL "$COBDIR/help" USING HELP-SCREEN-ID
                WHEN FUNCTION-KEY AND F2-IS-PRESSED
                   MOVE SPACES TO DAY-NAME-OUT,
                                  DAY-NO-OUT,
                                  MONTH-NAME-OUT,
                                  YEAR-NO-OUT,
                                  DAY-COUNT-OUT
                   PERFORM DISPLAY-DATESCRN-DATA
                WHEN OTHER
                   call alarm
                   PERFORM DISPLAY-DATESCRN-DATA
               END-EVALUATE
           END-PERFORM
           DISPLAY SPACES UPON CRT
           EXIT PROGRAM
           STOP RUN.

       DISPLAY-DATESCRN-DATA.
           MOVE 1600 TO IO-LENGTH
           MOVE 1 TO SCREEN-OFFSET BUFFER-OFFSET
           MOVE 1 TO WRITE-ATTR
           CALL SCREEN-IO USING WRITE-ATTR FORM-PARAMS datescrn-DATA
           PERFORM DATEPROM.

       DATEPROM.
           MOVE 240 TO IO-LENGTH
           MOVE 1681 TO SCREEN-OFFSET
           MOVE 3 TO WRITE-ATTR
           MOVE 1 TO BUFFER-OFFSET
           CALL SCREEN-IO USING WRITE-ATTR FORM-PARAMS DATEPROM-00-ATTR
           MOVE 1 TO WRITE-ATTR
           CALL SCREEN-IO USING WRITE-ATTR FORM-PARAMS DATEPROM-00.

       TEST-RESULTS.
           IF UK
               MOVE " date in UK format -" TO FORMAT-MSG
           ELSE
               MOVE " date in USA format " TO FORMAT-MSG
           END-IF
           MOVE " Date is OK" TO RESULT-MSG
           IF DAY-NO = SPACE
               CALL ALARM
               CALL ALARM
               CALL ALARM
               CALL ALARM
               MOVE " Day is invalid" TO RESULT-MSG
               MOVE SPACES TO DAY-NO-OUT YEAR-NO-OUT
               IF UK
                   MOVE 1142 TO CURSOR-POSITION
               ELSE
                   MOVE 1145 TO CURSOR-POSITION
               END-IF
           ELSE
               IF MONTH-NAME = SPACE
                   CALL ALARM
                   CALL ALARM
                   CALL ALARM
                   CALL ALARM
                   MOVE " Month is invalid" TO RESULT-MSG
                   MOVE SPACES TO DAY-NO-OUT YEAR-NO-OUT
                   IF UK
                       MOVE 1145 TO CURSOR-POSITION
                   ELSE
                       MOVE 1142 TO CURSOR-POSITION
                   END-IF
               ELSE
                   IF YEAR-NO = SPACE
                        CALL ALARM
                        CALL ALARM
                        CALL ALARM
                        CALL ALARM
                        MOVE " Year is not numeric" TO RESULT-MSG
                        IF UK
                            MOVE 0956 TO CURSOR-POSITION
                        ELSE
                            MOVE 0956 TO CURSOR-POSITION
                        END-IF
                   END-IF
               END-IF
           END-IF.

       IDENTIFICATION DIVISION.
       PROGRAM-ID. DATECHK.
      ********************************************************
      *    This subprogram validates dates input in either   *
      *      EUROPEAN or USA format. The result is returned  *
      *      as day-name, day, month-name, year.             *
      *    The program also calculates days since 1:1:1900   *
      ********************************************************
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01  DAYS-IN-MONTH-TABLE         PIC X(26)
                       VALUE "31283130313031313031303129".
       01  FILLER REDEFINES DAYS-IN-MONTH-TABLE.
           03 DAYS-IN-MONTH            PIC 99          OCCURS 13.
       01  MONTH-NAME-TABLE            PIC X(36)
                       VALUE "JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC".
       01  FILLER REDEFINES MONTH-NAME-TABLE.
           03 SHORT-MONTH-NAME         PIC XXX         OCCURS 12.
       01  DAY-NAMES                   PIC X(21)
                       VALUE "MONTUEWEDTHUFRISATSUN".
       01  FILLER REDEFINES DAY-NAMES.
           03 DAY-OF-THE-WEEK          PIC XXX         OCCURS 7.
       01  LEAP-YEAR-INDICATOR         PIC 9.
           88  LEAP-YEAR   VALUE 0.
       01  SUBSCRIPT                   PIC 99.
           88  FEBRUARY    VALUE 2.
       01  QUOTIENT                    PIC 9999.
       01  WORKING-DATE.
           03  WORK-DAY                PIC 99.
           03  WORK-MONTH              PIC 99.
           03  WORK-YEAR               PIC 99.
       01  JULIAN-CALCULATION.
           03  DAYS-IN-PREVIOUS-YEARS  PIC 9(5).
           03  EXTRA-LEAP-DAYS         PIC 99.
           03  DAYS-IN-YEAR-TO-DATE    PIC 9(3).
           03  TOTAL-DAYS              PIC 9(5).
       LINKAGE SECTION.

       01  INPUT-DATE.
           03 INPUT-DAY-OR-MONTH       PIC 99.
           03 FILLER                   PIC X.
           03 INPUT-MONTH-OR-DAY       PIC 99.
           03 FILLER                   PIC X.
           03 INPUT-YEAR               PIC 99.

       01  USA-OR-UK                   PIC X.
           88  USA     VALUE  "U".
           88  UK      VALUE  "E".

       01  OUTPUT-DATE.
           02  DAY-NAME                PIC XXX.
           02  DAY-NO                  PIC XX.
           02  MONTH-NAME              PIC XXX.
           02  FULL-YEAR-NO.
               03  CENT-NO             PIC XX.
               03  YEAR-NO             PIC XX.
           02  DAYS-SINCE-JAN-1-1900   PIC X(5).

      /
       PROCEDURE DIVISION USING INPUT-DATE, USA-OR-UK, OUTPUT-DATE.
       DATE-CHECK SECTION.
       PREPARE.
           IF UK MOVE INPUT-DAY-OR-MONTH TO WORK-DAY
                 MOVE INPUT-MONTH-OR-DAY TO WORK-MONTH
           ELSE  MOVE "U" TO USA-OR-UK
                 MOVE INPUT-DAY-OR-MONTH TO WORK-MONTH
                 MOVE INPUT-MONTH-OR-DAY TO WORK-DAY
           END-IF
           MOVE INPUT-YEAR TO WORK-YEAR.
           MOVE SPACES TO DAY-NAME, DAYS-SINCE-JAN-1-1900
           MOVE WORK-DAY TO DAY-NO
           MOVE WORK-MONTH TO MONTH-NAME
           MOVE "19" TO CENT-NO.
           MOVE WORK-YEAR TO YEAR-NO.

           IF INPUT-YEAR NOT NUMERIC
               MOVE SPACES TO YEAR-NO
           ELSE
               IF WORK-YEAR = 0
                   MOVE 1 TO LEAP-YEAR-INDICATOR
               ELSE
                   DIVIDE WORK-YEAR BY 4 GIVING QUOTIENT
                                       REMAINDER LEAP-YEAR-INDICATOR
               END-IF
               IF WORK-MONTH IS LESS THAN 1 OR GREATER THAN 12
                   MOVE SPACES TO MONTH-NAME
               ELSE
                   MOVE WORK-MONTH TO SUBSCRIPT
                   MOVE SHORT-MONTH-NAME (SUBSCRIPT) TO MONTH-NAME
                   IF LEAP-YEAR AND FEBRUARY
                       MOVE 13 TO SUBSCRIPT
                   END-IF
                   IF   WORK-DAY IS LESS THAN 1
                     OR GREATER THAN DAYS-IN-MONTH (SUBSCRIPT)
                       MOVE SPACES TO DAY-NO
                   ELSE
                       PERFORM CALC-1900
                   END-IF
               END-IF
           END-IF
           EXIT PROGRAM.

      * Calculate days since 1900.
       CALC-1900.
           MULTIPLY 365 BY WORK-YEAR GIVING DAYS-IN-PREVIOUS-YEARS
           IF WORK-YEAR IS NOT = 0
               SUBTRACT 1 FROM WORK-YEAR
           END-IF
           DIVIDE 4 INTO WORK-YEAR GIVING EXTRA-LEAP-DAYS
           ADD EXTRA-LEAP-DAYS TO DAYS-IN-PREVIOUS-YEARS
           MOVE 0 TO DAYS-IN-YEAR-TO-DATE
           MOVE 1 TO SUBSCRIPT
           PERFORM SUM-DAYS-IN-YEAR-TO-DATE
                                       UNTIL SUBSCRIPT = WORK-MONTH
           ADD WORK-DAY,
               DAYS-IN-YEAR-TO-DATE,
               DAYS-IN-PREVIOUS-YEARS
                                       GIVING TOTAL-DAYS
           MOVE TOTAL-DAYS TO DAYS-SINCE-JAN-1-1900
           SUBTRACT 1 FROM TOTAL-DAYS
           DIVIDE TOTAL-DAYS BY 7 GIVING QUOTIENT REMAINDER SUBSCRIPT.
           ADD 1 TO SUBSCRIPT.
           MOVE DAY-OF-THE-WEEK (SUBSCRIPT) TO DAY-NAME.

       SUM-DAYS-IN-YEAR-TO-DATE.
           ADD DAYS-IN-MONTH (SUBSCRIPT) TO DAYS-IN-YEAR-TO-DATE
           IF LEAP-YEAR AND FEBRUARY
               ADD 1 TO DAYS-IN-YEAR-TO-DATE
           END-IF
           ADD 1 TO SUBSCRIPT.

       END PROGRAM DATECHK.

       END PROGRAM DATECALL.
