      $Set ans85 noosvs warning(3)
      *--------------------------------------------------------------*
      *TESTDATA                                                      *
      *--------                                                      *
      *Program to update the files delivered with the EXAMPLE and    *
      *PARTS dictionaries.                                           *
      *These files are for demonstration only; therefore this        *
      *program contains only a minimum of input validation.          *
      *Note that data for decimal fields will not be accepted via    *
      *edited items.                                                 *
      *--------------------------------------------------------------*
       Environment division.
       Configuration section.
       Special-names.
           Console is crt
           Crt status is ws-crt.
       Input-output section.
       File-control.
       Select Customer-file assign to "clients"
           organization is indexed
           access mode is random
           record key is cust-code
           alternate record key is cust-name
           file status is file-status.
       Select Order-file assign to "orders"
           organization is indexed
           access mode is random
           record key is order-no
           file status is file-status.
       Select Delivery-file assign to "delvs"
           organization is indexed
           access mode is random
           record key is delv-no
           file status is file-status.
       Select Parts-file assign to "spares"
           organization is indexed
           access mode is random
           record key is part-no
           file status is file-status.
       Select Employee-file assign to "workers"
           organization is indexed
           access mode is random
           record key is e-code
           file status is file-status.
      *--------------------------------------------------------------*
       Data division.
       File section.
       FD Employee-file.
       01 E-rec.
          03 E-name.
              05 E-first-name              pic x(15).
              05 E-middle-name             pic x(15).
              05 E-last-name               pic x(15).
          03 E-code                        pic 9(6).
          03 E-address                     pic x(25) occurs 3.
          03 E-phone                       pic x(12).
          03 E-dob                         pic 9(6).
          03 E-dej                         pic 9(6).
          03 E-dept                        pic x(10).
          03 E-salary                      pic 9(5)v99.
          03 E-sex                         pic x.
          03 E-mstat                       pic x.
          03 E-tax-code                    pic 9(3).
      *--------------------------------------------------------------*
       FD Customer-file.
       01 Cust-rec.
           03 Cust-name                    pic x(20).
           03 Cust-code                    pic 9(6).
           03 Cust-addr                    pic x(25) occurs 3 times.
           03 Cust-phone                   pic x(12).
           03 Cust-terms.
               05 Cust-credit-limit        pic 9(5)v99.
               05 Cust-pay-period          pic 99.
               05 Cust-discount            pic 99v99.
           03 Cust-balance                 pic s9(5)v99.
      *--------------------------------------------------------------*
       FD Order-file.
       01 Order-rec.
           03 Order-no.
               05 O-cust-code              pic 9(6).
               05 Ord-date                 pic 9(6).
           03 Order-details occurs 5 times.
               05 O-part-no                pic x(8).
               05 Qty                      pic 9(5).
      *--------------------------------------------------------------*
       FD Delivery-file.
       01 Delv-rec.
           03 Delv-no.
               05 D-cust-code              pic 9(6).
               05 D-ord-date               pic 9(6).
           03 Delv-date                    pic 9(6).
           03 Shipping                     pic x(25) occurs 4 times.
      *--------------------------------------------------------------*
       FD Parts-file.
       01 Parts-rec.
           03 Part-no                      pic x(8).
           03 Part-desc                    pic x(25) occurs 5 times.
           03 Part-price                   pic 9(5)v99.
           03 Part-stocks                  pic 9(6).
      *--------------------------------------------------------------*
       Working-storage section.
       78  Adis                            value X"af".
       78  Read-char                       value 26.
       01  Adis-flag                       pic 99 comp.
       01  Enable-table.
           03  Enable-flag                 pic 99 comp value 1.
           03  Type-to-enable              pic X value "1".
           03  First-to-enable             pic 99 comp value 0.
           03  Number-to-enable            pic 99 comp value 1.
       01  Ws-crt.
           03  Ws-crt12.
               05  Ws-crt1                 pic X.
                   88  Character-input     value "3".
               05  Ws-crt-char.
                   07  Ws-crt2             pic 99 comp.
           03  Ws-crt3                     pic X.
       01  Ws-escape.
           03  Filler                      pic X value "1".
           03  Filler                      pic 99 comp value 0.
       01  Escape-flag                     pic 99 comp-x.
           88  Escape-not-requested        value 0.
           88  Escape-requested            value 1.
       01  Data-flag                       pic 99 comp-x.
           88  More-data-to-enter          value 0.
           88  No-more-data-to-enter       value 1.
       01 File-status                      pic xx.
           88  File-status-ok              value "00".
           88  Duplicate-record            value "22".
           88  Record-not-found            value "23".
       01  File-number                     pic 99 comp-x.
           88  Valid-file-number           value 1,2,3,4,5.
       01 Copyright-notice                 pic x(41) value
          "Copyright (C) 1989  Cowriter Systems Ltd.".
      *--------------------------------------------------------------*
       Screen section.
       01 G-ALL.
         02 BLANK SCREEN.
         02 LINE 3 COL 22 VALUE " Co-Writer DEMONSTRATION SYSTEMS ".
         02 LINE 5 COL 29 VALUE "DATA ENTRY PROGRAM".
         02 LINE 8 COL 16 VALUE "1  Update employee file (EXAMPLE dictio
      -"nary)".
         02 LINE 10 COL 16 VALUE "2  Update customer file (PARTS diction
      -"ary)".
         02 LINE 12 COL 16 VALUE "3  Update orders file   (PARTS diction
      -"ary)".
         02 LINE 14 COL 16 VALUE "4  Update delivery file (PARTS diction
      -"ary)".
         02 LINE 16 COL 16 VALUE "5  Update parts file    (PARTS diction
      -"ary)".
         02 LINE 23 COL 21 VALUE "Select an option (Escape to exit).".
       01 G-PRE-EMP.
         02 LINE 2 COL 27 VALUE "Update employee file".
         02 LINE 5 COL 25 VALUE "EMPLOYEE NUMBER [      ]".
         02 LINE 5 COL 42 PIC 9(6) USING e-code.
       01 G-EMPLOYEE.
         02 LINE 8 COL 1 VALUE "First name       [               ]   Hom
      -"e address   [                         ]".
         02 LINE 9 COL 1 VALUE "Middle name      [               ]
      -"            [                         ]".
         02 LINE 10 COL 1 VALUE "Last name        [               ]
      -"             [                         ]".
         02 LINE 12 COL 1 VALUE "Telephone number [            ]      Da
      -"te joined    [      ]".
         02 LINE 14 COL 1 VALUE "Date of birth    [      ]            Sa
      -"lary         [       ]".
         02 LINE 16 COL 1 VALUE "Department       [          ]        Ta
      -"x code       [   ]".
         02 LINE 18 COL 1 VALUE "Sex              [ ]                 Ma
      -"rital status [ ]".
         02 LINE 23 COL 15 VALUE "Enter details and press <return> (Esca
      -"pe to exit).".
         02 LINE 8 COL 19 PIC X(15) USING e-first-name.
         02 LINE 9 COL 19 PIC X(15) USING e-middle-name.
         02 LINE 10 COL 19 PIC X(15) USING e-last-name.
         02 LINE 8 COL 54 PIC X(25) USING e-address(1).
         02 LINE 9 COL 54 PIC X(25) USING e-address(2).
         02 LINE 10 COL 54 PIC X(25) USING e-address(3).
         02 LINE 12 COL 19 PIC X(12) USING e-phone.
         02 LINE 12 COL 54 PIC 9(6) USING e-dej.
         02 LINE 14 COL 19 PIC 9(6) USING e-dob.
         02 LINE 14 COL 54 PIC 9(7) USING e-salary.
         02 LINE 16 COL 19 PIC X(10) USING e-dept.
         02 LINE 16 COL 54 PIC 999 USING e-tax-code.
         02 LINE 18 COL 19 PIC X USING e-sex.
         02 LINE 18 COL 54 PIC X USING e-mstat.
       01 G-PRE-CUS.
         02 LINE 2 COL 27 VALUE "Update customer file".
         02 LINE 5 COL 26 VALUE "CUSTOMER CODE [      ]".
         02 LINE 5 COL 41 PIC 9(6) USING CUST-CODE.
       01 G-CUSTOMER.
         02 LINE 8 COL 1 VALUE "Customer name    [               ]   Hom
      -"e address   [                         ]".
         02 LINE 9 COL 53 VALUE "[                         ]".
         02 LINE 10 COL 53 VALUE "[                         ]".
         02 LINE 12 COL 1 VALUE "Telephone number [            ]      Cr
      -"edit limit   [       ]".
         02 LINE 14 COL 1 VALUE "Current balance  [        ]          Pa
      -"yment period [  ]".
         02 LINE 16 COL 38 VALUE "Discount (%)   [    ]".
         02 LINE 23 COL 15 VALUE "Enter details and press <return> (Esca
      -"pe to exit).".
         02 LINE 8 COL 19 PIC X(15) USING cust-name.
         02 LINE 8 COL 54 PIC X(25) USING cust-addr(1).
         02 LINE 9 COL 54 PIC X(25) USING cust-addr(2).
         02 LINE 10 COL 54 PIC X(25) USING cust-addr(3).
         02 LINE 12 COL 19 PIC X(12) USING cust-phone.
         02 LINE 14 COL 19 PIC 9(8) USING cust-balance.
         02 LINE 12 COL 54 PIC 9(7) USING cust-credit-limit.
         02 LINE 14 COL 54 PIC 99 USING cust-pay-period.
         02 LINE 16 COL 54 PIC 9(4) USING cust-discount.
       01 G-PRE-ORD.
         02 BLANK SCREEN.
         02 LINE 2 COL 28 VALUE "Update order file".
         02 LINE 5 COL 26 VALUE "CUSTOMER CODE [      ]".
         02 LINE 7 COL 26 VALUE "DATE OF ORDER [      ]".
         02 LINE 5 COL 41 PIC 9(6) USING o-cust-code.
         02 LINE 7 COL 41 PIC 9(6) USING ORD-DATE.
       01 G-ORDER.
         02 LINE 10 COL 11 VALUE "Part number [        ]    Quantity ord
      -"ered [     ]".
         02 LINE 11 COL 23 VALUE "[        ]                     [     ]
      -"".
         02 LINE 12 COL 23 VALUE "[        ]                     [     ]
      -"".
         02 LINE 13 COL 23 VALUE "[        ]                     [     ]
      -"".
         02 LINE 14 COL 23 VALUE "[        ]                     [     ]
      -"".
         02 LINE 23 COL 15 VALUE "Enter details and press <return> (Esca
      -"pe to exit).".
         02 LINE 10 COL 24 PIC X(8) USING o-part-no(1).
         02 LINE 10 COL 55 PIC 9(5) USING qty(1).
         02 LINE 11 COL 24 PIC X(8) USING o-part-no(2).
         02 LINE 11 COL 55 PIC 9(5) USING qty(2).
         02 LINE 12 COL 24 PIC X(8) USING o-part-no(3).
         02 LINE 12 COL 55 PIC 9(5) USING qty(3).
         02 LINE 13 COL 24 PIC X(8) USING o-part-no(4).
         02 LINE 13 COL 55 PIC 9(5) USING qty(4).
         02 LINE 14 COL 24 PIC X(8) USING o-part-no(5).
         02 LINE 14 COL 55 PIC 9(5) USING qty(5).
       01 G-PRE-DEL.
         02 BLANK SCREEN.
         02 LINE 2 COL 27 VALUE "Update delivery file".
         02 LINE 5 COL 26 VALUE "CUSTOMER CODE [      ]".
         02 LINE 7 COL 26 VALUE "DATE OF ORDER [      ]".
         02 LINE 5 COL 41 PIC 9(6) USING d-cust-code.
         02 LINE 7 COL 41 PIC 9(6) USING d-ord-date.
       01 G-DELIVERY.
         02 LINE 10 COL 15 VALUE "Delivery date    [      ]".
         02 LINE 12 COL 15 VALUE "Shipment details [
      -"     ]".
         02 LINE 13 COL 32 VALUE "[                         ]".
         02 LINE 14 COL 32 VALUE "[                         ]".
         02 LINE 15 COL 32 VALUE "[                         ]".
         02 LINE 23 COL 15 VALUE "Enter details and press <return> (Esca
      -"pe to exit).".
         02 LINE 10 COL 33 PIC 9(6) USING delv-date.
         02 LINE 12 COL 33 PIC X(25) USING shipping(1).
         02 LINE 13 COL 33 PIC X(25) USING shipping(2).
         02 LINE 14 COL 33 PIC X(25) USING shipping(3).
         02 LINE 15 COL 33 PIC X(25) USING shipping(4).
       01 G-PRE-PAR.
         02 BLANK SCREEN.
         02 LINE 2 COL 29 VALUE "Update parts file".
         02 LINE 5 COL 27 VALUE "PART NUMBER [        ]".
         02 LINE 5 COL 40 PIC X(8) USING PART-NO.
       01 G-PART.
         02 LINE 8 COL 19 VALUE "Description [                         ]
      -"".
         02 LINE 9 COL 31 VALUE "[                         ]".
         02 LINE 10 COL 31 VALUE "[                         ]".
         02 LINE 11 COL 31 VALUE "[                         ]".
         02 LINE 12 COL 31 VALUE "[                         ]".
         02 LINE 14 COL 19 VALUE "Part price  [       ]".
         02 LINE 16 COL 19 VALUE "Stock level [      ]".
         02 LINE 23 COL 15 VALUE "Enter details and press <return> (Esca
      -"pe to exit).".
         02 LINE 8 COL 32 PIC X(25) USING part-desc(1).
         02 LINE 9 COL 32 PIC X(25) USING part-desc(2).
         02 LINE 10 COL 32 PIC X(25) USING part-desc(3).
         02 LINE 11 COL 32 PIC X(25) USING part-desc(4).
         02 LINE 12 COL 32 PIC X(25) USING part-desc(5).
         02 LINE 14 COL 32 PIC 9(7) USING part-price.
         02 LINE 16 COL 32 PIC 9(6) USING part-stocks.
      *--------------------------------------------------------------*
       Procedure division.
       Main-control section.
           Perform 1-initialise
           Set escape-not-requested to true
           Perform 2-main-process until escape-requested
           Perform 4-finalise
           Stop run.
      *--------------------------------------------------------------*
       1-initialise section.
      *Enable the Escape key.
           Move 1 to adis-flag
           Call adis using adis-flag enable-table.
      *--------------------------------------------------------------*
       2-main-process section.
           Display g-all
           Move zero to file-number
           Perform 3-get-file-number until valid-file-number
                                     or    escape-requested
           If escape-not-requested
               Set file-status-ok to true
               Evaluate file-number
                   When 1 perform 10-employee-process
                   When 2 perform 20-customer-process
                   When 3 perform 30-order-process
                   When 4 perform 40-delivery-process
                   When 5 perform 50-parts-process
               end-evaluate
           end-if.
      *--------------------------------------------------------------*
       3-get-file-number section.
           Move read-char to adis-flag
           Call adis using adis-flag ws-crt
           If ws-crt12 = ws-escape
               set escape-requested to true
           else
               if character-input
                   if ws-crt3 numeric
                       move ws-crt3 to file-number
                   end-if
               end-if
           end-if.
      *--------------------------------------------------------------*
       4-finalise section.
           Display spaces upon crt.
      *--------------------------------------------------------------*
       10-employee-process section.
           Open i-o employee-file
           If file-status-ok
               display space upon crt
               initialize e-rec
               set more-data-to-enter to true
               perform 11-accept-employees
                   until no-more-data-to-enter
                   or    not file-status-ok
               close employee-file
           end-if.

       11-accept-employees section.
           Display g-pre-emp
           Accept  g-pre-emp
           If e-code = 0
           or ws-crt12 = ws-escape
               set no-more-data-to-enter to true
           else
               read employee-file
               if record-not-found
               or file-status-ok
                   perform 12-process-employee
                   if file-status-ok
                       initialize e-rec
                       display spaces upon crt
                   end-if
               end-if
           end-if.

       12-process-employee section.
           display g-employee
           accept g-employee
           if ws-crt12 not = ws-escape
               write e-rec
               if duplicate-record
                   rewrite e-rec
               end-if
           end-if.
      *--------------------------------------------------------------*
       20-customer-process section.
           Open i-o customer-file
           If file-status-ok
               display space upon crt
               initialize cust-rec
               set more-data-to-enter to true
               perform 21-accept-customer
                   until no-more-data-to-enter
               close customer-file
           end-if.

       21-accept-customer section.
           Display g-pre-cus
           Accept  g-pre-cus
           If cust-code = 0
           or ws-crt12 = ws-escape
               set no-more-data-to-enter to true
           else
               read customer-file
               if record-not-found
               or file-status-ok
                   perform 22-process-customer
                   if file-status-ok
                       initialize cust-rec
                       display spaces upon crt
                   end-if
               end-if
           end-if.

       22-process-customer section.
           display g-customer
           accept g-customer
           if ws-crt12 not = ws-escape
               write cust-rec
               if duplicate-record
                   rewrite cust-rec
               end-if
           end-if.
      *--------------------------------------------------------------*
       30-order-process section.
           Open i-o order-file
           If file-status-ok
               display space upon crt
               initialize order-rec
               set more-data-to-enter to true
               perform 31-accept-order
                   until no-more-data-to-enter
               close order-file
           end-if.

       31-accept-order section.
           Display g-pre-ord
           Accept  g-pre-ord
           If o-cust-code = 0
           or ws-crt12 = ws-escape
               set no-more-data-to-enter to true
           else
               read order-file
               if record-not-found
               or file-status-ok
                   perform 32-process-order
                   if file-status-ok
                       initialize order-rec
                       display spaces upon crt
                   end-if
               end-if
           end-if.

       32-process-order section.
           display g-order
           accept g-order
           if ws-crt12 not = ws-escape
               write order-rec
               if duplicate-record
                   rewrite order-rec
               end-if
           end-if.
      *--------------------------------------------------------------*
       40-delivery-process section.
           Open i-o delivery-file
           If file-status-ok
               display space upon crt
               initialize delv-rec
               set more-data-to-enter to true
               perform 41-accept-delivery
                   until no-more-data-to-enter
               close delivery-file
           end-if.

       41-accept-delivery section.
           Display g-pre-del
           Accept  g-pre-del
           If d-cust-code = 0
           or ws-crt12 = ws-escape
               set no-more-data-to-enter to true
           else
               read delivery-file
               if record-not-found
               or file-status-ok
                   perform 42-process-delivery
                   if file-status-ok
                       initialize delv-rec
                       display spaces upon crt
                   end-if
               end-if
           end-if.

       42-process-delivery section.
           display g-delivery
           accept g-delivery
           if ws-crt12 not = ws-escape
               write delv-rec
               if duplicate-record
                   rewrite delv-rec
               end-if
           end-if.
      *--------------------------------------------------------------*
       50-parts-process section.
           Open i-o parts-file
           If file-status-ok
               display space upon crt
               initialize parts-rec
               set more-data-to-enter to true
               perform 51-accept-part
                   until no-more-data-to-enter
               close parts-file
           end-if.

       51-accept-part section.
           Display g-pre-par
           Accept  g-pre-par
           If part-no = spaces
           or ws-crt12 = ws-escape
               set no-more-data-to-enter to true
           else
               read parts-file
               if record-not-found
               or file-status-ok
                   perform 52-process-parts
                   if file-status-ok
                       initialize parts-rec
                       display spaces upon crt
                   end-if
               end-if
           end-if.

       52-process-parts section.
           display g-part
           accept g-part
           if ws-crt12 not = ws-escape
               write parts-rec
               if duplicate-record
                   rewrite parts-rec
               end-if
           end-if.
      *--------------------------------------------------------------*
