      $Set ans85 noosvs warning(3)
      *-------------------------------------------------------------*
      *SQLIO                                                        *
      *------                                                       *
      *Specimen I-O module for the Delivery file.                   *
      *-------------------------------------------------------------*
      *This program provides an introduction to the use of the I-O
      *module within Co-Writer to access a database system.
      *
      *Its purpose is to provide all access to a table Delivery, which
      *corresponds to the file delvs provided with the PARTS
      *demonstration system.
      *
      *Note that the program Delvio.cbl is a specimen I-O module for
      *the Delivery file where the file is an indexed file rather
      *than a database table.  You are advised to become familiar
      *with Delvio.cbl and its interaction with the Co-Writer
      *REPORT software before you approach the current program.
      *-------------------------------------------------------------*
       Working-storage section.
       01 Sqlca.
          03 Sqlcaid                           pic X(8).
          03 Sqlcabc                           pic S9(9) comp-5.
          03 Sqlcode                           pic S9(9) comp-5.
             88 Sqlcode-ok                     value 0.
             88 Sqlcode-end-of-chain           value 100.
          03 Sqlerrm.
             49 Sqlerrml                       pic S9(4) comp-5.
             49 Sqlerrmc                       pic X(70).
          03 Sqlerrp                           pic X(8).
          03 Sqlerrd                           pic S9(9) comp-5
                                               occurs 6.
          03 Sqlwarn.
             05 Sqlwarn0                       pic X.
             05 Sqlwarn1                       pic X.
             05 Sqlwarn2                       pic X.
             05 Sqlwarn3                       pic X.
             05 Sqlwarn4                       pic X.
             05 Sqlwarn5                       pic X.
             05 Sqlwarn6                       pic X.
             05 Sqlwarn7                       pic X.
          03 Sqlext                            pic X(8).
       01  Delivery.
           03 D-cust-code                      pic X(06).
           03 D-ord-date                       pic X(06).
           03 D-delv-date                      pic X(06).
           03 Shipping-1                       pic X(25).
           03 Shipping-2                       pic X(25).
           03 Shipping-3                       pic X(25).
           03 Shipping-4                       pic X(25).

           Exec sql declare delivery table
           (
              'D_cust_code'                    Char (6) not null,
              'D_ord_date'                     Date not null,
              'D_delv_date'                    Date not null,
              'Shipping_1'                     Char (25) not null,
              'Shipping_2'                     Char (25) not null,
              'Shipping_3'                     Char (25) not null,
              'Shipping_4'                     Char (25) not null
           )
           End-exec.

       01  Ws-filename                         pic x(100).
       01  Ws-key                              pic x(120).
       01  Ws-key-components                   redefines ws-key.
           03  Ws-cust-code                    pic x(6).
           03  Ws-ord-date                     pic x(6).
           03  Filler                          pic x(108).
      *-------------------------------------------------------------*
       Linkage section.
       01 Lk-function                          pic 99 comp-x.
          88 Lk-function-open-file             value 1.
          88 Lk-function-prime-start           value 2.
          88 Lk-function-1-to-many-start       value 3.
          88 Lk-function-prime-next            value 4.
          88 Lk-function-1-to-many-next        value 5.
          88 Lk-function-random-read           value 6.
          88 Lk-function-close-file            value 7.
       01 Lk-record                            pic x(118).
       01 Lk-key                               pic x(120).
       01 Lk-record-type                       pic 99 comp-x.
       01 Lk-status                            pic xx.
          88 Lk-status-ok                      value "00".
       01 Lk-response                          pic 99 comp-x.
          88 Lk-response-ok                    value zero.
          88 Lk-response-end-of-chain          value 1.
          88 Lk-response-not-found             value 2.
          88 Lk-response-fe-continue           value 3.
          88 Lk-response-fe-abort              value 4.
          88 Lk-response-cwr-error             value 5.
       01 Lk-key-number                        pic 9(4) comp-x.
      *-------------------------------------------------------------*
       Procedure division using lk-function
                                lk-record
                                lk-key
                                lk-record-type
                                lk-status
                                lk-response
                                lk-key-number.
      *-------------------------------------------------------------*
       Main-control section.
           Set lk-response-ok to true
           Evaluate true
               when lk-function-open-file
                   perform 1-open-file
               when lk-function-prime-start
                   perform 2-prime-start
               when lk-function-1-to-many-start
                   perform 3-1-to-many-start
               when lk-function-prime-next
                   perform 4-prime-next
               when lk-function-1-to-many-next
                   perform 5-1-to-many-next
               when lk-function-random-read
                   perform 6-random-read
               when lk-function-close-file
                   perform 7-close-file
               when other
                   set lk-response-cwr-error to true
           end-evaluate
           Set lk-status-ok to true
           Exit program.
      *-------------------------------------------------------------*
       1-Open-file section.
      *Open is external to Co-Writer.
           Continue.
      *-------------------------------------------------------------*
       2-Prime-start section.
           If lk-key = low-values
               move zero to ws-cust-code ws-ord-date
           else
               move lk-key to ws-key
           end-if
           Initialize delivery
           Exec sql
               Declare prime1 cursor for
                   select  d_cust_code,
                           d_ord_date,
                           delv_date,
                           shipping_1,
                           shipping_2,
                           shipping_3,
                           shipping_4
                   from    delivery
                     where d_cust_code >= :ws-cust-code
                       and d_ord_date  >= :ws-ord-date
           end-exec
           Exec sql
               open prime1
           end-exec
           If not sqlcode-ok
               set lk-response-end-of-chain to true
           else
               perform 4-prime-next
           end-if.
      *-------------------------------------------------------------*
       3-1-To-many-start section.
           If lk-key = low-values
               move zero to ws-cust-code
           else
               move lk-key to ws-key
           end-if
           Initialize delivery
           Exec sql
               Declare many1 cursor for
                   select  d_cust_code,
                           d_ord_date,
                           delv_date,
                           shipping_1,
                           shipping_2,
                           shipping_3,
                           shipping_4
                   from    delivery
                     where d_cust_code >= :ws-cust-code
                       and d_ord_date  >= :ws-ord-date
           end-exec
           Exec sql
               open many1
           end-exec
           If not sqlcode-ok
               set lk-response-end-of-chain to true
           else
               perform 5-1-to-many-next
           end-if.
      *-------------------------------------------------------------*
       4-Prime-next section.
           Exec sql
               Fetch prime1
                   into    :d-cust-code,
                           :d-ord-date,
                           :d-delv-date,
                           :shipping-1,
                           :shipping-2,
                           :shipping-3,
                           :shipping-4
           end-exec
           If sqlcode-end-of-chain
               set lk-response-end-of-chain to true
           else
               if sqlcode-ok
                   move delivery to lk-record
               else
                   set lk-response-fe-continue to true
               end-if
           end-if.
      *-------------------------------------------------------------*
       5-1-To-many-next section.
           Exec sql
               Fetch many1
                   into    :d-cust-code,
                           :d-ord-date,
                           :d-delv-date,
                           :shipping-1,
                           :shipping-2,
                           :shipping-3,
                           :shipping-4
           end-exec
           If sqlcode-end-of-chain
               set lk-response-end-of-chain to true
           else
               if sqlcode-ok
                   if  d-cust-code = ws-cust-code
                       move delivery to lk-record
                   else
                       set lk-response-end-of-chain to true
                   end-if
               else
                   set lk-response-fe-continue to true
               end-if
           end-if.
      *-------------------------------------------------------------*
       6-Random-read section.
           Move lk-key to ws-key
           Initialize delivery
           Move ws-cust-code to d-cust-code
           Move ws-ord-date  to d-ord-date
           exec sql
               select  d_cust_code, d_ord_date, delv_date, shipping_1,
                       shipping_2, shipping_3, shipping_4
               into   :d-cust-code, :d-ord-date, :d-delv-date,
                      :shipping-1, :shipping-2, :shipping-3, :shipping-4
               from    delivery
                 where d_cust_code = :ws-cust-code
                   and d_ord_date  = :ws-ord-date
           end-exec
           If not sqlcode-ok
               set lk-response-not-found to true
           else
               move delivery to lk-record
           end-if.
      *-------------------------------------------------------------*
       7-Close-file section.
      *Close is external to Co-Writer.
           Continue.
      *-------------------------------------------------------------*
