      $Set ans85 noosvs warning(3)
      *-------------------------------------------------------------*
      *SKELIO                                                       *
      *------                                                       *
      *Skeleton I-O Module for Co-Writer file handling              *
      *-------------------------------------------------            *
      *This program provides the basic structure of a typical I-O   *
      *module used by Co-Writer for reading files with more than    *
      *one record type.                                             *
      *It is also of interest to the advanced user of Co-Writer     *
      *whose data definition does not exactly match the physical    *
      *file layout of a single record type file.                    *
      *                                                             *
      *Throughout the program you will see data names which must be *
      *replaced by the actual names which are relevant to your      *
      *particular file.                                             *
      *You will also find comments which will help you to assemble  *
      *your working I-O module quickly and accurately.              *
      *                                                             *
      *For present purposes we will make the assumption that the    *
      *file in question has THREE record types.                     *
      *-------------------------------------------------------------*
       Environment division.
       Input-output section.
       File-control.
           Select filename assign ws-file-name
      *    organization?
      *    access mode?
           record key record-key
           status file-status.
      *-------------------------------------------------------------*
       Data division.
       File section.
       Fd  filename.
       01  File-record.
      *Enter your file record definition(s) here...
      *
      *-------------------------------------------------------------*
       Working-storage section.
       01 File-status                          pic xx.
           88  File-status-ok                  value "00".
           88  Record-not-found                value "23".
      *
      *Set up the file name picture to the length of the path name
      *and file name expected.
       01 Ws-file-name                         pic x(?).
      *
      *
      *If your Co-Writer system involves links from one record type
      *in the file to another record type in the same file, then you
      *will require a "save area" for each of the record keys.
      *(See the Co-Writer DICTIONARY BUILDER User Guide for further
      *information).
      *As explained above, we assume that there are 3 record types,
      *requiring 3 save areas.
      *The picture must be equal to the record key length.
      *
       01 Ws-store-keys.
           03 Ws-store-key1                    pic x(?).
           03 Ws-store-key2                    pic x(?).
           03 Ws-store-key3                    pic x(?).
      *-------------------------------------------------------------*
       Linkage section.
      *See the Co-Writer DICTIONARY BUILDER User Guide for a
      *detailed explanation of the items within the linkage section.
      *N.B. remember that LK-KEY is used to pass the file name during
      *     the open function.  Therefore "n" must be large enough
      *     to contain path name and file name in this instance.
       01 Lk-function                          pic 99 comp.
          88 Lk-function-open-file             value 1.
          88 Lk-function-prime-start           value 2.
          88 Lk-function-1-to-many-start       value 3.
          88 Lk-function-prime-next            value 4.
          88 Lk-function-1-to-many-next        value 5.
          88 Lk-function-random-read           value 6.
          88 Lk-function-close-file            value 7.
       01 Lk-record                            pic x(8190).
       01 Lk-key                               pic x(n).
       01 Lk-record-type                       pic 99 comp.
       01 Lk-status                            pic xx.
       01 Lk-response                          pic 99 comp.
          88 Lk-response-ok                    value zero.
          88 Lk-response-end-of-chain          value 1.
          88 Lk-response-not-found             value 2.
          88 Lk-response-fe-continue           value 3.
          88 Lk-response-fe-abort              value 4.
          88 Lk-response-cwr-error             value 5.
       01 Lk-key-number                        pic 9(4) comp-x.
      *-------------------------------------------------------------*
       Procedure division using lk-function
                                lk-record
                                lk-key
                                lk-record-type
                                lk-status
                                lk-response
                                lk-key-number.
       Main-control section.
           Set lk-response-ok to true
      *    If lk-record-type > 3 (i.e. no. of record types)...
               set lk-response-cwr-error to true
           else
               if lk-function-open-file
                   perform 1-open-file
               else
                   evaluate lk-function
                       when lk-function-prime-start
                           perform 2-prime-start
                       when lk-function-1-to-many-start
                           perform 3-1-to-many-start
                       when lk-function-prime-next
                           perform 4-prime-next
                       when lk-function-1-to-many-next
                           perform 5-1-to-many-next
                       when lk-function-random-read
                           perform 6-random-read
                       when lk-function-close-file
                           perform 7-close-file
                      when other
                           set lk-response-cwr-error to true
                   end-evaluate
                   move file-status to lk-status
               end-if
           end-if
           Exit program.
      *-------------------------------------------------------------*
       1-Open-file section.
           Move lk-key to ws-file-name
           Open input filename
      *Set up lk-status here; if the open fails, we require the open
      *status, not the close status, to be returned.
           Move file-status to lk-status
           If not file-status-ok
               close filename
               set lk-response-fe-continue to true
           end-if.
      *-------------------------------------------------------------*
       2-Prime-start section.
      *
      *Here you must set up record-key using lk-key information.
      *Lk-key will be set to the start point (low-values in most
      *cases).
      *(See the Co-Writer DICTIONARY BUILDER User Guide for further
      *information).
      *    Set up record-key...
           Evaluate lk-record-type
               when 1 move record-key to ws-store-key1
               when 2 move record-key to ws-store-key2
               when 3 move record-key to ws-store-key3
           end-evaluate
           Perform 4-prime-next.
      *-------------------------------------------------------------*
       3-1-To-many-start section.
      *
      *Here you must set up record-key using lk-key information.
      *(See the Co-Writer DICTIONARY BUILDER User Guide for further
      *information).
      *    Set up record-key...
           Evaluate lk-record-type
               when 1 move record-key to ws-store-key1
               when 2 move record-key to ws-store-key2
               when 3 move record-key to ws-store-key3
           end-evaluate
           Perform 5-1-to-many-next.
      *-------------------------------------------------------------*
       4-Prime-next section.
      *
      *If your reports include a link from one record type within the
      *file to another record type within the same file, then you must
      *perform a start greater than the saved key before your read
      *next operation.
      *If, however, your reports only involve one record type at a time
      *then the key will not be lost and the start greater than may be
      *discarded.
      *
      *(See the Co-Writer DICTIONARY BUILDER User Guide for further
      *information).
      *
           Evaluate lk-record-type
               when 1 move ws-store-key1 to record-key
               when 2 move ws-store-key2 to record-key
               when 3 move ws-store-key3 to record-key
           end-evaluate
           If lk-function-prime-start
               start filename key not < record-key
           else
               start filename key > record-key
           end-if
      *    Perform until valid record found or end of file...
               Read filename next
                   at end
                       set lk-response-end-of-chain to true
                   not at end
      *                check record type against lk-record-type...
      *                if record type is correct...
                           move file-record to lk-record
                           evaluate lk-record-type
                               when 1 move record-key to ws-store-key1
                               when 2 move record-key to ws-store-key2
                               when 3 move record-key to ws-store-key3
                           end-evaluate
                       end-if
               end-read
           end-perform.
      *-------------------------------------------------------------*
       5-1-To-many-next section.
      *
      *If your reports include a link from one record type within the
      *file to another record type within the same file, then you must
      *perform a start greater than the saved key before your read
      *next operation.
      *If, however, your reports only involve one record type at a time
      *then the key will not be lost and the start greater than may be
      *discarded.
      *
      *(See the Co-Writer DICTIONARY BUILDER User Guide for further
      *information).
      *
           Evaluate lk-record-type
               when 1 move ws-store-key1 to record-key
               when 2 move ws-store-key2 to record-key
               when 3 move ws-store-key3 to record-key
           end-evaluate
           If lk-function-1-to-many-start
               start filename key not < record-key
           else
               start filename key > record-key
           end-if
      *    Perform until valid record found or end of chain
      *    or end of file...
               Read filename next
                   at end
                       move set lk-response-end-of-chain to true
                   not at end
      *                check record type against lk-record-type...
      *                if record type is correct...
      *                     check key value against the stored key...
      *                     if key value is correct...
                                move file-record to lk-record
                            else
                                set lk-response-end-of-chain to true
                            end-if
                       end-if
               end-read
           end-perform.
      *-------------------------------------------------------------*
       6-Random-read section.
      *Here you must set up record-key using lk-key information.
      *(See the Co-Writer DICTIONARY BUILDER User Guide for further
      *information).
           Evaluate lk-record-type
      *        when 1 set up key for record type 1...
      *        when 2 set up key for record type 2...
      *        when 3 set up key for record type 3...
           end-evaluate
           Read filename
           If record-not-found
               set lk-response-not-found to true
           else
               move file-record to lk-record
           end-if.
      *-------------------------------------------------------------*
       7-Close-file section.
           Close filename.
      *-------------------------------------------------------------*
