      $Set ans85 noosvs warning(3)
      *-------------------------------------------------------------*
      *DELVIO                                                       *
      *------                                                       *
      *Specimen I-O module for the Delivery file "delvs".           *
      *-------------------------------------------------------------*
      *This program provides an introduction to the use of the I-O
      *module within Co-Writer.
      *
      *Its purpose is to provide all access to the file delvs, which
      *is one of the files provided with the PARTS demonstration
      *system.  Delvs, being a single record type file, may of course
      *be accessed within Co-Writer with no I-O module present.
      *However, this program demonstrates the working of the I-O
      *module in the simplest case.  It also indicates its flexibility
      *since I-O modules may be used to provide access to any file
      *or database system.
      *
      *Note that the program Sqlio.cbl is a specimen I-O module for
      *the Delivery file where the file is a database table rather
      *than an indexed file.
      *
      *It assumes that links will be set up within the DICTIONARY
      *BUILDER such that three situations will apply:
      *
      *    1.  The Delivery file record will be accessed as Prime
      *        Record.  In this case the functions required will be:
      *            OPEN-FILE
      *            PRIME-START
      *            PRIME-NEXT
      *            CLOSE-FILE.
      *    2.  The Delivery file will be accessed as target in a
      *        1:1 link (e.g. from the orders file, with link items
      *        O-CUST-CODE and ORD-DATE).  In this case the functions
      *        required will be:
      *            OPEN-FILE
      *            READ-RANDOM
      *            CLOSE-FILE.
      *    3.  The Delivery file will be accessed as target in a
      *        1:m link (e.g. from the customer file, with link item
      *        CUST-CODE).  In this case the functions required will
      *        be:
      *            OPEN-FILE
      *            1-TO-MANY-START
      *            1-TO-MANY-NEXT
      *            CLOSE-FILE.
      *
      *Note that if the Delivery file is only accessed as a prime file,
      *then case 1 is the only one required; the 1-to-many and
      *read-random sections may be omitted.
      *
      *In order to activate this I-O module, the file specification
      *screen for delvs within the Co-Writer DICTIONARY BUILDER must
      *be modified to specify the name DELVIO in the I-O module field
      *(see the Co-Writer DICTIONARY BUILDER User Guide for further
      *information).
      *
      *Note that skelio.cbl, the skeleton I-O Module, is provided with
      *the Co-Writer software and introduces the functionality
      *necessary for its use with multi-record type files.
      *Delvio is provided as a more straightforward introduction.
      *
      *This program relies on the Run-Time-Switch +B being set, so that
      *the current record pointer will be advanced past locked records.
      *N.B. Even when a record locked return code is received the
      *     contents of the record are returned to the program.
      *-------------------------------------------------------------*
       Select delivery-file assign to ws-filename
           organization is indexed
           access mode is dynamic
           record key is delv-no
           status file-status.
       FD delivery-file.
       01 Delv-rec.
           03 Delv-no.
               05 D-cust-code                  pic 9(6).
               05 D-ord-date                   pic 9(6).
           03 Delv-date                        pic 9(6).
           03 Shipping                         pic x(25) occurs 4.
      *-------------------------------------------------------------*
       Working-storage section.
       01 Ws-filename                          pic x(100).
       01 File-status                          pic xx.
          88 Record-not-found                  value "23" "10".
          88 Locked-record                     value "9D".
       01 Filler redefines file-status.
           03 Filler                           pic x.
              88 Successful-completion         value "0".
           03 Filler                           pic x.
       01  Ws-key                              pic x(120).
       01  Ws-key-components redefines ws-key.
           03  Ws-cust-code                    pic 9(6).
           03  Ws-ord-date                     pic 9(6).
           03  Filler                          pic x(108).
      *-------------------------------------------------------------*
       Linkage section.
       01 Lk-function                          pic 99 comp-x.
          88 Lk-function-open-file             value 1.
          88 Lk-function-prime-start           value 2.
          88 Lk-function-1-to-many-start       value 3.
          88 Lk-function-prime-next            value 4.
          88 Lk-function-1-to-many-next        value 5.
          88 Lk-function-random-read           value 6.
          88 Lk-function-close-file            value 7.
       01 Lk-record                            pic x(118).
       01 Lk-key                               pic x(120).
       01 Lk-record-type                       pic 99 comp-x.
       01 Lk-status                            pic xx.
       01 Lk-response                          pic 99 comp-x.
          88 Lk-response-ok                    value zero.
          88 Lk-response-end-of-chain          value 1.
          88 Lk-response-not-found             value 2.
          88 Lk-response-fe-continue           value 3.
          88 Lk-response-fe-abort              value 4.
          88 Lk-response-cwr-error             value 5.
       01 Lk-key-number                        pic 9(4) comp-x.
      *-------------------------------------------------------------*
       Procedure division using lk-function
                                lk-record
                                lk-key
                                lk-record-type
                                lk-status
                                lk-response
                                lk-key-number.
      *-------------------------------------------------------------*
       Main-control section.
           Set lk-response-ok to true
           If lk-function-open-file
               perform 1-open-file
           else
               evaluate true
                   when lk-function-prime-start
                       perform 2-prime-start
                   when lk-function-1-to-many-start
                       perform 3-1-to-many-start
                   when lk-function-prime-next
                       perform 4-prime-next
                   when lk-function-1-to-many-next
                       perform 5-1-to-many-next
                   when lk-function-random-read
                       perform 6-random-read
                   when lk-function-close-file
                       perform 7-close-file
                   when other
                       set lk-response-cwr-error to true
               end-evaluate
               move file-status to lk-status
           end-if
           exit program.
      *-------------------------------------------------------------*
       1-Open-file section.
      *N.B. After a fail on the OPEN, we must return the OPEN status in
      *     the linkage LK-STATUS rather than a status from the CLOSE.
           Move lk-key to ws-filename
           Open input delivery-file
           If not successful-completion
               move file-status to lk-status
               close delivery-file
               set lk-response-fe-continue to true
           end-if.
      *-------------------------------------------------------------*
       2-Prime-start section.
           If lk-key = low-values
               move zero to ws-cust-code ws-ord-date
           else
               move lk-key to ws-key
           end-if
           Initialize delv-rec
           Move ws-cust-code to d-cust-code
           Move ws-ord-date  to d-ord-date
           Start delivery-file key >= delv-no
               invalid key
                   set lk-response-end-of-chain to true
               not invalid key
                   perform 4-prime-next
           end-start.
      *-------------------------------------------------------------*
       3-1-To-many-start section.
           If lk-key = low-values
               move zero to ws-cust-code
           else
               move lk-key to ws-key
           end-if
           Initialize delv-rec
           Move ws-cust-code to d-cust-code
           Start delivery-file key >= delv-no
               invalid key
                   set lk-response-end-of-chain to true
               not invalid key
                   perform 5-1-to-many-next
           end-start.
      *-------------------------------------------------------------*
       4-Prime-next section.
           Read delivery-file next
               at end
                   set lk-response-end-of-chain to true
               not at end
                   if successful-completion or locked-record
                       move delv-rec to lk-record
                   else
                       set lk-response-fe-continue to true
                   end-if
           end-read.
      *-------------------------------------------------------------*
       5-1-To-many-next section.
           Read delivery-file next
               at end
                   set lk-response-end-of-chain to true
               not at end
                   if d-cust-code = ws-cust-code
                       move delv-rec to lk-record
                   else
                       set lk-response-end-of-chain to true
                   end-if
           end-read.
      *-------------------------------------------------------------*
       6-Random-read section.
           Move lk-key to ws-key
           Initialize delv-rec
           Move ws-cust-code to d-cust-code
           Move ws-ord-date  to d-ord-date
           Read delivery-file
               invalid key
                   set lk-response-not-found to true
               not invalid key
                   move delv-rec to lk-record
           end-read.
      *-------------------------------------------------------------*
       7-Close-file section.
           Close delivery-file.
      *-------------------------------------------------------------*
