      $Set ans85 noosvs sql sqlaccess"dbmio" sqldb"sample"
      $Set sqlbind"dbmio.bnd" nosqlpass sqlinit
      *-------------------------------------------------------------*
      *DBMIO                                                        *
      *------                                                       *
      *Specimen I-O module for the STAFF table.                     *
      *-------------------------------------------------------------*
      *This program provides an introduction to the use of the I-O
      *module within Co-Writer to access a table defined within the
      *IBM Database Manager (incorporated in OS/2 Extended Edition).
      *
      *Its purpose is to provide all access to a table STAFF, which
      *corresponds to the file STAFF-FILE defined below.
      *
      *Note that in order to use this I-O module within your Co-Writer
      *system, you will have to compile this program and use the .IDY
      *file to create a data dictionary in the normal way.
      *
      *In the Builder File details screen, specify a real file name
      *"dbmio" (dummy data file supplied in demo directory because
      *Co-Writer checks for the existence of the data file before
      *running a report) and I-O Module name "dbmio.gnt".
      *
      *Then, when running a report based on this file definition,
      *Co-Writer will activate all file operations through this
      *program.
      *-------------------------------------------------------------*
       Select staff-file assign to "dbmio"
           organization is indexed
           access mode is dynamic
           record key is staff-id.

       FD staff-file.
       01 staff-rec.
           03 staff-id                         pic 9(04).
           03 staff-name                       pic x(09).
           03 staff-dept                       pic 9(04).
           03 staff-job                        pic x(05).
           03 staff-years                      pic 9(04).
           03 staff-salary                     pic 9(05)v9(02).
           03 staff-comm                       pic 9(05)v9(02).
      *-------------------------------------------------------------*
       Working-storage section.

      *SQLCODE for no data available:
       78 no-data                              value 100.

       01 y-or-n                               pic x.
       01 disp-n60                             pic zz9.9.

      *An SQLCA is needed to communicate with database manager:

       exec sql include sqlca end-exec

      *-------------------------------------------------------------*
      *Host variables for database interrogation:

       exec sql begin declare section end-exec

      *N.B. You may use comp-3, comp-5 or packed-decimal for host
      *variables.

       01 staff.
           03 id                               pic s9(4) packed-decimal.
           03 nme                              pic x(9).
           03 dept                             pic s9(4) packed-decimal.
           03 job                              pic x(5).
           03 years                            pic s9(4) packed-decimal.
           03 salary                           pic s9(5)v9(2)
                                                         packed-decimal.
           03 comm                             pic s9(5)v9(2)
                                                         packed-decimal.
       01 location                             pic x(13).
       01 deptname                             pic x(14).
       01 car                                  pic x(20).
       01 n60                                  pic s9(3)v9
                                                         packed-decimal.
       01 avalue                               pic s9(4) packed-decimal.

      *Now two indicator variables are needed because years and comm
      *may have null values (indicator variables must be comp-5):

       01 yrsnul                               pic s9(4) comp-5.
       01 commnul                              pic s9(4) comp-5.

       exec sql end declare section end-exec
      *-------------------------------------------------------------*
       01  Ws-filename                         pic x(28).
       01  Ws-key                              pic x(28).
       01  Ws-key-components                   redefines ws-key.
           03  Ws-id                           pic s9(04) comp-5.
           03  Filler                          pic x(26).
      *-------------------------------------------------------------*
       Linkage section.
       01 Lk-function                          pic 99 comp-x.
          88 Lk-function-open-file             value 1.
          88 Lk-function-prime-start           value 2.
          88 Lk-function-1-to-many-start       value 3.
          88 Lk-function-prime-next            value 4.
          88 Lk-function-1-to-many-next        value 5.
          88 Lk-function-random-read           value 6.
          88 Lk-function-close-file            value 7.
       01 Lk-record.
           03  id-char         pic 9(4).
           03  nme-char        pic x(9).
           03  dept-char       pic 9(4).
           03  job-char        pic x(5).
           03  years-char      pic 9(4).
           03  salary-char     pic 9(5)v9(2).
           03  comm-char       pic 9(5)v9(2).
       01 Lk-key                               pic x(40).
       01 Lk-record-type                       pic 99 comp-x.
       01 Lk-status                            pic xx.
          88 Lk-status-ok                      value "00".
       01 Lk-response                          pic 99 comp-x.
          88 Lk-response-ok                    value zero.
          88 Lk-response-end-of-chain          value 1.
          88 Lk-response-not-found             value 2.
          88 Lk-response-fe-continue           value 3.
          88 Lk-response-fe-abort              value 4.
          88 Lk-response-cwr-error             value 5.
       01 Lk-key-number                        pic 9(4) comp-x.
      *-------------------------------------------------------------*
       Procedure division using lk-function
                                lk-record
                                lk-key
                                lk-record-type
                                lk-status
                                lk-response
                                lk-key-number.
      *-------------------------------------------------------------*
       Main-control section.
           Set lk-response-ok to true
           Evaluate true
               when lk-function-open-file
                   perform 1-open-file
               when lk-function-prime-start
                   perform 2-prime-start
               when lk-function-1-to-many-start
                   perform 3-1-to-many-start
               when lk-function-prime-next
                   perform 4-prime-next
               when lk-function-1-to-many-next
                   perform 5-1-to-many-next
               when lk-function-random-read
                   perform 6-random-read
               when lk-function-close-file
                   perform 7-close-file
               when other
                   set lk-response-cwr-error to true
           end-evaluate
           Set lk-status-ok to true
           Exit program.
      *-------------------------------------------------------------*
       1-Open-file section.
      *Open is external to Co-Writer.
           Move 0 to sqlcode.
      *-------------------------------------------------------------*
       2-Prime-start section.
           If lk-key = low-values
               move zero to ws-id
           else
               move lk-key to ws-key
           end-if
           Initialize staff
           move ws-id to avalue
           Exec sql
               Declare prime1 cursor for
                   select  id,
                           name,
                           dept,
                           job,
                           years,
                           salary,
                           comm
                   from    staff
                     where id >= :avalue
           end-exec
           Exec sql
               open prime1
           end-exec
           If sqlcode = no-data
               set lk-response-end-of-chain to true
           else
               perform 4-prime-next
           end-if.
      *-------------------------------------------------------------*
       3-1-To-many-start section.
           If lk-key = low-values
               move zero to ws-id
           else
               move lk-key to ws-key
           end-if
           Initialize staff
           move ws-id to avalue
           Exec sql
               Declare many1 cursor for
                   select  id,
                           name,
                           dept,
                           job,
                           years,
                           salary,
                           comm
                   from    staff
                     where id >= :avalue
           end-exec
           Exec sql
               open many1
           end-exec
           If  sqlcode = no-data
               set lk-response-end-of-chain to true
           else
               perform 5-1-to-many-next
           end-if.
      *-------------------------------------------------------------*
       4-Prime-next section.
           Exec sql
               Fetch prime1
                   into    :id,
                           :nme,
                           :dept,
                           :job,
                           :years:yrsnul,
                           :salary,
                           :comm:commnul
           end-exec
           If  sqlcode = no-data
               set lk-response-end-of-chain to true
           else
               if  sqlcode = 0
                   perform 8-move-data-to-link
               else
                   set lk-response-fe-continue to true
               end-if
           end-if.
      *-------------------------------------------------------------*
       5-1-To-many-next section.
           Exec sql
               Fetch many1
                   into    :id,
                           :nme,
                           :dept,
                           :job,
                           :years:yrsnul,
                           :salary,
                           :comm:commnul
           end-exec
           If  sqlcode = no-data
               set lk-response-end-of-chain to true
           else
               if  sqlcode = 0
                   if  id = ws-id
                       perform 8-move-data-to-link
                   else
                       set lk-response-end-of-chain to true
                   end-if
               else
                   set lk-response-fe-continue to true
               end-if
           end-if.
      *-------------------------------------------------------------*
       6-Random-read section.
           Move lk-key to ws-key
           Initialize staff
           Move ws-id to avalue
           exec sql
               select  id, name, dept, job, years, salary, comm
                   into    :id,
                           :nme,
                           :dept,
                           :job,
                           :years:yrsnul,
                           :salary,
                           :comm:commnul
               from    staff
                 where id = :avalue
           end-exec
           If  sqlcode = no-data
               set lk-response-not-found to true
           else
               perform 8-move-data-to-link
           end-if.
      *-------------------------------------------------------------*
       7-Close-file section.
      *Close is external to Co-Writer.
           Continue.
      *-------------------------------------------------------------*
       8-Move-Data-To-Link section.
           Move id to id-char
           Move nme to nme-char
           Move dept to dept-char
           Move job to job-char
           Move years to years-char
           Move salary to salary-char
           Move comm to comm-char.
      *-------------------------------------------------------------*
