      $set ans85
      ****************************************************************
      * Copyright Micro Focus Limited 1993-94. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

       WORKING-STORAGE SECTION.

      * Working-Storage areas for CCI demo
	01  Async                   pic x(4) comp-5 value 0.
        01  CCI-Module              PIC X(8)    VALUE SPACES.
        01  Machinename             PIC X(21)   VALUE SPACES.
        01  Error-loc               PIC X(60).
        01  Info1                   PIC X(94).
        01  Maxlen                  PIC X(4)    COMP-5 VALUE 533.
        01  Mem-Ptr                 USAGE POINTER.
        01  Mem-Size                PIC X(4)    COMP-5 VALUE 10240.
        01  Mem-Flags               PIC X(4)    COMP-5 VALUE 0.
        01  Recvlen                 PIC X(4)    COMP-5.
        01  Servername              PIC X(8).
        01  Srvrhandle              PIC X(4)    COMP-5.
        01  Sendlen                 PIC X(4)    COMP-5.
        01  Sessid                  PIC X(4)    COMP-5 VALUE 0.

        01 Signature-Block.
            03  CCIsign             PIC X(6).
            03  CCItype             PIC X(8).
                88 valid-cci-type   value
                   "TCP/IP" "NAMPU" "IPX" "NETB"
                   "NAMP" "APPC" "LU2".
            03  CCIversn            PIC X(6).
            03  CCIcaltab           USAGE POINTER.

       01  cust-clients                pic 9 comp-x value 0.
       01  demo-end-flag               pic 9.
           88 end-of-demo              value 1.

           copy "DS-CNTRL.V1".

       LINKAGE SECTION.

      *  Linkage section areas for CCI demo
       01 Caltab.
           03 CCI-INITSERVER           PROCEDURE-POINTER.
           03 CCI-CLOSESERVER          PROCEDURE-POINTER.
           03 CCI-INITCLIENT           PROCEDURE-POINTER.
           03 CCI-CLOSECLIENT          PROCEDURE-POINTER.
           03 CCI-HANGUP               PROCEDURE-POINTER.
           03 CCI-SEND                 PROCEDURE-POINTER.
           03 CCI-RECEIVE              PROCEDURE-POINTER.
           03 CCI-RECEIVEALL           PROCEDURE-POINTER.
           03 CCI-TRANSACT             PROCEDURE-POINTER.
           03 CCI-CONNECT              PROCEDURE-POINTER.
           03 CCI-WAIT                 PROCEDURE-POINTER.
           03 CCI-QUERY                PROCEDURE-POINTER.
           03 CCI-RESUMECLIENT         PROCEDURE-POINTER.
           03 CCI-SUSPENDCLIENT        PROCEDURE-POINTER.
           03 CCI-RESUMESERVER         PROCEDURE-POINTER.
           03 CCI-SUSPENDSERVER        PROCEDURE-POINTER.
           03 CCI-GETERROR             PROCEDURE-POINTER.
           03 CCI-TRACE                PROCEDURE-POINTER.

       01  data-rec.
           03  data-CONTROL-BLOCK               pic x(84).
           03  data-CUSTOMER-BLOCK.
              05                                pic x(396).
              05 cust-end-flag                  pic 9.
              05                                pic x(52).

       SCREEN SECTION.
       01 dshead background-color 4.
         02 LINE 2 COL 1 VALUE "                 +======================
      -"================+                       ".
         02 LINE 3 COL 1 VALUE "                 |
      -"                |                       ".
         02 LINE 4 COL 1 VALUE "                 | DISTRIBUTED PROCESSIN
      -"G DEMONSTRATION |                       ".
         02 LINE 5 COL 1 VALUE "                 |
      -"                |                       ".
         02 LINE 6 COL 1 VALUE "                 +======================
      -"================+                       ".
       procedure division.
       010-control section.

           perform init-routines.
           move 0 to demo-end-flag.
           perform until end-of-demo
      *-----------------------------------------------------------------
      *    Get record from cciclnt
      *-----------------------------------------------------------------
           perform from-client
           call "ccicust" using data-CONTROL-BLOCK
                                data-CUSTOMER-BLOCK
                                cust-clients
           end-call
           if end-of-demo
              perform hangup-client
           else
              perform to-client
           end-if
           end-perform.

      *-----------------------------------------------------------------
      *    De-register server name from network
      *-----------------------------------------------------------------
           CALL CCI-CLOSESERVER USING by value Srvrhandle.

           IF RETURN-CODE NOT = 0
              MOVE "Error on return from CCI-CLOSESERVER"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.
           EXIT PROGRAM.
           STOP RUN.

       000-control-end.
           exit.

       init-routines section.
      *-----------------------------------------------------------------
      *    Allocate memory for send and receive buffer
      *-----------------------------------------------------------------
           CALL "CBL_ALLOC_MEM" USING
                            Mem-Ptr
                  by value  Mem-Size
                            Mem-Flags.
           SET ADDRESS OF data-rec TO Mem-Ptr.

      *-----------------------------------------------------------------
      *    Load servername and CCI module to be used
      *    We look for two envirnment variables to load these from, if
      *    they are not set, defaults of CCIDEMO and CCITCP are used.
      *    The environmentvariables are CCISRVR and CCICOMMS.   
      *-----------------------------------------------------------------
           display "CCISRVR" upon environment-name.
           accept servername from environment-value.
           if servername = spaces move "CCIDEMO" to servername.

           display "CCICOMMS" upon environment-name.
           accept CCI-MODULE from environment-value.
           if CCI-MODULE = spaces move "CCITCP" to CCI-MODULE.

      *-----------------------------------------------------------------
      *    Fold all environment variable entries to UPPER case
      *-----------------------------------------------------------------
           call "CBL_TOUPPER" using servername by value 8.
           call "CBL_TOUPPER" using CCI-MODULE by value 8.

      *-----------------------------------------------------------------
      *    Make initialisation call to requested CCI module.
      *    This call should return a signature block containing the
      *    protocol name ("TCP/IP" or "NAMPU"), and a pointer to the CCI 
      *    module's function table.
      *-----------------------------------------------------------------
           CALL CCI-Module USING Signature-Block.

           IF  not valid-cci-type
               DISPLAY "Error initialising " CCI-Module
                       AT 2301
               EXIT PROGRAM
               STOP RUN
           END-IF.

           SET ADDRESS OF Caltab to CCIcaltab.

      *-----------------------------------------------------------------
      *    Register server name on network, to allow CCICLNT clients to
      *    connect.
      *-----------------------------------------------------------------
           CALL CCI-INITSERVER USING Servername
                                     Srvrhandle
                       by value      0 size 4.

           IF RETURN-CODE NOT = 0 AND RETURN-CODE NOT = 4
              MOVE "Error on return from CCI-INITSERVER"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.

           display spaces at 0102 with background-color 4
             " " at 0101 with background-color 4
             dshead.
           display "...Ensure 'cciclnt' is running"
             at 1220 with background-color 4
                          foreground-color 7.
       init-para-end.
           exit.

       To-Client SECTION.
           perform Transact.
           perform suspend-server.
       010-xmit-data-exit.
           exit.

       from-client section.
           display ".......waiting for request from cciclnt"
           at 0820 with background-color 4 foreground-color 7
           ".......using server-name:"
           at 0920 with background-color 4 foreground-color 7
           servername
           with background-color 4 foreground-color 7.
           perform receive-data.
      *    After receiving data it is echoed back for verification.
           perform Send-Data.
           perform suspend-server.
           move data-control-block to ds-control-block.
           move cust-end-flag to demo-end-flag.
           if DS-SET-NAME not = spaces
              display spaces at 0801 with background-color 4
              "Request From Client-: " at 1020
              with foreground-color 5
              Sessid at 1041 with foreground-color 2
              if end-of-demo
                 display " Exit request detected, Closing all files "
                 at 1620 with foreground-color 2
              else
              if DS-FIELD-NAME = SPACES
                continue
              else
                display " Last field accessed was-: " at 1220
                with foreground-color 2
                DS-FIELD-NAME with foreground-color 2
                if DS-FIELD-CHANGE-TRUE
                   display " Key fields have been modified "
                   at 1420 with foreground-color 5
                else
                   display " No key fields have been modified "
                   at 1420 with foreground-color 5
                end-if
              end-if
               display " Last Panel accessed was-: "
                at 1620 with foreground-color 2
               DS-PANEL-NAME with foreground-color 2
               " Requested Action-: " at 1820 with foreground-color 5
              end-if
           end-if.
       receive-data-exit.
           exit.

      *---------------------------------------------------------------
      *  Send data to cciclnt
      *---------------------------------------------------------------
       Send-Data SECTION.
           MOVE LENGTH OF data-rec TO Sendlen.

           CALL CCI-SEND USING
		by value       Sessid
                by reference   data-rec
                by value       Sendlen
                by reference   Async
                by value       0 size 4.

           IF RETURN-CODE NOT = 0
              MOVE "Error on return from SEND"
                    to error-loc
              PERFORM Get-CCI-Error
           ELSE
	      PERFORM WITH TEST AFTER UNTIL return-code not = -1
	         CALL CCI-QUERY USING by value Async
	      END-PERFORM
              IF RETURN-CODE NOT = 0
                 MOVE "Error on return from Query of SEND"
                       to error-loc
                 PERFORM Get-CCI-Error
              END-IF
           END-IF.

       Receive-Data SECTION.
      *-----------------------------------------------------------------
      *    Receive data and/or new connections from CCICLNT.
      *    A return value of 1 indicates a timeout has occured.
      *    We detect this and retry the operation.
      *-----------------------------------------------------------------
           MOVE 1 to RETURN-CODE.

           PERFORM UNTIL RETURN-CODE NOT = 1
              CALL CCI-RECEIVEALL USING
		    by value        Srvrhandle
                    by reference    Sessid
                    by reference    data-rec
                    by value        Maxlen
                    by reference    Recvlen
                    by reference    Async
                    by value        0 size 4


	       perform with test after until return-code not = -1
                  CALL CCI-QUERY USING by value Async
               end-perform
           END-PERFORM.

           IF RETURN-CODE > 1
              MOVE "Error on return from RECEIVEALL"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.

      *---------------------------------------------------------------
      *  Transact - Combined send and receive operations
      *---------------------------------------------------------------
       Transact SECTION.

           CALL CCI-RESUMESERVER USING
		      by value       Sessid
                      by reference   Async
                      by value       0 size 4.
           IF RETURN-CODE NOT = 0
              MOVE "Error on return from CCI-RESUMESERVER"
                    to error-loc
              PERFORM Get-CCI-Error.

           MOVE LENGTH OF data-rec TO Sendlen.

           CALL CCI-TRANSACT USING
		  by value      Sessid
                  by reference  data-rec
                  by value      Sendlen
                                Maxlen
                  by reference  Recvlen
                  by value      0 size 4.
           IF RETURN-CODE NOT = 0
              MOVE "Error on return from TRANSACT"
                    to error-loc
              PERFORM Get-CCI-Error.
      
           IF Recvlen NOT = Sendlen
               DISPLAY
               "Send and receive lengths do not match"
               at 2301
               " Sent-:" sendlen " Recevied-:" recvlen
           END-IF.

       Suspend-server SECTION.
      *---------------------------------------------------------------
      *    Suspend connection with client.
      *---------------------------------------------------------------
           CALL CCI-SUSPENDSERVER USING by value Sessid.

           IF RETURN-CODE NOT = 0
              MOVE "Error on return from CCI-SUSPENDSERVER"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.

       Hangup-Client SECTION.
      *---------------------------------------------------------------
      *    Received record from client indicating that the
      *    connection needs to be terminated.
      *---------------------------------------------------------------
           CALL CCI-Hangup USING by value Sessid
           IF RETURN-CODE NOT = 0
              MOVE "Error on return from CCI-HANGUP"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.
      * Reduce the number of active clients by 1.
           subtract 1 from cust-clients.
      * If there are still active clients running, then cancel the
      * end-demo flag so that processing continues.
           if cust-clients > 0
              move 0 to demo-end-flag.
        
       Get-CCI-Error SECTION.
      ****************************************************************
      *    Get error message associated with last error code returned
      *    by a CCI function.
      ****************************************************************
           MOVE LENGTH OF Info1 TO Sendlen.
           CALL CCI-GETERROR USING
		 by reference   Info1
                 by value       Sendlen
                 by reference   Recvlen.
           DISPLAY error-loc at 2201
                   Info1     at 2301 with size recvlen.
           Stop Run.
