      $set ans85
      ****************************************************************
      * Copyright Micro Focus Limited 1993-94. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

       WORKING-STORAGE SECTION.

      * Working-Storage areas for CCI demo
	01  Async                   pic x(4) comp-5 value 0.
        01  CCI-Module              PIC X(8)    VALUE SPACES.
        01  Machinename             PIC X(21)   VALUE SPACES.
        01  Error-loc               PIC X(60).
        01  Info1                   PIC X(94).
        01  Maxlen                  PIC X(4)    COMP-5 VALUE 533.
        01  Mem-Ptr                 USAGE POINTER.
        01  Mem-Size                PIC X(4)    COMP-5 VALUE 10240.
        01  Mem-Flags               PIC X(4)    COMP-5 VALUE 0.
        01  Recvlen                 PIC X(4)    COMP-5.
        01  Servername              PIC X(8).
        01  Srvrhandle              PIC X(4)    COMP-5.
        01  Sendlen                 PIC X(4)    COMP-5.
        01  Sessid                  PIC X(4)    COMP-5 VALUE 0.

        01 Signature-Block.
            03  CCIsign             PIC X(6).
            03  CCItype             PIC X(8).
                88 valid-cci-type   value
                   "TCP/IP" "NAMPU" "IPX" "NETB"
                   "NAMP" "APPC" "LU2".
            03  CCIversn            PIC X(6).
            03  CCIcaltab           USAGE POINTER.

      *
      * Working-Storage areas for CBL_GET_OS_INFO
      *
        01  ws-os-info.
          03  ws-inf-size           pic xx   comp-x value 14.
          03  ws-inf-ostype         pic x    comp-x.
              88 unix value 128 129.
          03  ws-inf-osver          pic x(4) comp-x.
          03  ws-inf-dbcs           pic x    comp-x.
          03  ws-inf-coding         pic x    comp-x.
          03  ws-inf-country        pic xx   comp-x.
          03  ws-inf-code-page      pic xx   comp-x.
          03  ws-inf-process        pic x    comp-x.

       01  ws-arg-count             pic 9.
       01  dialog-system            pic x(8).
       01  screenset-version        pic xx.
       01  scrntype                 pic x(4).
       01  ws-delay                 pic XX COMP-X.
       01  ws-env-ptr               pic 9.
       01  demo-end-flag            pic 9.
           88 end-of-demo           value 1.

           copy "DS-CNTRL.V1".

       LINKAGE SECTION.

      *  Linkage section areas for CCI demo
       01 Caltab.
           03 CCI-INITSERVER           PROCEDURE-POINTER.
           03 CCI-CLOSESERVER          PROCEDURE-POINTER.
           03 CCI-INITCLIENT           PROCEDURE-POINTER.
           03 CCI-CLOSECLIENT          PROCEDURE-POINTER.
           03 CCI-HANGUP               PROCEDURE-POINTER.
           03 CCI-SEND                 PROCEDURE-POINTER.
           03 CCI-RECEIVE              PROCEDURE-POINTER.
           03 CCI-RECEIVEALL           PROCEDURE-POINTER.
           03 CCI-TRANSACT             PROCEDURE-POINTER.
           03 CCI-CONNECT              PROCEDURE-POINTER.
           03 CCI-WAIT                 PROCEDURE-POINTER.
           03 CCI-QUERY                PROCEDURE-POINTER.
           03 CCI-RESUMECLIENT         PROCEDURE-POINTER.
           03 CCI-SUSPENDCLIENT        PROCEDURE-POINTER.
           03 CCI-RESUMESERVER         PROCEDURE-POINTER.
           03 CCI-SUSPENDSERVER        PROCEDURE-POINTER.
           03 CCI-GETERROR             PROCEDURE-POINTER.
           03 CCI-TRACE                PROCEDURE-POINTER.

       01  data-rec.
           03  data-CONTROL-BLOCK               pic x(84).
           03  data-CUSTOMER-BLOCK.
              05                                pic x(396).
              05 cust-end-flag                  pic 9.
                 88 too-many-clients            value 2.
              05                                pic x(52).

       procedure division.
       000-control section.
           perform init-routines.
           perform to-server.
           perform until end-of-demo
               perform from-server
               perform how-many-clients
               if not end-of-demo
                  perform call-dialog-system
               end-if
               perform to-server
           end-perform.

           CALL CCI-CLOSECLIENT USING by value Sessid.

           IF RETURN-CODE NOT = 0
              MOVE "Error on return from CCI-CLOSECLIENT"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.

           EXIT PROGRAM.

       000-control-end.
               stop run.

       how-many-clients section.
          if too-many-clients
             move 1 to demo-end-flag cust-end-flag.
          if end-of-demo
             display spaces at 0101 with background-color 7
             "Maximum number of clients exceeded - session ended"
              at 1012 with foreground-color 4.

       from-server section.
           perform resume-client.
           perform receive-data.
      *  After receiving data, it is echoed back for verification.
           perform send-Data.
           perform suspend-client.
       from-server-exit.
           exit.

       to-server section.
           perform resume-client.
           perform transact.
           perform suspend-client.
       to-server-exit.
           exit.

      *-----------------------------------------------------------------
      *    The client can be run on systems where no dialog system is
      *    installed. If Dialog is not found, a standard cobol program
      *    which uses screen section coding will be called instead.
      *-----------------------------------------------------------------

       call-dialog-system section.
           call dialog-system using  data-control-block
                                     data-customer-block
             on exception
                move "cciscrn" to dialog-system
                call dialog-system using  data-control-block
                                     data-customer-block
             on exception
                display "                                 " at 1528
                        " Dialog System/cciscrn not found " at 1628
                        " Unable to run demo without a    " at 1728
                        " suitable User Interface System  " at 1828
                        "       Program Aborted           " at 1928
                        "                                 " at 2028
                stop run.
            
           move cust-end-flag to demo-end-flag.
       call-dialog-exit.
           exit.

       init-routines section.
      *-----------------------------------------------------------------
      *    Allocate memory for send and receive buffer
      *-----------------------------------------------------------------
           CALL "CBL_ALLOC_MEM" USING
                            Mem-Ptr
                  by value  Mem-Size
                            Mem-Flags.
           SET ADDRESS OF data-rec TO Mem-Ptr.

           initialize data-rec DS-CONTROL-BLOCK.

      *-----------------------------------------------------------------
      *    Load servername and CCI module to be used
      *    We look for two envirnment variables to load these from, if
      *    they are not set, defaults of CCIDEMO and CCITCP are used.
      *    The environmentvariables are CCISRVR and CCICOMMS.   
      *-----------------------------------------------------------------
           display "CCISRVR" upon environment-name.
           accept servername from environment-value.
           if servername = spaces move "CCIDEMO" to servername.

           display "CCICOMMS" upon environment-name.
           accept CCI-MODULE from environment-value.
           if CCI-MODULE = spaces move "CCITCP" to CCI-MODULE.

      *-----------------------------------------------------------------
      *    Fold all environment variable entries to UPPER case
      *-----------------------------------------------------------------
           call "CBL_TOUPPER" using servername by value 8.
           call "CBL_TOUPPER" using CCI-MODULE by value 8.

      *-----------------------------------------------------------------
      *    Check the 'CCIMODE' environment variable.
      *    and set the relevant screen management options in place.
      *-----------------------------------------------------------------
           display "CCIMODE" upon environment-name.
           accept scrntype from environment-value.
           perform setup-scrn-mgr

      *-----------------------------------------------------------------
      *    The default character setup can be overwritten by specifying
      *    an argument on the command line. So we need to test for this
      *    next.
      *    The number of arguments is counted differently on unix, so
      *    we need to establish the type of o/s before checking the
      *    command-line.
      *-----------------------------------------------------------------

           accept ws-env-ptr from argument-number.
           move spaces to scrntype.
           call "CBL_GET_OS_INFO" using ws-os-info.
           if unix
              subtract 1 from ws-env-ptr
              move 2 to ws-arg-count
           else
              move 1 to ws-arg-count.
           if ws-env-ptr > 0
              perform ws-arg-count times
                  accept scrntype from argument-value
              end-perform
              if scrntype not = spaces
                 perform setup-scrn-mgr
              end-if
           end-if.

      *-----------------------------------------------------------------
      *    Make initialisation call to requested CCI module.
      *    This call should return a signature block containing the
      *    protocol name ("TCP/IP" or "NAMPU"), and a pointer to the CCI 
      *    module's function table.
      *-----------------------------------------------------------------
           CALL CCI-Module USING Signature-Block.

           IF not valid-cci-type
               DISPLAY "Error initialising " CCI-Module
                       AT 2301
               EXIT PROGRAM
               STOP RUN
           END-IF.

           SET ADDRESS OF Caltab to CCIcaltab.

           display spaces at 0101 with background-color 7
             ".........Waiting for response from CCISRVR"
             at 1020 with foreground-color 4
             "....using server-name:"
             at 1120 with foreground-color 4
             servername with foreground-color 4

      *-----------------------------------------------------------------
      *    Search for registered server name on network, to allow CCICLNT
      *    to connect. A return value of 1 indicates a timeout has occured.
      *    We detect this and after a short delay, the search is retried.
      *-----------------------------------------------------------------
           MOVE 1 to return-code.
           PERFORM until return-code not = 1
              CALL CCI-INITCLIENT USING Servername
                                        Machinename
                                        Sessid
                             by value   0 size 4
                                        0 size 4
              IF RETURN-CODE = 1
                 display "....Ensure 'ccisrvr' is running"
                 at 1220 with foreground-color 4
                 "....using server-name:"
                 at 1320 with foreground-color 4
                 servername with foreground-color 4

      *-----------------------------------------------------------------
      *    Introduce a delay before retrying to connect with the server.
      *    This helps reduce the impact on the network when the server is
      *    not running.
      *-----------------------------------------------------------------
                 perform varying ws-delay
                   from 1 by 1
                   until ws-delay > 65000
                 end-perform
              END-IF
           END-PERFORM.

           IF RETURN-CODE NOT = 0 AND RETURN-CODE NOT = 4
              MOVE "Error on return from CCI-INITCLIENT"
                    to ERROR-LOC
              PERFORM Get-CCI-Error
           END-IF.

           move 0 to demo-end-flag cust-end-flag.
           move DS-CONTROL-BLOCK to DATA-CONTROL-BLOCK.
       init-para-end.
           exit.

       Setup-scrn-mgr SECTION.
           evaluate scrntype
             when "GUI"                        *> set the GUI defaults
             when "gui" 
                move "dsrun" to dialog-system  *> unix gui module name
                move 2 to ds-version-no 
                perform check-dsgver
             when "ADIS"                       *> setup the name of the
             when "adis"                       *> ADIS screen mgt module
                move "cciscrn" to dialog-system
             when other                        *> set the character
                move "DSRUN" to dialog-system  *> defaults
                move 1 to ds-version-no        *> unix character module name
                perform check-dscver
           end-evaluate.
       setup-scrn-exit.
           exit.

       Check-dscver SECTION.
      *-----------------------------------------------------------------
      *    Check the 'DSCVER' environment variable, if set, then use
      *    this value as the character screenset version number.
      *-----------------------------------------------------------------
           display "DSCVER" upon environment-name.
           accept screenset-version from environment-value.
           if screenset-version numeric
              move screenset-version
              to ds-data-block-version-no
           else
              move 36 to ds-data-block-version-no
           end-if.
       Check-dscver-exit.
           exit.

       Check-dsgver SECTION.
      *-----------------------------------------------------------------
      *    Check the 'DSGVER' environment variable, if set, then use
      *    this value as the graphical screenset version number.
      *-----------------------------------------------------------------
           display "DSGVER" upon environment-name.
           accept screenset-version from environment-value.
           if screenset-version numeric
              move screenset-version
                   to ds-data-block-version-no
           else
              move 37 to ds-data-block-version-no
           end-if.
       Check-dsgver-exit.
           exit.

       Send-Data SECTION.
      *---------------------------------------------------------------
      *  Send data to ccisrvr
      *---------------------------------------------------------------
           MOVE LENGTH of data-rec to Sendlen.

           CALL CCI-SEND USING
		 by value      Sessid
                 by reference  data-rec
                 by value      Sendlen
                 by reference  async
                 by value      0 size 4.
           IF RETURN-CODE NOT = 0
              MOVE "Error on return from SEND"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.

       Receive-Data SECTION.
      *---------------------------------------------------------------
      *    Receive data from CCISRVR.
      *---------------------------------------------------------------
           CALL CCI-RECEIVE USING
		   by value       Sessid
                   by reference   data-rec
                   by value       Maxlen
                   by reference   Recvlen
                   by value       0 size 4
                   by value       0 size 4.
           IF RETURN-CODE NOT = 0
              MOVE "Error on return from RECEIVE"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.

      *---------------------------------------------------------------
      *  Transact - Combined send and receive operations
      *---------------------------------------------------------------
       Transact SECTION.

           MOVE LENGTH OF data-rec TO Sendlen.

           CALL CCI-TRANSACT USING
		   by value        Sessid
                   by reference    data-rec
                   by value        Sendlen
                                   Maxlen
                   by reference    Recvlen
                   by value        0 size 4.
           IF RETURN-CODE NOT = 0
              MOVE "Error on return from TRANSACT"
                    to error-loc
              PERFORM Get-CCI-Error.
      
           IF Recvlen NOT = Sendlen
               DISPLAY
               "Send and receive lengths do not match"
               at 2301
               " Sent-:" sendlen " Recevied-:" recvlen
           END-IF.

       Suspend-Client SECTION.
      *---------------------------------------------------------------
      *    Suspend conversation with server
      *---------------------------------------------------------------
           CALL CCI-SUSPENDCLIENT USING by value Sessid.

           IF RETURN-CODE NOT = 0
              MOVE "Error on return from CCI-SUSPENDCLIENT"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.

       Resume-Client SECTION.
      *---------------------------------------------------------------
      *    Resume conversation with server
      *---------------------------------------------------------------
           CALL CCI-RESUMECLIENT USING
		              by value Sessid
                                       0 size 4
                                       0 size 4.
           IF RETURN-CODE NOT = 0
              MOVE "Error on return from CCI-RESUMECLIENT"
                    to error-loc
              PERFORM Get-CCI-Error
           END-IF.

       Get-CCI-Error SECTION.
      ****************************************************************
      *    Get error message associated with last error code returned
      *    by a CCI function.
      ****************************************************************
           MOVE LENGTH OF Info1 TO Sendlen.
           CALL CCI-GETERROR USING Info1
                    by value       Sendlen
                    by reference   Recvlen.
           DISPLAY error-loc at 2201
                   info1     at 2301 with size recvlen.
           Stop Run.
