      $set ans85
      ****************************************************************
      * Copyright Micro Focus Limited 1993-94. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

      *-----------------------------------------------------------------
      *  This program performs the user interface management functions
      *  (screen-handling), if the system does not have dialog
      *  installed. It uses the dialog copybooks and data-blocks so 
      *  that the demo runs in the same way with or without dialog.
      *-----------------------------------------------------------------

       identification division.
       program-id. cciscrn.
       special-names.
           cursor is ws-scrnpos
           crt status is crt-status.

       data division.
       working-storage section.
      *-----------------------------------------------*
      *  Fields used by CALL "CBL_GET_SCR_LINE_DRAW"  *
      *-----------------------------------------------* 
       01  function-code               pic x comp-x value 2. 

       01  line-draw-params.
           03 line-draw-code           pic x comp-x.
           03 line-draw-char           pic x.

       01  draw-codes.
           03 TL-BOX      pic x comp-x value 17.  *> "00010001"   
           03 TR-BOX      pic x comp-x value 20.  *> "00010100"
           03 BL-BOX      pic x comp-x value 65.  *> "01000001"
           03 BR-BOX      pic x comp-x value 68.  *> "01000100"
           03 X-LINE      pic x comp-x value 85.  *> "01010101"
           03 V-LINE      pic x comp-x value 80.  *> "01010000"
           03 H-LINE      pic x comp-x value 5.   *> "00000101"
           03 L-TEE       pic x comp-x value 81.  *> "01010001"
           03 R-TEE       pic x comp-x value 84.  *> "01010100"
           03 T-TEE       pic x comp-x value 21.  *> "00010101"
           03 B-TEE       pic x comp-x value 69.  *> "01000101"

       01  codes-array redefines draw-codes pic x comp-x occurs 11.

       01  draw-chars.
           03  TOP-LEFT               pic x.
           03  TOP-RIGHT              pic x.
           03  BOTTOM-LEFT            pic x.
           03  BOTTOM-RIGHT           pic x.
           03  CROSS-LINE             pic x.
           03  VERTICAL-LINE          pic x.
           03  HORIZONTAL-LINE        pic x.
           03  LEFT-TEE               pic x.
           03  RIGHT-TEE              pic x.
           03  TOP-TEE                pic x.
           03  BOTTOM-TEE             pic x.
       01  char-array redefines draw-chars pic x occurs 11.

       01  horiz-line                 pic x(80).
       01  w-line-clear               pic x(80) value spaces.
       01  ws-accept-control          pic x.
            88  return-to-client   value "c".
            88  re-accept          value "a".
       01  ws-previous-data-block     pic x(449).
       01  ws-scrnpos                 pic 9(4).
       01  ws-scrn-2 redefines ws-scrnpos.
           03  ws-row                 pic 99.
             88 in-order-details-area
                                    values 12 thru 21.
             88 up-arrow-allowed    values 13 thru 21.
             88 down-arrow-allowed  values 12 thru 20.
           03  ws-col                 pic 99.
             88 order-value-field   values 33 thru 39.
             88 payment-value-field values 47 thru 53.
      ***************************************************************
      *  This table stores the position of each field which can be  *
      *  accepted on the screen. Although the accept itself is      *
      *  done using screen section code, the field at which the     *
      *  accept starts can be controlled by setting the cursor is   *
      *  data item to the relevant co-ordinates from this table.    *
      ***************************************************************
       01  ws-accept-table.
           03                         pic x(12) value "042404530524".
           03                         pic x(12) value "055306240653".
           03                         pic x(12) value "075308531208".
           03                         pic x(12) value "121912331247".
           03                         pic x(12) value "130813191333".
           03                         pic x(12) value "134714081419".
           03                         pic x(12) value "143314471508".
           03                         pic x(12) value "151915331547".
           03                         pic x(12) value "160816191633".
           03                         pic x(12) value "164717081719".
           03                         pic x(12) value "173317471808".
           03                         pic x(12) value "181918331847".
           03                         pic x(12) value "190819191933".
           03                         pic x(12) value "194720082019".
           03                         pic x(12) value "203320472108".
           03                         pic x(12) value "211921332147".
       01  ws-table-2 redefines ws-accept-table.
           03 ws-accept-pos occurs 48 pic 9(4).
       01  ws-pos-ptr                 pic 99.

      *-----------------------------------------------------------------
      *    Entries for the crt-status routines.
      *-----------------------------------------------------------------
       01  crt-status.
           03  first-part.
               05  first-byte      pic x.
               05  second-byte     pic x.
           03  second-part redefines first-part
                                   pic 9(4) comp.
           03  third-byte          pic x.
       01  second-byte-9           pic 9(4).
       01  ws-flag                 pic 99 comp value 1.

      * Note: function keys pf1-pfnn are recogised as programmable
      * function keys (USER-FUNCTION-KEYS) and must be defined in the
      * user function key list.

       01  USER-FUNCTION-KEYS.
           03                      pic 99 COMP value 1.
           03                      pic X  value "1".
           03                      pic 99 COMP value 0.
           03                      pic 99 COMP value 30.

      * adis-function-keys refer to keys from the adis function key
      * list

       01  ADIS-FUNCTION-KEYS.
           03                      PIC 99 COMP VALUE 1.
           03                      PIC X VALUE "2".
           03                      PIC 99 COMP VALUE 0.
           03                      PIC 99 COMP VALUE 28.

       linkage section.

      *-----------------------------------------------------------------
      *    Standard dialog copybooks used to provide data for clients.
      *-----------------------------------------------------------------
       COPY "CUSTOMER.CPB".
       COPY "DS-CNTRL.V1".

       screen section.
       01  w-screen-blank background-colour 6 foreground-colour 0.
           03  line 1.
           03  occurs 24.
               05  pic x(80) from w-line-clear col 1.
               05  line + 1.

       01 cciscrn-main background-colour 6 foreground-colour 0.
         02 pic x from top-left LINE 1 COL 1.
         02 pic x(78) from horiz-line size 78 COL 2.
         02 pic x from top-right COL 79.
         02 pic x from vertical-line LINE 2 COL 1.
         02 COL 22 FOREGROUND-COLOR 6 HIGHLIGHT
            VALUE "C U S T O M E R   U P D A T E".
         02 pic x from vertical-line LINE 2 COL 79.
         02 pic x from vertical-line LINE 3 COL 1.
         02 pic x from vertical-line LINE 3 COL 79.
         02 pic x from vertical-line LINE 4 COL 1.
         02 LINE 4 COL 9 value "Customer Code: ".
         02 COL 37 value " Customer Name: ".
         02 pic x from vertical-line LINE 4 COL 79.
         02 pic x from vertical-line LINE 5 COL 1.
         02 LINE 5 COL 10 value "Credit Limit: ".
         02 COL 35 value "Customer Address: ".
         02 pic x from vertical-line LINE 5 COL 79.
         02 pic x from vertical-line LINE 6 COL 1.
         02 LINE 6 COL 13 value "Area Code: ".
         02 pic x from vertical-line LINE 6 COL 79.
         02 pic x from vertical-line LINE 7 COL 1.
         02 pic x from vertical-line LINE 7 COL 79.
         02 pic x from vertical-line LINE 8 COL 1.
         02 LINE 8 COL 7 value "Current Balance:  ".
         02 pic x from vertical-line LINE 8 COL 79.
         02 pic x from vertical-line LINE 9 COL 1.
         02 pic x from vertical-line LINE 9 COL 79.
         02 pic x from vertical-line LINE 10 COL 1.
         02 LINE 10 COL 7 VALUE
           "Order No   Order Date   Order Value".
         02 COL 45 VALUE
           "Payment Value  Order Balance".
         02 pic x from vertical-line LINE 10 COL 79.
         02 pic x from vertical-line LINE 11 COL 1.
         02 pic x from vertical-line LINE 11 COL 79.
         02 pic x from vertical-line LINE 12 COL 1.
         02 pic x from vertical-line LINE 12 COL 79.
         02 pic x from vertical-line LINE 13 COL 1.
         02 pic x from vertical-line LINE 13 COL 79.
         02 pic x from vertical-line LINE 14 COL 1.
         02 pic x from vertical-line LINE 14 COL 79.
         02 pic x from vertical-line LINE 15 COL 1.
         02 pic x from vertical-line LINE 15 COL 79.
         02 pic x from vertical-line LINE 16 COL 1.
         02 pic x from vertical-line LINE 16 COL 79.
         02 pic x from vertical-line LINE 17 COL 1.
         02 pic x from vertical-line LINE 17 COL 79.
         02 pic x from vertical-line LINE 18 COL 1.
         02 pic x from vertical-line LINE 18 COL 79.
         02 pic x from vertical-line LINE 19 COL 1.
         02 pic x from vertical-line LINE 19 COL 79.
         02 pic x from vertical-line LINE 20 COL 1.
         02 pic x from vertical-line LINE 20 COL 79.
         02 pic x from vertical-line LINE 21 COL 1.
         02 pic x from vertical-line LINE 21 COL 79.
         02 pic x from vertical-line LINE 22 COL 1.
         02 pic x from vertical-line LINE 22 COL 79.
         02 pic x from vertical-line LINE 23 COL 1.
         02 COL 11 FOREGROUND-COLOR 6 HIGHLIGHT value "F2".
         02 COL 13 value "=read data ".
         02 COL 24 FOREGROUND-COLOR 6 HIGHLIGHT value "F3".
         02 COL 26 value "=save data ".
         02 COL 37 FOREGROUND-COLOR 6 HIGHLIGHT value "F4".
         02 COL 39 value "=delete data ".
         02 COL 52 FOREGROUND-COLOR 6 HIGHLIGHT value "F5".
         02 COL 54 value "=clear data".
         02 COL 69 FOREGROUND-COLOR 6 HIGHLIGHT value "Esc".
         02 COL 72 value "ape".
         02 pic x from vertical-line LINE 23 COL 79.
         02 pic x from vertical-line LINE 24 COL 1.
         02 pic x from vertical-line LINE 24 COL 79.
         02 pic x from vertical-line LINE 24 COL 1.
         02 pic x from vertical-line LINE 24 COL 79.
         02 pic x from bottom-left LINE 24 COL 1.
         02 col 2 pic x(78) from horiz-line size 77.
         02 pic x from bottom-right LINE 24 COL 79.
         02 LINE 4 COL 24 pic X(5) USING customer-c-code.
         02 LINE 4 COL 53 pic X(15) USING customer-c-name.
         02 LINE 5 COL 24 pic 9(4) USING customer-c-limit.
         02 LINE 5 COL 53 pic X(15) USING customer-c-addr1.
         02 LINE 6 COL 24 pic X USING customer-c-area.
         02 LINE 6 COL 53 pic X(15) USING customer-c-addr2.
         02 LINE 7 COL 53 pic X(15) USING customer-c-addr3.
         02 LINE 8 COL 23 pic ZZZZ9.99 FROM customer-c-bal.
         02 LINE 8 COL 53 pic X(15) USING customer-c-addr4.
         02 LINE 12 COL 8.
         02 ord-line.
          03 OCCURS 10.
           04 pic 9(6) USING customer-ord-no.
           04 COL + 6 pic 99/99/99 USING customer-ord-date.
           04 COL + 7 pic ZZZ9.99 USING customer-ord-val.
           04 COL + 8 pic ZZZ9.99 USING customer-pay-val.
           04 COL + 10 pic ZZZ9.99 FROM customer-ord-bal.
           04 LINE + 1 COL - 61.
       procedure division using
           ds-control-block customer-data-block.
       main-control section.
           if ds-panel-name = spaces
      *-----------------------------------------------------------------
      *    Enable function keys and adis keys so that they both terminate
      *    the accept and can be recognised
      *-----------------------------------------------------------------
              CALL X"AF" USING ws-flag USER-FUNCTION-KEYS
              CALL X"AF" USING ws-flag ADIS-FUNCTION-KEYS

      *-----------------------------------------------------------------
      *    Setup the required generic line drawing characters
      *-----------------------------------------------------------------
              perform varying ws-pos-ptr from 1 by 1
                  until ws-pos-ptr > 11
                  move codes-array(ws-pos-ptr) to line-draw-code
                  call "CBL_GET_SCR_LINE_DRAW" using function-code
                                                     line-draw-params
                  move line-draw-char to char-array(ws-pos-ptr)
              end-perform
              inspect horiz-line replacing all space
                  by horizontal-line
              move 1 to ws-pos-ptr
              move ws-accept-pos(1) to ws-scrnpos
              move "CUSTMAIN" to ds-panel-name

              display spaces at 2401  *> clear the foot of the screen as it
      *                                  never gets used by this program but
      *                                  is white when this program starts.

              DISPLAY w-screen-blank. *> set the screen back-ground to brown.

           set re-accept to true.
           move 0 to ds-exit-field ds-field-change
                     customer-del-flg customer-load-flg
                     customer-save-flg customer-clr-flg
                     customer-exit-flg.
           DISPLAY cciscrn-main.
           perform until return-to-client
             ACCEPT cciscrn-main

      *-----------------------------------------------------------------
      *    Test to determine current field position
      *-----------------------------------------------------------------
                 evaluate ws-pos-ptr
                   when 1
                      move "CODE" to ds-field-name
                   when 2
                      move "NAME" to ds-field-name
                   when 3
                      move "LIMIT" to ds-field-name
                   when 4
                      move "ADDR1" to ds-field-name
                   when 5
                      move "AREA" to ds-field-name
                   when 6
                      move "ADDR2" to ds-field-name
                   when 7
                      move "ADDR3" to ds-field-name
                   when 8
                      move "ADDR4" to ds-field-name
                   when 9
                   when 13
                   when 17
                   when 21
                   when 25
                   when 29
                   when 33
                   when 37
                   when 41
                   when 45
                      move "ORD-NO" to ds-field-name
                   when 10
                   when 14
                   when 18
                   when 22
                   when 26
                   when 30
                   when 34
                   when 38
                   when 42
                   when 46
                      move "ORD-DATE" to ds-field-name
                   when 11
                   when 15
                   when 19
                   when 23
                   when 27
                   when 31
                   when 35
                   when 39
                   when 43
                   when 47
                      move "ORD-VAL" to ds-field-name
                   when 12
                   when 16
                   when 20
                   when 24
                   when 28
                   when 32
                   when 36
                   when 40
                   when 44
                   when 48
                      move "PAY-VAL" to ds-field-name
                 end-evaluate

      *-----------------------------------------------------------------
      *    Test to determine how the ACCEPT was terminated.
      *-----------------------------------------------------------------
             if first-byte = "1"  *> Terminated by a user function key
                 move ws-accept-pos(ws-pos-ptr) to ws-scrnpos
                 set return-to-client to true
                 MOVE LOW-VALUES TO first-byte
                 MOVE second-PART TO second-byte-9
                 evaluate second-byte-9
                  when 0
                    set customer-exit-flg-true to true
                  when 2
                    set customer-load-flg-true to true
                  when 3
                    set customer-save-flg-true to true
                  when 4
                    set customer-del-flg-true to true
                    move ws-accept-pos(1) to ws-scrnpos
                  when 5
                    set customer-clr-flg-true to true
                    move ws-accept-pos(1) to ws-scrnpos
                  when other
                    set re-accept to true
                  end-evaluate
             end-if

             if first-byte = "2"  *> Terminated by an ADIS key
                 MOVE LOW-VALUES TO first-byte
                 MOVE second-PART TO second-byte-9
                 evaluate second-byte-9
                 when 3 *> left arrow, point to previous char position
                   subtract 1 from ws-col
                 when 4 *> right arrow, point to next char position
                   add 1 to ws-col

                 when 5 *> up arrow,
      *                    if in the details area, move to start of
      *                    previous order line otherwise move to the
      *                    first screen position.

                   if up-arrow-allowed
                      subtract 1 from ws-row
                      perform set-position
                   else
                      move 1 to ws-pos-ptr
                      move ws-accept-pos(1) to ws-scrnpos
                   end-if

                 when 6 *> down arrow,
      *                    if in the details area, move to start of
      *                    next order line otherwise move to the first
      *                    order detail line.

                   if down-arrow-allowed
                      add 1 to ws-row
                      perform set-position
                   else
                      move 9 to ws-pos-ptr
                      move ws-accept-pos(9) to ws-scrnpos
                   end-if

                 when 11 *> forward tab, point to next field position
                   add 1 to ws-pos-ptr
                 when 12 *> back tab, point to previous field position
                   subtract 1 from ws-pos-ptr
                 end-evaluate
                 if ws-pos-ptr = 0       *> ensure you remain within the
                    move 1 to ws-pos-ptr *> screen position table
                 end-if
                 if ws-pos-ptr = 48
                    move 48 to ws-pos-ptr
                 end-if

      *-----------------------------------------------------------------
      *    If in the order detail area, check if entering the order value
      *    or payment value. If so, then trigger an exit back to the
      *    client. This simulates the dialog exit field functionality.
      *-----------------------------------------------------------------
                 if in-order-details-area
                    evaluate true
                      when order-value-field
                        set ds-exit-field-true to true
                        set return-to-client to true
                      when payment-value-field
                        set ds-exit-field-true to true
                        set return-to-client to true
                      end-evaluate
                 end-if
                 if second-byte-9 = 3 or 4 or 5 or 6
                    set re-accept to true
                    move spaces to ds-field-name
                    move 0 to ds-exit-field
                 else
                    move ws-accept-pos(ws-pos-ptr) to ws-scrnpos
                 end-if
             end-if
             end-perform.

             if ws-previous-data-block not = customer-data-block
                set ds-field-change-true to true
                move customer-data-block to ws-previous-data-block.
             exit program.

       set-position section.
           evaluate ws-row
             when 12
                move 9 to ws-pos-ptr
             when 13
                move 13 to ws-pos-ptr
             when 14
                move 17 to ws-pos-ptr
             when 15
                move 21 to ws-pos-ptr
             when 16
                move 25 to ws-pos-ptr
             when 17
                move 29 to ws-pos-ptr
             when 18
                move 33 to ws-pos-ptr
             when 19
                move 37 to ws-pos-ptr
             when 20
                move 41 to ws-pos-ptr
             when 21
                move 45 to ws-pos-ptr
           end-evaluate.
           move ws-accept-pos(ws-pos-ptr) to ws-scrnpos.
