      $set ans85
      ****************************************************************
      *  This is a special version of the customer demo program
      *  which is designed to show the use of CCI to create a client
      *  server application.
      *  The calls to dialog actually call 'ccisrvr' which passes the
      *  dialog-control-block and the customer-data-block via the 
      *  network to 'cciclnt'. 'cciclnt' then calls dialog to manage
      *  the user interface, i.e display and process this data.
      *  When dialog exits to cobol the reverse occurs i.e the control
      *  and data blocks are passed back to 'ccisrvr' via CCI which in
      *  turn calls this program with the relevant data in linkage.
      *  'ccisrvr' can manage multiple 'clients' so this program has
      *  checks to ensure that datafiles are only opened once, by the
      *  first 'client', and are closed when the last client terminates.
      ****************************************************************

      ******************* IDENTIFICATION DIVISION *********************
       identification division.
       program-id. ccicust.

      ******************* ENVIRONMENT DIVISION ************************
       environment division.

      *---------------------------------------------------------------*
       input-output section.
       file-control.
           select customer-file assign "custism"
           organization is indexed
           record key is file-c-code
           lock mode manual
           access is dynamic.

      ******************* DATA DIVISION *******************************
       data division.

      *---------------------------------------------------------------*
       file section.
       fd  customer-file.
       01  customer-record.
           03  file-c-code             pic x(5).
           03  file-c-name             pic x(15).
           03  file-c-addr1            pic x(15).
           03  file-c-addr2            pic x(15).
           03  file-c-addr3            pic x(15).
           03  file-c-addr4            pic x(15).
           03  file-c-limit            pic 9(4) comp.
           03  file-c-area             pic x.
           03  file-c-order.
             78  no-of-orders              value 10.
               05  file-c-order-entry occurs no-of-orders.
                   07  file-ord-no     pic 9(6).
                   07  file-ord-date   pic 9(6).
                   07  file-ord-val    pic 9(4)v99 comp.
                   07  file-pay-val    pic 9(4)v99 comp.

      *---------------------------------------------------------------*
       working-storage section.

           copy "DS-CNTRL.V1".
           copy "CUSTOMER.CPB".

       78  refresh-text-and-data-proc      value 255.

       77  array-ind                   pic 9(4) comp.
       77  display-error-no            PIC 9(4).

       linkage section.

       01  linkage-CONTROL-BLOCK        pic x(84).
       01  linkage-CUSTOMER-BLOCK       pic x(449).
       01  linkage-Clients              pic 9 comp-x.
           88 over-client-limit         value 10 thru 255.

      ******************* PROCEDURE DIVISION **************************

       procedure division using linkage-control-block
				linkage-customer-block
				linkage-clients.
      *---------------------------------------------------------------*
       controlling section.
           move linkage-control-block to DS-CONTROL-BLOCK.
           move linkage-customer-block to CUSTOMER-DATA-BLOCK.

           evaluate true
      *
      * If this is the first call to this module, then initialise
      * initialise the dialog control blocks
      *
           when DS-SET-NAME = SPACES
              perform program-initialize
      *
      * If over-client-limit, set special exit flag so that the client
      * can be shut down.
      *
           when over-client-limit
              move 3 to CUSTOMER-EXIT-FLG
           when other
              perform program-body
           end-evaluate.

      * When exit is selected with only one client active, then the files
      * can be closed.
           if CUSTOMER-EXIT-FLG-TRUE
              and linkage-clients = 1
              perform program-terminate.
           move DS-CONTROL-BLOCK to linkage-control-block.
           move CUSTOMER-DATA-BLOCK to linkage-customer-block.
           exit program.
      *---------------------------------------------------------------*
       program-initialize section.
           initialize CUSTOMER-DATA-BLOCK.
           if linkage-clients = 0
              open i-o customer-file.
           add 1 to linkage-clients.
           perform load-screenset.
      *---------------------------------------------------------------*
       program-body section.
           if DS-EXIT-FIELD-TRUE
               display " Recalculate Customer Balance "
               at 2020
               with background-color 0
                    foreground-color 2
               perform derivations
               perform set-up-for-refresh-screen
           end-if
           evaluate true
               when CUSTOMER-DEL-FLG-TRUE
                   display " Delete Record for Customer "
                   at 2020
                   with background-color 0
                        foreground-color 2
                   perform customer-display
                   perform delete-record
               when CUSTOMER-LOAD-FLG-TRUE
                   display " Load Data for Customer "
                   at 2020
                   with background-color 0
                        foreground-color 2
                   perform customer-display
                   perform load-record
               when CUSTOMER-SAVE-FLG-TRUE
                   display " Update Record for Customer "
                   at 2020
                   with background-color 0
                        foreground-color 2
                   perform customer-display
                   perform save-record
               when CUSTOMER-CLR-FLG-TRUE
                   display " Clear Details of Customer "
                   at 2020
                   with background-color 0
                        foreground-color 2
                   perform customer-display
                   perform clear-record
           end-evaluate
           if not CUSTOMER-EXIT-FLG-TRUE
              perform clear-flags
           end-if
           perform call-dialog-system.
      *---------------------------------------------------------------*
       customer-display section.
           display CUSTOMER-C-CODE
           at 0000
           with background-color 0
                foreground-color 2
           " "
           with background-color 0
                foreground-color 2.
      *---------------------------------------------------------------*
       program-terminate section.
           close customer-file.
      *--------------------------------------------------------------*
       delete-record section.
           move CUSTOMER-C-CODE to file-c-code
           delete customer-file
           perform clear-record.
      *---------------------------------------------------------------*
       load-record section.
           initialize customer-record
           move CUSTOMER-C-CODE to file-c-code
           if file-c-code not = spaces
               read customer-file
                   invalid key
                       initialize CUSTOMER-DATA-BLOCK
                       move file-c-code to CUSTOMER-C-CODE
                   not invalid key
                       perform fill-screen-from-record
                       perform derivations
               end-read
           else
               initialize CUSTOMER-DATA-BLOCK
           end-if
           perform set-up-for-refresh-screen.
      *---------------------------------------------------------------*
       save-record section.
           perform fill-record-from-screen
           rewrite customer-record
               invalid key
                   write customer-record
               end-write
           end-rewrite.
      *---------------------------------------------------------------*
       clear-flags section.
           initialize CUSTOMER-GROUP-002.
      *---------------------------------------------------------------*
       clear-record section.
           initialize customer-record
           initialize CUSTOMER-DATA-BLOCK
           perform set-up-for-refresh-screen.
      *---------------------------------------------------------------*
       fill-record-from-screen section.
           move CUSTOMER-C-CODE to file-c-code
           move CUSTOMER-C-NAME to file-c-name
           move CUSTOMER-C-ADDR1 to file-c-addr1
           move CUSTOMER-C-ADDR2 to file-c-addr2
           move CUSTOMER-C-ADDR3 to file-c-addr3
           move CUSTOMER-C-ADDR4 to file-c-addr4
           move CUSTOMER-C-LIMIT to file-c-limit
           move CUSTOMER-C-AREA to file-c-area
           perform varying array-ind from 1 by 1
                                          until array-ind > no-of-orders
               move CUSTOMER-ORD-NO(array-ind) to file-ord-no(array-ind)
               move CUSTOMER-ORD-DATE(array-ind) to
                                           file-ord-date(array-ind)
               move CUSTOMER-ORD-VAL(array-ind) to
                                           file-ord-val(array-ind)
               move CUSTOMER-PAY-VAL(array-ind) to
                                           file-pay-val(array-ind)
           end-perform.
      *---------------------------------------------------------------*
       fill-screen-from-record section.
           move file-c-code  to CUSTOMER-C-CODE
           move file-c-name  to CUSTOMER-C-NAME
           move file-c-addr1 to CUSTOMER-C-ADDR1
           move file-c-addr2 to CUSTOMER-C-ADDR2
           move file-c-addr3 to CUSTOMER-C-ADDR3
           move file-c-addr4 to CUSTOMER-C-ADDR4
           move file-c-limit to CUSTOMER-C-LIMIT
           move file-c-area  to CUSTOMER-C-AREA
           perform varying array-ind from 1 by 1
                                          until array-ind > no-of-orders
               move file-ord-no(array-ind) to CUSTOMER-ORD-NO(array-ind)
               move file-ord-date(array-ind) to
                                           CUSTOMER-ORD-DATE(array-ind)
               move file-ord-val(array-ind) to
                                           CUSTOMER-ORD-VAL(array-ind)
               move file-pay-val(array-ind) to
                                           CUSTOMER-PAY-VAL(array-ind)
           end-perform.
      *---------------------------------------------------------------*
       set-up-for-refresh-screen section.
           move refresh-text-and-data-proc to DS-PROC-NO.
      *---------------------------------------------------------------*
       derivations section.
           move 0 to CUSTOMER-C-BAL
           perform varying array-ind
                              from 1 by 1 until array-ind > no-of-orders
               compute CUSTOMER-ORD-BAL(array-ind) =
                     CUSTOMER-ORD-VAL(array-ind) -
                                           CUSTOMER-PAY-VAL(array-ind)
               add CUSTOMER-ORD-BAL(array-ind) to CUSTOMER-C-BAL
           end-perform.
      *---------------------------------------------------------------*
       load-screenset section.
           move DS-NEW-SET to DS-CONTROL.
      *
      * As Dialog 2.5 has a degree of intelligence, we have to give the
      * full screenset name (including extension) to stop it always
      * trying to load the character one. It does this because we are
      * using the character interface (ds-cntrl.v1), but the client
      * module can run character or graphical screensets, based on run
      * options supplied by the user.
      *
           if ds-version-no = 1       *> Character screenset
              move "CUSTOMER.S" to DS-SET-NAME
           else                       *> Graphical screenset
              move "CUSTOMER.gs" to DS-SET-NAME.
           perform call-dialog-system.
      *---------------------------------------------------------------*
       call-dialog-system section.
           if not DS-NO-ERROR
               move DS-SYSTEM-ERROR-NO to display-error-no
               display "DS ERROR NO:   " display-error-no
           end-if.
      ******************* END OF PROGRAM ******************************
