      $set ans85 noosvs vsc2 mf

      ****************************************************************
      * Copyright Micro Focus Limited 1986-94. All Rights Reserved.  *
      * This demonstration program is provided for use by users of   *
      * Micro Focus products and may be used, modified and           *
      * distributed as part of your application provided that you    *
      * properly acknowledge the copyright of Micro Focus in this    *
      * material.                                                    *
      ****************************************************************

       IDENTIFICATION DIVISION.
       PROGRAM-ID. CCISERV.

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.

       WORKING-STORAGE SECTION.
       01  Locals.
               03  CCI-End-Test            PIC X       COMP-5 VALUE 0.
               78  CCI-False           VALUE       0.
               78  CCI-True            VALUE       1.
           03  CCI-Module              PIC X(8)    VALUE SPACES.
           03  CCI-Test-State          PIC X       COMP-5 VALUE 0.
               78  CCI-Passed          VALUE       0.
               78  CCI-Failed          VALUE       1.
           03  Srvrhandle              PIC X(4)    COMP-5 VALUE 0.
           03  Buffer                  PIC X(80).
           03  Maxlen                  PIC X(4)    COMP-5.
           03  Mem-Size                PIC X(4)    COMP-5 VALUE 65535.
           03  Mem-Flags               PIC X(4)    COMP-5 VALUE 2.
           03  Query-Count             PIC X(4)    COMP-5 VALUE 0.
           03  Recvall-Count           PIC X(4)    COMP-5 VALUE 0.
           03  Recvlen                 PIC X(4)    COMP-5.
           03  Publicname              PIC X(8)    VALUE "CCISERV".
           03  Send-Count              PIC X(4)    COMP-5 VALUE 0.
           03  Actuallen               PIC X(4)    COMP-5.
           03  Sendlen                 PIC X(4)    COMP-5.
           03  Sessid                  PIC X(4)    COMP-5 VALUE 0.
           03  Async                   PIC S9(9)   COMP-5 VALUE 0.
           03  Cciend                  PIC X(4)    COMP-5 VALUE 0.
           03  Time1.
               05  Time1-HH            PIC 9(2).
               05  Time1-MM            PIC 9(2).
               05  Time1-SS            PIC 9(2).
               05                      PIC 9(2).
           03  Time1-Secs              PIC X(4)    COMP-5.
           03  Time2.
               05  Time2-HH            PIC 9(2).
               05  Time2-MM            PIC 9(2).
               05  Time2-SS            PIC 9(2).
               05                      PIC 9(2).
           03  Time2-Secs              PIC X(4)    COMP-5.
        01 Mem-Ptr                    USAGE POINTER.
        01 Signature-Block.
           03  Signature.
               05  CCIsign             PIC X(6).
               05  CCItype             PIC X(8).
               05  CCIversn            PIC X(6).
           03  CCIcaltab               USAGE POINTER.

       LINKAGE SECTION.
       copy "ccitab.cpy".

       01  Input-Rec                   PIC X(65535).

       PROCEDURE DIVISION.
      *-----------------------------------------------------------------
      *    Prompt for name of CCI module to be used
      *-----------------------------------------------------------------
           DISPLAY "Enter CCI Module Name: " WITH NO ADVANCING
           ACCEPT CCI-Module

           IF CCI-Module = SPACES
               DISPLAY
               "Cannot run CCICLI without a CCI module being specified"
               EXIT PROGRAM
               STOP RUN
           END-IF
      *-----------------------------------------------------------------
      *    Clear screen, and display counters
      *-----------------------------------------------------------------
           DISPLAY SPACES UPON CRT

           DISPLAY "Querys         :" AT LINE NUMBER 11 COL NUMBER 1
           DISPLAY Query-Count        AT LINE NUMBER 11 COL NUMBER 18
           DISPLAY "Receivealls    :" AT LINE NUMBER 12 COL NUMBER 1
           DISPLAY Recvall-Count      AT LINE NUMBER 12 COL NUMBER 18
           DISPLAY "Sends          :" AT LINE NUMBER 13 COL NUMBER 1
           DISPLAY Send-Count         AT LINE NUMBER 13 COL NUMBER 18
      *-----------------------------------------------------------------
      *    Make initialisation call to requested CCI module.
      *    This call should return a signature block containing the
      *    CCIsign, CCItype, CCIversn, and a pointer to the CCI module's
      *    function table.  The CCIsign should be equal to "MFCCI-".
      *    You may also check the CCItype to confirm the protocol that
      *    has been loaded.  CCItype should equal one of the following
      *    values; "IPX", "NETB", "NAMP", "TCP/IP". "APPC", "LU2", and
      *    "NAMPU".  Additional protocol types will be available in
      *    future releases, please check your documentation and release
      *    notes for further information.  The CCIversn indicates the
      *    level of release of the CCI module.  This field is used to
      *    indicate the level of functionality that is available.  Some
      *    CCI verbs may not be available under all CCI modules.  Please
      *    check your documentation for more information.
      *-----------------------------------------------------------------
           DISPLAY "Initialisation" AT LINE NUMBER 15 COLUMN 1

           CALL CCI-Module USING Signature-Block

           IF CCIsign NOT = "MFCCI-"
               DISPLAY "Error initialising " CCI-Module
               EXIT PROGRAM
               STOP RUN
           END-IF

           SET ADDRESS OF Proctab to CCIcaltab
      *-----------------------------------------------------------------
      *    Register server name on network, to allow CCICLI clients to
      *    connect.
      *-----------------------------------------------------------------
           MOVE ZEROES TO Cciend
           CALL CCI-INITSERVER USING Publicname
                                     Srvrhandle
                                     Cciend

           IF RETURN-CODE NOT = 0
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from CCI-INITSERVER"
                        AT LINE NUMBER 16 COLUMN 1
               EXIT PROGRAM
               STOP RUN
           END-IF

           DISPLAY "              " AT LINE NUMBER 15 COLUMN 1
      *-----------------------------------------------------------------
      *    Allocate memory for receive buffer
      *-----------------------------------------------------------------
           CALL "CBL_ALLOC_MEM" USING BY REFERENCE Mem-Ptr
                                      BY VALUE Mem-Size
                                      BY VALUE Mem-Flags

           SET ADDRESS OF Input-Rec TO Mem-Ptr
      *-----------------------------------------------------------------
      *    Service client requests
      *-----------------------------------------------------------------
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    De-register server name from network
      *-----------------------------------------------------------------
           DISPLAY "Closing down server" AT LINE NUMBER 15 COLUMN 1

           CALL CCI-CLOSESERVER USING Srvrhandle

           IF RETURN-CODE NOT = 0
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from CCI-CLOSESERVER"
                       AT LINE NUMBER 16 COLUMN 1
           END-IF

           DISPLAY " " AT LINE NUMBER 20 COL NUMBER 1

           EXIT PROGRAM
           STOP RUN
           .
      ******************************************************************
      *    Main processing which on receipt of a buffer from a CCICLI
      *    client, immediately sends the buffer back. The CCICLI client
      *    validates that the buffer it receives is identical to the
      *    one it sent.
      *
      *    This section uses CCI-RECEIVEALL to receive buffers from
      *    CCICLI clients (CCI-RECEIVEALL implicitly allows CCICLI
      *    clients to connect using CCI-INITCLIENT calls), and CCI-SEND
      *    to send buffers back.
      *
      *    This section terminates after a minute's inactivity when no
      *    buffers have been received from a CCICLI client.
      ******************************************************************
       CCI-Test SECTION.
           MOVE LENGTH OF Input-Rec TO Maxlen
           MOVE CCI-False TO CCI-End-Test
           MOVE CCI-Passed TO CCI-Test-State
      *
      *    Get first record from a client
      *
           PERFORM Recvall1

           PERFORM UNTIL CCI-End-Test = CCI-True
      *
      *        Send record back to client
      *
               PERFORM Write-Record

               IF CCI-Test-State = CCI-Passed
                   IF Recvlen = 4 AND
                      Input-Rec(1:4) = HIGH-VALUES
      *
      *                Received record from client indicating that he
      *                wants to terminate the connection
      *
                       CALL CCI-Hangup USING Sessid

                       IF RETURN-CODE NOT = 0
                           PERFORM Get-CCI-Error
                           DISPLAY "Error on return from CCI-HANGUP"
                                   AT LINE NUMBER 16 COLUMN 1
                       END-IF
                   END-IF
      *
      *        Get next record from a client
      *
                   IF CCI-Test-State = CCI-Passed
                       PERFORM Recvall1
                   END-IF
               END-IF
           END-PERFORM
           .
      ****************************************************************
      *    Get error message associated with last error code returned
      *    by a CCI function.
      *
      *    On exit:
      *
      *        Buffer    =   error message text
      *        Maxlen    =   maximum length of buffer
      *        Actuallen =   length of error message text
      ****************************************************************
       Get-CCI-Error SECTION.
           MOVE CCI-True TO CCI-End-Test
           MOVE CCI-Failed TO CCI-Test-State
           MOVE LENGTH OF Buffer TO Maxlen
           CALL CCI-GETERROR USING Buffer
                                   Maxlen
                                   Actuallen
           DISPLAY Buffer AT LINE NUMBER 15 COLUMN 1
           .
      ******************************************************************
      *    Receive next record from a client. CCI-RECEIVEALL is used
      *    because it will implicitly connect any client attempting
      *    to establish a connection using CCI-INITCLIENT, and it will
      *    receive records from any client currently connected.
      *
      *    CCI-RECEIVEALL is invoked asynchronously here so that a
      *    check can be made as to how much time has elapsed since
      *    being invoked. As soon as one minute has elapsed without
      *    a record being received, a flag (CCI-End-Test) is set to
      *    indicate that the program is to shut down
      *
      *    On exit:
      *
      *        CCI-End-Test    =   1 if one minute has elapsed
      *        Input-Rec       =   received buffer
      *        Recvlen         =   length of received buffer
      *
      ******************************************************************
       Recvall1 SECTION.
           ADD 1 TO Recvall-Count
           DISPLAY Recvall-Count AT LINE NUMBER 12 COL NUMBER 18
           MOVE ZEROES TO Cciend
           MOVE -1 TO Async
           CALL CCI-RECEIVEALL USING Srvrhandle
                                     Sessid
                                     Input-Rec
                                     Maxlen
                                     Recvlen
                                     Async
                                     Cciend

           ACCEPT Time1 FROM TIME
           COMPUTE Time1-Secs=(Time1-HH*3600)+(Time1-MM*60)+Time1-SS

           PERFORM WITH TEST AFTER UNTIL RETURN-CODE NOT = -1
               ADD 1 TO Query-Count
               DISPLAY Query-Count AT LINE NUMBER 11 COL NUMBER 18
               CALL CCI-QUERY USING Async

               EVALUATE RETURN-CODE
      *
      *            Nothing received yet. Check if a minute has elapsed
      *            since making the CCI-RECEIVEALL request
      *
                   WHEN -1
                       ACCEPT Time2 FROM TIME
                       IF Time1-HH > Time2-HH
                           ADD 24 TO Time2-HH
                       END-IF
                       COMPUTE Time2-Secs=
                               (Time2-HH*3600)+(Time2-MM*60)+Time2-SS
                       SUBTRACT Time1-Secs FROM Time2-Secs
                       IF Time2-Secs >= 60
                           MOVE CCI-True TO CCI-End-Test
                           MOVE 0 TO RETURN-CODE
                       END-IF
      *
      *            CCI-RECEIEVALL request timed out
      *
                   WHEN 1
                       MOVE 0 TO RETURN-CODE
                       MOVE CCI-True TO CCI-End-Test

               END-EVALUATE

           END-PERFORM

           IF RETURN-CODE NOT = 0
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from CCI-RECEIVEALL"
                       AT LINE NUMBER 16 COLUMN 1
           END-IF
           .
      ****************************************************************
      *    Send record back to client using asynchronous CCI-SEND call
      ****************************************************************
       Write-Record SECTION.
           MOVE Recvlen TO Sendlen
           ADD 1 TO Send-Count
           DISPLAY Send-Count AT LINE NUMBER 13 COL NUMBER 18
      *
      *    Do the send
      *
           MOVE ZEROES TO Cciend
           MOVE -1 TO Async
           CALL CCI-SEND USING Sessid
                               Input-Rec
                               Sendlen
                               Async
                               Cciend

           IF RETURN-CODE NOT = 0
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from CCI-SEND"
                       AT LINE NUMBER 16 COLUMN 1
           ELSE
               PERFORM WITH TEST AFTER UNTIL RETURN-CODE NOT = -1
                   ADD 1 TO Query-Count
                   DISPLAY Query-Count AT LINE NUMBER 11 COL NUMBER 18
                   CALL CCI-QUERY USING Async
               END-PERFORM

               IF RETURN-CODE NOT = 0
                   PERFORM Get-CCI-Error
                   DISPLAY "Error on return from CCI-QUERY of CCI-SEND"
                           AT LINE NUMBER 16 COLUMN 1
               END-IF
           END-IF
      *
      *    Suspend conversation with client
      *
           CALL CCI-SUSPENDSERVER USING Sessid

           IF RETURN-CODE NOT = 0
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from CCI-SUSPENDSERVER"
                       AT LINE NUMBER 16 COLUMN 1
           END-IF
           .
