      $set ans85 noosvs vsc2 mf

      ******************************************************************
      * Copyright Micro Focus Limited 1986-94. All Rights Reserved.    *
      * This demonstration program is provided for use by users of     *
      * Micro Focus products and may be used, modified and distributed *
      * as part of your application provided that you properly         *
      * acknowledge the copyright of Micro Focus in this material.     *
      ******************************************************************

       IDENTIFICATION DIVISION.
       PROGRAM-ID. CCICLI.

       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.

       WORKING-STORAGE SECTION.

       01  Input-File-Name             PIC X(80).

       01  Locals.
           03  Access-Mode             PIC X       COMP-5 VALUE 1.
           03  Buffer-Size             PIC X(4)    COMP-5.
           03  Byte-Count              PIC X(4)    COMP-X.
           03  CCI-Module              PIC X(8)    VALUE SPACES.
           03  CCI-Test-State          PIC X       COMP-5 VALUE 0.
               78  CCI-Passed          VALUE       0.
               78  CCI-Failed          VALUE       1.
           03  Deny-Mode               PIC X       COMP-5 VALUE 3.
           03  Device                  PIC X       COMP-5 VALUE 0.
           03  Eof-Flag                PIC X       COMP-5.
           03  File-Details.
               05  File-Size           PIC X(8)    COMP-X.
               05  FILLER              PIC X(8).
           03  File-Handle             PIC X(4).
           03  File-Offset             PIC X(8)    COMP-X VALUE 0.
           03  Flags                   PIC X       COMP-5 VALUE 0.
           03  Buffer                  PIC X(80).
           03  Maxlen                  PIC X(4)    COMP-5.
           03  Machinename             PIC X(21)   VALUE SPACES.
           03  Mem-Size                PIC X(4)    COMP-5 VALUE 65535.
           03  Mem-Flags               PIC X(4)    COMP-5 VALUE 2.
           03  Recvlen                 PIC X(4)    COMP-5.
           03  Publicname              PIC X(8)    VALUE "CCISERV".
           03  Actuallen               PIC X(4)    COMP-5.
           03  Sendlen                 PIC X(4)    COMP-5.
           03  Sessid                  PIC X(4)    COMP-5 VALUE 0.
           03  Async                   PIC S9(9)   COMP-5 VALUE 0.
           03  Cciend                  PIC X(4)    COMP-5 VALUE 0.
        01 Mem-Ptr                    USAGE POINTER.
        01 Signature-Block.
           03  Signature.
               05  CCIsign             PIC X(6).
               05  CCItype             PIC X(8).
               05  CCIversn            PIC X(6).
           03  CCIcaltab               USAGE POINTER.

       LINKAGE SECTION.
       copy "ccitab.cpy".

       01  Input-Rec                   PIC X(65535).
       01  Output-Rec                  PIC X(65535).

       PROCEDURE DIVISION.

      *-----------------------------------------------------------------
      *    Prompt for name of CCI module to be used
      *-----------------------------------------------------------------
           DISPLAY "Enter CCI Module Name: " WITH NO ADVANCING
           ACCEPT CCI-Module

           IF CCI-Module = SPACES
               DISPLAY
               "Cannot run CCICLI without a CCI module being specified"
               EXIT PROGRAM
               STOP RUN
           END-IF
      *-----------------------------------------------------------------
      *    Prompt for name of file to be used
      *-----------------------------------------------------------------
           DISPLAY "Enter File Name      : " WITH NO ADVANCING
           ACCEPT Input-File-Name
           DISPLAY SPACES

           IF Input-File-Name NOT = SPACES
               CALL "CBL_CHECK_FILE_EXIST" USING Input-File-Name
                                                 File-Details

               IF RETURN-CODE NOT = 0
                   DISPLAY "Input file does not exist"
                   MOVE CCI-Failed TO CCI-Test-State
                   EXIT PROGRAM
                   STOP RUN
               END-IF
           ELSE
               DISPLAY
               "Cannot run CCICLI without a file name being specified"
               EXIT PROGRAM
               STOP RUN
           END-IF
      *-----------------------------------------------------------------
      *    Allocate memory to be used to send and receive data.
      *-----------------------------------------------------------------
           DISPLAY "Initialisation"

           CALL "CBL_ALLOC_MEM" USING BY REFERENCE Mem-Ptr
                                      BY VALUE Mem-Size
                                      BY VALUE Mem-Flags

           SET ADDRESS OF Input-Rec TO Mem-Ptr

           CALL "CBL_ALLOC_MEM" USING BY REFERENCE Mem-Ptr
                                      BY VALUE Mem-Size
                                      BY VALUE Mem-Flags

           SET ADDRESS OF Output-Rec TO Mem-Ptr
      *-----------------------------------------------------------------
      *    Make initialisation call to requested CCI module.
      *    This call should return a signature block containing the
      *    CCIsign, CCItype, CCIversn, and a pointer to the CCI module's
      *    function table.  The CCIsign should be equal to "MFCCI-".
      *    You may also check the CCItype to confirm the protocol that
      *    has been loaded.  CCItype should equal one of the following
      *    values; "IPX", "NETB", "NAMP", "TCP/IP". "APPC", "LU2", and
      *    "NAMPU".  Additional protocol types will be available in
      *    future releases, please check your documentation and release
      *    notes for further information.  The CCIversn indicates the
      *    level of release of the CCI module.  This field is used to
      *    indicate the level of functionality that is available.  Some
      *    CCI verbs may not be available under all CCI modules.  Please
      *    check your documentation for more information.
      *-----------------------------------------------------------------
           CALL CCI-Module USING Signature-Block

           IF CCIsign NOT = "MFCCI-"
               DISPLAY "Error initialising " CCI-Module
               EXIT PROGRAM
               STOP RUN
           END-IF

           SET ADDRESS OF Proctab to CCIcaltab
      *-----------------------------------------------------------------
      *    Establish a connection with server application CCISERV
      *-----------------------------------------------------------------
           MOVE ZEROES TO Async, Cciend
           CALL CCI-INITCLIENT USING Publicname
                                     Machinename
                                     Sessid
                                     Async
                                     Cciend

           IF RETURN-CODE NOT = 0
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from INITCLIENT"
               EXIT PROGRAM
               STOP RUN
           END-IF
      *-----------------------------------------------------------------
      *    Send contents of user specified file to server application
      *    CCISERV using 127 byte records
      *-----------------------------------------------------------------
           DISPLAY "Using 127 byte records"
           MOVE 127 TO Buffer-Size
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    Send contents of user specified file to server application
      *    CCISERV using 255 byte records
      *-----------------------------------------------------------------
           DISPLAY "Using 255 byte records"
           MOVE 255 TO Buffer-Size
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    Send contents of user specified file to server application
      *    CCISERV using 511 byte records
      *-----------------------------------------------------------------
           DISPLAY "Using 511 byte records"
           MOVE 511 TO Buffer-Size
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    Send contents of user specified file to server application
      *    CCISERV using 1023 byte records
      *-----------------------------------------------------------------
           DISPLAY "Using 1023 byte records"
           MOVE 1023 TO Buffer-Size
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    Send contents of user specified file to server application
      *    CCISERV using 2047 byte records
      *-----------------------------------------------------------------
           DISPLAY "Using 2047 byte records"
           MOVE 2047 TO Buffer-Size
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    Send contents of user specified file to server application
      *    CCISERV using 4095 byte records
      *-----------------------------------------------------------------
           DISPLAY "Using 4095 byte records"
           MOVE 4095 TO Buffer-Size
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    Send contents of user specified file to server application
      *    CCISERV using 8191 byte records
      *-----------------------------------------------------------------
           DISPLAY "Using 8191 byte records"
           MOVE 8191 TO Buffer-Size
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    Send contents of user specified file to server application
      *    CCISERV using 16383 byte records
      *-----------------------------------------------------------------
           DISPLAY "Using 16383 byte records"
           MOVE 16383 TO Buffer-Size
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    Send contents of user specified file to server application
      *    CCISERV using 32767 byte records
      *-----------------------------------------------------------------
           DISPLAY "Using 32767 byte records"
           MOVE 32767 TO Buffer-Size
           PERFORM CCI-Test
      *-----------------------------------------------------------------
      *    Send special record to server application CCISERV to
      *    indicate that we are about to disconnect, and then
      *    issue CCI_CLOSECLIENT to disconnect.
      *-----------------------------------------------------------------
           DISPLAY "Terminating connection with server"

           MOVE ZEROES TO Async, Cciend
           CALL CCI-RESUMECLIENT USING Sessid
                                       Async
                                       Cciend
           IF RETURN-CODE NOT = 0
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from RESUMECLIENT"
               EXIT PROGRAM
               STOP RUN
           END-IF

           MOVE 4 TO Byte-Count
           MOVE HIGH-VALUES TO Input-Rec(1:4)
           PERFORM Write-Record

           IF CCI-Test-State = CCI-Passed
               CALL CCI-CLOSECLIENT USING Sessid

               IF RETURN-CODE NOT = 0
                   PERFORM Get-CCI-Error
                   DISPLAY "Error on return from CLOSECLIENT"
               END-IF
           END-IF
      *-----------------------------------------------------------------
      *    Normal termination
      *-----------------------------------------------------------------
           DISPLAY SPACES
           DISPLAY "CCICLI terminated successfully"
           EXIT PROGRAM
           STOP RUN
           .
      ******************************************************************
      *    Test sending and receiving records to and from server
      *    application CCISERV.
      *
      *    On entry:
      *
      *        Buffer-Size =   size of record to send to server app
      ******************************************************************
       CCI-Test SECTION.
           MOVE 0 TO File-Offset
           MOVE CCI-Passed TO CCI-Test-State
      *-----------------------------------------------------------------
      *    Open user specified file. Exit if error.
      *-----------------------------------------------------------------
           CALL "CBL_OPEN_FILE" USING Input-File-Name
                                      Access-Mode
                                      Deny-Mode
                                      Device
                                      File-Handle

           IF RETURN-CODE NOT = 0
               DISPLAY "Could not open input file"
               MOVE CCI-Failed TO CCI-Test-State
               EXIT SECTION
           END-IF
      *-----------------------------------------------------------------
      *    File opened OK. Read first record.
      *-----------------------------------------------------------------
           MOVE 0 TO Eof-Flag
           PERFORM Read-Input-File
      *-----------------------------------------------------------------
      *    Loop sending and receiving records until end of file
      *-----------------------------------------------------------------
           PERFORM UNTIL Eof-Flag NOT = 0
               PERFORM Write-Record
               IF CCI-Test-State NOT = CCI-Failed
                   PERFORM Read-Input-File
               END-IF
           END-PERFORM
      *-----------------------------------------------------------------
      *    Close user specified file
      *-----------------------------------------------------------------
           CALL "CBL_CLOSE_FILE" USING File-Handle
           .
      ****************************************************************
      *    Get error message associated with last error code returned
      *    by a CCI function.
      *
      *    On exit:
      *
      *        Buffer    =   error message text
      *        Maxlen    =   maximum length of buffer
      *        Actuallen =   length of error message text
      ****************************************************************
       Get-CCI-Error SECTION.
           MOVE 1 TO Eof-Flag
           MOVE CCI-Failed TO CCI-Test-State
           MOVE LENGTH OF Buffer TO Maxlen
           CALL CCI-GETERROR USING Buffer
                                   Maxlen
                                   Actuallen
           DISPLAY Buffer
           .
      ****************************************************************
      *    Resume conversation with CCISERV and read next record from
      *    user specified file.
      *
      *    On entry:
      *
      *        Buffer-Size =   size of record to read from file
      *        File-Offset =   current read pointer in file
      *        File-Size   =   size of file
      *
      *    On exit:
      *
      *        Byte-Count  =   size of record read
      *        File-Offset =   new current read pointer in file
      *        Input-Rec   =   record read from file
      *        Eof-Flag    =   1 if end of file reached
      ****************************************************************
       Read-Input-File SECTION.
           MOVE ZEROES TO Async, Cciend
           CALL CCI-RESUMECLIENT USING Sessid
                                       Async
                                       Cciend
           IF RETURN-CODE NOT = 0
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from RESUMECLIENT"
           ELSE
               IF File-Offset < File-Size
                   MOVE File-Size TO Byte-Count
                   SUBTRACT File-Offset FROM Byte-Count

                   IF Byte-Count > Buffer-Size
                       MOVE Buffer-Size TO Byte-Count
                   END-IF

                   CALL "CBL_READ_FILE" USING File-Handle
                                              File-Offset
                                              Byte-Count
                                              Flags
                                              Input-Rec
                   ADD Byte-Count TO File-Offset
               ELSE
                   MOVE 1 TO Eof-Flag
               END-IF
           END-IF
           .
      ****************************************************************
      *    Send record to server application CCISERV. Receive record
      *    back from CCISERV, and check that received buffer length
      *    and received buffer contents are the same as those sent
      *
      *    On entry:
      *
      *        Byte-Count      =   size of record to send
      *        Input-Rec       =   record to send
      *
      *    On exit:
      *
      *        CCI-Test-State  =   0 if no error; 1 if error
      *        EOF-Flag        =   1 if error to force logical EOF
      ****************************************************************
       Write-Record SECTION.
           MOVE Byte-Count TO Sendlen
      *---------------------------------------------------------------
      *    Send record asynchronously (i.e. setting Async to -1)
      *    Wait for send to complete using CCI-QUERY
      *    to query the asynchronous handle.
      *---------------------------------------------------------------
           MOVE -1 TO Async
           MOVE ZEROES TO Cciend
           CALL CCI-SEND USING Sessid
                               Input-Rec
                               Sendlen
                               Async
                               Cciend

           IF RETURN-CODE = 0
               PERFORM WITH TEST AFTER UNTIL RETURN-CODE NOT = -1
                   CALL CCI-QUERY USING Async
               END-PERFORM
           ELSE
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from SEND"
               EXIT SECTION
           END-IF
      *---------------------------------------------------------------
      *    Pick up error message set by asynchronous CCI-SEND
      *---------------------------------------------------------------
           IF RETURN-CODE NOT = 0
               PERFORM Get-CCI-Error
               DISPLAY "Error on return from SEND query"
      *---------------------------------------------------------------
      *    Successful send. Wait for CCISERV to send record back.
      *    CCI-RECEIVE invoked synchronously (i.e. Async initialized
      *    to zero.)
      *---------------------------------------------------------------
           ELSE
               MOVE LENGTH OF Output-Rec TO Maxlen
               MOVE ZEROES TO Async, Cciend
               CALL CCI-RECEIVE USING Sessid
                                      Output-Rec
                                      Maxlen
                                      Recvlen
                                      Async
                                      Cciend
               IF RETURN-CODE NOT = 0
                   PERFORM Get-CCI-Error
                   DISPLAY "Error on return from RECEIVE"
               ELSE
                   EVALUATE TRUE
      *
      *                Received buffer length different to sent buffer
      *                length
      *
                       WHEN Recvlen NOT = Sendlen
                           MOVE CCI-Failed TO CCI-Test-State
                           MOVE 1 TO Eof-Flag
                           DISPLAY
                               "Send and receive lengths do not match"
      *
      *                Received buffer contents different to sent buffer
      *                contents
      *
                       WHEN Input-Rec(1:Sendlen) NOT =
                            Output-Rec(1:Recvlen)
                           MOVE CCI-Failed TO CCI-Test-State
                           MOVE 1 TO Eof-Flag
                           DISPLAY
                               "Send and receive buffers do not match"
      *
      *                Sent and received buffer lengths and contents
      *                match.
      *
                       WHEN OTHER
                           CONTINUE

                   END-EVALUATE
      *---------------------------------------------------------------
      *            Suspend conversation with CCISERV
      *---------------------------------------------------------------
                   CALL CCI-SUSPENDCLIENT USING Sessid

                   IF RETURN-CODE NOT = 0
                       PERFORM Get-CCI-Error
                       DISPLAY "Error on return from SUSPENDCLIENT"
                   END-IF
               END-IF
           END-IF
           .
